/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.client.cli;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.LinkedHashSet;
import javax.net.ssl.KeyManager;
import org.opends.admin.ads.util.ApplicationTrustManager;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.ToolMessages;
import org.opends.server.admin.client.cli.DsFrameworkCliReturnCode;
import org.opends.server.admin.client.cli.SecureConnectionCliArgs;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.tools.ToolConstants;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.util.PasswordReader;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.Argument;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentGroup;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.FileBasedArgument;
import org.opends.server.util.args.StringArgument;
import org.opends.server.util.args.SubCommandArgumentParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SecureConnectionCliParser
extends SubCommandArgumentParser {
    protected BooleanArgument showUsageArg = null;
    protected BooleanArgument verboseArg = null;
    protected SecureConnectionCliArgs secureArgsList;
    protected StringArgument propertiesFileArg = null;
    protected BooleanArgument noPropertiesFileArg;
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    public static String EOL = System.getProperty("line.separator");

    protected SecureConnectionCliParser(String mainClassName, Message toolDescription, boolean longArgumentsCaseSensitive) {
        super(mainClassName, toolDescription, longArgumentsCaseSensitive);
    }

    public String getBindDN() {
        return this.secureArgsList.getBindDN();
    }

    public String getAdministratorUID() {
        return this.secureArgsList.getAdministratorUID();
    }

    protected String getBindPassword(String dn, OutputStream out, OutputStream err, StringArgument clearArg, FileBasedArgument fileArg) {
        if (clearArg.isPresent()) {
            String bindPasswordValue = clearArg.getValue();
            if (bindPasswordValue != null && bindPasswordValue.equals("-")) {
                try {
                    out.write(ToolMessages.INFO_LDAPAUTH_PASSWORD_PROMPT.get(dn).getBytes());
                    out.flush();
                    char[] pwChars = PasswordReader.readPassword();
                    bindPasswordValue = new String(pwChars);
                }
                catch (Exception ex) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, ex);
                    }
                    try {
                        err.write(StaticUtils.wrapText(ex.getMessage(), ServerConstants.MAX_LINE_WIDTH).getBytes());
                        err.write(EOL.getBytes());
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    return null;
                }
            }
            return bindPasswordValue;
        }
        if (fileArg.isPresent()) {
            return fileArg.getValue();
        }
        try {
            out.write(ToolMessages.INFO_LDAPAUTH_PASSWORD_PROMPT.get(dn).toString().getBytes());
            out.flush();
            char[] pwChars = PasswordReader.readPassword();
            return new String(pwChars);
        }
        catch (Exception ex) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ex);
            }
            try {
                err.write(StaticUtils.wrapText(ex.getMessage(), ServerConstants.MAX_LINE_WIDTH).getBytes());
                err.write(EOL.getBytes());
            }
            catch (IOException e) {
                // empty catch block
            }
            return null;
        }
    }

    public String getBindPassword(String dn, OutputStream out, OutputStream err) {
        return this.getBindPassword(dn, out, err, this.secureArgsList.bindPasswordArg, this.secureArgsList.bindPasswordFileArg);
    }

    public String getBindPassword() {
        return SecureConnectionCliParser.getBindPassword(this.secureArgsList.bindPasswordArg, this.secureArgsList.bindPasswordFileArg);
    }

    protected LinkedHashSet<Argument> createGlobalArguments(OutputStream outStream, boolean alwaysSSL) throws ArgumentException {
        this.secureArgsList = new SecureConnectionCliArgs(alwaysSSL);
        LinkedHashSet<Argument> set = this.secureArgsList.createGlobalArguments();
        this.showUsageArg = new BooleanArgument("showUsage", Character.valueOf('H'), "help", ToolMessages.INFO_DESCRIPTION_SHOWUSAGE.get());
        this.setUsageArgument(this.showUsageArg, outStream);
        set.add(this.showUsageArg);
        this.verboseArg = new BooleanArgument("verbose", ToolConstants.OPTION_SHORT_VERBOSE, "verbose", ToolMessages.INFO_DESCRIPTION_VERBOSE.get());
        set.add(this.verboseArg);
        this.propertiesFileArg = new StringArgument("propertiesFilePath", null, "propertiesFilePath", false, false, true, ToolMessages.INFO_PROP_FILE_PATH_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_PROP_FILE_PATH.get());
        this.setFilePropertiesArgument(this.propertiesFileArg);
        set.add(this.propertiesFileArg);
        this.noPropertiesFileArg = new BooleanArgument("noPropertiesFileArgument", null, "noPropertiesFile", ToolMessages.INFO_DESCRIPTION_NO_PROP_FILE.get());
        this.setNoPropertiesFileArgument(this.noPropertiesFileArg);
        set.add(this.noPropertiesFileArg);
        return set;
    }

    protected void initializeGlobalArguments(Collection<Argument> args) throws ArgumentException {
        this.initializeGlobalArguments(args, null);
    }

    protected void initializeGlobalArguments(Collection<Argument> args, ArgumentGroup argGroup) throws ArgumentException {
        for (Argument arg : args) {
            this.addGlobalArgument(arg, argGroup);
        }
        this.setFilePropertiesArgument(this.propertiesFileArg);
    }

    public String getHostName() {
        return this.secureArgsList.getHostName();
    }

    public String getPort() {
        return this.secureArgsList.getPort();
    }

    public int validateGlobalOptions(MessageBuilder buf) {
        int ret = this.secureArgsList.validateGlobalOptions(buf);
        if (this.noPropertiesFileArg.isPresent() && this.propertiesFileArg.isPresent()) {
            Message message = ToolMessages.ERR_TOOL_CONFLICTING_ARGS.get(this.noPropertiesFileArg.getLongIdentifier(), this.propertiesFileArg.getLongIdentifier());
            if (buf.length() > 0) {
                buf.append(EOL);
            }
            buf.append(message);
            ret = DsFrameworkCliReturnCode.CONFLICTING_ARGS.getReturnCode();
        }
        return ret;
    }

    public int validateGlobalOptions(PrintStream err) {
        MessageBuilder buf = new MessageBuilder();
        int returnValue = this.validateGlobalOptions(buf);
        if (buf.length() > 0) {
            err.println(StaticUtils.wrapText(buf.toString(), ServerConstants.MAX_LINE_WIDTH));
        }
        return returnValue;
    }

    public boolean isVerbose() {
        return this.verboseArg.isPresent();
    }

    public boolean useSSL() {
        return this.secureArgsList.useSSL();
    }

    public boolean useStartTLS() {
        return this.secureArgsList.useStartTLS();
    }

    public ApplicationTrustManager getTrustManager() {
        return this.secureArgsList.getTrustManager();
    }

    public KeyManager getKeyManager() {
        return this.secureArgsList.getKeyManager();
    }

    public int getConnectTimeout() throws IllegalStateException {
        try {
            return this.secureArgsList.connectTimeoutArg.getIntValue();
        }
        catch (ArgumentException ae) {
            throw new IllegalStateException("Argument parser is not parsed: " + ae, ae);
        }
    }
}

