/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.task;

import org.opends.messages.Message;
import org.opends.messages.TaskMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TaskState {
    UNSCHEDULED(TaskMessages.INFO_TASK_STATE_UNSCHEDULED.get()),
    DISABLED(TaskMessages.INFO_TASK_STATE_DISABLED.get()),
    WAITING_ON_START_TIME(TaskMessages.INFO_TASK_STATE_WAITING_ON_START_TIME.get()),
    WAITING_ON_DEPENDENCY(TaskMessages.INFO_TASK_STATE_WAITING_ON_DEPENDENCY.get()),
    RUNNING(TaskMessages.INFO_TASK_STATE_RUNNING.get()),
    RECURRING(TaskMessages.INFO_TASK_STATE_RECURRING.get()),
    COMPLETED_SUCCESSFULLY(TaskMessages.INFO_TASK_STATE_COMPLETED_SUCCESSFULLY.get()),
    COMPLETED_WITH_ERRORS(TaskMessages.INFO_TASK_STATE_COMPLETED_WITH_ERRORS.get()),
    STOPPED_BY_SHUTDOWN(TaskMessages.INFO_TASK_STATE_STOPPED_BY_SHUTDOWN.get()),
    STOPPED_BY_ERROR(TaskMessages.INFO_TASK_STATE_STOPPED_BY_ERROR.get()),
    STOPPED_BY_ADMINISTRATOR(TaskMessages.INFO_TASK_STATE_STOPPED_BY_ADMINISTRATOR.get()),
    CANCELED_BEFORE_STARTING(TaskMessages.INFO_TASK_STATE_CANCELED_BEFORE_STARTING.get());

    private Message displayName;

    public static boolean isPending(TaskState taskState) {
        switch (taskState) {
            case UNSCHEDULED: 
            case WAITING_ON_START_TIME: 
            case WAITING_ON_DEPENDENCY: {
                return true;
            }
        }
        return false;
    }

    public static boolean isRunning(TaskState taskState) {
        switch (taskState) {
            case RUNNING: {
                return true;
            }
        }
        return false;
    }

    public static boolean isRecurring(TaskState taskState) {
        switch (taskState) {
            case RECURRING: {
                return true;
            }
        }
        return false;
    }

    public static boolean isDone(TaskState taskState) {
        switch (taskState) {
            case UNSCHEDULED: 
            case WAITING_ON_START_TIME: 
            case WAITING_ON_DEPENDENCY: 
            case RUNNING: {
                return false;
            }
        }
        return true;
    }

    public static boolean isSuccessful(TaskState taskState) {
        switch (taskState) {
            case WAITING_ON_START_TIME: 
            case WAITING_ON_DEPENDENCY: 
            case RUNNING: 
            case STOPPED_BY_ERROR: 
            case COMPLETED_WITH_ERRORS: {
                return false;
            }
        }
        return true;
    }

    public static boolean isCancelled(TaskState taskState) {
        switch (taskState) {
            case STOPPED_BY_ADMINISTRATOR: 
            case CANCELED_BEFORE_STARTING: {
                return true;
            }
        }
        return false;
    }

    public static TaskState fromString(String s) {
        String lowerString = s.toLowerCase();
        if (lowerString.equals("unscheduled")) {
            return UNSCHEDULED;
        }
        if (lowerString.equals("disabled")) {
            return DISABLED;
        }
        if (lowerString.equals("waiting_on_start_time")) {
            return WAITING_ON_START_TIME;
        }
        if (lowerString.equals("waiting_on_dependency")) {
            return WAITING_ON_DEPENDENCY;
        }
        if (lowerString.equals("running")) {
            return RUNNING;
        }
        if (lowerString.equals("recurring")) {
            return RECURRING;
        }
        if (lowerString.equals("completed_successfully")) {
            return COMPLETED_SUCCESSFULLY;
        }
        if (lowerString.equals("completed_with_errors")) {
            return COMPLETED_WITH_ERRORS;
        }
        if (lowerString.equals("stopped_by_shutdown")) {
            return STOPPED_BY_SHUTDOWN;
        }
        if (lowerString.equals("stopped_by_error")) {
            return STOPPED_BY_ERROR;
        }
        if (lowerString.equals("stopped_by_administrator")) {
            return STOPPED_BY_ADMINISTRATOR;
        }
        if (lowerString.equals("canceled_before_starting")) {
            return CANCELED_BEFORE_STARTING;
        }
        return null;
    }

    public Message getDisplayName() {
        return this.displayName;
    }

    private TaskState(Message displayName) {
        this.displayName = displayName;
    }
}

