/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.plugin.PluginResult;
import org.opends.server.core.BindOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.PluginConfigManager;
import org.opends.server.core.Workflow;
import org.opends.server.core.WorkflowImpl;
import org.opends.server.core.networkgroups.NetworkGroup;
import org.opends.server.loggers.AccessLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.AbstractOperation;
import org.opends.server.types.AuthenticationInfo;
import org.opends.server.types.AuthenticationType;
import org.opends.server.types.ByteString;
import org.opends.server.types.CancelRequest;
import org.opends.server.types.CancelResult;
import org.opends.server.types.CanceledOperationException;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.OperationType;
import org.opends.server.types.ResultCode;
import org.opends.server.types.operation.PreParseBindOperation;
import org.opends.server.workflowelement.localbackend.LocalBackendBindOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindOperationBasis
extends AbstractOperation
implements BindOperation,
PreParseBindOperation {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ByteString saslCredentials;
    private ByteString serverSASLCredentials;
    private AuthenticationInfo authInfo = null;
    private AuthenticationType authType;
    private ByteString rawBindDN;
    private ByteString simplePassword;
    private DN bindDN;
    private DN userEntryDN;
    private Entry saslAuthUserEntry;
    private List<Control> responseControls;
    private Message authFailureReason;
    private String saslMechanism;
    private String protocolVersion;

    public BindOperationBasis(ClientConnection clientConnection, long operationID, int messageID, List<Control> requestControls, String protocolVersion, ByteString rawBindDN, ByteString simplePassword) {
        super(clientConnection, operationID, messageID, requestControls);
        this.protocolVersion = protocolVersion;
        this.authType = AuthenticationType.SIMPLE;
        this.saslMechanism = null;
        this.saslCredentials = null;
        this.rawBindDN = rawBindDN == null ? ByteString.empty() : rawBindDN;
        this.simplePassword = simplePassword == null ? ByteString.empty() : simplePassword;
        this.bindDN = null;
        this.userEntryDN = null;
        this.responseControls = new ArrayList<Control>(0);
        this.authFailureReason = null;
        this.saslAuthUserEntry = null;
        this.cancelResult = new CancelResult(ResultCode.CANNOT_CANCEL, CoreMessages.ERR_CANNOT_CANCEL_BIND.get());
    }

    public BindOperationBasis(ClientConnection clientConnection, long operationID, int messageID, List<Control> requestControls, String protocolVersion, ByteString rawBindDN, String saslMechanism, ByteString saslCredentials) {
        super(clientConnection, operationID, messageID, requestControls);
        this.protocolVersion = protocolVersion;
        this.authType = AuthenticationType.SASL;
        this.saslMechanism = saslMechanism;
        this.saslCredentials = saslCredentials;
        this.simplePassword = null;
        this.rawBindDN = rawBindDN == null ? ByteString.empty() : rawBindDN;
        this.bindDN = null;
        this.userEntryDN = null;
        this.responseControls = new ArrayList<Control>(0);
        this.authFailureReason = null;
        this.saslAuthUserEntry = null;
        this.cancelResult = new CancelResult(ResultCode.CANNOT_CANCEL, CoreMessages.ERR_CANNOT_CANCEL_BIND.get());
    }

    public BindOperationBasis(ClientConnection clientConnection, long operationID, int messageID, List<Control> requestControls, String protocolVersion, DN bindDN, ByteString simplePassword) {
        super(clientConnection, operationID, messageID, requestControls);
        this.protocolVersion = protocolVersion;
        this.authType = AuthenticationType.SIMPLE;
        this.bindDN = bindDN;
        this.saslMechanism = null;
        this.saslCredentials = null;
        this.rawBindDN = bindDN == null ? ByteString.empty() : ByteString.valueOf(bindDN.toString());
        this.simplePassword = simplePassword == null ? ByteString.empty() : simplePassword;
        this.responseControls = new ArrayList<Control>(0);
        this.authFailureReason = null;
        this.saslAuthUserEntry = null;
        this.userEntryDN = null;
        this.cancelResult = new CancelResult(ResultCode.CANNOT_CANCEL, CoreMessages.ERR_CANNOT_CANCEL_BIND.get());
    }

    public BindOperationBasis(ClientConnection clientConnection, long operationID, int messageID, List<Control> requestControls, String protocolVersion, DN bindDN, String saslMechanism, ByteString saslCredentials) {
        super(clientConnection, operationID, messageID, requestControls);
        this.protocolVersion = protocolVersion;
        this.authType = AuthenticationType.SASL;
        this.bindDN = bindDN;
        this.saslMechanism = saslMechanism;
        this.saslCredentials = saslCredentials;
        this.simplePassword = null;
        this.rawBindDN = bindDN == null ? ByteString.empty() : ByteString.valueOf(bindDN.toString());
        this.responseControls = new ArrayList<Control>(0);
        this.authFailureReason = null;
        this.saslAuthUserEntry = null;
        this.userEntryDN = null;
        this.cancelResult = new CancelResult(ResultCode.CANNOT_CANCEL, CoreMessages.ERR_CANNOT_CANCEL_BIND.get());
    }

    @Override
    public final AuthenticationType getAuthenticationType() {
        return this.authType;
    }

    @Override
    public final ByteString getRawBindDN() {
        return this.rawBindDN;
    }

    @Override
    public final void setRawBindDN(ByteString rawBindDN) {
        this.rawBindDN = rawBindDN == null ? ByteString.empty() : rawBindDN;
        this.bindDN = null;
    }

    @Override
    public final DN getBindDN() {
        try {
            if (this.bindDN == null) {
                this.bindDN = DN.decode(this.rawBindDN);
            }
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            this.setResultCode(ResultCode.INVALID_CREDENTIALS);
            this.setAuthFailureReason(de.getMessageObject());
        }
        return this.bindDN;
    }

    @Override
    public final ByteString getSimplePassword() {
        return this.simplePassword;
    }

    @Override
    public final void setSimplePassword(ByteString simplePassword) {
        this.simplePassword = simplePassword == null ? ByteString.empty() : simplePassword;
        this.authType = AuthenticationType.SIMPLE;
        this.saslMechanism = null;
        this.saslCredentials = null;
    }

    @Override
    public final String getSASLMechanism() {
        return this.saslMechanism;
    }

    @Override
    public final ByteString getSASLCredentials() {
        return this.saslCredentials;
    }

    @Override
    public final void setSASLCredentials(String saslMechanism, ByteString saslCredentials) {
        this.saslMechanism = saslMechanism;
        this.saslCredentials = saslCredentials;
        this.authType = AuthenticationType.SASL;
        this.simplePassword = null;
    }

    @Override
    public final ByteString getServerSASLCredentials() {
        return this.serverSASLCredentials;
    }

    @Override
    public final void setServerSASLCredentials(ByteString serverSASLCredentials) {
        this.serverSASLCredentials = serverSASLCredentials;
    }

    @Override
    public final Entry getSASLAuthUserEntry() {
        return this.saslAuthUserEntry;
    }

    @Override
    public final void setSASLAuthUserEntry(Entry saslAuthUserEntry) {
        this.saslAuthUserEntry = saslAuthUserEntry;
    }

    @Override
    public final Message getAuthFailureReason() {
        return this.authFailureReason;
    }

    @Override
    public final void setAuthFailureReason(Message message) {
        if (DirectoryServer.returnBindErrorMessages()) {
            this.appendErrorMessage(message);
        } else {
            this.authFailureReason = message;
        }
    }

    @Override
    public final DN getUserEntryDN() {
        return this.userEntryDN;
    }

    @Override
    public final AuthenticationInfo getAuthenticationInfo() {
        return this.authInfo;
    }

    @Override
    public final void setAuthenticationInfo(AuthenticationInfo authInfo) {
        this.authInfo = authInfo;
    }

    @Override
    public final OperationType getOperationType() {
        return OperationType.BIND;
    }

    @Override
    public final String[][] getRequestLogElements() {
        if (this.authType == AuthenticationType.SASL) {
            return new String[][]{{"bindDN", String.valueOf(this.rawBindDN)}, {"authType", this.authType.toString()}, {"saslMechanism", this.saslMechanism}};
        }
        return new String[][]{{"bindDN", String.valueOf(this.rawBindDN)}, {"authType", this.authType.toString()}};
    }

    @Override
    public final String[][] getResponseLogElements() {
        String referrals;
        String resultCode = String.valueOf(this.getResultCode().getIntValue());
        MessageBuilder errorMessageBuffer = this.getErrorMessage();
        String errorMessage = errorMessageBuffer == null ? null : errorMessageBuffer.toString();
        DN matchedDN = this.getMatchedDN();
        String matchedDNStr = matchedDN == null ? null : matchedDN.toString();
        List<String> referralURLs = this.getReferralURLs();
        if (referralURLs == null || referralURLs.isEmpty()) {
            referrals = null;
        } else {
            StringBuilder buffer = new StringBuilder();
            Iterator<String> iterator = referralURLs.iterator();
            buffer.append(iterator.next());
            while (iterator.hasNext()) {
                buffer.append(", ");
                buffer.append(iterator.next());
            }
            referrals = buffer.toString();
        }
        String processingTime = String.valueOf(this.getProcessingTime());
        return new String[][]{{"resultCode", resultCode}, {"errorMessage", errorMessage}, {"matchedDN", matchedDNStr}, {"referralURLs", referrals}, {"processingTime", processingTime}};
    }

    @Override
    public final List<Control> getResponseControls() {
        return this.responseControls;
    }

    @Override
    public final void addResponseControl(Control control) {
        this.responseControls.add(control);
    }

    @Override
    public final void removeResponseControl(Control control) {
        this.responseControls.remove(control);
    }

    @Override
    public final void toString(StringBuilder buffer) {
        buffer.append("BindOperation(connID=");
        buffer.append(this.clientConnection.getConnectionID());
        buffer.append(", opID=");
        buffer.append(this.operationID);
        buffer.append(", protocol=\"");
        buffer.append(this.clientConnection.getProtocol());
        buffer.append(" ");
        buffer.append(this.protocolVersion);
        buffer.append(", dn=");
        buffer.append(this.rawBindDN);
        buffer.append(", authType=");
        buffer.append((Object)this.authType);
        buffer.append(")");
    }

    @Override
    public void setUserEntryDN(DN userEntryDN) {
        this.userEntryDN = userEntryDN;
    }

    @Override
    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    @Override
    public void setProtocolVersion(String protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        this.setResultCode(ResultCode.UNDEFINED);
        this.setProcessingStartTime();
        AccessLogger.logBindRequest(this);
        ClientConnection clientConnection = this.getClientConnection();
        clientConnection.setUnauthenticated();
        Message cancelReason = CoreMessages.INFO_CANCELED_BY_BIND_REQUEST.get();
        CancelRequest cancelRequest = new CancelRequest(true, cancelReason);
        clientConnection.cancelAllOperationsExcept(cancelRequest, this.getMessageID());
        PluginConfigManager pluginConfigManager = DirectoryServer.getPluginConfigManager();
        boolean workflowExecuted = false;
        try {
            Workflow workflow;
            boolean isInConfig;
            PluginResult.PreParse preParseResult = pluginConfigManager.invokePreParseBindPlugins(this);
            if (!preParseResult.continueProcessing()) {
                this.setResultCode(preParseResult.getResultCode());
                this.appendErrorMessage(preParseResult.getErrorMessage());
                this.setMatchedDN(preParseResult.getMatchedDN());
                this.setReferralURLs(preParseResult.getReferralURLs());
                return;
            }
            DN bindDN = this.getBindDN();
            if (bindDN == null) {
                return;
            }
            switch (this.getAuthenticationType()) {
                case SIMPLE: {
                    DN actualRootDN = DirectoryServer.getActualRootBindDN(bindDN);
                    if (actualRootDN == null) break;
                    bindDN = actualRootDN;
                }
            }
            try {
                isInConfig = bindDN.isDescendantOf(DN.decode("cn=config"));
            }
            catch (DirectoryException ex) {
                isInConfig = false;
            }
            if (isInConfig) {
                workflow = WorkflowImpl.getWorkflow("__config.ldif__#cn=config");
            } else {
                NetworkGroup ng = this.getClientConnection().getNetworkGroup();
                workflow = ng.getWorkflowCandidate(bindDN);
            }
            if (workflow == null) {
                this.updateOperationErrMsgAndResCode();
                return;
            }
            workflow.execute(this);
            workflowExecuted = true;
        }
        catch (CanceledOperationException coe) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, coe);
            }
            this.setResultCode(ResultCode.CANCELED);
            this.appendErrorMessage(cancelRequest.getCancelReason());
        }
        finally {
            this.setProcessingStopTime();
            AccessLogger.logBindResponse(this);
            clientConnection.sendResponse(this);
            if (this.getResultCode() != ResultCode.SASL_BIND_IN_PROGRESS) {
                clientConnection.finishSaslBind();
            }
            clientConnection.finishBindOrStartTLS();
            this.invokePostResponsePlugins(workflowExecuted);
        }
    }

    private void invokePostResponsePlugins(boolean workflowExecuted) {
        List localOperations;
        PluginConfigManager pluginConfigManager = DirectoryServer.getPluginConfigManager();
        if (workflowExecuted && (localOperations = (List)this.getAttachment("LocalBackendOperations")) != null) {
            for (Object localOp : localOperations) {
                LocalBackendBindOperation localOperation = (LocalBackendBindOperation)localOp;
                pluginConfigManager.invokePostResponseBindPlugins(localOperation);
            }
        }
    }

    private void updateOperationErrMsgAndResCode() {
        Message message = CoreMessages.ERR_BIND_OPERATION_UNKNOWN_USER.get(String.valueOf(this.getBindDN()));
        this.setResultCode(ResultCode.INVALID_CREDENTIALS);
        this.setAuthFailureReason(message);
    }
}

