/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.admin.std.server.RootCfg;
import org.opends.server.admin.std.server.WorkflowCfg;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.WorkflowImpl;
import org.opends.server.core.networkgroups.NetworkGroup;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ResultCode;
import org.opends.server.workflowelement.WorkflowElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowConfigManager
implements ConfigurationChangeListener<WorkflowCfg>,
ConfigurationAddListener<WorkflowCfg>,
ConfigurationDeleteListener<WorkflowCfg> {
    private ConcurrentHashMap<DN, WorkflowImpl> workflows = new ConcurrentHashMap();

    public void initializeWorkflows() throws ConfigException {
        ServerManagementContext managementContext = ServerManagementContext.getInstance();
        RootCfg rootConfiguration = managementContext.getRootConfiguration();
        rootConfiguration.addWorkflowAddListener(this);
        rootConfiguration.addWorkflowDeleteListener(this);
        for (String workflowName : rootConfiguration.listWorkflows()) {
            WorkflowCfg workflowConfiguration = rootConfiguration.getWorkflow(workflowName);
            workflowConfiguration.addChangeListener(this);
            if (!workflowConfiguration.isEnabled()) continue;
            try {
                this.createAndRegisterWorkflow(workflowConfiguration);
            }
            catch (DirectoryException de) {
                throw new ConfigException(de.getMessageObject());
            }
        }
    }

    @Override
    public boolean isConfigurationAddAcceptable(WorkflowCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationAdd(WorkflowCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        configuration.addChangeListener(this);
        if (configuration.isEnabled()) {
            try {
                this.createAndRegisterWorkflow(configuration);
            }
            catch (DirectoryException de) {
                if (resultCode == ResultCode.SUCCESS) {
                    resultCode = de.getResultCode();
                }
                messages.add(de.getMessageObject());
            }
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationDeleteAcceptable(WorkflowCfg configuration, List<Message> unacceptableReasons) {
        boolean acceptable = true;
        WorkflowImpl existingWorkflow = this.workflows.get(configuration.dn());
        if (existingWorkflow != null) {
            acceptable = this.checkReferenceCounter(existingWorkflow, unacceptableReasons);
        }
        return acceptable;
    }

    @Override
    public ConfigChangeResult applyConfigurationDelete(WorkflowCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        WorkflowImpl workflow = this.workflows.remove(configuration.dn());
        if (workflow != null) {
            boolean acceptable = this.checkReferenceCounter(workflow, messages);
            if (acceptable) {
                workflow.deregister();
                workflow.finalizeWorkflow();
                NetworkGroup.getInternalNetworkGroup().deregisterWorkflow(workflow.getWorkflowId());
                NetworkGroup.getAdminNetworkGroup().deregisterWorkflow(workflow.getWorkflowId());
            } else {
                resultCode = ResultCode.UNWILLING_TO_PERFORM;
            }
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(WorkflowCfg configuration, List<Message> unacceptableReasons) {
        WorkflowImpl existingWorkflow = this.workflows.get(configuration.dn());
        boolean acceptable = true;
        if (!configuration.isEnabled() && existingWorkflow != null) {
            acceptable = this.checkReferenceCounter(existingWorkflow, unacceptableReasons);
        }
        return acceptable;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(WorkflowCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        WorkflowImpl existingWorkflow = this.workflows.get(configuration.dn());
        if (!configuration.isEnabled()) {
            if (existingWorkflow != null) {
                boolean acceptable = this.checkReferenceCounter(existingWorkflow, messages);
                if (acceptable) {
                    this.workflows.remove(configuration.dn());
                    existingWorkflow.deregister();
                    existingWorkflow.finalizeWorkflow();
                    NetworkGroup.getInternalNetworkGroup().deregisterWorkflow(existingWorkflow.getWorkflowId());
                    NetworkGroup.getAdminNetworkGroup().deregisterWorkflow(existingWorkflow.getWorkflowId());
                } else {
                    resultCode = ResultCode.UNWILLING_TO_PERFORM;
                }
            }
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        if (existingWorkflow == null) {
            try {
                this.createAndRegisterWorkflow(configuration);
            }
            catch (DirectoryException de) {
                if (resultCode == ResultCode.SUCCESS) {
                    resultCode = de.getResultCode();
                }
                messages.add(de.getMessageObject());
            }
        } else {
            existingWorkflow.updateConfig(configuration);
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    private void createAndRegisterWorkflow(WorkflowCfg workflowCfg) throws DirectoryException {
        String workflowId = ((Object)workflowCfg.dn().getRDN().getAttributeValue(0)).toString();
        String rootWorkflowElementID = workflowCfg.getWorkflowElement();
        WorkflowElement rootWorkflowElement = DirectoryServer.getWorkflowElement(rootWorkflowElementID);
        DN baseDN = workflowCfg.getBaseDN();
        WorkflowImpl workflowImpl = new WorkflowImpl(workflowId, baseDN, rootWorkflowElementID, rootWorkflowElement);
        this.workflows.put(workflowCfg.dn(), workflowImpl);
        workflowImpl.register();
        NetworkGroup.getInternalNetworkGroup().registerWorkflow(workflowImpl);
        NetworkGroup.getAdminNetworkGroup().registerWorkflow(workflowImpl);
    }

    private boolean checkReferenceCounter(WorkflowImpl workflow, List<Message> messages) {
        boolean acceptable = true;
        int refCounter = workflow.getReferenceCounter();
        if (refCounter != 0) {
            Message message = CoreMessages.INFO_ERR_WORKFLOW_IN_USE.get(workflow.getWorkflowId(), workflow.getReferenceCounter());
            messages.add(message);
            acceptable = false;
        }
        return acceptable;
    }
}

