/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.server.admin.std.server.CollectiveAttributeSubentriesVirtualAttributeCfg;
import org.opends.server.api.VirtualAttributeProvider;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.SearchOperation;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AttributeValues;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SubEntry;
import org.opends.server.types.VirtualAttributeRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectiveAttributeSubentriesVirtualAttributeProvider
extends VirtualAttributeProvider<CollectiveAttributeSubentriesVirtualAttributeCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();

    @Override
    public void initializeVirtualAttributeProvider(CollectiveAttributeSubentriesVirtualAttributeCfg configuration) throws ConfigException, InitializationException {
    }

    @Override
    public boolean isMultiValued() {
        return true;
    }

    @Override
    public Set<AttributeValue> getValues(Entry entry, VirtualAttributeRule rule) {
        HashSet<AttributeValue> valueSet = new HashSet<AttributeValue>();
        if (!entry.isSubentry() && !entry.isLDAPSubentry()) {
            List<SubEntry> subentries = DirectoryServer.getSubentryManager().getCollectiveSubentries(entry);
            AttributeType dnAttrType = DirectoryServer.getAttributeType("2.5.4.49");
            for (SubEntry subentry : subentries) {
                if (!subentry.isCollective()) continue;
                DN subentryDN = subentry.getDN();
                AttributeValue value = AttributeValues.create(dnAttrType, subentryDN.toString());
                valueSet.add(value);
            }
        }
        return valueSet;
    }

    @Override
    public boolean isSearchable(VirtualAttributeRule rule, SearchOperation searchOperation) {
        return false;
    }

    @Override
    public void processSearch(VirtualAttributeRule rule, SearchOperation searchOperation) {
        searchOperation.setResultCode(ResultCode.UNWILLING_TO_PERFORM);
        Message message = ExtensionMessages.ERR_COLLECTIVEATTRIBUTESUBENTRIES_VATTR_NOT_SEARCHABLE.get(rule.getAttributeType().getNameOrOID());
        searchOperation.appendErrorMessage(message);
    }
}

