/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.server.admin.std.server.StructuralObjectClassVirtualAttributeCfg;
import org.opends.server.api.VirtualAttributeProvider;
import org.opends.server.config.ConfigException;
import org.opends.server.core.SearchOperation;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AttributeValues;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConditionResult;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.types.VirtualAttributeRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructuralObjectClassVirtualAttributeProvider
extends VirtualAttributeProvider<StructuralObjectClassVirtualAttributeCfg> {
    @Override
    public void initializeVirtualAttributeProvider(StructuralObjectClassVirtualAttributeCfg configuration) throws ConfigException, InitializationException {
    }

    @Override
    public boolean isMultiValued() {
        return false;
    }

    @Override
    public Set<AttributeValue> getValues(Entry entry, VirtualAttributeRule rule) {
        AttributeValue value = AttributeValues.create(rule.getAttributeType(), entry.getStructuralObjectClass().getNameOrOID());
        return Collections.singleton(value);
    }

    @Override
    public boolean hasValue(Entry entry, VirtualAttributeRule rule) {
        return true;
    }

    @Override
    public ConditionResult matchesSubstring(Entry entry, VirtualAttributeRule rule, ByteString subInitial, List<ByteString> subAny, ByteString subFinal) {
        return ConditionResult.UNDEFINED;
    }

    @Override
    public ConditionResult greaterThanOrEqualTo(Entry entry, VirtualAttributeRule rule, AttributeValue value) {
        return ConditionResult.UNDEFINED;
    }

    @Override
    public ConditionResult lessThanOrEqualTo(Entry entry, VirtualAttributeRule rule, AttributeValue value) {
        return ConditionResult.UNDEFINED;
    }

    @Override
    public ConditionResult approximatelyEqualTo(Entry entry, VirtualAttributeRule rule, AttributeValue value) {
        return ConditionResult.UNDEFINED;
    }

    @Override
    public boolean isSearchable(VirtualAttributeRule rule, SearchOperation searchOperation) {
        return false;
    }

    @Override
    public void processSearch(VirtualAttributeRule rule, SearchOperation searchOperation) {
        searchOperation.setResultCode(ResultCode.UNWILLING_TO_PERFORM);
        Message message = ExtensionMessages.ERR_VATTR_NOT_SEARCHABLE.get(rule.getAttributeType().getNameOrOID());
        searchOperation.appendErrorMessage(message);
    }
}

