/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.plugins.profiler;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.opends.messages.Message;
import org.opends.messages.PluginMessages;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.meta.PluginCfgDefn;
import org.opends.server.admin.std.server.PluginCfg;
import org.opends.server.admin.std.server.ProfilerPluginCfg;
import org.opends.server.api.plugin.DirectoryServerPlugin;
import org.opends.server.api.plugin.PluginResult;
import org.opends.server.api.plugin.PluginType;
import org.opends.server.config.ConfigException;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.plugins.profiler.ProfilerThread;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryConfig;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.TimeThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProfilerPlugin
extends DirectoryServerPlugin<ProfilerPluginCfg>
implements ConfigurationChangeListener<ProfilerPluginCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    public static final String PROFILE_ACTION_NONE = "none";
    public static final String PROFILE_ACTION_START = "start";
    public static final String PROFILE_ACTION_STOP = "stop";
    public static final String PROFILE_ACTION_CANCEL = "cancel";
    private DN configEntryDN;
    private ProfilerPluginCfg currentConfig;
    private ProfilerThread profilerThread;

    @Override
    public final void initializePlugin(Set<PluginType> pluginTypes, ProfilerPluginCfg configuration) throws ConfigException {
        configuration.addProfilerChangeListener(this);
        this.currentConfig = configuration;
        this.configEntryDN = configuration.dn();
        if (pluginTypes.isEmpty()) {
            Message message = PluginMessages.ERR_PLUGIN_PROFILER_NO_PLUGIN_TYPES.get(String.valueOf(this.configEntryDN));
            throw new ConfigException(message);
        }
        for (PluginType t : pluginTypes) {
            if (t == PluginType.STARTUP) continue;
            Message message = PluginMessages.ERR_PLUGIN_PROFILER_INVALID_PLUGIN_TYPE.get(String.valueOf(this.configEntryDN), String.valueOf((Object)t));
            throw new ConfigException(message);
        }
        File profileDirectory = StaticUtils.getFileForPath(configuration.getProfileDirectory());
        if (!profileDirectory.exists() || !profileDirectory.isDirectory()) {
            Message message = PluginMessages.WARN_PLUGIN_PROFILER_INVALID_PROFILE_DIR.get(profileDirectory.getAbsolutePath(), String.valueOf(this.configEntryDN));
            throw new ConfigException(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void finalizePlugin() {
        this.currentConfig.removeProfilerChangeListener(this);
        ProfilerPlugin profilerPlugin = this;
        synchronized (profilerPlugin) {
            if (this.profilerThread != null) {
                this.profilerThread.stopProfiling();
                String filename = this.currentConfig.getProfileDirectory() + File.separator + "profile." + TimeThread.getGMTTime();
                try {
                    this.profilerThread.writeCaptureData(filename);
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    Message message = PluginMessages.ERR_PLUGIN_PROFILER_CANNOT_WRITE_PROFILE_DATA.get(String.valueOf(this.configEntryDN), filename, StaticUtils.stackTraceToSingleLineString(e));
                    ErrorLogger.logError(message);
                }
            }
        }
    }

    @Override
    public final PluginResult.Startup doStartup() {
        ProfilerPluginCfg config = this.currentConfig;
        if (config.isEnableProfilingOnStartup()) {
            this.profilerThread = new ProfilerThread(config.getProfileSampleInterval());
            this.profilerThread.start();
        }
        return PluginResult.Startup.continueStartup();
    }

    @Override
    public boolean isConfigurationAcceptable(PluginCfg configuration, List<Message> unacceptableReasons) {
        ProfilerPluginCfg config = (ProfilerPluginCfg)configuration;
        return this.isConfigurationChangeAcceptable(config, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(ProfilerPluginCfg configuration, List<Message> unacceptableReasons) {
        boolean configAcceptable = true;
        DN cfgEntryDN = configuration.dn();
        if (configuration.getPluginType().isEmpty()) {
            Message message = PluginMessages.ERR_PLUGIN_PROFILER_NO_PLUGIN_TYPES.get(String.valueOf(cfgEntryDN));
            unacceptableReasons.add(message);
            configAcceptable = false;
        } else {
            for (PluginCfgDefn.PluginType t : configuration.getPluginType()) {
                if (t == PluginCfgDefn.PluginType.STARTUP) continue;
                Message message = PluginMessages.ERR_PLUGIN_PROFILER_INVALID_PLUGIN_TYPE.get(String.valueOf(cfgEntryDN), String.valueOf((Object)t));
                unacceptableReasons.add(message);
                configAcceptable = false;
                break;
            }
        }
        File profileDirectory = StaticUtils.getFileForPath(configuration.getProfileDirectory());
        if (!profileDirectory.exists() || !profileDirectory.isDirectory()) {
            unacceptableReasons.add(PluginMessages.WARN_PLUGIN_PROFILER_INVALID_PROFILE_DIR.get(profileDirectory.getAbsolutePath(), String.valueOf(cfgEntryDN)));
            configAcceptable = false;
        }
        return configAcceptable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigChangeResult applyConfigurationChange(ProfilerPluginCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        this.currentConfig = configuration;
        switch (configuration.getProfileAction()) {
            case START: {
                ProfilerPlugin profilerPlugin = this;
                synchronized (profilerPlugin) {
                    if (this.profilerThread == null) {
                        this.profilerThread = new ProfilerThread(configuration.getProfileSampleInterval());
                        this.profilerThread.start();
                        messages.add(PluginMessages.INFO_PLUGIN_PROFILER_STARTED_PROFILING.get(String.valueOf(this.configEntryDN)));
                    } else {
                        messages.add(PluginMessages.INFO_PLUGIN_PROFILER_ALREADY_PROFILING.get(String.valueOf(this.configEntryDN)));
                    }
                    break;
                }
            }
            case STOP: {
                ProfilerPlugin profilerPlugin = this;
                synchronized (profilerPlugin) {
                    if (this.profilerThread == null) {
                        messages.add(PluginMessages.INFO_PLUGIN_PROFILER_NOT_RUNNING.get(String.valueOf(this.configEntryDN)));
                    } else {
                        this.profilerThread.stopProfiling();
                        messages.add(PluginMessages.INFO_PLUGIN_PROFILER_STOPPED_PROFILING.get(String.valueOf(this.configEntryDN)));
                        String filename = StaticUtils.getFileForPath(configuration.getProfileDirectory()).getAbsolutePath() + File.separator + "profile." + TimeThread.getGMTTime();
                        try {
                            this.profilerThread.writeCaptureData(filename);
                            messages.add(PluginMessages.INFO_PLUGIN_PROFILER_WROTE_PROFILE_DATA.get(String.valueOf(this.configEntryDN), filename));
                        }
                        catch (Exception e) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                            }
                            messages.add(PluginMessages.ERR_PLUGIN_PROFILER_CANNOT_WRITE_PROFILE_DATA.get(String.valueOf(this.configEntryDN), filename, StaticUtils.stackTraceToSingleLineString(e)));
                            resultCode = DirectoryConfig.getServerErrorResultCode();
                        }
                        this.profilerThread = null;
                    }
                    break;
                }
            }
            case CANCEL: {
                ProfilerPlugin profilerPlugin = this;
                synchronized (profilerPlugin) {
                    if (this.profilerThread == null) {
                        messages.add(PluginMessages.INFO_PLUGIN_PROFILER_NOT_RUNNING.get(String.valueOf(this.configEntryDN)));
                    } else {
                        this.profilerThread.stopProfiling();
                        messages.add(PluginMessages.INFO_PLUGIN_PROFILER_STOPPED_PROFILING.get(String.valueOf(this.configEntryDN)));
                        this.profilerThread = null;
                    }
                    break;
                }
            }
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }
}

