/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.protocol;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.zip.DataFormatException;
import org.opends.server.core.AddOperationBasis;
import org.opends.server.core.DirectoryServer;
import org.opends.server.protocols.asn1.ASN1;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.ldap.LDAPAttribute;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.protocol.AddContext;
import org.opends.server.replication.protocol.LDAPUpdateMsg;
import org.opends.server.replication.protocol.ProtocolVersion;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeBuilder;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValues;
import org.opends.server.types.ByteString;
import org.opends.server.types.ByteStringBuilder;
import org.opends.server.types.LDAPException;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.RawAttribute;
import org.opends.server.types.operation.PostOperationAddOperation;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddMsg
extends LDAPUpdateMsg {
    private byte[] encodedAttributes;
    private String parentUniqueId;

    public AddMsg(PostOperationAddOperation op) {
        super((AddContext)op.getAttachment("replicationContext"), op.getRawEntryDN().toString());
        AddContext ctx = (AddContext)op.getAttachment("replicationContext");
        this.parentUniqueId = ctx.getParentUid();
        this.encodedAttributes = this.encodeAttributes(op.getObjectClasses(), op.getUserAttributes(), op.getOperationalAttributes());
    }

    public AddMsg(ChangeNumber cn, String dn, String uniqueId, String parentId, Map<ObjectClass, String> objectClasses, Map<AttributeType, List<Attribute>> userAttributes, Map<AttributeType, List<Attribute>> operationalAttributes) {
        super(cn, uniqueId, dn);
        this.parentUniqueId = parentId;
        this.encodedAttributes = this.encodeAttributes(objectClasses, userAttributes, operationalAttributes);
    }

    public AddMsg(ChangeNumber cn, String dn, String uniqueId, String parentId, Attribute objectClass, Collection<Attribute> userAttributes, Collection<Attribute> operationalAttributes) {
        super(cn, uniqueId, dn);
        this.parentUniqueId = parentId;
        this.encodedAttributes = this.encodeAttributes(objectClass, userAttributes, operationalAttributes);
    }

    public AddMsg(byte[] in) throws DataFormatException, UnsupportedEncodingException {
        byte[] allowedPduTypes = new byte[]{23, 2};
        int pos = this.decodeHeader(allowedPduTypes, in);
        if (this.protocolVersion <= 3) {
            this.decodeBody_V123(in, pos);
        } else {
            this.decodeBody_V4(in, pos);
        }
        if (this.protocolVersion == ProtocolVersion.getCurrentVersion()) {
            this.bytes = in;
        }
    }

    @Override
    public AddOperationBasis createOperation(InternalClientConnection connection, String newDn) throws LDAPException, ASN1Exception {
        ArrayList<RawAttribute> attr = this.decodeRawAttributes(this.encodedAttributes);
        AddOperationBasis add = new AddOperationBasis(connection, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), null, ByteString.valueOf(newDn), attr);
        AddContext ctx = new AddContext(this.getChangeNumber(), this.getUniqueId(), this.parentUniqueId);
        add.setAttachment("replicationContext", ctx);
        return add;
    }

    @Override
    public byte[] getBytes_V1() throws UnsupportedEncodingException {
        int bodyLength = this.encodedAttributes.length;
        byte[] byteParentId = null;
        if (this.parentUniqueId != null) {
            byteParentId = this.parentUniqueId.getBytes("UTF-8");
            bodyLength += byteParentId.length + 1;
        } else {
            ++bodyLength;
        }
        byte[] resultByteArray = this.encodeHeader_V1((byte)2, bodyLength);
        int pos = resultByteArray.length - bodyLength;
        if (byteParentId != null) {
            pos = AddMsg.addByteArray(byteParentId, resultByteArray, pos);
        } else {
            resultByteArray[pos++] = 0;
        }
        int i = 0;
        while (i < this.encodedAttributes.length) {
            resultByteArray[pos] = this.encodedAttributes[i];
            ++i;
            ++pos;
        }
        return resultByteArray;
    }

    @Override
    public byte[] getBytes_V23() throws UnsupportedEncodingException {
        int bodyLength = this.encodedAttributes.length;
        byte[] byteParentId = null;
        if (this.parentUniqueId != null) {
            byteParentId = this.parentUniqueId.getBytes("UTF-8");
            bodyLength += byteParentId.length + 1;
        } else {
            ++bodyLength;
        }
        byte[] resultByteArray = this.encodeHeader((byte)23, bodyLength, (short)3);
        int pos = resultByteArray.length - bodyLength;
        if (byteParentId != null) {
            pos = AddMsg.addByteArray(byteParentId, resultByteArray, pos);
        } else {
            resultByteArray[pos++] = 0;
        }
        int i = 0;
        while (i < this.encodedAttributes.length) {
            resultByteArray[pos] = this.encodedAttributes[i];
            ++i;
            ++pos;
        }
        return resultByteArray;
    }

    @Override
    public byte[] getBytes_V4() throws UnsupportedEncodingException {
        int bodyLength = 0;
        byte[] byteParentId = null;
        if (this.parentUniqueId != null) {
            byteParentId = this.parentUniqueId.getBytes("UTF-8");
            bodyLength += byteParentId.length + 1;
        } else {
            ++bodyLength;
        }
        byte[] byteAttrLen = String.valueOf(this.encodedAttributes.length).getBytes("UTF-8");
        bodyLength += byteAttrLen.length + 1;
        bodyLength += this.encodedAttributes.length + 1;
        byte[] byteEntryAttrLen = String.valueOf(this.encodedEclIncludes.length).getBytes("UTF-8");
        bodyLength += byteEntryAttrLen.length + 1;
        byte[] encodedMsg = this.encodeHeader((byte)23, bodyLength += this.encodedEclIncludes.length + 1, (short)4);
        int pos = encodedMsg.length - bodyLength;
        if (byteParentId != null) {
            pos = AddMsg.addByteArray(byteParentId, encodedMsg, pos);
        } else {
            encodedMsg[pos++] = 0;
        }
        pos = AddMsg.addByteArray(byteAttrLen, encodedMsg, pos);
        pos = AddMsg.addByteArray(this.encodedAttributes, encodedMsg, pos);
        pos = AddMsg.addByteArray(byteEntryAttrLen, encodedMsg, pos);
        pos = AddMsg.addByteArray(this.encodedEclIncludes, encodedMsg, pos);
        return encodedMsg;
    }

    private byte[] encodeAttributes(Map<ObjectClass, String> objectClasses, Map<AttributeType, List<Attribute>> userAttributes, Map<AttributeType, List<Attribute>> operationalAttributes) {
        ByteStringBuilder byteBuilder = new ByteStringBuilder();
        ASN1Writer writer = ASN1.getWriter(byteBuilder);
        try {
            AttributeBuilder builder = new AttributeBuilder(DirectoryServer.getObjectClassAttributeType());
            builder.setInitialCapacity(objectClasses.size());
            for (String s : objectClasses.values()) {
                builder.add(AttributeValues.create(ByteString.valueOf(s), ByteString.valueOf(StaticUtils.toLowerCase(s))));
            }
            Attribute attr = builder.toAttribute();
            new LDAPAttribute(attr).write(writer);
            for (List<Attribute> list : userAttributes.values()) {
                for (Attribute a : list) {
                    if (a.isVirtual()) continue;
                    new LDAPAttribute(a).write(writer);
                }
            }
            for (List<Attribute> list : operationalAttributes.values()) {
                for (Attribute a : list) {
                    if (a.isVirtual()) continue;
                    new LDAPAttribute(a).write(writer);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return byteBuilder.toByteArray();
    }

    private byte[] encodeAttributes(Attribute objectClass, Collection<Attribute> userAttributes, Collection<Attribute> operationalAttributes) {
        ByteStringBuilder byteBuilder = new ByteStringBuilder();
        ASN1Writer writer = ASN1.getWriter(byteBuilder);
        try {
            new LDAPAttribute(objectClass).write(writer);
            for (Attribute a : userAttributes) {
                new LDAPAttribute(a).write(writer);
            }
            if (operationalAttributes != null) {
                for (Attribute a : operationalAttributes) {
                    new LDAPAttribute(a).write(writer);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return byteBuilder.toByteArray();
    }

    private void decodeBody_V123(byte[] in, int pos) throws DataFormatException, UnsupportedEncodingException {
        int length = this.getNextLength(in, pos);
        if (length != 0) {
            this.parentUniqueId = new String(in, pos, length, "UTF-8");
            pos += length + 1;
        } else {
            this.parentUniqueId = null;
            ++pos;
        }
        this.encodedAttributes = new byte[in.length - pos];
        int i = 0;
        while (pos < in.length) {
            this.encodedAttributes[i++] = in[pos++];
        }
    }

    private void decodeBody_V4(byte[] in, int pos) throws DataFormatException, UnsupportedEncodingException {
        int length = this.getNextLength(in, pos);
        if (length != 0) {
            this.parentUniqueId = new String(in, pos, length, "UTF-8");
            pos += length + 1;
        } else {
            this.parentUniqueId = null;
            ++pos;
        }
        length = this.getNextLength(in, pos);
        int attrLen = Integer.valueOf(new String(in, pos, length, "UTF-8"));
        pos += length + 1;
        this.encodedAttributes = new byte[attrLen];
        try {
            System.arraycopy(in, pos, this.encodedAttributes, 0, attrLen);
        }
        catch (IndexOutOfBoundsException e) {
            throw new DataFormatException(e.getMessage());
        }
        catch (ArrayStoreException e) {
            throw new DataFormatException(e.getMessage());
        }
        catch (NullPointerException e) {
            throw new DataFormatException(e.getMessage());
        }
        length = this.getNextLength(in, pos += attrLen + 1);
        int eclAttrLen = Integer.valueOf(new String(in, pos, length, "UTF-8"));
        pos += length + 1;
        this.encodedEclIncludes = new byte[eclAttrLen];
        try {
            System.arraycopy(in, pos, this.encodedEclIncludes, 0, eclAttrLen);
        }
        catch (IndexOutOfBoundsException e) {
            throw new DataFormatException(e.getMessage());
        }
        catch (ArrayStoreException e) {
            throw new DataFormatException(e.getMessage());
        }
        catch (NullPointerException e) {
            throw new DataFormatException(e.getMessage());
        }
    }

    public String toString() {
        if (this.protocolVersion == 1) {
            return "AddMsg content:  protocolVersion: " + this.protocolVersion + " dn: " + this.dn + " changeNumber: " + this.changeNumber + " uniqueId: " + this.uniqueId + " assuredFlag: " + this.assuredFlag;
        }
        if (this.protocolVersion >= 2) {
            return "AddMsg content:  protocolVersion: " + this.protocolVersion + " dn: " + this.dn + " changeNumber: " + this.changeNumber + " uniqueId: " + this.uniqueId + " assuredFlag: " + this.assuredFlag + " assuredMode: " + (Object)((Object)this.assuredMode) + " safeDataLevel: " + this.safeDataLevel;
        }
        return "!!! Unknown version: " + this.protocolVersion + "!!!";
    }

    public void addAttribute(String name, String value) throws ASN1Exception {
        ByteStringBuilder byteBuilder = new ByteStringBuilder();
        byteBuilder.append(this.encodedAttributes);
        ASN1Writer writer = ASN1.getWriter(byteBuilder);
        try {
            new LDAPAttribute(name, value).write(writer);
            this.encodedAttributes = byteBuilder.toByteArray();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public List<Attribute> getAttributes() throws LDAPException, ASN1Exception {
        ArrayList<Attribute> attrs = this.decodeAttributes(this.encodedAttributes);
        return attrs;
    }

    public void setParentUid(String uid) {
        this.parentUniqueId = uid;
    }

    public String getParentUid() {
        return this.parentUniqueId;
    }

    @Override
    public int size() {
        return this.encodedAttributes.length + this.encodedEclIncludes.length + this.headerSize();
    }
}

