/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockConflictException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.opends.messages.MessageBuilder;
import org.opends.messages.ReplicationMessages;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.server.DraftCNData;
import org.opends.server.replication.server.ReplicationDbEnv;
import org.opends.server.replication.server.ReplicationDraftCNKey;
import org.opends.server.replication.server.ReplicationServer;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.util.StaticUtils;

public class DraftCNDB {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private Database db = null;
    private ReplicationDbEnv dbenv = null;
    private ReplicationServer replicationServer;
    private static final int DEADLOCK_RETRIES = 10;
    private ReentrantReadWriteLock dbCloseLock;

    public DraftCNDB(ReplicationServer replicationServer, ReplicationDbEnv dbenv) throws DatabaseException {
        this.dbenv = dbenv;
        this.replicationServer = replicationServer;
        this.db = dbenv.getOrCreateDraftCNDb();
        this.dbCloseLock = new ReentrantReadWriteLock(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntry(int draftCN, String value, String domainBaseDN, ChangeNumber changeNumber) {
        Transaction txn = null;
        try {
            int tries = 0;
            boolean done = false;
            while (tries++ < 10 && !done) {
                this.dbCloseLock.readLock().lock();
                try {
                    txn = this.dbenv.beginTransaction();
                    ReplicationDraftCNKey key = new ReplicationDraftCNKey(draftCN);
                    DraftCNData data = new DraftCNData(draftCN, value, domainBaseDN, changeNumber);
                    this.db.put(txn, (DatabaseEntry)key, (DatabaseEntry)data);
                    txn.commitWriteNoSync();
                    txn = null;
                    done = true;
                }
                catch (LockConflictException e) {
                    if (txn != null) {
                        txn.abort();
                    }
                    txn = null;
                }
                finally {
                    this.dbCloseLock.readLock().unlock();
                }
            }
            if (!done) {
                MessageBuilder mb = new MessageBuilder();
                mb.append(ReplicationMessages.ERR_CHANGELOG_SHUTDOWN_DATABASE_ERROR.get());
                ErrorLogger.logError(mb.toMessage());
                if (txn != null) {
                    txn.abort();
                }
                this.replicationServer.shutdown();
            }
        }
        catch (DatabaseException e) {
            MessageBuilder mb = new MessageBuilder();
            mb.append(ReplicationMessages.ERR_CHANGELOG_SHUTDOWN_DATABASE_ERROR.get());
            mb.append(StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(mb.toMessage());
            if (txn != null) {
                try {
                    txn.abort();
                }
                catch (DatabaseException e1) {
                    // empty catch block
                }
            }
            this.replicationServer.shutdown();
        }
        catch (UnsupportedEncodingException e) {
            MessageBuilder mb = new MessageBuilder();
            mb.append(ReplicationMessages.ERR_CHANGELOG_UNSUPPORTED_UTF8_ENCODING.get());
            mb.append(StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(mb.toMessage());
            this.replicationServer.shutdown();
            if (txn != null) {
                try {
                    txn.abort();
                }
                catch (DatabaseException e1) {
                    // empty catch block
                }
            }
            this.replicationServer.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        try {
            this.dbCloseLock.writeLock().lock();
            try {
                this.db.close();
            }
            finally {
                this.dbCloseLock.writeLock().unlock();
            }
        }
        catch (DatabaseException e) {
            MessageBuilder mb = new MessageBuilder();
            mb.append(ReplicationMessages.NOTE_EXCEPTION_CLOSING_DATABASE.get(this.toString()));
            mb.append(StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(mb.toMessage());
        }
    }

    public DraftCNDBCursor openReadCursor(int draftCN) throws DatabaseException, Exception {
        return new DraftCNDBCursor(draftCN);
    }

    public DraftCNDBCursor openDeleteCursor() throws DatabaseException, Exception {
        return new DraftCNDBCursor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeLockedCursor(Cursor cursor) throws DatabaseException {
        try {
            if (cursor != null) {
                cursor.close();
            }
        }
        finally {
            this.dbCloseLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int readFirstDraftCN() {
        Cursor cursor = null;
        String str = null;
        try {
            this.dbCloseLock.readLock().lock();
            cursor = this.db.openCursor(null, null);
        }
        catch (DatabaseException e1) {
            this.dbCloseLock.readLock().unlock();
            return 0;
        }
        try {
            try {
                int sn;
                DatabaseEntry key = new DatabaseEntry();
                DatabaseEntry entry = new DatabaseEntry();
                OperationStatus status = cursor.getFirst(key, entry, LockMode.DEFAULT);
                if (status != OperationStatus.SUCCESS) {
                    int n = 0;
                    return n;
                }
                try {
                    str = new String(key.getData(), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    // empty catch block
                }
                int n = sn = new Integer(str).intValue();
                return n;
            }
            finally {
                this.closeLockedCursor(cursor);
            }
        }
        catch (DatabaseException e) {
            MessageBuilder mb = new MessageBuilder();
            mb.append(ReplicationMessages.ERR_CHANGELOG_SHUTDOWN_DATABASE_ERROR.get());
            mb.append(StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(mb.toMessage());
            this.replicationServer.shutdown();
            return 0;
        }
        catch (Exception e) {
            MessageBuilder mb = new MessageBuilder();
            mb.append(ReplicationMessages.ERR_CHANGELOG_SHUTDOWN_DATABASE_ERROR.get());
            mb.append(StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(mb.toMessage());
            this.replicationServer.shutdown();
            return 0;
        }
    }

    public long count() {
        try {
            return this.db.count();
        }
        catch (Exception e) {
            TRACER.debugCaught(DebugLogLevel.ERROR, e);
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int readLastDraftCN() {
        Cursor cursor = null;
        String str = null;
        try {
            int sn;
            DatabaseEntry key;
            block8: {
                int n;
                this.dbCloseLock.readLock().lock();
                try {
                    cursor = this.db.openCursor(null, null);
                    key = new DatabaseEntry();
                    DatabaseEntry entry = new DatabaseEntry();
                    OperationStatus status = cursor.getLast(key, entry, LockMode.DEFAULT);
                    if (status == OperationStatus.SUCCESS) break block8;
                    n = 0;
                }
                catch (Throwable throwable) {
                    this.closeLockedCursor(cursor);
                    throw throwable;
                }
                this.closeLockedCursor(cursor);
                return n;
            }
            try {
                str = new String(key.getData(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
            int n = sn = new Integer(str).intValue();
            this.closeLockedCursor(cursor);
            return n;
        }
        catch (DatabaseException e) {
            MessageBuilder mb = new MessageBuilder();
            mb.append(ReplicationMessages.ERR_CHANGELOG_SHUTDOWN_DATABASE_ERROR.get());
            mb.append(StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(mb.toMessage());
            this.replicationServer.shutdown();
            return 0;
        }
        catch (Exception e) {
            this.replicationServer.shutdown();
            return 0;
        }
    }

    public String toString() {
        return "DraftCNDB";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws Exception, DatabaseException {
        this.dbCloseLock.writeLock().lock();
        try {
            String dbName = this.db.getDatabaseName();
            this.db.close();
            this.dbenv.clearDb(dbName);
            this.db = this.dbenv.getOrCreateDraftCNDb();
        }
        catch (Exception e) {
            MessageBuilder mb = new MessageBuilder();
            mb.append(ReplicationMessages.ERR_ERROR_CLEARING_DB.get(this.toString(), e.getMessage() + " " + StaticUtils.stackTraceToSingleLineString(e)));
            ErrorLogger.logError(mb.toMessage());
        }
        finally {
            this.dbCloseLock.writeLock().unlock();
        }
    }

    public class DraftCNDBCursor {
        private Cursor cursor = null;
        private Transaction txn = null;
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry entry = new DatabaseEntry();

        private DraftCNDBCursor(int startingDraftCN) throws Exception {
            try {
                DraftCNDB.this.dbCloseLock.readLock().lock();
                this.cursor = DraftCNDB.this.db.openCursor(this.txn, null);
                if (startingDraftCN >= 0) {
                    this.key = new ReplicationDraftCNKey(startingDraftCN);
                    this.entry = new DatabaseEntry();
                    if (this.cursor.getSearchKey(this.key, this.entry, LockMode.DEFAULT) != OperationStatus.SUCCESS) {
                        if (this.cursor.getSearchKeyRange(this.key, this.entry, LockMode.DEFAULT) != OperationStatus.SUCCESS) {
                            throw new Exception("ChangeLog Draft Change Number " + startingDraftCN + " is not available");
                        }
                        DatabaseEntry key = new DatabaseEntry();
                        DatabaseEntry data = new DatabaseEntry();
                        if (this.cursor.getPrev(key, data, LockMode.DEFAULT) != OperationStatus.SUCCESS) {
                            DraftCNDB.this.closeLockedCursor(this.cursor);
                            DraftCNDB.this.dbCloseLock.readLock().lock();
                            this.cursor = DraftCNDB.this.db.openCursor(this.txn, null);
                        }
                    }
                }
            }
            catch (Exception e) {
                DraftCNDB.this.closeLockedCursor(this.cursor);
                throw e;
            }
        }

        private DraftCNDBCursor() throws DatabaseException {
            try {
                DraftCNDB.this.dbCloseLock.readLock().lock();
                this.txn = DraftCNDB.this.dbenv.beginTransaction();
                this.cursor = DraftCNDB.this.db.openCursor(this.txn, null);
            }
            catch (DatabaseException e) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                if (this.txn != null) {
                    try {
                        this.txn.abort();
                    }
                    catch (DatabaseException databaseException) {
                        // empty catch block
                    }
                }
                DraftCNDB.this.closeLockedCursor(this.cursor);
                throw e;
            }
        }

        public void close() {
            MessageBuilder mb;
            try {
                DraftCNDB.this.closeLockedCursor(this.cursor);
                this.cursor = null;
            }
            catch (DatabaseException e) {
                mb = new MessageBuilder();
                mb.append(ReplicationMessages.ERR_CHANGELOG_SHUTDOWN_DATABASE_ERROR.get());
                mb.append(StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(mb.toMessage());
                DraftCNDB.this.replicationServer.shutdown();
            }
            if (this.txn != null) {
                try {
                    this.txn.commit();
                }
                catch (DatabaseException e) {
                    mb = new MessageBuilder();
                    mb.append(ReplicationMessages.ERR_CHANGELOG_SHUTDOWN_DATABASE_ERROR.get());
                    mb.append(StaticUtils.stackTraceToSingleLineString(e));
                    ErrorLogger.logError(mb.toMessage());
                    DraftCNDB.this.replicationServer.shutdown();
                }
            }
        }

        public void abort() {
            MessageBuilder mb;
            if (this.cursor == null) {
                return;
            }
            try {
                DraftCNDB.this.closeLockedCursor(this.cursor);
                this.cursor = null;
            }
            catch (LockConflictException e1) {
            }
            catch (DatabaseException e) {
                mb = new MessageBuilder();
                mb.append(ReplicationMessages.ERR_CHANGELOG_SHUTDOWN_DATABASE_ERROR.get());
                mb.append(StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(mb.toMessage());
                DraftCNDB.this.replicationServer.shutdown();
            }
            if (this.txn != null) {
                try {
                    this.txn.abort();
                }
                catch (DatabaseException e) {
                    mb = new MessageBuilder();
                    mb.append(ReplicationMessages.ERR_CHANGELOG_SHUTDOWN_DATABASE_ERROR.get());
                    mb.append(StaticUtils.stackTraceToSingleLineString(e));
                    ErrorLogger.logError(mb.toMessage());
                    DraftCNDB.this.replicationServer.shutdown();
                }
            }
        }

        public String currentValue() throws DatabaseException {
            try {
                OperationStatus status = this.cursor.getCurrent(this.key, this.entry, LockMode.DEFAULT);
                if (status != OperationStatus.SUCCESS) {
                    return null;
                }
                DraftCNData seqnumData = new DraftCNData(this.entry.getData());
                return seqnumData.getValue();
            }
            catch (Exception e) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                return null;
            }
        }

        public String currentServiceID() throws DatabaseException {
            try {
                OperationStatus status = this.cursor.getCurrent(this.key, this.entry, LockMode.DEFAULT);
                if (status != OperationStatus.SUCCESS) {
                    return null;
                }
                DraftCNData seqnumData = new DraftCNData(this.entry.getData());
                return seqnumData.getServiceID();
            }
            catch (Exception exception) {
                return null;
            }
        }

        public ChangeNumber currentChangeNumber() throws DatabaseException {
            try {
                OperationStatus status = this.cursor.getCurrent(this.key, this.entry, LockMode.DEFAULT);
                if (status != OperationStatus.SUCCESS) {
                    return null;
                }
                DraftCNData seqnumData = new DraftCNData(this.entry.getData());
                return seqnumData.getChangeNumber();
            }
            catch (Exception e) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                return null;
            }
        }

        public boolean next() throws DatabaseException {
            OperationStatus status = this.cursor.getNext(this.key, this.entry, LockMode.DEFAULT);
            return status == OperationStatus.SUCCESS;
        }

        public void delete() throws DatabaseException {
            this.cursor.delete();
        }
    }
}

