/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.admin.std.server.BackendCfg;
import org.opends.server.api.Backend;
import org.opends.server.backends.jeb.BackendImpl;
import org.opends.server.backends.jeb.RebuildConfig;
import org.opends.server.config.ConfigException;
import org.opends.server.core.CoreConfigManager;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.LockFileManager;
import org.opends.server.extensions.ConfigFileHandler;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.TextErrorLogPublisher;
import org.opends.server.loggers.TextWriter;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.TextDebugLogPublisher;
import org.opends.server.protocols.ldap.LDAPAttribute;
import org.opends.server.tasks.RebuildTask;
import org.opends.server.tools.BackendToolUtils;
import org.opends.server.tools.tasks.TaskTool;
import org.opends.server.types.ByteString;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.NullOutputStream;
import org.opends.server.types.RawAttribute;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.LDAPConnectionArgumentParser;
import org.opends.server.util.args.StringArgument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RebuildIndex
extends TaskTool {
    private StringArgument configClass = null;
    private StringArgument configFile = null;
    private StringArgument baseDNString = null;
    private StringArgument indexList = null;
    private StringArgument tmpDirectory = null;
    private BooleanArgument rebuildAll = null;

    public static void main(String[] args) {
        int retCode = RebuildIndex.mainRebuildIndex(args, true, System.out, System.err);
        if (retCode != 0) {
            System.exit(StaticUtils.filterExitCode(retCode));
        }
    }

    public static int mainRebuildIndex(String[] args, boolean initializeServer, OutputStream outStream, OutputStream errStream) {
        RebuildIndex tool = new RebuildIndex();
        return tool.process(args, initializeServer, outStream, errStream);
    }

    private int process(String[] args, boolean initializeServer, OutputStream outStream, OutputStream errStream) {
        PrintStream out = outStream == null ? NullOutputStream.printStream() : new PrintStream(outStream);
        PrintStream err = errStream == null ? NullOutputStream.printStream() : new PrintStream(errStream);
        Message toolDescription = ToolMessages.INFO_REBUILDINDEX_TOOL_DESCRIPTION.get();
        LDAPConnectionArgumentParser argParser = this.createArgParser("org.opends.server.tools.RebuildIndex", toolDescription);
        try {
            this.configClass = new StringArgument("configclass", Character.valueOf('C'), "configClass", true, false, true, ToolMessages.INFO_CONFIGCLASS_PLACEHOLDER.get(), ConfigFileHandler.class.getName(), null, ToolMessages.INFO_DESCRIPTION_CONFIG_CLASS.get());
            this.configClass.setHidden(true);
            argParser.addArgument(this.configClass);
            this.configFile = new StringArgument("configfile", Character.valueOf('f'), "configFile", true, false, true, ToolMessages.INFO_CONFIGFILE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_CONFIG_FILE.get());
            this.configFile.setHidden(true);
            argParser.addArgument(this.configFile);
            this.baseDNString = new StringArgument("basedn", Character.valueOf('b'), "baseDN", true, false, true, ToolMessages.INFO_BASEDN_PLACEHOLDER.get(), null, null, ToolMessages.INFO_REBUILDINDEX_DESCRIPTION_BASE_DN.get());
            argParser.addArgument(this.baseDNString);
            this.indexList = new StringArgument("index", Character.valueOf('i'), "index", false, true, true, ToolMessages.INFO_INDEX_PLACEHOLDER.get(), null, null, ToolMessages.INFO_REBUILDINDEX_DESCRIPTION_INDEX_NAME.get());
            argParser.addArgument(this.indexList);
            this.rebuildAll = new BooleanArgument("rebuildAll", null, "rebuildAll", ToolMessages.INFO_REBUILDINDEX_DESCRIPTION_REBUILD_ALL.get());
            argParser.addArgument(this.rebuildAll);
            this.tmpDirectory = new StringArgument("tmpdirectory", null, "tmpdirectory", false, false, true, ToolMessages.INFO_REBUILDINDEX_TEMP_DIR_PLACEHOLDER.get(), "import-tmp", null, ToolMessages.INFO_REBUILDINDEX_DESCRIPTION_TEMP_DIRECTORY.get());
            argParser.addArgument(this.tmpDirectory);
            BooleanArgument displayUsage = new BooleanArgument("help", Character.valueOf('H'), "help", ToolMessages.INFO_DESCRIPTION_USAGE.get());
            argParser.addArgument(displayUsage);
            argParser.setUsageArgument(displayUsage);
        }
        catch (ArgumentException ae) {
            Message message = ToolMessages.ERR_CANNOT_INITIALIZE_ARGS.get(ae.getMessage());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        try {
            argParser.parseArguments(args);
        }
        catch (ArgumentException ae) {
            Message message = ToolMessages.ERR_ERROR_PARSING_ARGS.get(ae.getMessage());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            err.println(argParser.getUsage());
            return 1;
        }
        if (argParser.usageOrVersionDisplayed()) {
            return 0;
        }
        int numArgs = args.length;
        if (numArgs == 0) {
            out.println(argParser.getUsage());
            return 1;
        }
        if (this.indexList.getValues().size() <= 0 && !this.rebuildAll.isPresent()) {
            Message message = ToolMessages.ERR_REBUILDINDEX_REQUIRES_AT_LEAST_ONE_INDEX.get();
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            out.println(argParser.getUsage());
            return 1;
        }
        if (this.rebuildAll.isPresent() && this.indexList.isPresent()) {
            Message msg = ToolMessages.ERR_REBUILDINDEX_REBUILD_ALL_ERROR.get();
            err.println(StaticUtils.wrapText(msg, ServerConstants.MAX_LINE_WIDTH));
            out.println(argParser.getUsage());
            return 1;
        }
        return this.process(argParser, initializeServer, out, err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int processLocal(boolean initializeServer, PrintStream out, PrintStream err) {
        Message message;
        DN rebuildBaseDN;
        DirectoryServer directoryServer = DirectoryServer.getInstance();
        if (initializeServer) {
            try {
                DirectoryServer.bootstrapClient();
                DirectoryServer.initializeJMX();
            }
            catch (Exception e) {
                Message message2 = ToolMessages.ERR_SERVER_BOOTSTRAP_ERROR.get(StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message2, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                directoryServer.initializeConfiguration(this.configClass.getValue(), this.configFile.getValue());
            }
            catch (InitializationException ie) {
                Message message3 = ToolMessages.ERR_CANNOT_LOAD_CONFIG.get(ie.getMessage());
                err.println(StaticUtils.wrapText(message3, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (Exception e) {
                Message message4 = ToolMessages.ERR_CANNOT_LOAD_CONFIG.get(StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message4, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                directoryServer.initializeSchema();
            }
            catch (ConfigException ce) {
                Message message5 = ToolMessages.ERR_CANNOT_LOAD_SCHEMA.get(ce.getMessage());
                err.println(StaticUtils.wrapText(message5, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (InitializationException ie) {
                Message message6 = ToolMessages.ERR_CANNOT_LOAD_SCHEMA.get(ie.getMessage());
                err.println(StaticUtils.wrapText(message6, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (Exception e) {
                Message message7 = ToolMessages.ERR_CANNOT_LOAD_SCHEMA.get(StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message7, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                CoreConfigManager coreConfigManager = new CoreConfigManager();
                coreConfigManager.initializeCoreConfig();
            }
            catch (ConfigException ce) {
                Message message8 = ToolMessages.ERR_CANNOT_INITIALIZE_CORE_CONFIG.get(ce.getMessage());
                err.println(StaticUtils.wrapText(message8, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (InitializationException ie) {
                Message message9 = ToolMessages.ERR_CANNOT_INITIALIZE_CORE_CONFIG.get(ie.getMessage());
                err.println(StaticUtils.wrapText(message9, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (Exception e) {
                Message message10 = ToolMessages.ERR_CANNOT_INITIALIZE_CORE_CONFIG.get(StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message10, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                directoryServer.initializeCryptoManager();
            }
            catch (ConfigException ce) {
                Message message11 = ToolMessages.ERR_CANNOT_INITIALIZE_CRYPTO_MANAGER.get(ce.getMessage());
                err.println(StaticUtils.wrapText(message11, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (InitializationException ie) {
                Message message12 = ToolMessages.ERR_CANNOT_INITIALIZE_CRYPTO_MANAGER.get(ie.getMessage());
                err.println(StaticUtils.wrapText(message12, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (Exception e) {
                Message message13 = ToolMessages.ERR_CANNOT_INITIALIZE_CRYPTO_MANAGER.get(StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message13, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                TextErrorLogPublisher errorLogPublisher = TextErrorLogPublisher.getStartupTextErrorPublisher(new TextWriter.STREAM(out));
                TextDebugLogPublisher debugLogPublisher = TextDebugLogPublisher.getStartupTextDebugPublisher(new TextWriter.STREAM(out));
                ErrorLogger.addErrorLogPublisher(errorLogPublisher);
                DebugLogger.addDebugLogPublisher(debugLogPublisher);
            }
            catch (Exception e) {
                err.println("Error installing the custom error logger: " + StaticUtils.stackTraceToSingleLineString(e));
            }
        }
        try {
            rebuildBaseDN = DN.decode(this.baseDNString.getValue());
        }
        catch (DirectoryException de) {
            Message message14 = ToolMessages.ERR_CANNOT_DECODE_BASE_DN.get(this.baseDNString.getValue(), de.getMessageObject());
            ErrorLogger.logError(message14);
            return 1;
        }
        catch (Exception e) {
            Message message15 = ToolMessages.ERR_CANNOT_DECODE_BASE_DN.get(this.baseDNString.getValue(), StaticUtils.getExceptionMessage(e));
            ErrorLogger.logError(message15);
            return 1;
        }
        Backend backend = null;
        ArrayList<Backend> backendList = new ArrayList<Backend>();
        ArrayList<BackendCfg> entryList = new ArrayList<BackendCfg>();
        ArrayList<List<DN>> dnList = new ArrayList<List<DN>>();
        BackendToolUtils.getBackends(backendList, entryList, dnList);
        int numBackends = backendList.size();
        block35: for (int i = 0; i < numBackends; ++i) {
            Backend b = backendList.get(i);
            List<DN> baseDNs = dnList.get(i);
            for (DN baseDN : baseDNs) {
                if (!baseDN.equals(rebuildBaseDN)) continue;
                if (backend == null) {
                    backend = b;
                    DN[] baseDNArray = new DN[baseDNs.size()];
                    baseDNs.toArray(baseDNArray);
                    continue block35;
                }
                Message message16 = ToolMessages.ERR_MULTIPLE_BACKENDS_FOR_BASE.get(this.baseDNString.getValue());
                ErrorLogger.logError(message16);
                return 1;
            }
        }
        if (backend == null) {
            Message message17 = ToolMessages.ERR_NO_BACKENDS_FOR_BASE.get(this.baseDNString.getValue());
            ErrorLogger.logError(message17);
            return 1;
        }
        if (!(backend instanceof BackendImpl)) {
            Message message18 = ToolMessages.ERR_BACKEND_NO_INDEXING_SUPPORT.get();
            ErrorLogger.logError(message18);
            return 1;
        }
        RebuildConfig rebuildConfig = new RebuildConfig();
        rebuildConfig.setBaseDN(rebuildBaseDN);
        for (String s : this.indexList.getValues()) {
            rebuildConfig.addRebuildIndex(s);
        }
        try {
            String lockFile = LockFileManager.getBackendLockFileName(backend);
            StringBuilder failureReason = new StringBuilder();
            if (!LockFileManager.acquireExclusiveLock(lockFile, failureReason)) {
                message = ToolMessages.ERR_REBUILDINDEX_CANNOT_EXCLUSIVE_LOCK_BACKEND.get(backend.getBackendID(), String.valueOf(failureReason));
                ErrorLogger.logError(message);
                return 1;
            }
        }
        catch (Exception e) {
            Message message19 = ToolMessages.ERR_REBUILDINDEX_CANNOT_EXCLUSIVE_LOCK_BACKEND.get(backend.getBackendID(), StaticUtils.getExceptionMessage(e));
            ErrorLogger.logError(message19);
            return 1;
        }
        rebuildConfig.setRebuildAll(this.rebuildAll.isPresent());
        rebuildConfig.setTmpDirectory(this.tmpDirectory.getValue());
        int returnCode = 0;
        try {
            BackendImpl jebBackend = (BackendImpl)backend;
            jebBackend.rebuildBackend(rebuildConfig);
        }
        catch (Exception e) {
            message = ToolMessages.ERR_REBUILDINDEX_ERROR_DURING_REBUILD.get(StaticUtils.getExceptionMessage(e));
            ErrorLogger.logError(message);
            returnCode = 1;
        }
        finally {
            try {
                String lockFile = LockFileManager.getBackendLockFileName(backend);
                StringBuilder failureReason = new StringBuilder();
                if (!LockFileManager.releaseLock(lockFile, failureReason)) {
                    Message message20 = ToolMessages.WARN_REBUILDINDEX_CANNOT_UNLOCK_BACKEND.get(backend.getBackendID(), String.valueOf(failureReason));
                    ErrorLogger.logError(message20);
                }
            }
            catch (Exception e) {
                message = ToolMessages.WARN_REBUILDINDEX_CANNOT_UNLOCK_BACKEND.get(backend.getBackendID(), StaticUtils.getExceptionMessage(e));
                ErrorLogger.logError(message);
            }
        }
        return returnCode;
    }

    @Override
    public String getTaskId() {
        return null;
    }

    @Override
    public void addTaskAttributes(List<RawAttribute> attributes) {
        String baseDN = this.baseDNString.getValue();
        ArrayList<ByteString> values = new ArrayList<ByteString>(1);
        values.add(ByteString.valueOf(baseDN));
        attributes.add(new LDAPAttribute("ds-task-rebuild-base-dn", values));
        LinkedList<String> indexes = this.indexList.getValues();
        values = new ArrayList(indexes.size());
        for (String s : indexes) {
            values.add(ByteString.valueOf(s));
        }
        attributes.add(new LDAPAttribute("ds-task-rebuild-index", values));
        if (this.tmpDirectory.getValue() != null && !this.tmpDirectory.getValue().equals(this.tmpDirectory.getDefaultValue())) {
            values = new ArrayList(1);
            values.add(ByteString.valueOf(this.tmpDirectory.getValue()));
            attributes.add(new LDAPAttribute("ds-task-rebuild-tmp-directory", values));
        }
        if (this.rebuildAll.getValue() != null && !this.rebuildAll.getValue().equals(this.rebuildAll.getDefaultValue())) {
            values = new ArrayList(1);
            values.add(ByteString.valueOf("rebuildall"));
            attributes.add(new LDAPAttribute("ds-task-rebuild-index", values));
        }
    }

    @Override
    public String getTaskObjectclass() {
        return "ds-task-rebuild";
    }

    @Override
    public Class getTaskClass() {
        return RebuildTask.class;
    }
}

