/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.makeldif;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.Random;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.core.DirectoryServer;
import org.opends.server.tools.makeldif.EntryWriter;
import org.opends.server.tools.makeldif.MakeLDIFException;
import org.opends.server.tools.makeldif.TemplateEntry;
import org.opends.server.tools.makeldif.TemplateFile;
import org.opends.server.types.AttributeType;
import org.opends.server.types.ExistingFileBehavior;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.NullOutputStream;
import org.opends.server.util.LDIFWriter;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.IntegerArgument;
import org.opends.server.util.args.StringArgument;

public class MakeLDIF
implements EntryWriter {
    private static final String CLASS_NAME = "org.opends.server.tools.makeldif.MakeLDIF";
    private LDIFWriter ldifWriter = null;
    private long entriesWritten = 0L;
    private PrintStream out = System.out;
    private PrintStream err = System.err;

    public static void main(String[] args) {
        MakeLDIF makeLDIF = new MakeLDIF();
        int returnCode = makeLDIF.makeLDIFMain(args);
        if (returnCode != 0) {
            System.exit(StaticUtils.filterExitCode(returnCode));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int makeLDIFMain(String[] args, boolean initializeServer, boolean initializeSchema, OutputStream outStream, OutputStream errStream) {
        File resourceDir;
        Random random;
        IntegerArgument randomSeed;
        StringArgument ldifFile;
        StringArgument templatePath;
        StringArgument resourcePath;
        StringArgument configClass;
        StringArgument configFile;
        this.out = outStream == null ? NullOutputStream.printStream() : new PrintStream(outStream);
        this.err = errStream == null ? NullOutputStream.printStream() : new PrintStream(errStream);
        Message toolDescription = ToolMessages.INFO_MAKELDIF_TOOL_DESCRIPTION.get();
        ArgumentParser argParser = new ArgumentParser(CLASS_NAME, toolDescription, false);
        try {
            configFile = new StringArgument("configfile", Character.valueOf('c'), "configFile", true, false, true, ToolMessages.INFO_CONFIGFILE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_CONFIG_FILE.get());
            configFile.setHidden(true);
            argParser.addArgument(configFile);
            configClass = new StringArgument("configclass", Character.valueOf('C'), "configClass", false, false, true, ToolMessages.INFO_CONFIGCLASS_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_CONFIG_CLASS.get());
            configClass.setHidden(true);
            argParser.addArgument(configClass);
            resourcePath = new StringArgument("resourcepath", Character.valueOf('r'), "resourcePath", true, false, true, ToolMessages.INFO_PATH_PLACEHOLDER.get(), null, null, ToolMessages.INFO_MAKELDIF_DESCRIPTION_RESOURCE_PATH.get());
            resourcePath.setHidden(true);
            argParser.addArgument(resourcePath);
            templatePath = new StringArgument("templatefile", Character.valueOf('t'), "templateFile", true, false, true, ToolMessages.INFO_FILE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_MAKELDIF_DESCRIPTION_TEMPLATE.get());
            argParser.addArgument(templatePath);
            ldifFile = new StringArgument("ldiffile", Character.valueOf('o'), "ldifFile", true, false, true, ToolMessages.INFO_FILE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_MAKELDIF_DESCRIPTION_LDIF.get());
            argParser.addArgument(ldifFile);
            randomSeed = new IntegerArgument("randomseed", Character.valueOf('s'), "randomSeed", false, false, true, ToolMessages.INFO_SEED_PLACEHOLDER.get(), 0, null, ToolMessages.INFO_MAKELDIF_DESCRIPTION_SEED.get());
            argParser.addArgument(randomSeed);
            BooleanArgument showUsage = new BooleanArgument("help", Character.valueOf('H'), "help", ToolMessages.INFO_MAKELDIF_DESCRIPTION_HELP.get());
            argParser.addArgument(showUsage);
            argParser.setUsageArgument(showUsage);
        }
        catch (ArgumentException ae) {
            Message message = ToolMessages.ERR_CANNOT_INITIALIZE_ARGS.get(ae.getMessage());
            this.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        try {
            argParser.parseArguments(args);
        }
        catch (ArgumentException ae) {
            Message message = ToolMessages.ERR_ERROR_PARSING_ARGS.get(ae.getMessage());
            this.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            this.err.println(argParser.getUsage());
            return 1;
        }
        if (argParser.usageOrVersionDisplayed()) {
            return 0;
        }
        if (initializeServer) {
            DirectoryServer directoryServer = DirectoryServer.getInstance();
            directoryServer.bootstrapClient();
            try {
                directoryServer.initializeJMX();
            }
            catch (Exception e) {
                Message message = ToolMessages.ERR_MAKELDIF_CANNOT_INITIALIZE_JMX.get(String.valueOf(configFile.getValue()), e.getMessage());
                this.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                directoryServer.initializeConfiguration(configClass.getValue(), configFile.getValue());
            }
            catch (Exception e) {
                Message message = ToolMessages.ERR_MAKELDIF_CANNOT_INITIALIZE_CONFIG.get(String.valueOf(configFile.getValue()), e.getMessage());
                this.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
        }
        if (initializeSchema) {
            try {
                DirectoryServer.getInstance().initializeSchema();
            }
            catch (Exception e) {
                Message message = ToolMessages.ERR_MAKELDIF_CANNOT_INITIALIZE_SCHEMA.get(String.valueOf(configFile.getValue()), e.getMessage());
                System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
        }
        if (randomSeed.isPresent()) {
            try {
                random = new Random(randomSeed.getIntValue());
            }
            catch (Exception e) {
                random = new Random();
            }
        } else {
            random = new Random();
        }
        if (!(resourceDir = new File(resourcePath.getValue())).exists()) {
            Message message = ToolMessages.ERR_MAKELDIF_NO_SUCH_RESOURCE_DIRECTORY.get(resourcePath.getValue());
            this.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        LinkedList<Message> warnings = new LinkedList<Message>();
        TemplateFile templateFile = new TemplateFile(resourcePath.getValue(), random);
        try {
            templateFile.parse(templatePath.getValue(), warnings);
        }
        catch (IOException ioe) {
            Message message = ToolMessages.ERR_MAKELDIF_IOEXCEPTION_DURING_PARSE.get(ioe.getMessage());
            this.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        catch (Exception e) {
            Message message = ToolMessages.ERR_MAKELDIF_EXCEPTION_DURING_PARSE.get(e.getMessage());
            this.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        if (!warnings.isEmpty()) {
            for (Message s : warnings) {
                this.err.println(StaticUtils.wrapText(s, ServerConstants.MAX_LINE_WIDTH));
            }
        }
        LDIFExportConfig exportConfig = new LDIFExportConfig(ldifFile.getValue(), ExistingFileBehavior.OVERWRITE);
        try {
            this.ldifWriter = new LDIFWriter(exportConfig);
        }
        catch (IOException ioe) {
            Message message = ToolMessages.ERR_MAKELDIF_UNABLE_TO_CREATE_LDIF.get(ldifFile.getValue(), String.valueOf(ioe));
            this.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        try {
            templateFile.generateLDIF(this);
        }
        catch (Exception e) {
            Message message = ToolMessages.ERR_MAKELDIF_ERROR_WRITING_LDIF.get(ldifFile.getValue(), StaticUtils.stackTraceToSingleLineString(e));
            this.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            int n = 1;
            return n;
        }
        finally {
            try {
                this.ldifWriter.close();
            }
            catch (Exception e) {}
        }
        return 0;
    }

    public int makeLDIFMain(String[] args) {
        return this.makeLDIFMain(args, true, true, System.out, System.err);
    }

    public boolean writeEntry(TemplateEntry entry) throws IOException, MakeLDIFException {
        try {
            if (entry.getDN() != null) {
                this.ldifWriter.writeTemplateEntry(entry);
                if (++this.entriesWritten % 1000L == 0L) {
                    Message message = ToolMessages.INFO_MAKELDIF_PROCESSED_N_ENTRIES.get(this.entriesWritten);
                    this.out.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                }
            } else {
                AttributeType[] rdnAttrs = entry.getTemplate().getRDNAttributes();
                String nullRdn = "";
                for (AttributeType att : rdnAttrs) {
                    if (entry.getValue(att) != null) continue;
                    nullRdn = att.getNameOrOID();
                    break;
                }
                Message message = ToolMessages.ERR_MAKELDIF_CANNOT_WRITE_ENTRY_WITHOUT_DN.get(nullRdn);
                this.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                return true;
            }
            return true;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            Message message = ToolMessages.ERR_MAKELDIF_CANNOT_WRITE_ENTRY.get(String.valueOf(entry.getDN()), StaticUtils.stackTraceToSingleLineString(e));
            throw new MakeLDIFException(message, (Throwable)e);
        }
    }

    public void closeEntryWriter() {
        Message message = ToolMessages.INFO_MAKELDIF_PROCESSING_COMPLETE.get(this.entriesWritten);
        this.out.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
    }
}

