/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.schema.AttributeTypeSyntax;
import org.opends.server.types.AttributeUsage;
import org.opends.server.types.ByteString;
import org.opends.server.types.CommonSchemaElements;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.Schema;
import org.opends.server.types.SchemaFileElement;
import org.opends.server.types.StabilityLevel;
import org.opends.server.util.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=false, mayExtend=false, mayInvoke=true)
public final class AttributeType
extends CommonSchemaElements
implements SchemaFileElement,
Comparable<AttributeType> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private final ApproximateMatchingRule approximateMatchingRule;
    private final AttributeSyntax syntax;
    private final AttributeType superiorType;
    private final AttributeUsage attributeUsage;
    private final boolean isCollective;
    private final boolean isNoUserModification;
    private final boolean isObjectClassType;
    private final boolean isOperational;
    private final boolean isSingleValue;
    private boolean mayHaveSubordinateTypes;
    private final EqualityMatchingRule equalityMatchingRule;
    private final OrderingMatchingRule orderingMatchingRule;
    private final String definition;
    private final String syntaxOID;
    private final SubstringMatchingRule substringMatchingRule;

    public AttributeType(String definition, String primaryName, Collection<String> typeNames, String oid, String description, AttributeType superiorType, AttributeSyntax syntax, AttributeUsage attributeUsage, boolean isCollective, boolean isNoUserModification, boolean isObsolete, boolean isSingleValue) {
        this(definition, primaryName, typeNames, oid, description, superiorType, syntax, null, null, null, null, attributeUsage, isCollective, isNoUserModification, isObsolete, isSingleValue, null);
    }

    public AttributeType(String definition, String primaryName, Collection<String> typeNames, String oid, String description, AttributeType superiorType, AttributeSyntax syntax, ApproximateMatchingRule approximateMatchingRule, EqualityMatchingRule equalityMatchingRule, OrderingMatchingRule orderingMatchingRule, SubstringMatchingRule substringMatchingRule, AttributeUsage attributeUsage, boolean isCollective, boolean isNoUserModification, boolean isObsolete, boolean isSingleValue, Map<String, List<String>> extraProperties) {
        super(primaryName, typeNames, oid, description, isObsolete, extraProperties);
        Validator.ensureNotNull(definition, oid);
        this.superiorType = superiorType;
        this.isCollective = isCollective;
        this.isNoUserModification = isNoUserModification;
        this.isSingleValue = isSingleValue;
        this.mayHaveSubordinateTypes = false;
        int schemaFilePos = definition.indexOf("X-SCHEMA-FILE");
        if (schemaFilePos > 0) {
            String defStr;
            try {
                int firstQuotePos = definition.indexOf(39, schemaFilePos);
                int secondQuotePos = definition.indexOf(39, firstQuotePos + 1);
                defStr = definition.substring(0, schemaFilePos).trim() + " " + definition.substring(secondQuotePos + 1).trim();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                defStr = definition;
            }
            this.definition = defStr;
        } else {
            this.definition = definition;
        }
        this.syntax = syntax == null ? (superiorType != null ? superiorType.getSyntax() : DirectoryServer.getDefaultAttributeSyntax()) : syntax;
        this.syntaxOID = this.syntax.getOID();
        this.approximateMatchingRule = approximateMatchingRule == null ? this.syntax.getApproximateMatchingRule() : approximateMatchingRule;
        this.equalityMatchingRule = equalityMatchingRule == null ? this.syntax.getEqualityMatchingRule() : equalityMatchingRule;
        this.orderingMatchingRule = orderingMatchingRule == null ? this.syntax.getOrderingMatchingRule() : orderingMatchingRule;
        this.substringMatchingRule = substringMatchingRule == null ? this.syntax.getSubstringMatchingRule() : substringMatchingRule;
        this.attributeUsage = attributeUsage != null ? attributeUsage : AttributeUsage.USER_APPLICATIONS;
        this.isObjectClassType = oid.equals("2.5.4.0") ? true : this.hasName("objectclass");
        this.isOperational = this.attributeUsage.isOperational();
    }

    @Override
    public String getDefinition() {
        return this.definition;
    }

    public String getDefinitionWithFileName() {
        if (this.getSchemaFile() != null) {
            int pos = this.definition.lastIndexOf(41);
            String defStr = this.definition.substring(0, pos).trim() + " " + "X-SCHEMA-FILE" + " '" + this.getSchemaFile() + "' )";
            return defStr;
        }
        return this.definition;
    }

    @Override
    public AttributeType recreateFromDefinition() throws DirectoryException {
        ByteString value = ByteString.valueOf(this.definition);
        Schema schema = DirectoryServer.getSchema();
        AttributeType at = AttributeTypeSyntax.decodeAttributeType(value, schema, false);
        at.setSchemaFile(this.getSchemaFile());
        at.mayHaveSubordinateTypes = this.mayHaveSubordinateTypes;
        return at;
    }

    public AttributeType getSuperiorType() {
        return this.superiorType;
    }

    boolean mayHaveSubordinateTypes() {
        return this.mayHaveSubordinateTypes;
    }

    void setMayHaveSubordinateTypes() {
        this.mayHaveSubordinateTypes = true;
    }

    public AttributeSyntax getSyntax() {
        return this.syntax;
    }

    public boolean isBinary() {
        return this.syntax.isBinary();
    }

    public String getSyntaxOID() {
        return this.syntaxOID;
    }

    public ApproximateMatchingRule getApproximateMatchingRule() {
        return this.approximateMatchingRule;
    }

    public EqualityMatchingRule getEqualityMatchingRule() {
        return this.equalityMatchingRule;
    }

    public OrderingMatchingRule getOrderingMatchingRule() {
        return this.orderingMatchingRule;
    }

    public SubstringMatchingRule getSubstringMatchingRule() {
        return this.substringMatchingRule;
    }

    public AttributeUsage getUsage() {
        return this.attributeUsage;
    }

    public boolean isOperational() {
        return this.isOperational;
    }

    public boolean isCollective() {
        return this.isCollective;
    }

    public boolean isNoUserModification() {
        return this.isNoUserModification;
    }

    public boolean isSingleValue() {
        return this.isSingleValue;
    }

    public boolean isObjectClassType() {
        return this.isObjectClassType;
    }

    @Override
    protected void toStringContent(StringBuilder buffer) {
        if (this.superiorType != null) {
            buffer.append(" SUP ");
            buffer.append(this.superiorType.getNameOrOID());
        }
        if (this.equalityMatchingRule != null) {
            buffer.append(" EQUALITY ");
            buffer.append(this.equalityMatchingRule.getNameOrOID());
        }
        if (this.orderingMatchingRule != null) {
            buffer.append(" ORDERING ");
            buffer.append(this.orderingMatchingRule.getNameOrOID());
        }
        if (this.substringMatchingRule != null) {
            buffer.append(" SUBSTR ");
            buffer.append(this.substringMatchingRule.getNameOrOID());
        }
        if (this.syntax != null) {
            buffer.append(" SYNTAX ");
            buffer.append(this.syntax.getOID());
        }
        if (this.isSingleValue) {
            buffer.append(" SINGLE-VALUE");
        }
        if (this.isCollective) {
            buffer.append(" COLLECTIVE");
        }
        if (this.isNoUserModification) {
            buffer.append(" NO-USER-MODIFICATION");
        }
        if (this.attributeUsage != null) {
            buffer.append(" USAGE ");
            buffer.append(this.attributeUsage.toString());
        }
    }

    @Override
    public int compareTo(AttributeType o) {
        return this.getNormalizedPrimaryNameOrOID().compareTo(o.getNormalizedPrimaryNameOrOID());
    }
}

