/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import org.opends.server.types.AuthenticationType;
import org.opends.server.types.ByteString;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;
import org.opends.server.util.Validator;

@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=true, mayExtend=false, mayInvoke=true)
public final class AuthenticationInfo {
    private ByteString simplePassword;
    private boolean isAuthenticated;
    private boolean isRoot;
    private boolean mustChangePassword;
    private Entry authenticationEntry;
    private Entry authorizationEntry;
    private AuthenticationType authenticationType;
    private String saslMechanism;
    private DN simpleBindDN;
    private ByteString saslCredentials;

    public AuthenticationInfo() {
        this.isAuthenticated = false;
        this.isRoot = false;
        this.mustChangePassword = false;
        this.simplePassword = null;
        this.authenticationType = null;
        this.authenticationEntry = null;
        this.authorizationEntry = null;
        this.simpleBindDN = null;
        this.saslCredentials = null;
        this.saslMechanism = null;
    }

    public AuthenticationInfo(Entry authenticationEntry, boolean isRoot) {
        this.authenticationEntry = authenticationEntry;
        this.isRoot = isRoot;
        this.isAuthenticated = authenticationEntry != null;
        this.mustChangePassword = false;
        this.simpleBindDN = authenticationEntry != null ? authenticationEntry.getDN() : null;
        this.simplePassword = null;
        this.authorizationEntry = authenticationEntry;
        this.saslMechanism = null;
        this.saslCredentials = null;
        this.authenticationType = AuthenticationType.INTERNAL;
    }

    public AuthenticationInfo(Entry authenticationEntry, DN simpleBindDN, ByteString simplePassword, boolean isRoot) {
        Validator.ensureNotNull(authenticationEntry, simplePassword);
        this.authenticationEntry = authenticationEntry;
        this.simpleBindDN = simpleBindDN;
        this.simplePassword = simplePassword;
        this.isRoot = isRoot;
        this.isAuthenticated = true;
        this.mustChangePassword = false;
        this.authorizationEntry = authenticationEntry;
        this.saslMechanism = null;
        this.saslCredentials = null;
        this.authenticationType = AuthenticationType.SIMPLE;
    }

    public AuthenticationInfo(Entry authenticationEntry, String saslMechanism, ByteString saslCredentials, boolean isRoot) {
        Validator.ensureNotNull(authenticationEntry, saslMechanism);
        this.authenticationEntry = authenticationEntry;
        this.isRoot = isRoot;
        this.isAuthenticated = true;
        this.mustChangePassword = false;
        this.authorizationEntry = authenticationEntry;
        this.simpleBindDN = null;
        this.simplePassword = null;
        this.authenticationType = AuthenticationType.SASL;
        this.saslMechanism = saslMechanism;
        this.saslCredentials = saslCredentials;
    }

    public AuthenticationInfo(Entry authenticationEntry, Entry authorizationEntry, String saslMechanism, ByteString saslCredentials, boolean isRoot) {
        Validator.ensureNotNull(authenticationEntry, saslMechanism);
        this.authenticationEntry = authenticationEntry;
        this.authorizationEntry = authorizationEntry;
        this.isRoot = isRoot;
        this.isAuthenticated = true;
        this.mustChangePassword = false;
        this.simpleBindDN = null;
        this.simplePassword = null;
        this.authenticationType = AuthenticationType.SASL;
        this.saslMechanism = saslMechanism;
        this.saslCredentials = saslCredentials;
    }

    public boolean isAuthenticated() {
        return this.isAuthenticated;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public boolean mustChangePassword() {
        return this.mustChangePassword;
    }

    public void setMustChangePassword(boolean mustChangePassword) {
        this.mustChangePassword = mustChangePassword;
    }

    public boolean hasAuthenticationType(AuthenticationType authenticationType) {
        return this.authenticationType == authenticationType;
    }

    public Entry getAuthenticationEntry() {
        return this.authenticationEntry;
    }

    public DN getAuthenticationDN() {
        if (this.authenticationEntry == null) {
            return null;
        }
        return this.authenticationEntry.getDN();
    }

    public Entry getAuthorizationEntry() {
        return this.authorizationEntry;
    }

    public DN getAuthorizationDN() {
        if (this.authorizationEntry == null) {
            return null;
        }
        return this.authorizationEntry.getDN();
    }

    public DN getSimpleBindDN() {
        return this.simpleBindDN;
    }

    public ByteString getSimplePassword() {
        return this.simplePassword;
    }

    public boolean hasSASLMechanism(String saslMechanism) {
        return this.saslMechanism.equals(saslMechanism);
    }

    public ByteString getSASLCredentials() {
        return this.saslCredentials;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("AuthenticationInfo(isAuthenticated=");
        buffer.append(this.isAuthenticated);
        buffer.append(",isRoot=");
        buffer.append(this.isRoot);
        buffer.append(",mustChangePassword=");
        buffer.append(this.mustChangePassword);
        buffer.append(",authenticationDN=\"");
        if (this.authenticationEntry != null) {
            this.authenticationEntry.getDN().toString(buffer);
        }
        if (this.authorizationEntry == null) {
            buffer.append("\",authorizationDN=\"\"");
        } else {
            buffer.append("\",authorizationDN=\"");
            this.authorizationEntry.getDN().toString(buffer);
            buffer.append("\"");
        }
        if (this.authenticationType != null) {
            buffer.append(",authType=");
            buffer.append((Object)this.authenticationType);
        }
        if (this.saslMechanism != null) {
            buffer.append(",saslMechanism=");
            buffer.append(this.saslMechanism);
        }
        buffer.append(")");
    }

    public AuthenticationInfo duplicate(Entry newAuthenticationEntry, Entry newAuthorizationEntry) {
        AuthenticationInfo authInfo = new AuthenticationInfo();
        authInfo.simplePassword = this.simplePassword;
        authInfo.isAuthenticated = this.isAuthenticated;
        authInfo.isRoot = this.isRoot;
        authInfo.mustChangePassword = this.mustChangePassword;
        authInfo.authenticationEntry = newAuthenticationEntry;
        authInfo.authorizationEntry = newAuthorizationEntry;
        authInfo.authenticationType = this.authenticationType;
        authInfo.saslMechanism = this.saslMechanism;
        return authInfo;
    }
}

