/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.RFC3672SubtreeSpecification;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeBuilder;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.CollectiveVirtualAttribute;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubEntry {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    public static final String ATTR_COLLECTIVE_CONFLICT_BEHAVIOR = "collectiveconflictbehavior";
    private static final String ATTR_OPTION_COLLECTIVE = "collective";
    private Entry entry;
    private RFC3672SubtreeSpecification subTreeSpec;
    private boolean isCollective = false;
    private List<Attribute> collectiveAttributes;
    private CollectiveConflictBehavior conflictBehavior = CollectiveConflictBehavior.REAL_OVERRIDES_VIRTUAL;

    public SubEntry(Entry entry) throws DirectoryException {
        this.entry = entry;
        this.subTreeSpec = null;
        AttributeType specAttrType = DirectoryServer.getAttributeType("subtreespecification", true);
        List<Attribute> specAttrList = entry.getAttribute(specAttrType);
        if (specAttrList != null) {
            for (Attribute attr : specAttrList) {
                Iterator<Object> i$ = attr.iterator();
                if (i$.hasNext()) {
                    AttributeValue value = i$.next();
                    this.subTreeSpec = RFC3672SubtreeSpecification.valueOf(entry.getDN().getParent(), ((Object)value).toString());
                }
                if (this.subTreeSpec == null) continue;
                break;
            }
        }
        if (this.subTreeSpec == null) {
            this.subTreeSpec = new RFC3672SubtreeSpecification(DN.NULL_DN, null, -1, -1, null, null, null);
        }
        this.isCollective = entry.isCollectiveAttributeSubentry();
        this.collectiveAttributes = new ArrayList<Attribute>();
        if (this.isCollective) {
            List<Attribute> subAttrList = entry.getAttributes();
            for (Attribute subAttr : subAttrList) {
                AttributeType attrType = subAttr.getAttributeType();
                if (attrType.isCollective()) {
                    CollectiveVirtualAttribute collectiveAttr = new CollectiveVirtualAttribute(subAttr);
                    this.collectiveAttributes.add(collectiveAttr);
                    continue;
                }
                if (!subAttr.hasOption(ATTR_OPTION_COLLECTIVE)) continue;
                AttributeBuilder builder = new AttributeBuilder(subAttr.getAttributeType());
                builder.addAll(subAttr);
                LinkedHashSet<String> options = new LinkedHashSet<String>(subAttr.getOptions());
                options.remove(ATTR_OPTION_COLLECTIVE);
                builder.setOptions(options);
                Attribute attr = builder.toAttribute();
                CollectiveVirtualAttribute collectiveAttr = new CollectiveVirtualAttribute(attr);
                this.collectiveAttributes.add(collectiveAttr);
            }
            List<Attribute> attrList = entry.getAttribute(ATTR_COLLECTIVE_CONFLICT_BEHAVIOR);
            if (attrList != null && !attrList.isEmpty()) {
                for (Attribute attr : attrList) {
                    block3: for (AttributeValue value : attr) {
                        for (CollectiveConflictBehavior behavior : CollectiveConflictBehavior.values()) {
                            if (!behavior.toString().equals(((Object)value).toString())) continue;
                            this.conflictBehavior = behavior;
                            continue block3;
                        }
                    }
                }
            }
        }
    }

    public DN getDN() {
        return this.entry.getDN();
    }

    public Entry getEntry() {
        return this.entry;
    }

    public boolean isCollective() {
        return this.isCollective;
    }

    public RFC3672SubtreeSpecification getSubTreeSpecification() {
        return this.subTreeSpec;
    }

    public List<Attribute> getCollectiveAttributes() {
        return this.collectiveAttributes;
    }

    public CollectiveConflictBehavior getConflictBehavior() {
        return this.conflictBehavior;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CollectiveConflictBehavior {
        MERGE_REAL_AND_VIRTUAL("merge-real-and-virtual"),
        REAL_OVERRIDES_VIRTUAL("real-overrides-virtual"),
        VIRTUAL_OVERRIDES_REAL("virtual-overrides-real");

        private final String name;

        private CollectiveConflictBehavior(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

