/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util.args;

import java.io.PrintStream;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLException;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.admin.client.cli.SecureConnectionCliArgs;
import org.opends.server.tools.LDAPConnection;
import org.opends.server.tools.LDAPConnectionException;
import org.opends.server.tools.LDAPConnectionOptions;
import org.opends.server.tools.SSLConnectionException;
import org.opends.server.tools.SSLConnectionFactory;
import org.opends.server.types.OpenDsException;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.Argument;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentGroup;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.FileBasedArgument;
import org.opends.server.util.args.StringArgument;
import org.opends.server.util.cli.LDAPConnectionConsoleInteraction;

public class LDAPConnectionArgumentParser
extends ArgumentParser {
    private SecureConnectionCliArgs args;

    public LDAPConnectionArgumentParser(String mainClassName, Message toolDescription, boolean longArgumentsCaseSensitive, ArgumentGroup argumentGroup, boolean alwaysSSL) {
        super(mainClassName, toolDescription, longArgumentsCaseSensitive);
        this.addLdapConnectionArguments(argumentGroup, alwaysSSL);
    }

    public LDAPConnectionArgumentParser(String mainClassName, Message toolDescription, boolean longArgumentsCaseSensitive, boolean allowsTrailingArguments, int minTrailingArguments, int maxTrailingArguments, String trailingArgsDisplayName, ArgumentGroup argumentGroup, boolean alwaysSSL) {
        super(mainClassName, toolDescription, longArgumentsCaseSensitive, allowsTrailingArguments, minTrailingArguments, maxTrailingArguments, trailingArgsDisplayName);
        this.addLdapConnectionArguments(argumentGroup, alwaysSSL);
    }

    public boolean connectionArgumentsPresent() {
        return this.args != null && this.args.argumentsPresent();
    }

    public LDAPConnection connect(PrintStream out, PrintStream err) throws LDAPConnectionException, ArgumentException {
        return this.connect(this.args, out, err);
    }

    private LDAPConnection connect(SecureConnectionCliArgs args, PrintStream out, PrintStream err) throws LDAPConnectionException, ArgumentException {
        if (args.bindPasswordArg.isPresent() && args.bindPasswordFileArg.isPresent()) {
            Message message = ToolMessages.ERR_LDAP_CONN_MUTUALLY_EXCLUSIVE_ARGUMENTS.get(args.bindPasswordArg.getLongIdentifier(), args.bindPasswordFileArg.getLongIdentifier());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            throw new ArgumentException(message);
        }
        if (args.keyStorePasswordArg.isPresent() && args.keyStorePasswordFileArg.isPresent()) {
            Message message = ToolMessages.ERR_LDAP_CONN_MUTUALLY_EXCLUSIVE_ARGUMENTS.get(args.keyStorePasswordArg.getLongIdentifier(), args.keyStorePasswordFileArg.getLongIdentifier());
            throw new ArgumentException(message);
        }
        if (args.trustStorePasswordArg.isPresent() && args.trustStorePasswordFileArg.isPresent()) {
            Message message = ToolMessages.ERR_LDAP_CONN_MUTUALLY_EXCLUSIVE_ARGUMENTS.get(args.trustStorePasswordArg.getLongIdentifier(), args.trustStorePasswordFileArg.getLongIdentifier());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            throw new ArgumentException(message);
        }
        LDAPConnectionOptions connectionOptions = new LDAPConnectionOptions();
        connectionOptions.setVersionNumber(3);
        if (args.useSSLArg.isPresent()) {
            if (args.useStartTLSArg.isPresent()) {
                Message message = ToolMessages.ERR_LDAP_CONN_MUTUALLY_EXCLUSIVE_ARGUMENTS.get(args.useSSLArg.getLongIdentifier(), args.useSSLArg.getLongIdentifier());
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                throw new ArgumentException(message);
            }
            connectionOptions.setUseSSL(true);
        } else if (args.useStartTLSArg.isPresent()) {
            connectionOptions.setStartTLS(true);
        }
        if (args.useSSLArg.isPresent() || args.useStartTLSArg.isPresent()) {
            try {
                String clientAlias = args.certNicknameArg.isPresent() ? args.certNicknameArg.getValue() : null;
                SSLConnectionFactory sslConnectionFactory = new SSLConnectionFactory();
                sslConnectionFactory.init(args.trustAllArg.isPresent(), args.keyStorePathArg.getValue(), args.keyStorePasswordArg.getValue(), clientAlias, args.trustStorePathArg.getValue(), args.trustStorePasswordArg.getValue());
                connectionOptions.setSSLConnectionFactory(sslConnectionFactory);
            }
            catch (SSLConnectionException sce) {
                Message message = ToolMessages.ERR_LDAP_CONN_CANNOT_INITIALIZE_SSL.get(sce.getMessage());
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            }
        }
        if (args.saslOptionArg.isPresent()) {
            String mechanism = null;
            LinkedList<String> options = new LinkedList<String>();
            for (String s : args.saslOptionArg.getValues()) {
                int equalPos = s.indexOf(61);
                if (equalPos <= 0) {
                    Message message = ToolMessages.ERR_LDAP_CONN_CANNOT_PARSE_SASL_OPTION.get(s);
                    err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                    throw new ArgumentException(message);
                }
                String name = s.substring(0, equalPos);
                if (name.equalsIgnoreCase("mech")) {
                    mechanism = s;
                    continue;
                }
                options.add(s);
            }
            if (mechanism == null) {
                Message message = ToolMessages.ERR_LDAP_CONN_NO_SASL_MECHANISM.get();
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                throw new ArgumentException(message);
            }
            connectionOptions.setSASLMechanism(mechanism);
            for (String option : options) {
                connectionOptions.addSASLProperty(option);
            }
        }
        int timeout = args.connectTimeoutArg.getIntValue();
        return this.connect(args.hostNameArg.getValue(), args.portArg.getIntValue(), args.bindDnArg.getValue(), LDAPConnectionArgumentParser.getPasswordValue(args.bindPasswordArg, args.bindPasswordFileArg), connectionOptions, timeout, out, err);
    }

    public LDAPConnection connect(LDAPConnectionConsoleInteraction ui, PrintStream out, PrintStream err) throws LDAPConnectionException {
        LDAPConnection connection = null;
        try {
            ui.run();
            LDAPConnectionOptions options = new LDAPConnectionOptions();
            options.setVersionNumber(3);
            connection = this.connect(ui.getHostName(), ui.getPortNumber(), ui.getBindDN(), ui.getBindPassword(), ui.populateLDAPOptions(options), ui.getConnectTimeout(), out, err);
        }
        catch (OpenDsException e) {
            if (e.getCause() != null && e.getCause().getCause() != null && e.getCause().getCause() instanceof SSLException) {
                err.println(ToolMessages.ERR_TASKINFO_LDAP_EXCEPTION_SSL.get(ui.getHostName(), String.valueOf(ui.getPortNumber())));
            }
            err.println(e.getMessageObject());
        }
        return connection;
    }

    public LDAPConnection connect(String host, int port, String bindDN, String bindPw, LDAPConnectionOptions options, PrintStream out, PrintStream err) throws LDAPConnectionException {
        return this.connect(host, port, bindDN, bindPw, options, 0, out, err);
    }

    public LDAPConnection connect(String host, int port, String bindDN, String bindPw, LDAPConnectionOptions options, int timeout, PrintStream out, PrintStream err) throws LDAPConnectionException {
        AtomicInteger nextMessageID = new AtomicInteger(1);
        LDAPConnection connection = new LDAPConnection(host, port, options, out, err);
        connection.connectToHost(bindDN, bindPw, nextMessageID, timeout);
        return connection;
    }

    public SecureConnectionCliArgs getArguments() {
        return this.args;
    }

    public static String getPasswordValue(StringArgument bindPwdArg, FileBasedArgument bindPwdFileArg) {
        String pwd = bindPwdArg.getValue();
        if (pwd == null && bindPwdFileArg.isPresent()) {
            pwd = bindPwdFileArg.getValue();
        }
        return pwd;
    }

    private void addLdapConnectionArguments(ArgumentGroup argGroup, boolean alwaysSSL) {
        this.args = new SecureConnectionCliArgs(alwaysSSL);
        try {
            LinkedHashSet<Argument> argSet = this.args.createGlobalArguments();
            for (Argument arg : argSet) {
                this.addArgument(arg, argGroup);
            }
        }
        catch (ArgumentException ae) {
            ae.printStackTrace();
        }
    }
}

