/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.workflowelement.localbackend;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.server.admin.std.meta.PasswordPolicyCfgDefn;
import org.opends.server.api.Backend;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.SASLMechanismHandler;
import org.opends.server.api.plugin.PluginResult;
import org.opends.server.controls.AuthorizationIdentityResponseControl;
import org.opends.server.controls.PasswordExpiredControl;
import org.opends.server.controls.PasswordExpiringControl;
import org.opends.server.controls.PasswordPolicyErrorType;
import org.opends.server.controls.PasswordPolicyResponseControl;
import org.opends.server.controls.PasswordPolicyWarningType;
import org.opends.server.core.AccessControlConfigManager;
import org.opends.server.core.BindOperation;
import org.opends.server.core.BindOperationWrapper;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.PasswordPolicy;
import org.opends.server.core.PasswordPolicyState;
import org.opends.server.core.PluginConfigManager;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.AccountStatusNotification;
import org.opends.server.types.AccountStatusNotificationType;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AuthenticationInfo;
import org.opends.server.types.ByteString;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.LockManager;
import org.opends.server.types.ResultCode;
import org.opends.server.types.WritabilityMode;
import org.opends.server.types.operation.PostOperationBindOperation;
import org.opends.server.types.operation.PostResponseBindOperation;
import org.opends.server.types.operation.PreOperationBindOperation;
import org.opends.server.util.StaticUtils;
import org.opends.server.workflowelement.localbackend.LocalBackendWorkflowElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalBackendBindOperation
extends BindOperationWrapper
implements PreOperationBindOperation,
PostOperationBindOperation,
PostResponseBindOperation {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    protected Backend backend;
    protected boolean isFirstWarning;
    protected boolean isGraceLogin;
    private boolean mustChangePassword;
    private boolean pwPolicyControlRequested;
    private boolean returnAuthzID;
    protected boolean executePostOpPlugins;
    private ClientConnection clientConnection;
    protected DN bindDN;
    private int lookthroughLimit;
    private int pwPolicyWarningValue;
    private int sizeLimit;
    private int timeLimit;
    private long idleTimeLimit;
    protected PasswordPolicy policy;
    protected PasswordPolicyState pwPolicyState;
    private PasswordPolicyErrorType pwPolicyErrorType;
    private PasswordPolicyWarningType pwPolicyWarningType;
    protected PluginConfigManager pluginConfigManager;
    private String saslMechanism;

    public LocalBackendBindOperation(BindOperation bind) {
        super(bind);
        LocalBackendWorkflowElement.attachLocalOperation(bind, this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processLocalBind(LocalBackendWorkflowElement wfe) {
        PluginResult.PostOperation postOpResult;
        block31: {
            block30: {
                this.backend = wfe.getBackend();
                this.clientConnection = this.getClientConnection();
                this.returnAuthzID = false;
                this.executePostOpPlugins = false;
                this.sizeLimit = DirectoryServer.getSizeLimit();
                this.timeLimit = DirectoryServer.getTimeLimit();
                this.lookthroughLimit = DirectoryServer.getLookthroughLimit();
                this.idleTimeLimit = DirectoryServer.getIdleTimeLimit();
                this.bindDN = this.getBindDN();
                this.saslMechanism = this.getSASLMechanism();
                this.pwPolicyState = null;
                this.pwPolicyErrorType = null;
                this.pwPolicyControlRequested = false;
                this.isGraceLogin = false;
                this.isFirstWarning = false;
                this.mustChangePassword = false;
                this.pwPolicyWarningType = null;
                this.pwPolicyWarningValue = -1;
                this.pluginConfigManager = DirectoryServer.getPluginConfigManager();
                try {
                    if (!AccessControlConfigManager.getInstance().getAccessControlHandler().isAllowed(this)) {
                        this.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        this.setAuthFailureReason(CoreMessages.ERR_BIND_AUTHZ_INSUFFICIENT_ACCESS_RIGHTS.get(String.valueOf(this.bindDN)));
                    }
                    break block30;
                }
                catch (DirectoryException e) {
                    this.setResultCode(e.getResultCode());
                    this.setAuthFailureReason(e.getMessageObject());
                }
                break block31;
            }
            try {
                this.handleRequestControls();
            }
            catch (DirectoryException de) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                }
                this.setResponseData(de);
                break block31;
            }
            switch (this.getAuthenticationType()) {
                case SIMPLE: {
                    try {
                        if (!this.processSimpleBind()) break;
                    }
                    catch (DirectoryException de) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                        if (de.getResultCode() == ResultCode.INVALID_CREDENTIALS) {
                            this.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            this.setAuthFailureReason(de.getMessageObject());
                            break;
                        }
                        this.setResponseData(de);
                    }
                    break;
                }
                case SASL: {
                    try {
                        if (!this.processSASLBind()) break;
                    }
                    catch (DirectoryException de) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                        if (de.getResultCode() == ResultCode.INVALID_CREDENTIALS) {
                            this.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            this.setAuthFailureReason(de.getMessageObject());
                            break;
                        }
                        this.setResponseData(de);
                    }
                    break;
                }
                default: {
                    this.setResultCode(ResultCode.PROTOCOL_ERROR);
                }
            }
        }
        try {
            if (this.pwPolicyState != null) {
                this.pwPolicyState.updateUserEntry();
            }
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            this.setResponseData(de);
        }
        if (this.executePostOpPlugins && !(postOpResult = this.pluginConfigManager.invokePostOperationBindPlugins(this)).continueProcessing()) {
            this.setResultCode(postOpResult.getResultCode());
            this.appendErrorMessage(postOpResult.getErrorMessage());
            this.setMatchedDN(postOpResult.getMatchedDN());
            this.setReferralURLs(postOpResult.getReferralURLs());
        }
        AuthenticationInfo authInfo = this.getAuthenticationInfo();
        if (this.getResultCode() == ResultCode.SUCCESS && authInfo != null) {
            this.clientConnection.setAuthenticationInfo(authInfo);
            this.clientConnection.setSizeLimit(this.sizeLimit);
            this.clientConnection.setTimeLimit(this.timeLimit);
            this.clientConnection.setIdleTimeLimit(this.idleTimeLimit);
            this.clientConnection.setLookthroughLimit(this.lookthroughLimit);
            this.clientConnection.setMustChangePassword(this.mustChangePassword);
            if (this.returnAuthzID) {
                this.addResponseControl(new AuthorizationIdentityResponseControl(authInfo.getAuthorizationDN()));
            }
        }
        if (this.getResultCode() == ResultCode.SUCCESS) {
            if (this.pwPolicyControlRequested) {
                PasswordPolicyResponseControl pwpControl = new PasswordPolicyResponseControl(this.pwPolicyWarningType, this.pwPolicyWarningValue, this.pwPolicyErrorType);
                this.addResponseControl(pwpControl);
                return;
            }
            if (this.pwPolicyErrorType == PasswordPolicyErrorType.PASSWORD_EXPIRED) {
                this.addResponseControl(new PasswordExpiredControl());
                return;
            }
            if (this.pwPolicyWarningType == PasswordPolicyWarningType.TIME_BEFORE_EXPIRATION) {
                this.addResponseControl(new PasswordExpiringControl(this.pwPolicyWarningValue));
                return;
            }
            if (!this.mustChangePassword) return;
            this.addResponseControl(new PasswordExpiredControl());
            return;
        }
        if (this.pwPolicyControlRequested) {
            PasswordPolicyResponseControl pwpControl = new PasswordPolicyResponseControl(this.pwPolicyWarningType, this.pwPolicyWarningValue, this.pwPolicyErrorType);
            this.addResponseControl(pwpControl);
            return;
        }
        if (this.pwPolicyErrorType != PasswordPolicyErrorType.PASSWORD_EXPIRED) return;
        this.addResponseControl(new PasswordExpiredControl());
    }

    private void handleRequestControls() throws DirectoryException {
        List<Control> requestControls = this.getRequestControls();
        if (requestControls != null && !requestControls.isEmpty()) {
            for (int i = 0; i < requestControls.size(); ++i) {
                Control c = requestControls.get(i);
                String oid = c.getOID();
                if (!AccessControlConfigManager.getInstance().getAccessControlHandler().isAllowed(this.bindDN, this, c)) {
                    throw new DirectoryException(ResultCode.INSUFFICIENT_ACCESS_RIGHTS, CoreMessages.ERR_CONTROL_INSUFFICIENT_ACCESS_RIGHTS.get(oid));
                }
                if (oid.equals("2.16.840.1.113730.3.4.16")) {
                    this.returnAuthzID = true;
                    continue;
                }
                if (oid.equals("1.3.6.1.4.1.42.2.27.8.5.1")) {
                    this.pwPolicyControlRequested = true;
                    continue;
                }
                if (!c.isCritical()) continue;
                throw new DirectoryException(ResultCode.UNAVAILABLE_CRITICAL_EXTENSION, CoreMessages.ERR_BIND_UNSUPPORTED_CRITICAL_CONTROL.get(oid));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processSimpleBind() throws DirectoryException {
        ByteString simplePassword = this.getSimplePassword();
        if (simplePassword == null || simplePassword.length() == 0) {
            return this.processAnonymousSimpleBind();
        }
        DN actualRootDN = DirectoryServer.getActualRootBindDN(this.bindDN);
        if (actualRootDN != null) {
            this.bindDN = actualRootDN;
        }
        Lock userLock = null;
        for (int i = 0; i < 3 && (userLock = LockManager.lockRead(this.bindDN)) == null; ++i) {
        }
        if (userLock == null) {
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), CoreMessages.ERR_BIND_OPERATION_CANNOT_LOCK_USER.get(String.valueOf(this.bindDN)));
        }
        try {
            Entry userEntry2;
            try {
                userEntry2 = this.backend.getEntry(this.bindDN);
            }
            catch (DirectoryException de) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                }
                Object userEntry2 = null;
                if (de.getResultCode() == ResultCode.REFERRAL) {
                    throw de;
                }
                throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, de.getMessageObject());
            }
            if (userEntry2 == null) {
                throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, CoreMessages.ERR_BIND_OPERATION_UNKNOWN_USER.get(String.valueOf(this.bindDN)));
            }
            this.setUserEntryDN(userEntry2.getDN());
            this.pwPolicyState = new PasswordPolicyState(userEntry2, false);
            this.policy = this.pwPolicyState.getPolicy();
            AttributeType pwType = this.policy.getPasswordAttribute();
            List<Attribute> pwAttr = userEntry2.getAttribute(pwType);
            if (pwAttr == null || pwAttr.isEmpty()) {
                throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, CoreMessages.ERR_BIND_OPERATION_NO_PASSWORD.get(String.valueOf(this.bindDN)));
            }
            this.checkPasswordPolicyState(userEntry2, null);
            this.executePostOpPlugins = true;
            PluginResult.PreOperation preOpResult = this.pluginConfigManager.invokePreOperationBindPlugins(this);
            if (!preOpResult.continueProcessing()) {
                this.setResultCode(preOpResult.getResultCode());
                this.appendErrorMessage(preOpResult.getErrorMessage());
                this.setMatchedDN(preOpResult.getMatchedDN());
                this.setReferralURLs(preOpResult.getReferralURLs());
                boolean bl = false;
                return bl;
            }
            if (this.pwPolicyState.passwordMatches(simplePassword)) {
                this.setResultCode(ResultCode.SUCCESS);
                boolean isRoot = DirectoryServer.isRootDN(userEntry2.getDN());
                if (DirectoryServer.lockdownMode() && !isRoot) {
                    throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, CoreMessages.ERR_BIND_REJECTED_LOCKDOWN_MODE.get());
                }
                this.setAuthenticationInfo(new AuthenticationInfo(userEntry2, this.getBindDN(), simplePassword, isRoot));
                this.setResourceLimits(userEntry2);
                this.pwPolicyState.handleDeprecatedStorageSchemes(simplePassword);
                this.pwPolicyState.clearFailureLockout();
                if (this.isFirstWarning) {
                    this.pwPolicyState.setWarnedTime();
                    int numSeconds = this.pwPolicyState.getSecondsUntilExpiration();
                    Message m = CoreMessages.WARN_BIND_PASSWORD_EXPIRING.get(StaticUtils.secondsToTimeString(numSeconds));
                    this.pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.PASSWORD_EXPIRING, userEntry2, m, AccountStatusNotification.createProperties(this.pwPolicyState, false, numSeconds, null, null));
                }
                if (this.isGraceLogin) {
                    this.pwPolicyState.updateGraceLoginTimes();
                }
                this.pwPolicyState.setLastLoginTime();
            } else {
                this.setResultCode(ResultCode.INVALID_CREDENTIALS);
                this.setAuthFailureReason(CoreMessages.ERR_BIND_OPERATION_WRONG_PASSWORD.get());
                if (this.policy.getLockoutFailureCount() > 0) {
                    this.pwPolicyState.updateAuthFailureTimes();
                    if (this.pwPolicyState.lockedDueToFailures()) {
                        Message m;
                        boolean tempLocked;
                        AccountStatusNotificationType notificationType;
                        int lockoutDuration = this.pwPolicyState.getSecondsUntilUnlock();
                        if (lockoutDuration > -1) {
                            notificationType = AccountStatusNotificationType.ACCOUNT_TEMPORARILY_LOCKED;
                            tempLocked = true;
                            m = CoreMessages.ERR_BIND_ACCOUNT_TEMPORARILY_LOCKED.get(StaticUtils.secondsToTimeString(lockoutDuration));
                        } else {
                            notificationType = AccountStatusNotificationType.ACCOUNT_PERMANENTLY_LOCKED;
                            tempLocked = false;
                            m = CoreMessages.ERR_BIND_ACCOUNT_PERMANENTLY_LOCKED.get();
                        }
                        this.pwPolicyState.generateAccountStatusNotification(notificationType, userEntry2, m, AccountStatusNotification.createProperties(this.pwPolicyState, tempLocked, -1, null, null));
                    }
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            LockManager.unlock(this.bindDN, userLock);
        }
    }

    protected boolean processAnonymousSimpleBind() throws DirectoryException {
        if (DirectoryServer.lockdownMode()) {
            throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, CoreMessages.ERR_BIND_REJECTED_LOCKDOWN_MODE.get());
        }
        if (DirectoryServer.bindWithDNRequiresPassword() && this.bindDN != null && !this.bindDN.isNullDN()) {
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, CoreMessages.ERR_BIND_DN_BUT_NO_PASSWORD.get());
        }
        this.executePostOpPlugins = true;
        PluginResult.PreOperation preOpResult = this.pluginConfigManager.invokePreOperationBindPlugins(this);
        if (!preOpResult.continueProcessing()) {
            this.setResultCode(preOpResult.getResultCode());
            this.appendErrorMessage(preOpResult.getErrorMessage());
            this.setMatchedDN(preOpResult.getMatchedDN());
            this.setReferralURLs(preOpResult.getReferralURLs());
            return false;
        }
        this.setResultCode(ResultCode.SUCCESS);
        this.setAuthenticationInfo(new AuthenticationInfo());
        return true;
    }

    private boolean processSASLBind() throws DirectoryException {
        ResultCode resultCode;
        SASLMechanismHandler saslHandler = DirectoryServer.getSASLMechanismHandler(this.saslMechanism);
        if (saslHandler == null) {
            throw new DirectoryException(ResultCode.AUTH_METHOD_NOT_SUPPORTED, CoreMessages.ERR_BIND_OPERATION_UNKNOWN_SASL_MECHANISM.get(this.saslMechanism));
        }
        PluginResult.PreOperation preOpResult = this.pluginConfigManager.invokePreOperationBindPlugins(this);
        if (!preOpResult.continueProcessing()) {
            this.setResultCode(preOpResult.getResultCode());
            this.appendErrorMessage(preOpResult.getErrorMessage());
            this.setMatchedDN(preOpResult.getMatchedDN());
            this.setReferralURLs(preOpResult.getReferralURLs());
            return false;
        }
        saslHandler.processSASLBind(this);
        Entry saslAuthUserEntry = this.getSASLAuthUserEntry();
        if (DirectoryServer.lockdownMode() && (resultCode = this.getResultCode()) != ResultCode.SASL_BIND_IN_PROGRESS && (resultCode != ResultCode.SUCCESS || saslAuthUserEntry == null || !DirectoryServer.isRootDN(saslAuthUserEntry.getDN()))) {
            throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, CoreMessages.ERR_BIND_REJECTED_LOCKDOWN_MODE.get());
        }
        if (saslAuthUserEntry == null) {
            this.pwPolicyState = null;
        } else {
            this.pwPolicyState = new PasswordPolicyState(saslAuthUserEntry, false);
            this.policy = this.pwPolicyState.getPolicy();
            this.setUserEntryDN(saslAuthUserEntry.getDN());
            this.checkPasswordPolicyState(saslAuthUserEntry, saslHandler);
        }
        resultCode = this.getResultCode();
        if (resultCode == ResultCode.SUCCESS) {
            if (this.pwPolicyState != null) {
                if (saslHandler.isPasswordBased(this.saslMechanism) && this.pwPolicyState.mustChangePassword()) {
                    this.mustChangePassword = true;
                }
                if (this.isFirstWarning) {
                    this.pwPolicyState.setWarnedTime();
                    int numSeconds = this.pwPolicyState.getSecondsUntilExpiration();
                    Message m = CoreMessages.WARN_BIND_PASSWORD_EXPIRING.get(StaticUtils.secondsToTimeString(numSeconds));
                    this.pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.PASSWORD_EXPIRING, saslAuthUserEntry, m, AccountStatusNotification.createProperties(this.pwPolicyState, false, numSeconds, null, null));
                }
                if (this.isGraceLogin) {
                    this.pwPolicyState.updateGraceLoginTimes();
                }
                this.pwPolicyState.setLastLoginTime();
                this.setResourceLimits(saslAuthUserEntry);
            }
        } else {
            if (resultCode == ResultCode.SASL_BIND_IN_PROGRESS) {
                return false;
            }
            if (this.pwPolicyState != null && saslHandler.isPasswordBased(this.saslMechanism) && this.pwPolicyState.getPolicy().getLockoutFailureCount() > 0) {
                this.pwPolicyState.updateAuthFailureTimes();
                if (this.pwPolicyState.lockedDueToFailures()) {
                    Message m;
                    boolean tempLocked;
                    AccountStatusNotificationType notificationType;
                    int lockoutDuration = this.pwPolicyState.getSecondsUntilUnlock();
                    if (lockoutDuration > -1) {
                        notificationType = AccountStatusNotificationType.ACCOUNT_TEMPORARILY_LOCKED;
                        tempLocked = true;
                        m = CoreMessages.ERR_BIND_ACCOUNT_TEMPORARILY_LOCKED.get(StaticUtils.secondsToTimeString(lockoutDuration));
                    } else {
                        notificationType = AccountStatusNotificationType.ACCOUNT_PERMANENTLY_LOCKED;
                        tempLocked = false;
                        m = CoreMessages.ERR_BIND_ACCOUNT_PERMANENTLY_LOCKED.get();
                    }
                    this.pwPolicyState.generateAccountStatusNotification(notificationType, saslAuthUserEntry, m, AccountStatusNotification.createProperties(this.pwPolicyState, tempLocked, -1, null, null));
                }
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void checkPasswordPolicyState(Entry userEntry, SASLMechanismHandler<?> saslHandler) throws DirectoryException {
        block21: {
            block23: {
                block22: {
                    int maxGraceLogins;
                    boolean isSASLBind;
                    boolean bl = isSASLBind = saslHandler != null;
                    if (!(this.policy.getStateUpdateFailurePolicy() != PasswordPolicyCfgDefn.StateUpdateFailurePolicy.PROACTIVE || this.policy.getLockoutFailureCount() <= 0 && (this.policy.getLastLoginTimeAttribute() == null || this.policy.getLastLoginTimeFormat() == null) || DirectoryServer.getWritabilityMode() != WritabilityMode.DISABLED && this.backend.getWritabilityMode() != WritabilityMode.DISABLED || DirectoryServer.isRootDN(userEntry.getDN()))) {
                        throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, CoreMessages.ERR_BIND_OPERATION_WRITABILITY_DISABLED.get(String.valueOf(userEntry.getDN())));
                    }
                    if (this.policy.requireSecureAuthentication() && !this.clientConnection.isSecure()) {
                        if (!isSASLBind) {
                            throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, CoreMessages.ERR_BIND_OPERATION_INSECURE_SIMPLE_BIND.get(String.valueOf(userEntry.getDN())));
                        }
                        if (!saslHandler.isSecure(this.saslMechanism)) {
                            throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, CoreMessages.ERR_BIND_OPERATION_INSECURE_SASL_BIND.get(this.saslMechanism, String.valueOf(userEntry.getDN())));
                        }
                    }
                    if (this.pwPolicyState.isDisabled()) {
                        throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, CoreMessages.ERR_BIND_OPERATION_ACCOUNT_DISABLED.get(String.valueOf(userEntry.getDN())));
                    }
                    if (this.pwPolicyState.isAccountExpired()) {
                        Message m = CoreMessages.ERR_BIND_OPERATION_ACCOUNT_EXPIRED.get(String.valueOf(userEntry.getDN()));
                        this.pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.ACCOUNT_EXPIRED, userEntry, m, AccountStatusNotification.createProperties(this.pwPolicyState, false, -1, null, null));
                        throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, m);
                    }
                    if (this.pwPolicyState.lockedDueToFailures()) {
                        if (this.pwPolicyErrorType == null) {
                            this.pwPolicyErrorType = PasswordPolicyErrorType.ACCOUNT_LOCKED;
                        }
                        throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, CoreMessages.ERR_BIND_OPERATION_ACCOUNT_FAILURE_LOCKED.get(String.valueOf(userEntry.getDN())));
                    }
                    if (this.pwPolicyState.lockedDueToIdleInterval()) {
                        Message m = CoreMessages.ERR_BIND_OPERATION_ACCOUNT_IDLE_LOCKED.get(String.valueOf(userEntry.getDN()));
                        if (this.pwPolicyErrorType == null) {
                            this.pwPolicyErrorType = PasswordPolicyErrorType.ACCOUNT_LOCKED;
                        }
                        this.pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.ACCOUNT_IDLE_LOCKED, userEntry, m, AccountStatusNotification.createProperties(this.pwPolicyState, false, -1, null, null));
                        throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, m);
                    }
                    if (isSASLBind && !saslHandler.isPasswordBased(this.saslMechanism)) break block21;
                    if (this.pwPolicyState.lockedDueToMaximumResetAge()) {
                        Message m = CoreMessages.ERR_BIND_OPERATION_ACCOUNT_RESET_LOCKED.get(String.valueOf(userEntry.getDN()));
                        if (this.pwPolicyErrorType == null) {
                            this.pwPolicyErrorType = PasswordPolicyErrorType.ACCOUNT_LOCKED;
                        }
                        this.pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.ACCOUNT_RESET_LOCKED, userEntry, m, AccountStatusNotification.createProperties(this.pwPolicyState, false, -1, null, null));
                        throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, m);
                    }
                    if (!this.pwPolicyState.isPasswordExpired()) break block22;
                    if (this.pwPolicyErrorType == null) {
                        this.pwPolicyErrorType = PasswordPolicyErrorType.PASSWORD_EXPIRED;
                    }
                    if ((maxGraceLogins = this.policy.getGraceLoginCount()) > 0 && this.pwPolicyState.mayUseGraceLogin()) {
                        List<Long> graceLoginTimes = this.pwPolicyState.getGraceLoginTimes();
                        if (graceLoginTimes != null && graceLoginTimes.size() >= maxGraceLogins) {
                            Message m = CoreMessages.ERR_BIND_OPERATION_PASSWORD_EXPIRED.get(String.valueOf(userEntry.getDN()));
                            this.pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.PASSWORD_EXPIRED, userEntry, m, AccountStatusNotification.createProperties(this.pwPolicyState, false, -1, null, null));
                            throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, m);
                        }
                        this.isGraceLogin = true;
                        this.mustChangePassword = true;
                        if (this.pwPolicyWarningType == null) {
                            this.pwPolicyWarningType = PasswordPolicyWarningType.GRACE_LOGINS_REMAINING;
                            this.pwPolicyWarningValue = maxGraceLogins - (graceLoginTimes.size() + 1);
                        }
                        break block23;
                    } else {
                        Message m = CoreMessages.ERR_BIND_OPERATION_PASSWORD_EXPIRED.get(String.valueOf(userEntry.getDN()));
                        this.pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.PASSWORD_EXPIRED, userEntry, m, AccountStatusNotification.createProperties(this.pwPolicyState, false, -1, null, null));
                        throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, m);
                    }
                }
                if (this.pwPolicyState.shouldWarn()) {
                    int numSeconds = this.pwPolicyState.getSecondsUntilExpiration();
                    if (this.pwPolicyWarningType == null) {
                        this.pwPolicyWarningType = PasswordPolicyWarningType.TIME_BEFORE_EXPIRATION;
                        this.pwPolicyWarningValue = numSeconds;
                    }
                    this.isFirstWarning = this.pwPolicyState.isFirstWarning();
                }
            }
            if (this.pwPolicyState.mustChangePassword()) {
                this.mustChangePassword = true;
                if (this.pwPolicyErrorType == null) {
                    this.pwPolicyErrorType = PasswordPolicyErrorType.CHANGE_AFTER_RESET;
                }
            }
        }
    }

    protected void setResourceLimits(Entry userEntry) {
        AttributeValue v;
        Attribute a;
        Iterator<AttributeValue> iterator;
        AttributeType attrType = DirectoryServer.getAttributeType("ds-rlim-size-limit", true);
        List<Attribute> attrList = userEntry.getAttribute(attrType);
        if (attrList != null && attrList.size() == 1 && (iterator = (a = attrList.get(0)).iterator()).hasNext()) {
            v = iterator.next();
            if (iterator.hasNext()) {
                ErrorLogger.logError(CoreMessages.WARN_BIND_MULTIPLE_USER_SIZE_LIMITS.get(String.valueOf(userEntry.getDN())));
            } else {
                try {
                    this.sizeLimit = Integer.parseInt(v.getValue().toString());
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    ErrorLogger.logError(CoreMessages.WARN_BIND_CANNOT_PROCESS_USER_SIZE_LIMIT.get(v.getValue().toString(), String.valueOf(userEntry.getDN())));
                }
            }
        }
        if ((attrList = userEntry.getAttribute(attrType = DirectoryServer.getAttributeType("ds-rlim-time-limit", true))) != null && attrList.size() == 1 && (iterator = (a = attrList.get(0)).iterator()).hasNext()) {
            v = iterator.next();
            if (iterator.hasNext()) {
                ErrorLogger.logError(CoreMessages.WARN_BIND_MULTIPLE_USER_TIME_LIMITS.get(String.valueOf(userEntry.getDN())));
            } else {
                try {
                    this.timeLimit = Integer.parseInt(v.getValue().toString());
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    ErrorLogger.logError(CoreMessages.WARN_BIND_CANNOT_PROCESS_USER_TIME_LIMIT.get(v.getValue().toString(), String.valueOf(userEntry.getDN())));
                }
            }
        }
        if ((attrList = userEntry.getAttribute(attrType = DirectoryServer.getAttributeType("ds-rlim-idle-time-limit", true))) != null && attrList.size() == 1 && (iterator = (a = attrList.get(0)).iterator()).hasNext()) {
            v = iterator.next();
            if (iterator.hasNext()) {
                ErrorLogger.logError(CoreMessages.WARN_BIND_MULTIPLE_USER_IDLE_TIME_LIMITS.get(String.valueOf(userEntry.getDN())));
            } else {
                try {
                    this.idleTimeLimit = 1000L * Long.parseLong(v.getValue().toString());
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    ErrorLogger.logError(CoreMessages.WARN_BIND_CANNOT_PROCESS_USER_IDLE_TIME_LIMIT.get(v.getValue().toString(), String.valueOf(userEntry.getDN())));
                }
            }
        }
        if ((attrList = userEntry.getAttribute(attrType = DirectoryServer.getAttributeType("ds-rlim-lookthrough-limit", true))) != null && attrList.size() == 1 && (iterator = (a = attrList.get(0)).iterator()).hasNext()) {
            v = iterator.next();
            if (iterator.hasNext()) {
                ErrorLogger.logError(CoreMessages.WARN_BIND_MULTIPLE_USER_LOOKTHROUGH_LIMITS.get(String.valueOf(userEntry.getDN())));
            } else {
                try {
                    this.lookthroughLimit = Integer.parseInt(v.getValue().toString());
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    ErrorLogger.logError(CoreMessages.WARN_BIND_CANNOT_PROCESS_USER_LOOKTHROUGH_LIMIT.get(v.getValue().toString(), String.valueOf(userEntry.getDN())));
                }
            }
        }
    }
}

