/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.snmp;

import com.sun.management.snmp.agent.SnmpMib;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.snmp.DsApplIfOpsEntryImpl;
import org.opends.server.snmp.DsEntry;
import org.opends.server.snmp.DsMIB;
import org.opends.server.snmp.DsTableEntryImpl;
import org.opends.server.snmp.SNMPMonitor;
import org.opends.server.types.DebugLogLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DsMIBImpl
extends DsMIB
implements NotificationListener {
    private static final long serialVersionUID = 6787374593664749374L;
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private SnmpMib mib;
    private boolean registeredSnmpMBean = false;
    private Hashtable<ObjectName, DsEntry> dsTableEntries = new Hashtable();
    private Hashtable<ObjectName, DsEntry> dsApplIfOpsTableEntries = new Hashtable();
    private Hashtable<ObjectName, DsEntry> dsIntTableEntries = new Hashtable();
    private MBeanServer server;
    private SNMPMonitor monitor;
    private int applIndex = 1;
    private int applIfOpsIndex = 1;
    private int intIndex = 1;

    public DsMIBImpl(SnmpMib myMib, MBeanServer server, boolean registered) {
        super(myMib);
        this.mib = myMib;
        this.server = server;
        this.monitor = SNMPMonitor.getMonitor(server);
        this.registeredSnmpMBean = registered;
        this.dsTableEntries.clear();
        this.dsApplIfOpsTableEntries.clear();
        this.dsIntTableEntries.clear();
        this.initDsTables();
        if (DebugLogger.debugEnabled()) {
            TRACER.debugVerbose("DsMIB Group Created");
        }
    }

    public Set<ObjectName> getEntriesObjectNames() {
        HashSet<ObjectName> results = new HashSet<ObjectName>();
        results.addAll(this.dsTableEntries.keySet());
        results.addAll(this.dsApplIfOpsTableEntries.keySet());
        results.addAll(this.dsIntTableEntries.keySet());
        return results;
    }

    public Set<ObjectName> getEntries() {
        HashSet<ObjectName> results = new HashSet<ObjectName>();
        results.addAll(this.dsTableEntries.values());
        results.addAll(this.dsApplIfOpsTableEntries.values());
        results.addAll(this.dsIntTableEntries.values());
        return results;
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        if (notification instanceof MBeanServerNotification) {
            ObjectName name;
            MBeanServerNotification notif = (MBeanServerNotification)notification;
            if (notif.getType().equals("JMX.mbean.registered")) {
                ObjectName name2 = notif.getMBeanName();
                if (name2.getKeyProperty("Rdn1").equals("cn-monitor") && this.isAConnectionHandler(name2)) {
                    this.addRowInDsApplIfOpsTable(name2);
                }
            } else if (notif.getType().equals("JMX.mbean.unregistered") && (name = notif.getMBeanName()).getKeyProperty("Rdn1").equals("cn-monitor") && this.isAConnectionHandler(name)) {
                this.removeRowInDsApplIfOpsTable(name);
            }
        }
    }

    private void initDsTables() {
        block2: {
            this.initializeDsTable();
            this.initializeDsApplIfOpsTable();
            try {
                ObjectName name = new ObjectName("JMImplementation:type=MBeanServerDelegate");
                this.server.addNotificationListener(name, this, null, null);
            }
            catch (Exception ex) {
                if (!DebugLogger.debugEnabled()) break block2;
                TRACER.debugCaught(DebugLogLevel.ERROR, (Throwable)ex);
            }
        }
    }

    private void initializeDsTable() {
        this.addRowInDsTable();
    }

    private void initializeDsApplIfOpsTable() {
        Set<ObjectName> connectionHandlers = this.monitor.getConnectionHandlers();
        for (ObjectName name : connectionHandlers) {
            this.addRowInDsApplIfOpsTable(name);
        }
    }

    private boolean addRowInDsTable() {
        try {
            DsTableEntryImpl entry = new DsTableEntryImpl(this.mib, this.server, this.applIndex);
            if (this.dsTableEntries.containsKey(entry.getObjectName()) || entry == null) {
                return true;
            }
            this.DsTable.addEntry(entry, entry.getObjectName());
            this.dsTableEntries.put(entry.getObjectName(), entry);
            if (this.registeredSnmpMBean) {
                this.server.registerMBean(entry, entry.getObjectName());
            }
        }
        catch (Exception ex) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, (Throwable)ex);
            }
            return false;
        }
        return true;
    }

    private boolean addRowInDsIntTable() {
        return false;
    }

    private boolean addRowInDsApplIfOpsTable(ObjectName connectionHandlerName) {
        try {
            DsApplIfOpsEntryImpl entry = new DsApplIfOpsEntryImpl(this.mib, this.server, connectionHandlerName, this.applIndex, this.applIfOpsIndex);
            if (this.dsApplIfOpsTableEntries.containsKey(entry.getObjectName()) || entry == null) {
                return true;
            }
            this.DsApplIfOpsTable.addEntry(entry);
            this.dsApplIfOpsTableEntries.put(entry.getObjectName(), entry);
            ++this.applIfOpsIndex;
            if (this.registeredSnmpMBean) {
                this.server.registerMBean(entry, entry.getObjectName());
            }
        }
        catch (Exception ex) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, (Throwable)ex);
            }
            return false;
        }
        return true;
    }

    private boolean removeRowInDsApplIfOpsTable(ObjectName connectionHandlerName) {
        try {
            if (!this.dsApplIfOpsTableEntries.containsKey(connectionHandlerName)) {
                return false;
            }
            DsApplIfOpsEntryImpl entry = (DsApplIfOpsEntryImpl)this.dsApplIfOpsTableEntries.get(connectionHandlerName);
            this.DsApplIfOpsTable.removeEntry(entry);
            this.dsApplIfOpsTableEntries.remove(connectionHandlerName);
            this.server.unregisterMBean(entry.getObjectName());
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private boolean isAConnectionHandler(ObjectName name) {
        String Rdn2 = name.getKeyProperty("Rdn2");
        String Rdn3 = name.getKeyProperty("Rdn3");
        return (Rdn3 == null || Rdn3.length() == 0) && Rdn2.contains("Connection_Handler") && !Rdn2.endsWith("_Statistics");
    }
}

