/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.installer.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.security.KeyStoreException;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.SecurityOptions;
import org.opends.quicksetup.event.BrowseActionListener;
import org.opends.quicksetup.event.MinimumSizeComponentListener;
import org.opends.quicksetup.installer.ui.SelectAliasDialog;
import org.opends.quicksetup.ui.UIFactory;
import org.opends.quicksetup.ui.Utilities;
import org.opends.quicksetup.util.BackgroundTask;
import org.opends.quicksetup.util.Utils;
import org.opends.server.util.CertificateManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityOptionsDialog
extends JDialog {
    private static final long serialVersionUID = 4083707346899442215L;
    private JCheckBox cbEnableSSL;
    private JCheckBox cbEnableStartTLS;
    private JTextField tfPort;
    private JRadioButton rbUseSelfSignedCertificate;
    private JRadioButton rbUseExistingCertificate;
    private JLabel lKeystoreType;
    private JRadioButton rbPKCS11;
    private JRadioButton rbJKS;
    private JRadioButton rbJCEKS;
    private JRadioButton rbPKCS12;
    private JLabel lKeystorePath;
    private JTextField tfKeystorePath;
    private JButton browseButton;
    private JLabel lKeystorePwd;
    private JPasswordField tfKeystorePwd;
    private JButton cancelButton;
    private JButton okButton;
    private SelectAliasDialog aliasDlg;
    private boolean isCanceled = true;
    private SecurityOptions securityOptions;
    private String[] aliases;
    private boolean certificateHasAlias;
    private String selectedAlias;
    private final int DEFAULT_PORT = 636;

    public SecurityOptionsDialog(JFrame parent, SecurityOptions options) throws IllegalArgumentException {
        super(parent);
        this.setTitle(QuickSetupMessages.INFO_SECURITY_OPTIONS_DIALOG_TITLE.get().toString());
        this.securityOptions = options;
        this.getContentPane().add(this.createPanel());
        this.pack();
        this.updateContents();
        int minWidth = (int)this.getPreferredSize().getWidth();
        int minHeight = (int)this.getPreferredSize().getHeight();
        this.addComponentListener(new MinimumSizeComponentListener(this, minWidth, minHeight));
        this.getRootPane().setDefaultButton(this.okButton);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                SecurityOptionsDialog.this.cancelClicked();
            }
        });
        this.setDefaultCloseOperation(0);
        Utilities.centerOnComponent(this, parent);
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void display(SecurityOptions options) throws IllegalArgumentException {
        if (options == null) {
            throw new IllegalArgumentException("options parameter cannot be null.");
        }
        UIFactory.setTextStyle(this.cbEnableSSL, UIFactory.TextStyle.SECONDARY_FIELD_VALID);
        UIFactory.setTextStyle(this.lKeystorePath, UIFactory.TextStyle.SECONDARY_FIELD_VALID);
        UIFactory.setTextStyle(this.lKeystorePwd, UIFactory.TextStyle.SECONDARY_FIELD_VALID);
        this.securityOptions = options;
        this.updateContents();
        this.isCanceled = true;
        this.setVisible(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SecurityOptions getSecurityOptions() {
        boolean enableSSL = this.cbEnableSSL.isSelected();
        boolean enableStartTLS = this.cbEnableStartTLS.isSelected();
        if (!enableSSL) {
            if (!enableStartTLS) return SecurityOptions.createNoCertificateOptions();
        }
        int sslPort = -1;
        try {
            sslPort = Integer.parseInt(this.tfPort.getText());
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (this.rbUseSelfSignedCertificate.isSelected()) {
            return SecurityOptions.createSelfSignedCertificateOptions(enableSSL, enableStartTLS, sslPort);
        }
        if (this.rbJKS.isSelected()) {
            return SecurityOptions.createJKSCertificateOptions(this.tfKeystorePath.getText(), String.valueOf(this.tfKeystorePwd.getPassword()), enableSSL, enableStartTLS, sslPort, this.selectedAlias);
        }
        if (this.rbJCEKS.isSelected()) {
            return SecurityOptions.createJCEKSCertificateOptions(this.tfKeystorePath.getText(), String.valueOf(this.tfKeystorePwd.getPassword()), enableSSL, enableStartTLS, sslPort, this.selectedAlias);
        }
        if (this.rbPKCS11.isSelected()) {
            return SecurityOptions.createPKCS11CertificateOptions(String.valueOf(this.tfKeystorePwd.getPassword()), enableSSL, enableStartTLS, sslPort, this.selectedAlias);
        }
        if (!this.rbPKCS12.isSelected()) throw new IllegalStateException("No certificate options selected.");
        return SecurityOptions.createPKCS12CertificateOptions(this.tfKeystorePath.getText(), String.valueOf(this.tfKeystorePwd.getPassword()), enableSSL, enableStartTLS, sslPort, this.selectedAlias);
    }

    private JPanel createPanel() {
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel contentPanel = new JPanel(new GridBagLayout());
        contentPanel.setBackground(UIFactory.DEFAULT_BACKGROUND);
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        JPanel topPanel = new JPanel(new GridBagLayout());
        topPanel.setBorder(UIFactory.DIALOG_PANEL_BORDER);
        topPanel.setBackground(UIFactory.CURRENT_STEP_PANEL_BACKGROUND);
        Insets insets = UIFactory.getCurrentStepPanelInsets();
        gbc.weighty = 0.0;
        insets.bottom = 0;
        gbc.insets = insets;
        topPanel.add(this.createTitlePanel(), gbc);
        gbc.insets.top = 5;
        topPanel.add(this.createInstructionsPane(), gbc);
        gbc.insets.top = 10;
        gbc.insets.bottom = 10;
        topPanel.add(this.createInputPanel(), gbc);
        gbc.weighty = 1.0;
        gbc.insets = UIFactory.getEmptyInsets();
        topPanel.add(Box.createVerticalGlue(), gbc);
        contentPanel.add((Component)topPanel, gbc);
        gbc.weighty = 0.0;
        gbc.insets = UIFactory.getButtonsPanelInsets();
        contentPanel.add(this.createButtonsPanel(), gbc);
        return contentPanel;
    }

    private Component createTitlePanel() {
        JPanel titlePanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        titlePanel.setOpaque(false);
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 0.0;
        gbc.gridwidth = -1;
        Message title = QuickSetupMessages.INFO_SECURITY_OPTIONS_TITLE.get();
        JLabel l = UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, title, UIFactory.TextStyle.TITLE);
        l.setOpaque(false);
        titlePanel.add((Component)l, gbc);
        gbc.gridwidth = -1;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        gbc.insets.left = 0;
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        titlePanel.add(Box.createHorizontalGlue(), gbc);
        return titlePanel;
    }

    private Component createInstructionsPane() {
        Message instructions = QuickSetupMessages.INFO_SECURITY_OPTIONS_INSTRUCTIONS.get();
        JEditorPane instructionsPane = UIFactory.makeHtmlPane(instructions, UIFactory.INSTRUCTIONS_FONT);
        instructionsPane.setOpaque(false);
        instructionsPane.setEditable(false);
        return instructionsPane;
    }

    private Component createInputPanel() {
        JPanel inputPanel = new JPanel(new GridBagLayout());
        inputPanel.setOpaque(false);
        ActionListener l = new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                SecurityOptionsDialog.this.updateEnablingState();
            }
        };
        this.cbEnableSSL = UIFactory.makeJCheckBox(QuickSetupMessages.INFO_ENABLE_SSL_LABEL.get(), QuickSetupMessages.INFO_ENABLE_SSL_TOOLTIP.get(), UIFactory.TextStyle.PRIMARY_FIELD_VALID);
        this.cbEnableSSL.addActionListener(l);
        String sPort = "";
        int port = this.securityOptions.getSslPort();
        if (port > 0) {
            sPort = String.valueOf(port);
        }
        this.tfPort = UIFactory.makeJTextField(Message.raw(sPort, new Object[0]), QuickSetupMessages.INFO_SSL_PORT_TEXTFIELD_TOOLTIP.get(), 5, UIFactory.TextStyle.TEXTFIELD);
        this.cbEnableStartTLS = UIFactory.makeJCheckBox(QuickSetupMessages.INFO_ENABLE_STARTTLS_LABEL.get(), QuickSetupMessages.INFO_ENABLE_STARTTLS_TOOLTIP.get(), UIFactory.TextStyle.SECONDARY_FIELD_VALID);
        this.cbEnableStartTLS.addActionListener(l);
        this.rbUseSelfSignedCertificate = UIFactory.makeJRadioButton(QuickSetupMessages.INFO_USE_SELF_SIGNED_LABEL.get(), QuickSetupMessages.INFO_USE_SELF_SIGNED_TOOLTIP.get(), UIFactory.TextStyle.SECONDARY_FIELD_VALID);
        this.rbUseSelfSignedCertificate.addActionListener(l);
        this.rbUseExistingCertificate = UIFactory.makeJRadioButton(QuickSetupMessages.INFO_USE_EXISTING_CERTIFICATE_LABEL.get(), QuickSetupMessages.INFO_USE_EXISTING_CERTIFICATE_TOOLTIP.get(), UIFactory.TextStyle.SECONDARY_FIELD_VALID);
        this.rbUseExistingCertificate.addActionListener(l);
        ButtonGroup group1 = new ButtonGroup();
        group1.add(this.rbUseSelfSignedCertificate);
        group1.add(this.rbUseExistingCertificate);
        this.lKeystoreType = UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, QuickSetupMessages.INFO_KEYSTORE_TYPE_LABEL.get(), UIFactory.TextStyle.SECONDARY_FIELD_VALID);
        this.lKeystoreType.setOpaque(false);
        this.rbJKS = UIFactory.makeJRadioButton(QuickSetupMessages.INFO_JKS_CERTIFICATE_LABEL.get(), QuickSetupMessages.INFO_JKS_CERTIFICATE_TOOLTIP.get(), UIFactory.TextStyle.SECONDARY_FIELD_VALID);
        this.rbJKS.addActionListener(l);
        this.rbJCEKS = UIFactory.makeJRadioButton(QuickSetupMessages.INFO_JCEKS_CERTIFICATE_LABEL.get(), QuickSetupMessages.INFO_JCEKS_CERTIFICATE_TOOLTIP.get(), UIFactory.TextStyle.SECONDARY_FIELD_VALID);
        this.rbJCEKS.addActionListener(l);
        this.rbPKCS11 = UIFactory.makeJRadioButton(QuickSetupMessages.INFO_PKCS11_CERTIFICATE_LABEL.get(), QuickSetupMessages.INFO_PKCS11_CERTIFICATE_TOOLTIP.get(), UIFactory.TextStyle.SECONDARY_FIELD_VALID);
        this.rbPKCS11.addActionListener(l);
        this.rbPKCS12 = UIFactory.makeJRadioButton(QuickSetupMessages.INFO_PKCS12_CERTIFICATE_LABEL.get(), QuickSetupMessages.INFO_PKCS12_CERTIFICATE_TOOLTIP.get(), UIFactory.TextStyle.SECONDARY_FIELD_VALID);
        this.rbPKCS12.addActionListener(l);
        ButtonGroup group2 = new ButtonGroup();
        group2.add(this.rbJKS);
        group2.add(this.rbJCEKS);
        group2.add(this.rbPKCS11);
        group2.add(this.rbPKCS12);
        this.lKeystoreType.setLabelFor(this.rbJKS);
        this.lKeystorePath = UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, QuickSetupMessages.INFO_KEYSTORE_PATH_LABEL.get(), UIFactory.TextStyle.SECONDARY_FIELD_VALID);
        this.lKeystorePath.setOpaque(false);
        this.tfKeystorePath = UIFactory.makeJTextField(Message.EMPTY, QuickSetupMessages.INFO_KEYSTORE_PATH_TOOLTIP.get(), 20, UIFactory.TextStyle.TEXTFIELD);
        this.lKeystorePath.setLabelFor(this.tfKeystorePath);
        this.browseButton = UIFactory.makeJButton(QuickSetupMessages.INFO_BROWSE_BUTTON_LABEL.get(), QuickSetupMessages.INFO_BROWSE_BUTTON_TOOLTIP.get());
        BrowseActionListener browseListener = new BrowseActionListener(this.tfKeystorePath, BrowseActionListener.BrowseType.GENERIC_FILE, this);
        this.browseButton.addActionListener(browseListener);
        this.lKeystorePwd = UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, QuickSetupMessages.INFO_KEYSTORE_PWD_LABEL.get(), UIFactory.TextStyle.SECONDARY_FIELD_VALID);
        this.lKeystorePwd.setOpaque(false);
        this.tfKeystorePwd = UIFactory.makeJPasswordField(Message.EMPTY, QuickSetupMessages.INFO_KEYSTORE_PWD_TOOLTIP.get(), 15, UIFactory.TextStyle.PASSWORD_FIELD);
        this.lKeystorePwd.setLabelFor(this.tfKeystorePwd);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.weightx = 0.0;
        gbc.gridwidth = -1;
        gbc.insets = UIFactory.getEmptyInsets();
        gbc.fill = 2;
        inputPanel.add((Component)UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, QuickSetupMessages.INFO_SSL_ACCESS_LABEL.get(), UIFactory.TextStyle.PRIMARY_FIELD_VALID), gbc);
        JPanel auxPanel = new JPanel(new GridBagLayout());
        auxPanel.setOpaque(false);
        gbc.gridwidth = 4;
        gbc.fill = 0;
        auxPanel.add((Component)this.cbEnableSSL, gbc);
        --gbc.gridwidth;
        gbc.insets.left = 5;
        auxPanel.add((Component)this.tfPort, gbc);
        gbc.gridwidth = -1;
        auxPanel.add((Component)UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, this.getPortHelpMessage(), UIFactory.TextStyle.SECONDARY_FIELD_VALID), gbc);
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        auxPanel.add(Box.createHorizontalGlue(), gbc);
        gbc.insets.left = 10;
        gbc.weightx = 1.0;
        inputPanel.add((Component)auxPanel, gbc);
        gbc.insets = UIFactory.getEmptyInsets();
        gbc.insets.top = 5;
        gbc.gridwidth = -1;
        gbc.weightx = 0.0;
        inputPanel.add((Component)UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, QuickSetupMessages.INFO_STARTTLS_ACCESS_LABEL.get(), UIFactory.TextStyle.PRIMARY_FIELD_VALID), gbc);
        auxPanel = new JPanel(new GridBagLayout());
        auxPanel.setOpaque(false);
        gbc.gridwidth = -1;
        gbc.insets = UIFactory.getEmptyInsets();
        auxPanel.add((Component)this.cbEnableStartTLS, gbc);
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        auxPanel.add(Box.createHorizontalGlue(), gbc);
        gbc.insets.left = 10;
        gbc.insets.top = 5;
        inputPanel.add((Component)auxPanel, gbc);
        gbc.insets = UIFactory.getEmptyInsets();
        gbc.insets.top = 5;
        gbc.anchor = 18;
        gbc.gridwidth = -1;
        gbc.weightx = 0.0;
        JLabel lCertificate = UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, QuickSetupMessages.INFO_CERTIFICATE_LABEL.get(), UIFactory.TextStyle.PRIMARY_FIELD_VALID);
        int additionalInset = Math.abs(lCertificate.getPreferredSize().height - this.rbUseSelfSignedCertificate.getPreferredSize().height) / 2;
        gbc.insets.top += additionalInset;
        inputPanel.add((Component)lCertificate, gbc);
        auxPanel = new JPanel(new GridBagLayout());
        auxPanel.setOpaque(false);
        gbc.insets.left = 10;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.insets.top = 5;
        inputPanel.add((Component)auxPanel, gbc);
        gbc.insets = UIFactory.getEmptyInsets();
        gbc.anchor = 17;
        JPanel aux2Panel = new JPanel(new GridBagLayout());
        aux2Panel.setOpaque(false);
        gbc.gridwidth = -1;
        aux2Panel.add((Component)this.rbUseSelfSignedCertificate, gbc);
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        aux2Panel.add(Box.createHorizontalGlue(), gbc);
        auxPanel.add((Component)aux2Panel, gbc);
        aux2Panel = new JPanel(new GridBagLayout());
        aux2Panel.setOpaque(false);
        gbc.gridwidth = -1;
        gbc.insets = UIFactory.getEmptyInsets();
        gbc.weightx = 0.0;
        aux2Panel.add((Component)this.rbUseExistingCertificate, gbc);
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        aux2Panel.add(Box.createHorizontalGlue(), gbc);
        gbc.insets.top = 5;
        auxPanel.add((Component)aux2Panel, gbc);
        additionalInset = Math.abs(this.lKeystoreType.getPreferredSize().height - this.rbJKS.getPreferredSize().height) / 2;
        aux2Panel = new JPanel(new GridBagLayout());
        aux2Panel.setOpaque(false);
        gbc.insets.top -= additionalInset;
        gbc.insets.left = 35;
        auxPanel.add((Component)aux2Panel, gbc);
        gbc.gridwidth = -1;
        gbc.insets = UIFactory.getEmptyInsets();
        gbc.weightx = 0.0;
        gbc.anchor = 18;
        gbc.insets.top = additionalInset;
        aux2Panel.add((Component)this.lKeystoreType, gbc);
        gbc.gridwidth = 0;
        gbc.insets.top = 0;
        aux2Panel.add((Component)this.rbJKS, gbc);
        gbc.insets.top = 0;
        gbc.gridwidth = -1;
        aux2Panel.add(Box.createHorizontalGlue(), gbc);
        gbc.gridwidth = 0;
        aux2Panel.add((Component)this.rbJCEKS, gbc);
        gbc.gridwidth = -1;
        aux2Panel.add(Box.createHorizontalGlue(), gbc);
        gbc.gridwidth = 0;
        aux2Panel.add((Component)this.rbPKCS12, gbc);
        gbc.gridwidth = -1;
        aux2Panel.add(Box.createHorizontalGlue(), gbc);
        gbc.gridwidth = 0;
        aux2Panel.add((Component)this.rbPKCS11, gbc);
        gbc.gridwidth = -1;
        gbc.insets.left = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 17;
        aux2Panel.add((Component)this.lKeystorePath, gbc);
        JPanel aux3Panel = new JPanel(new GridBagLayout());
        aux3Panel.setOpaque(false);
        gbc.weightx = 1.0;
        gbc.insets.left = 5;
        gbc.gridwidth = 0;
        aux2Panel.add((Component)aux3Panel, gbc);
        gbc.insets = UIFactory.getEmptyInsets();
        gbc.gridwidth = -1;
        aux3Panel.add((Component)this.tfKeystorePath, gbc);
        gbc.insets.left = 10;
        gbc.gridwidth = 0;
        gbc.weightx = 0.0;
        aux3Panel.add((Component)this.browseButton, gbc);
        gbc.insets.left = 0;
        gbc.insets.top = 5;
        gbc.gridwidth = -1;
        gbc.weightx = 0.0;
        gbc.anchor = 17;
        aux2Panel.add((Component)this.lKeystorePwd, gbc);
        gbc.insets.left = 5;
        gbc.gridwidth = 0;
        gbc.fill = 0;
        aux2Panel.add((Component)this.tfKeystorePwd, gbc);
        return inputPanel;
    }

    private Component createButtonsPanel() {
        JPanel buttonsPanel = new JPanel(new GridBagLayout());
        buttonsPanel.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridwidth = 4;
        gbc.insets = UIFactory.getEmptyInsets();
        gbc.insets.left = UIFactory.getCurrentStepPanelInsets().left;
        buttonsPanel.add((Component)UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, null, UIFactory.TextStyle.NO_STYLE), gbc);
        gbc.weightx = 1.0;
        --gbc.gridwidth;
        gbc.insets.left = 0;
        buttonsPanel.add(Box.createHorizontalGlue(), gbc);
        gbc.gridwidth = -1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        this.okButton = UIFactory.makeJButton(QuickSetupMessages.INFO_OK_BUTTON_LABEL.get(), QuickSetupMessages.INFO_SECURITY_OPTIONS_OK_BUTTON_TOOLTIP.get());
        buttonsPanel.add((Component)this.okButton, gbc);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                SecurityOptionsDialog.this.okClicked();
            }
        });
        gbc.gridwidth = 0;
        gbc.insets.left = 5;
        this.cancelButton = UIFactory.makeJButton(QuickSetupMessages.INFO_CANCEL_BUTTON_LABEL.get(), QuickSetupMessages.INFO_SECURITY_OPTIONS_CANCEL_BUTTON_TOOLTIP.get());
        buttonsPanel.add((Component)this.cancelButton, gbc);
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                SecurityOptionsDialog.this.cancelClicked();
            }
        });
        return buttonsPanel;
    }

    private void cancelClicked() {
        this.isCanceled = true;
        this.dispose();
    }

    private void okClicked() {
        BackgroundTask<ArrayList<Message>> worker = new BackgroundTask<ArrayList<Message>>(){

            @Override
            public ArrayList<Message> processBackgroundTask() {
                ArrayList<Message> errorMsgs = new ArrayList<Message>();
                errorMsgs.addAll(SecurityOptionsDialog.this.checkPort());
                errorMsgs.addAll(SecurityOptionsDialog.this.checkKeystore());
                return errorMsgs;
            }

            @Override
            public void backgroundTaskCompleted(ArrayList<Message> returnValue, Throwable throwable) {
                if (throwable != null) {
                    throwable.printStackTrace();
                    SecurityOptionsDialog.this.displayError(Utils.getThrowableMsg(QuickSetupMessages.INFO_BUG_MSG.get(), throwable), QuickSetupMessages.INFO_ERROR_TITLE.get());
                    SecurityOptionsDialog.this.cancelButton.setEnabled(true);
                    SecurityOptionsDialog.this.okButton.setEnabled(true);
                } else {
                    SecurityOptionsDialog.this.cancelButton.setEnabled(true);
                    SecurityOptionsDialog.this.okButton.setEnabled(true);
                    if (returnValue.size() > 0) {
                        SecurityOptionsDialog.this.displayError(Utils.getMessageFromCollection(returnValue, "\n"), QuickSetupMessages.INFO_ERROR_TITLE.get());
                    } else if (SecurityOptionsDialog.this.rbUseExistingCertificate.isSelected() && (SecurityOptionsDialog.this.cbEnableSSL.isSelected() || SecurityOptionsDialog.this.cbEnableStartTLS.isSelected())) {
                        if (!SecurityOptionsDialog.this.certificateHasAlias) {
                            SecurityOptionsDialog.this.selectedAlias = null;
                            SecurityOptionsDialog.this.isCanceled = false;
                            SecurityOptionsDialog.this.dispose();
                        } else if (SecurityOptionsDialog.this.aliases.length > 1) {
                            if (SecurityOptionsDialog.this.aliasDlg == null) {
                                SecurityOptionsDialog.this.aliasDlg = new SelectAliasDialog(SecurityOptionsDialog.this);
                            }
                            SecurityOptionsDialog.this.aliasDlg.display(SecurityOptionsDialog.this.aliases);
                            if (!SecurityOptionsDialog.this.aliasDlg.isCanceled()) {
                                SecurityOptionsDialog.this.selectedAlias = SecurityOptionsDialog.this.aliasDlg.getSelectedAlias();
                                SecurityOptionsDialog.this.isCanceled = false;
                                SecurityOptionsDialog.this.dispose();
                            }
                        } else {
                            SecurityOptionsDialog.this.selectedAlias = SecurityOptionsDialog.this.aliases[0];
                            SecurityOptionsDialog.this.isCanceled = false;
                            SecurityOptionsDialog.this.dispose();
                        }
                    } else {
                        SecurityOptionsDialog.this.isCanceled = false;
                        SecurityOptionsDialog.this.dispose();
                    }
                }
            }
        };
        this.cancelButton.setEnabled(false);
        this.okButton.setEnabled(false);
        worker.startBackgroundTask();
    }

    private void displayError(Message msg, Message title) {
        Utilities.displayError(this, msg, title);
        this.toFront();
    }

    private void updateContents() {
        int port;
        this.cbEnableSSL.setSelected(this.securityOptions.getEnableSSL());
        this.cbEnableStartTLS.setSelected(this.securityOptions.getEnableStartTLS());
        if (this.securityOptions.getEnableSSL() && (port = this.securityOptions.getSslPort()) > 0) {
            this.tfPort.setText(String.valueOf(port));
        }
        switch (this.securityOptions.getCertificateType()) {
            case NO_CERTIFICATE: {
                break;
            }
            case SELF_SIGNED_CERTIFICATE: {
                this.rbUseSelfSignedCertificate.setSelected(true);
                break;
            }
            case JKS: {
                this.rbUseExistingCertificate.setSelected(true);
                this.rbJKS.setSelected(true);
                this.tfKeystorePath.setText(this.securityOptions.getKeystorePath());
                this.tfKeystorePwd.setText(this.securityOptions.getKeystorePassword());
                break;
            }
            case JCEKS: {
                this.rbUseExistingCertificate.setSelected(true);
                this.rbJCEKS.setSelected(true);
                this.tfKeystorePath.setText(this.securityOptions.getKeystorePath());
                this.tfKeystorePwd.setText(this.securityOptions.getKeystorePassword());
                break;
            }
            case PKCS11: {
                this.rbUseExistingCertificate.setSelected(true);
                this.rbPKCS11.setSelected(true);
                this.tfKeystorePwd.setText(this.securityOptions.getKeystorePassword());
                break;
            }
            case PKCS12: {
                this.rbUseExistingCertificate.setSelected(true);
                this.rbPKCS12.setSelected(true);
                this.tfKeystorePath.setText(this.securityOptions.getKeystorePath());
                this.tfKeystorePwd.setText(this.securityOptions.getKeystorePassword());
                break;
            }
            default: {
                throw new IllegalStateException("Unknown certificate type.");
            }
        }
        this.updateEnablingState();
    }

    private void updateEnablingState() {
        boolean useSSL;
        boolean enableSSL = this.cbEnableSSL.isSelected();
        boolean enableStartTLS = this.cbEnableStartTLS.isSelected();
        boolean bl = useSSL = enableSSL || enableStartTLS;
        if (useSSL && !this.rbUseSelfSignedCertificate.isSelected() && !this.rbUseExistingCertificate.isSelected()) {
            this.rbUseSelfSignedCertificate.setSelected(true);
        }
        if (useSSL && this.rbUseExistingCertificate.isSelected() && !this.rbJKS.isSelected() && !this.rbJCEKS.isSelected() && !this.rbPKCS11.isSelected() && !this.rbPKCS12.isSelected()) {
            this.rbJKS.setSelected(true);
        }
        this.tfPort.setEnabled(enableSSL);
        this.rbUseSelfSignedCertificate.setEnabled(useSSL);
        this.rbUseExistingCertificate.setEnabled(useSSL);
        this.lKeystoreType.setEnabled(this.rbUseExistingCertificate.isSelected() && useSSL);
        this.rbJKS.setEnabled(this.rbUseExistingCertificate.isSelected() && useSSL);
        this.rbJCEKS.setEnabled(this.rbUseExistingCertificate.isSelected() && useSSL);
        this.rbPKCS11.setEnabled(this.rbUseExistingCertificate.isSelected() && useSSL);
        this.rbPKCS12.setEnabled(this.rbUseExistingCertificate.isSelected() && useSSL);
        this.lKeystorePath.setEnabled(this.rbUseExistingCertificate.isSelected() && useSSL);
        this.tfKeystorePath.setEnabled(this.rbUseExistingCertificate.isSelected() && useSSL);
        this.browseButton.setEnabled(this.rbUseExistingCertificate.isSelected() && useSSL);
        this.lKeystorePwd.setEnabled(this.rbUseExistingCertificate.isSelected() && useSSL);
        this.tfKeystorePwd.setEnabled(this.rbUseExistingCertificate.isSelected() && useSSL);
        this.lKeystorePath.setVisible(!this.rbPKCS11.isSelected());
        this.tfKeystorePath.setVisible(!this.rbPKCS11.isSelected());
        this.browseButton.setVisible(!this.rbPKCS11.isSelected());
    }

    private Message getPortHelpMessage() {
        Message s = Message.EMPTY;
        if (this.securityOptions.getSslPort() != 636) {
            s = QuickSetupMessages.INFO_CANNOT_USE_DEFAULT_SECURE_PORT.get();
        }
        return s;
    }

    private ArrayList<Message> checkPort() {
        ArrayList<Message> errorMsgs = new ArrayList<Message>();
        if (this.cbEnableSSL.isSelected()) {
            String sPort = this.tfPort.getText();
            int port = -1;
            try {
                port = Integer.parseInt(sPort);
                if (port < 1 || port > 65535) {
                    errorMsgs.add(QuickSetupMessages.INFO_INVALID_SECURE_PORT_VALUE_RANGE.get(String.valueOf(1), String.valueOf(65535)));
                } else if (!Utils.canUseAsPort(port)) {
                    if (Utils.isPriviledgedPort(port)) {
                        errorMsgs.add(QuickSetupMessages.INFO_CANNOT_BIND_PRIVILEDGED_PORT.get(String.valueOf(port)));
                    } else {
                        errorMsgs.add(QuickSetupMessages.INFO_CANNOT_BIND_PORT.get(String.valueOf(port)));
                    }
                }
            }
            catch (NumberFormatException nfe) {
                errorMsgs.add(QuickSetupMessages.INFO_INVALID_SECURE_PORT_VALUE_RANGE.get(String.valueOf(1), String.valueOf(65535)));
            }
        }
        this.setValidLater(this.cbEnableSSL, errorMsgs.size() == 0);
        return errorMsgs;
    }

    private ArrayList<Message> checkKeystore() {
        ArrayList<Message> errorMsgs = new ArrayList<Message>();
        boolean pathValid = true;
        boolean pwdValid = true;
        if (this.rbUseExistingCertificate.isSelected() && (this.cbEnableSSL.isSelected() || this.cbEnableStartTLS.isSelected())) {
            String pwd;
            String path = this.tfKeystorePath.getText();
            if (this.rbJKS.isSelected() || this.rbJCEKS.isSelected() || this.rbPKCS12.isSelected()) {
                if (path == null || path.length() == 0) {
                    errorMsgs.add(QuickSetupMessages.INFO_KEYSTORE_PATH_NOT_PROVIDED.get());
                } else {
                    File f = new File(path);
                    if (!f.exists()) {
                        errorMsgs.add(QuickSetupMessages.INFO_KEYSTORE_PATH_DOES_NOT_EXIST.get());
                    } else if (!f.isFile()) {
                        errorMsgs.add(QuickSetupMessages.INFO_KEYSTORE_PATH_NOT_A_FILE.get());
                    }
                }
                boolean bl = pathValid = errorMsgs.size() == 0;
            }
            if ((pwd = String.valueOf(this.tfKeystorePwd.getPassword())) == null || pwd.length() == 0) {
                errorMsgs.add(QuickSetupMessages.INFO_KEYSTORE_PWD_EMPTY.get());
                pwdValid = false;
            }
            if (pathValid && pwdValid) {
                try {
                    CertificateManager certManager;
                    if (this.rbJKS.isSelected()) {
                        certManager = new CertificateManager(path, "JKS", pwd);
                    } else if (this.rbJCEKS.isSelected()) {
                        certManager = new CertificateManager(path, "JCEKS", pwd);
                    } else if (this.rbPKCS12.isSelected()) {
                        certManager = new CertificateManager(path, "PKCS12", pwd);
                    } else if (this.rbPKCS11.isSelected()) {
                        certManager = new CertificateManager("NONE", "PKCS11", pwd);
                    } else {
                        throw new IllegalStateException("No keystore type selected.");
                    }
                    this.aliases = certManager.getCertificateAliases();
                    if (this.aliases == null || this.aliases.length == 0) {
                        if (this.rbPKCS11.isSelected()) {
                            errorMsgs.add(QuickSetupMessages.INFO_PKCS11_KEYSTORE_DOES_NOT_EXIST.get());
                        } else {
                            if (this.rbJKS.isSelected()) {
                                errorMsgs.add(QuickSetupMessages.INFO_JKS_KEYSTORE_DOES_NOT_EXIST.get());
                            } else if (this.rbJCEKS.isSelected()) {
                                errorMsgs.add(QuickSetupMessages.INFO_JCEKS_KEYSTORE_DOES_NOT_EXIST.get());
                            } else {
                                errorMsgs.add(QuickSetupMessages.INFO_PKCS12_KEYSTORE_DOES_NOT_EXIST.get());
                            }
                            pathValid = false;
                        }
                    } else {
                        this.certificateHasAlias = certManager.hasRealAliases();
                    }
                }
                catch (KeyStoreException ke) {
                    pwdValid = false;
                    if (!this.rbPKCS11.isSelected()) {
                        pathValid = false;
                    }
                    if (this.rbPKCS11.isSelected()) {
                        errorMsgs.add(QuickSetupMessages.INFO_ERROR_ACCESSING_PKCS11_KEYSTORE.get());
                    }
                    if (this.rbJKS.isSelected()) {
                        errorMsgs.add(QuickSetupMessages.INFO_ERROR_ACCESSING_JKS_KEYSTORE.get());
                    } else if (this.rbJCEKS.isSelected()) {
                        errorMsgs.add(QuickSetupMessages.INFO_ERROR_ACCESSING_JCEKS_KEYSTORE.get());
                    } else {
                        errorMsgs.add(QuickSetupMessages.INFO_ERROR_ACCESSING_PKCS12_KEYSTORE.get());
                    }
                    pathValid = false;
                }
            }
        }
        this.setValidLater(this.lKeystorePath, pathValid);
        this.setValidLater(this.lKeystorePwd, pwdValid);
        return errorMsgs;
    }

    private void setValidLater(final JComponent comp, final boolean valid) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                UIFactory.setTextStyle(comp, valid ? UIFactory.TextStyle.SECONDARY_FIELD_VALID : UIFactory.TextStyle.SECONDARY_FIELD_INVALID);
            }
        });
    }

    public static void main(String[] args) {
        try {
            SecurityOptionsDialog dlg = new SecurityOptionsDialog(new JFrame(), SecurityOptions.createNoCertificateOptions());
            dlg.pack();
            dlg.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

