/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.cleaner.CleanerStatDefinition;
import com.sleepycat.je.dbi.DbiStatDefinition;
import com.sleepycat.je.evictor.Evictor;
import com.sleepycat.je.evictor.EvictorStatDefinition;
import com.sleepycat.je.incomp.INCompStatDefinition;
import com.sleepycat.je.latch.LatchStatDefinition;
import com.sleepycat.je.log.LogStatDefinition;
import com.sleepycat.je.recovery.CheckpointStatDefinition;
import com.sleepycat.je.txn.LockStatDefinition;
import com.sleepycat.je.utilint.StatGroup;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvironmentStats
implements Serializable {
    private static final long serialVersionUID = 1734048134L;
    private StatGroup incompStats;
    private StatGroup cacheStats;
    private StatGroup ckptStats;
    private StatGroup cleanerStats;
    private StatGroup logStats;
    private StatGroup lockStats;
    private StatGroup envImplStats;
    private final Map<String, String> tipsMap = new HashMap<String, String>();

    public EnvironmentStats() {
        this.incompStats = new StatGroup("Node Compression", "Removal and compression of internal btree nodes.");
        this.cacheStats = new StatGroup("Cache", "Current size, allocations, and eviction activity.");
        this.ckptStats = new StatGroup("Checkpoints", "Frequency and extent of checkpointing activity.");
        this.cleanerStats = new StatGroup("Cleaning", "Frequency and extent of log file cleaning activity.");
        this.logStats = new StatGroup("I/O", "Log file opens, fsyncs, reads, writes, cache misses.");
        this.lockStats = new StatGroup("Locks", "Locks held by data operations, latching contention on lock table.");
        this.envImplStats = new StatGroup("Environment", "General environment wide statistics.");
    }

    public static String[] getStatGroupTitles() {
        return new String[]{"I/O", "Cache", "Cleaning", "Node Compression", "Checkpoints", "Environment", "Locks"};
    }

    public void setINCompStats(StatGroup stats) {
        this.incompStats = stats;
    }

    public void setCkptStats(StatGroup stats) {
        this.ckptStats = stats;
    }

    public void setCleanerStats(StatGroup stats) {
        this.cleanerStats = stats;
    }

    public void setLogStats(StatGroup stats) {
        this.logStats = stats;
    }

    public void setMBAndEvictorStats(StatGroup clonedMBStats, StatGroup clonedEvictorStats) {
        this.cacheStats = clonedEvictorStats;
        this.cacheStats.addAll(clonedMBStats);
    }

    public void setLockStats(StatGroup stats) {
        this.lockStats = stats;
    }

    public void setEnvImplStats(StatGroup stats) {
        this.envImplStats = stats;
    }

    public long getCursorsBins() {
        return this.incompStats.getLong(INCompStatDefinition.INCOMP_CURSORS_BINS);
    }

    public long getDbClosedBins() {
        return this.incompStats.getLong(INCompStatDefinition.INCOMP_DBCLOSED_BINS);
    }

    public long getInCompQueueSize() {
        return this.incompStats.getLong(INCompStatDefinition.INCOMP_QUEUE_SIZE);
    }

    public long getNonEmptyBins() {
        return this.incompStats.getLong(INCompStatDefinition.INCOMP_NON_EMPTY_BINS);
    }

    public long getProcessedBins() {
        return this.incompStats.getLong(INCompStatDefinition.INCOMP_PROCESSED_BINS);
    }

    public long getSplitBins() {
        return this.incompStats.getLong(INCompStatDefinition.INCOMP_SPLIT_BINS);
    }

    public long getLastCheckpointId() {
        return this.ckptStats.getLong(CheckpointStatDefinition.CKPT_LAST_CKPTID);
    }

    public long getNCheckpoints() {
        return this.ckptStats.getLong(CheckpointStatDefinition.CKPT_CHECKPOINTS);
    }

    public long getNFullINFlush() {
        return this.ckptStats.getLong(CheckpointStatDefinition.CKPT_FULL_IN_FLUSH);
    }

    public long getNFullBINFlush() {
        return this.ckptStats.getLong(CheckpointStatDefinition.CKPT_FULL_BIN_FLUSH);
    }

    public long getNDeltaINFlush() {
        return this.ckptStats.getLong(CheckpointStatDefinition.CKPT_DELTA_IN_FLUSH);
    }

    public long getLastCheckpointStart() {
        return this.ckptStats.getLong(CheckpointStatDefinition.CKPT_LAST_CKPT_START);
    }

    public long getLastCheckpointEnd() {
        return this.ckptStats.getLong(CheckpointStatDefinition.CKPT_LAST_CKPT_END);
    }

    public int getCleanerBacklog() {
        return this.cleanerStats.getInt(CleanerStatDefinition.CLEANER_BACKLOG);
    }

    public int getFileDeletionBacklog() {
        return this.cleanerStats.getInt(CleanerStatDefinition.CLEANER_FILE_DELETION_BACKLOG);
    }

    public long getNCleanerRuns() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_RUNS);
    }

    public long getNCleanerDeletions() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_DELETIONS);
    }

    public long getNCleanerEntriesRead() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_ENTRIES_READ);
    }

    public long getNINsObsolete() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_INS_OBSOLETE);
    }

    public long getNINsCleaned() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_INS_CLEANED);
    }

    public long getNINsDead() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_INS_DEAD);
    }

    public long getNINsMigrated() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_INS_MIGRATED);
    }

    public long getNLNsObsolete() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_LNS_OBSOLETE);
    }

    public long getNLNsCleaned() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_LNS_CLEANED);
    }

    public long getNLNsDead() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_LNS_DEAD);
    }

    public long getNLNsLocked() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_LNS_LOCKED);
    }

    public long getNLNsMigrated() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_LNS_MIGRATED);
    }

    public long getNLNsMarked() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_LNS_MARKED);
    }

    public long getNLNQueueHits() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_LNQUEUE_HITS);
    }

    public long getNPendingLNsProcessed() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_PENDING_LNS_PROCESSED);
    }

    public long getNMarkedLNsProcessed() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_MARKED_LNS_PROCESSED);
    }

    public long getNToBeCleanedLNsProcessed() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_TO_BE_CLEANED_LNS_PROCESSED);
    }

    public long getNClusterLNsProcessed() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_CLUSTER_LNS_PROCESSED);
    }

    public long getNPendingLNsLocked() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_PENDING_LNS_LOCKED);
    }

    public long getNRepeatIteratorReads() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_REPEAT_ITERATOR_READS);
    }

    public long getTotalLogSize() {
        return this.cleanerStats.getLong(CleanerStatDefinition.CLEANER_TOTAL_LOG_SIZE);
    }

    public long getNCacheMiss() {
        return this.logStats.getLong(LogStatDefinition.LBFP_MISS);
    }

    public long getEndOfLog() {
        return this.logStats.getLong(LogStatDefinition.LOGMGR_END_OF_LOG);
    }

    public long getNFSyncs() {
        return this.logStats.getLong(LogStatDefinition.FSYNCMGR_FSYNCS);
    }

    public long getNFSyncRequests() {
        return this.logStats.getLong(LogStatDefinition.FSYNCMGR_FSYNC_REQUESTS);
    }

    public long getNFSyncTimeouts() {
        return this.logStats.getLong(LogStatDefinition.FSYNCMGR_FSYNC_TIMEOUTS);
    }

    public long getNLogFSyncs() {
        return this.logStats.getLong(LogStatDefinition.FILEMGR_LOG_FSYNCS);
    }

    public int getNLogBuffers() {
        return this.logStats.getInt(LogStatDefinition.LBFP_LOG_BUFFERS);
    }

    public long getNRandomReads() {
        return this.logStats.getLong(LogStatDefinition.FILEMGR_RANDOM_READS);
    }

    public long getNRandomReadBytes() {
        return this.logStats.getLong(LogStatDefinition.FILEMGR_RANDOM_READ_BYTES);
    }

    public long getNRandomWrites() {
        return this.logStats.getLong(LogStatDefinition.FILEMGR_RANDOM_WRITES);
    }

    public long getNRandomWriteBytes() {
        return this.logStats.getLong(LogStatDefinition.FILEMGR_RANDOM_WRITE_BYTES);
    }

    public long getNSequentialReads() {
        return this.logStats.getLong(LogStatDefinition.FILEMGR_SEQUENTIAL_READS);
    }

    public long getNSequentialReadBytes() {
        return this.logStats.getLong(LogStatDefinition.FILEMGR_SEQUENTIAL_READ_BYTES);
    }

    public long getNSequentialWrites() {
        return this.logStats.getLong(LogStatDefinition.FILEMGR_SEQUENTIAL_WRITES);
    }

    public long getNSequentialWriteBytes() {
        return this.logStats.getLong(LogStatDefinition.FILEMGR_SEQUENTIAL_WRITE_BYTES);
    }

    public long getNBytesReadFromWriteQueue() {
        return this.logStats.getLong(LogStatDefinition.FILEMGR_BYTES_READ_FROM_WRITEQUEUE);
    }

    public long getNBytesWrittenFromWriteQueue() {
        return this.logStats.getLong(LogStatDefinition.FILEMGR_BYTES_WRITTEN_FROM_WRITEQUEUE);
    }

    public long getNReadsFromWriteQueue() {
        return this.logStats.getLong(LogStatDefinition.FILEMGR_READS_FROM_WRITEQUEUE);
    }

    public long getNWritesFromWriteQueue() {
        return this.logStats.getLong(LogStatDefinition.FILEMGR_WRITES_FROM_WRITEQUEUE);
    }

    public long getNWriteQueueOverflow() {
        return this.logStats.getLong(LogStatDefinition.FILEMGR_WRITEQUEUE_OVERFLOW);
    }

    public long getNWriteQueueOverflowFailures() {
        return this.logStats.getLong(LogStatDefinition.FILEMGR_WRITEQUEUE_OVERFLOW_FAILURES);
    }

    public long getBufferBytes() {
        return this.logStats.getLong(LogStatDefinition.LBFP_BUFFER_BYTES);
    }

    public long getNNotResident() {
        return this.logStats.getLong(LogStatDefinition.LBFP_NOT_RESIDENT);
    }

    public long getNRepeatFaultReads() {
        return this.logStats.getLong(LogStatDefinition.LOGMGR_REPEAT_FAULT_READS);
    }

    public long getNTempBufferWrites() {
        return this.logStats.getLong(LogStatDefinition.LOGMGR_TEMP_BUFFER_WRITES);
    }

    public int getNFileOpens() {
        return this.logStats.getInt(LogStatDefinition.FILEMGR_FILE_OPENS);
    }

    public int getNOpenFiles() {
        return this.logStats.getInt(LogStatDefinition.FILEMGR_OPEN_FILES);
    }

    public long getNEvictPasses() {
        return this.cacheStats.getLong(EvictorStatDefinition.EVICTOR_EVICT_PASSES);
    }

    public long getNNodesExplicitlyEvicted() {
        return this.cacheStats.getLong(EvictorStatDefinition.EVICTOR_NODES_EVICTED);
    }

    public long getNRootNodesEvicted() {
        return this.cacheStats.getLong(EvictorStatDefinition.EVICTOR_ROOT_NODES_EVICTED);
    }

    public long getNBINsStripped() {
        return this.cacheStats.getLong(EvictorStatDefinition.EVICTOR_BINS_STRIPPED);
    }

    public long getRequiredEvictBytes() {
        return this.cacheStats.getLong(EvictorStatDefinition.EVICTOR_REQUIRED_EVICT_BYTES);
    }

    public long getNNodesScanned() {
        return this.cacheStats.getLong(EvictorStatDefinition.EVICTOR_NODES_SCANNED);
    }

    public long getNNodesSelected() {
        return this.cacheStats.getLong(EvictorStatDefinition.EVICTOR_NODES_SELECTED);
    }

    public int getNSharedCacheEnvironments() {
        return this.cacheStats.getInt(EvictorStatDefinition.EVICTOR_SHARED_CACHE_ENVS);
    }

    public long getNLNsFetch() {
        return this.cacheStats.getAtomicLong(EvictorStatDefinition.LN_FETCH);
    }

    public long getNUpperINsFetch() {
        return this.cacheStats.getAtomicLong(EvictorStatDefinition.UPPER_IN_FETCH);
    }

    public long getNBINsFetch() {
        return this.cacheStats.getAtomicLong(EvictorStatDefinition.BIN_FETCH);
    }

    public long getNLNsFetchMiss() {
        return this.cacheStats.getAtomicLong(EvictorStatDefinition.LN_FETCH_MISS);
    }

    public long getNUpperINsFetchMiss() {
        return this.cacheStats.getAtomicLong(EvictorStatDefinition.UPPER_IN_FETCH_MISS);
    }

    public long getNBINsFetchMiss() {
        return this.cacheStats.getAtomicLong(EvictorStatDefinition.BIN_FETCH_MISS);
    }

    public long getNCachedUpperINs() {
        return this.cacheStats.getLong(EvictorStatDefinition.CACHED_UPPER_INS);
    }

    public long getNCachedBINs() {
        return this.cacheStats.getLong(EvictorStatDefinition.CACHED_BINS);
    }

    public long getNBINsEvictedEVICTORTHREAD() {
        return this.cacheStats.getAtomicLong(Evictor.EvictionSource.EVICTORTHREAD.getBINStatDef());
    }

    public long getNBINsEvictedMANUAL() {
        return this.cacheStats.getAtomicLong(Evictor.EvictionSource.MANUAL.getBINStatDef());
    }

    public long getNBINsEvictedCRITICAL() {
        return this.cacheStats.getAtomicLong(Evictor.EvictionSource.CRITICAL.getBINStatDef());
    }

    public long getNBINsEvictedCACHEMODE() {
        return this.cacheStats.getAtomicLong(Evictor.EvictionSource.CACHEMODE.getBINStatDef());
    }

    public long getNUpperINsEvictedEVICTORTHREAD() {
        return this.cacheStats.getAtomicLong(Evictor.EvictionSource.EVICTORTHREAD.getUpperINStatDef());
    }

    public long getNUpperINsEvictedMANUAL() {
        return this.cacheStats.getAtomicLong(Evictor.EvictionSource.MANUAL.getUpperINStatDef());
    }

    public long getNUpperINsEvictedCRITICAL() {
        return this.cacheStats.getAtomicLong(Evictor.EvictionSource.CRITICAL.getUpperINStatDef());
    }

    public long getNUpperINsEvictedCACHEMODE() {
        return this.cacheStats.getAtomicLong(Evictor.EvictionSource.CACHEMODE.getUpperINStatDef());
    }

    public long getSharedCacheTotalBytes() {
        return this.cacheStats.getLong(DbiStatDefinition.MB_SHARED_CACHE_TOTAL_BYTES);
    }

    public long getCacheTotalBytes() {
        return this.cacheStats.getLong(DbiStatDefinition.MB_TOTAL_BYTES);
    }

    public long getDataBytes() {
        return this.cacheStats.getLong(DbiStatDefinition.MB_DATA_BYTES);
    }

    public long getAdminBytes() {
        return this.cacheStats.getLong(DbiStatDefinition.MB_ADMIN_BYTES);
    }

    public long getLockBytes() {
        return this.cacheStats.getLong(DbiStatDefinition.MB_LOCK_BYTES);
    }

    public long getCacheDataBytes() {
        return this.getCacheTotalBytes() - this.getBufferBytes();
    }

    public long getRelatchesRequired() {
        return this.envImplStats.getLong(DbiStatDefinition.ENVIMPL_RELATCHES_REQUIRED);
    }

    public int getNOwners() {
        return this.lockStats.getInt(LockStatDefinition.LOCK_OWNERS);
    }

    public int getNReadLocks() {
        return this.lockStats.getInt(LockStatDefinition.LOCK_READ_LOCKS);
    }

    public int getNTotalLocks() {
        return this.lockStats.getInt(LockStatDefinition.LOCK_TOTAL);
    }

    public int getNWaiters() {
        return this.lockStats.getInt(LockStatDefinition.LOCK_WAITERS);
    }

    public int getNWriteLocks() {
        return this.lockStats.getInt(LockStatDefinition.LOCK_WRITE_LOCKS);
    }

    public long getNRequests() {
        return this.lockStats.getLong(LockStatDefinition.LOCK_REQUESTS);
    }

    public long getNWaits() {
        return this.lockStats.getLong(LockStatDefinition.LOCK_WAITS);
    }

    public int getNAcquiresNoWaiters() {
        return this.lockStats.getInt(LatchStatDefinition.LATCH_NO_WAITERS);
    }

    public int getNAcquiresSelfOwned() {
        return this.lockStats.getInt(LatchStatDefinition.LATCH_SELF_OWNED);
    }

    public int getNAcquiresWithContention() {
        return this.lockStats.getInt(LatchStatDefinition.LATCH_CONTENTION);
    }

    public int getNAcquiresNoWaitSuccessful() {
        return this.lockStats.getInt(LatchStatDefinition.LATCH_NOWAIT_SUCCESS);
    }

    public int getNAcquiresNoWaitUnSuccessful() {
        return this.lockStats.getInt(LatchStatDefinition.LATCH_NOWAIT_UNSUCCESS);
    }

    public int getNReleases() {
        return this.lockStats.getInt(LatchStatDefinition.LATCH_RELEASES);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.logStats.toString());
        sb.append(this.cacheStats.toString());
        sb.append(this.cleanerStats.toString());
        sb.append(this.incompStats.toString());
        sb.append(this.ckptStats.toString());
        sb.append(this.envImplStats.toString());
        sb.append(this.lockStats.toString());
        return sb.toString();
    }

    public String toStringVerbose() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.logStats.toStringVerbose());
        sb.append(this.cacheStats.toStringVerbose());
        sb.append(this.cleanerStats.toStringVerbose());
        sb.append(this.incompStats.toStringVerbose());
        sb.append(this.ckptStats.toStringVerbose());
        sb.append(this.envImplStats.toStringVerbose());
        sb.append(this.lockStats.toStringVerbose());
        return sb.toString();
    }

    public Map<String, String> getTips() {
        this.cacheStats.addToTipMap(this.tipsMap);
        this.ckptStats.addToTipMap(this.tipsMap);
        this.cleanerStats.addToTipMap(this.tipsMap);
        this.logStats.addToTipMap(this.tipsMap);
        this.lockStats.addToTipMap(this.tipsMap);
        this.envImplStats.addToTipMap(this.tipsMap);
        return this.tipsMap;
    }
}

