/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.evictor;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.evictor.Evictor;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.utilint.StatGroup;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrivateEvictor
extends Evictor {
    private EnvironmentImpl envImpl;
    private Iterator<IN> scanIter;

    public PrivateEvictor(EnvironmentImpl envImpl, long wakeupInterval, String name) throws DatabaseException {
        super(envImpl, wakeupInterval, name);
        this.envImpl = envImpl;
        this.scanIter = null;
    }

    @Override
    public StatGroup loadStats(StatsConfig config) {
        return super.loadStats(config);
    }

    @Override
    public void onWakeup() throws DatabaseException {
        if (!this.envImpl.isClosed()) {
            super.onWakeup();
        }
    }

    @Override
    public void clearEnv() {
        this.envImpl = null;
    }

    @Override
    public void noteINListChange(int nINs) {
    }

    @Override
    public void addEnvironment(EnvironmentImpl unused) {
        throw EnvironmentFailureException.unexpectedState();
    }

    @Override
    public void removeEnvironment(EnvironmentImpl unused) {
        throw EnvironmentFailureException.unexpectedState();
    }

    @Override
    public boolean checkEnv(EnvironmentImpl env) {
        throw EnvironmentFailureException.unexpectedState();
    }

    @Override
    long startBatch() throws DatabaseException {
        if (this.scanIter == null) {
            this.scanIter = this.envImpl.getInMemoryINs().iterator();
        }
        return this.envImpl.specialEviction();
    }

    @Override
    int getMaxINsPerBatch() {
        return this.envImpl.getInMemoryINs().getSize();
    }

    @Override
    IN getNextIN() {
        if (this.envImpl.getMemoryBudget().isTreeUsageAboveMinimum()) {
            if (!this.scanIter.hasNext()) {
                this.scanIter = this.envImpl.getInMemoryINs().iterator();
            }
            return this.scanIter.hasNext() ? this.scanIter.next() : null;
        }
        return null;
    }

    @Override
    StatGroup getINListStats(StatsConfig config) {
        return this.envImpl.getInMemoryINs().loadStats();
    }

    @Override
    Iterator<IN> getScanIterator() {
        return this.scanIter;
    }

    @Override
    void setScanIterator(Iterator<IN> iter) {
        this.scanIter = iter;
    }
}

