/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.elections;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.rep.elections.Proposer;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;

public class TimebasedProposalGenerator {
    private final int locallyUniqueId;
    static int uniqueIdGenerator = 1;
    private long prevProposalTime = System.currentTimeMillis();
    private String machineId;
    static final int TIME_WIDTH = 16;
    static final int ADDRESS_WIDTH = 32;
    static final int UID_WIDTH = 8;

    TimebasedProposalGenerator(int locallyUniqueId) {
        this.locallyUniqueId = locallyUniqueId;
        try {
            byte[] localAddress = InetAddress.getLocalHost().getAddress();
            if (InetAddress.getLocalHost().isLoopbackAddress()) {
                localAddress = null;
                try {
                    Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                    block4: while (interfaces.hasMoreElements()) {
                        Enumeration<InetAddress> addresses = interfaces.nextElement().getInetAddresses();
                        while (addresses.hasMoreElements()) {
                            InetAddress ia = addresses.nextElement();
                            if (ia.isLoopbackAddress() || ia.isAnyLocalAddress() || ia.isMulticastAddress()) continue;
                            localAddress = ia.getAddress();
                            continue block4;
                        }
                    }
                }
                catch (SocketException e) {
                    // empty catch block
                }
                if (localAddress == null) {
                    throw EnvironmentFailureException.unexpectedState("java.net.InetAddress.getLocalHost() returned loopback address: " + InetAddress.getLocalHost() + " and no suitable adddress associated " + " with network interfaces.");
                }
            }
            this.machineId = "";
            for (byte b : localAddress) {
                this.machineId = this.machineId + String.format("%02x", b);
            }
            String pad = "000000000000000000000000000000";
            this.machineId = pad.substring(0, 32 - this.machineId.length()) + this.machineId;
        }
        catch (UnknownHostException e) {
            throw EnvironmentFailureException.unexpectedException(e);
        }
    }

    public TimebasedProposalGenerator() {
        this(uniqueIdGenerator++);
    }

    public synchronized Proposer.Proposal nextProposal() {
        long proposalTime = System.currentTimeMillis();
        if (proposalTime <= this.prevProposalTime) {
            proposalTime = ++this.prevProposalTime;
        }
        this.prevProposalTime = proposalTime;
        return new StringProposal(String.format("%016x%s%08x", proposalTime, this.machineId, this.locallyUniqueId));
    }

    public static Proposer.ProposalParser getParser() {
        return StringProposal.getParser();
    }

    private static class StringProposal
    implements Proposer.Proposal {
        private final String proposal;
        private static Proposer.ProposalParser theParser = new Proposer.ProposalParser(){

            public Proposer.Proposal parse(String wireFormat) {
                return wireFormat == null || "".equals(wireFormat) ? null : new StringProposal(wireFormat);
            }
        };

        StringProposal(String proposal) {
            assert (proposal != null);
            this.proposal = proposal;
        }

        public String wireFormat() {
            return this.proposal;
        }

        public int compareTo(Proposer.Proposal otherProposal) {
            return this.proposal.compareTo(((StringProposal)otherProposal).proposal);
        }

        public String toString() {
            return "Proposal(" + this.proposal.substring(0, 16) + ":" + this.proposal.substring(16, 48) + ":" + this.proposal.substring(48) + ")";
        }

        private static Proposer.ProposalParser getParser() {
            return theParser;
        }

        public int hashCode() {
            return this.proposal == null ? 0 : this.proposal.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof StringProposal)) {
                return false;
            }
            StringProposal other = (StringProposal)obj;
            return !(this.proposal == null ? other.proposal != null : !this.proposal.equals(other.proposal));
        }
    }
}

