/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.cleaner.LocalUtilizationTracker;
import com.sleepycat.je.cleaner.PackedObsoleteInfo;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.INList;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.evictor.Evictor;
import com.sleepycat.je.latch.SharedLatch;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.Loggable;
import com.sleepycat.je.log.Provisional;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.log.entry.INLogEntry;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.BINReference;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.Generation;
import com.sleepycat.je.tree.INLogContext;
import com.sleepycat.je.tree.INLogItem;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.SearchResult;
import com.sleepycat.je.tree.TrackingInfo;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.tree.TreeUtils;
import com.sleepycat.je.tree.TreeWalkerStatsAccumulator;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.RelatchRequiredException;
import java.io.FileNotFoundException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IN
extends Node
implements Comparable<IN>,
Loggable {
    private static final String BEGIN_TAG = "<in>";
    private static final String END_TAG = "</in>";
    private static final String TRACE_SPLIT = "Split:";
    private static final String TRACE_DELETE = "Delete:";
    private static final byte KNOWN_DELETED_BIT = 1;
    private static final byte CLEAR_KNOWN_DELETED_BIT = -2;
    private static final byte DIRTY_BIT = 2;
    private static final byte CLEAR_DIRTY_BIT = -3;
    private static final byte MIGRATE_BIT = 4;
    private static final byte CLEAR_MIGRATE_BIT = -5;
    private static final byte PENDING_DELETED_BIT = 8;
    private static final byte CLEAR_PENDING_DELETED_BIT = -9;
    private static final int BYTES_PER_LSN_ENTRY = 4;
    private static final int MAX_FILE_OFFSET = 0xFFFFFE;
    private static final int THREE_BYTE_NEGATIVE_ONE = 0xFFFFFF;
    private static final int GROWTH_INCREMENT = 5;
    public static final int DBMAP_LEVEL = 131072;
    public static final int MAIN_LEVEL = 65536;
    public static final int LEVEL_MASK = 65535;
    public static final int MIN_LEVEL = -1;
    public static final int MAX_LEVEL = Integer.MAX_VALUE;
    public static final int BIN_LEVEL = 65537;
    public static final int MAY_NOT_EVICT = 0;
    public static final int MAY_EVICT_LNS = 1;
    public static final int MAY_EVICT_NODE = 2;
    private static final int IN_DIRTY_BIT = 1;
    private static final int IN_RECALC_TOGGLE_BIT = 2;
    private static final int IN_IS_ROOT_BIT = 4;
    private int flags;
    protected SharedLatch latch;
    private long generation;
    private int nEntries;
    private byte[] identifierKey;
    private Node[] entryTargets;
    private byte[][] entryKeyVals;
    private byte[] keyPrefix;
    private long baseFileNumber;
    private byte[] entryLsnByteArray;
    private long[] entryLsnLongArray;
    private byte[] entryStates;
    DatabaseImpl databaseImpl;
    private int level;
    private long inMemorySize;
    private boolean inListResident;
    private long lastFullVersion = -1L;
    private PackedObsoleteInfo provisionalObsolete;
    public static final int EXACT_MATCH = 65536;
    public static final int INSERT_SUCCESS = 131072;
    private int accumulatedDelta = 0;
    public static int ACCUMULATED_LIMIT = 1000;

    public IN() {
        this.init(null, Key.EMPTY_KEY, 0, 0);
    }

    public IN(DatabaseImpl dbImpl, byte[] identifierKey, int capacity, int level) {
        super(dbImpl.getDbEnvironment(), false);
        this.init(dbImpl, identifierKey, capacity, this.generateLevel(dbImpl.getId(), level));
        this.initMemorySize();
    }

    protected void init(DatabaseImpl db, byte[] identifierKey, int initialCapacity, int level) {
        this.setDatabase(db);
        this.latch = new SharedLatch(this.shortClassName() + this.getNodeId());
        this.latch.setExclusiveOnly(EnvironmentImpl.getSharedLatches() ? this.isAlwaysLatchedExclusively() : true);
        assert (this.latch.setNoteLatch(true));
        this.generation = 0L;
        this.flags = 0;
        this.nEntries = 0;
        this.identifierKey = identifierKey;
        this.entryTargets = new Node[initialCapacity];
        this.entryKeyVals = new byte[initialCapacity][];
        this.keyPrefix = null;
        this.baseFileNumber = -1L;
        this.entryLsnByteArray = new byte[initialCapacity << 2];
        this.entryLsnLongArray = null;
        this.entryStates = new byte[initialCapacity];
        this.level = level;
        this.inListResident = false;
    }

    protected void initMemorySize() {
        this.inMemorySize = this.computeMemorySize();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IN)) {
            return false;
        }
        IN in = (IN)obj;
        return this.getNodeId() == in.getNodeId();
    }

    public int hashCode() {
        return (int)(this.getNodeId() ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public int compareTo(IN argIN) {
        long argNodeId = argIN.getNodeId();
        long myNodeId = this.getNodeId();
        if (myNodeId < argNodeId) {
            return -1;
        }
        if (myNodeId > argNodeId) {
            return 1;
        }
        return 0;
    }

    protected IN createNewInstance(byte[] identifierKey, int maxEntries, int level) {
        return new IN(this.databaseImpl, identifierKey, maxEntries, level);
    }

    boolean isAlwaysLatchedExclusively() {
        return false;
    }

    @Override
    public void postFetchInit(DatabaseImpl db, long sourceLsn) {
        this.setDatabase(db);
        this.setLastFullLsn(sourceLsn);
        EnvironmentImpl env = db.getDbEnvironment();
        this.initMemorySize();
        env.getInMemoryINs().add(this);
    }

    public void postRecoveryInit(DatabaseImpl db, long sourceLsn) {
        this.setDatabase(db);
        this.setLastFullLsn(sourceLsn);
        this.initMemorySize();
    }

    void setLastFullLsn(long lsn) {
        this.lastFullVersion = lsn;
    }

    public long getLastFullVersion() {
        return this.lastFullVersion;
    }

    public void latch(CacheMode cacheMode) throws DatabaseException {
        this.setGeneration(cacheMode);
        this.latch.acquireExclusive();
    }

    @Override
    public void latchShared(CacheMode cacheMode) throws DatabaseException {
        this.setGeneration(cacheMode);
        this.latch.acquireShared();
    }

    public boolean latchNoWait(CacheMode cacheMode) throws DatabaseException {
        if (this.latch.acquireExclusiveNoWait()) {
            this.setGeneration(cacheMode);
            return true;
        }
        return false;
    }

    public void latch() throws DatabaseException {
        this.latch(CacheMode.DEFAULT);
    }

    @Override
    public void latchShared() throws DatabaseException {
        this.latchShared(CacheMode.DEFAULT);
    }

    public boolean latchNoWait() throws DatabaseException {
        return this.latchNoWait(CacheMode.DEFAULT);
    }

    @Override
    public void releaseLatch() {
        this.latch.release();
    }

    public void releaseLatchIfOwner() {
        this.latch.releaseIfOwner();
    }

    public boolean isLatchOwnerForRead() {
        return this.latch.isOwner();
    }

    public boolean isLatchOwnerForWrite() {
        return this.latch.isWriteLockedByCurrentThread();
    }

    public long getGeneration() {
        return this.generation;
    }

    public void setGeneration(CacheMode cacheMode) {
        switch (cacheMode) {
            case DEFAULT: {
                this.generation = Generation.getNextGeneration();
                break;
            }
            case UNCHANGED: {
                break;
            }
            case KEEP_HOT: {
                this.generation = Long.MAX_VALUE;
                break;
            }
            case MAKE_COLD: 
            case EVICT_LN: 
            case EVICT_BIN: {
                if (!this.isBottomMostNode()) break;
                this.generation = 0L;
                break;
            }
            default: {
                throw EnvironmentFailureException.unexpectedState("unknown cacheMode: " + (Object)((Object)cacheMode));
            }
        }
    }

    public void setGeneration(long newGeneration) {
        this.generation = newGeneration;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    boolean isBottomMostNode() {
        return false;
    }

    protected int generateLevel(DatabaseId dbId, int newLevel) {
        if (dbId.equals(DbTree.ID_DB_ID)) {
            return newLevel | 0x20000;
        }
        return newLevel | 0x10000;
    }

    void setKeyPrefix(byte[] keyPrefix) {
        assert (this.databaseImpl != null);
        this.keyPrefix = keyPrefix;
    }

    byte[] getKeyPrefix() {
        return this.keyPrefix;
    }

    public boolean getDirty() {
        return (this.flags & 1) != 0;
    }

    public void setDirty(boolean dirty) {
        this.flags = dirty ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
    }

    public boolean getRecalcToggle() {
        return (this.flags & 2) != 0;
    }

    public void setRecalcToggle(boolean toggle) {
        this.flags = toggle ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    public boolean isRoot() {
        return (this.flags & 4) != 0;
    }

    public boolean isDbRoot() {
        return (this.flags & 4) != 0;
    }

    void setIsRoot(boolean isRoot) {
        this.setIsRootFlag(isRoot);
        this.setDirty(true);
    }

    private void setIsRootFlag(boolean isRoot) {
        this.flags = isRoot ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
    }

    public byte[] getIdentifierKey() {
        return this.identifierKey;
    }

    void setIdentifierKey(byte[] key) {
        this.identifierKey = key;
        this.setDirty(true);
    }

    public byte[] getChildKey(IN child) {
        return child.getIdentifierKey();
    }

    public byte[] selectKey(byte[] mainTreeKey, byte[] dupTreeKey) {
        return mainTreeKey;
    }

    public byte[] getDupKey() {
        throw EnvironmentFailureException.unexpectedState(this.shortClassName() + ".getDupKey() called");
    }

    public byte[] getDupTreeKey() {
        return null;
    }

    public byte[] getMainTreeKey() {
        return this.getIdentifierKey();
    }

    public DatabaseImpl getDatabase() {
        return this.databaseImpl;
    }

    public void setDatabase(DatabaseImpl db) {
        this.databaseImpl = db;
    }

    public DatabaseId getDatabaseId() {
        return this.databaseImpl.getId();
    }

    private void copyEntries(int from, int to, int n) {
        System.arraycopy(this.entryTargets, from, this.entryTargets, to, n);
        System.arraycopy(this.entryKeyVals, from, this.entryKeyVals, to, n);
        System.arraycopy(this.entryStates, from, this.entryStates, to, n);
        if (this.entryLsnLongArray == null) {
            int fromOff = from << 2;
            int toOff = to << 2;
            int nBytes = n << 2;
            System.arraycopy(this.entryLsnByteArray, fromOff, this.entryLsnByteArray, toOff, nBytes);
        } else {
            System.arraycopy(this.entryLsnLongArray, from, this.entryLsnLongArray, to, n);
        }
    }

    private void clearEntry(int idx) {
        this.entryTargets[idx] = null;
        this.entryKeyVals[idx] = null;
        this.setLsnElement(idx, -1L);
        this.entryStates[idx] = 0;
    }

    public byte[] getKey(int idx) {
        if (this.keyPrefix != null) {
            int prefixLen = this.keyPrefix.length;
            byte[] suffix = this.entryKeyVals[idx];
            if (prefixLen == 0) {
                return suffix;
            }
            int suffixLen = suffix == null ? 0 : suffix.length;
            byte[] ret = new byte[prefixLen + suffixLen];
            if (this.keyPrefix != null) {
                System.arraycopy(this.keyPrefix, 0, ret, 0, prefixLen);
            }
            if (suffix != null) {
                System.arraycopy(suffix, 0, ret, prefixLen, suffixLen);
            }
            return ret;
        }
        return this.entryKeyVals[idx];
    }

    private boolean setKeyAndDirty(int idx, byte[] keyVal) {
        int n = idx;
        this.entryStates[n] = (byte)(this.entryStates[n] | 2);
        return this.setKeyAndPrefix(idx, keyVal);
    }

    private boolean setKeyAndPrefix(int idx, byte[] keyVal) {
        assert (this.databaseImpl != null);
        if (this.databaseImpl.getKeyPrefixing() && this.keyPrefix != null) {
            if (!this.compareToKeyPrefix(keyVal)) {
                byte[] newPrefix = this.computeKeyPrefix(idx);
                if (newPrefix != null) {
                    newPrefix = Key.createKeyPrefix(newPrefix, keyVal);
                }
                this.recalcSuffixes(newPrefix, keyVal, idx);
                return true;
            }
            this.entryKeyVals[idx] = this.computeKeySuffix(this.keyPrefix, keyVal);
            return false;
        }
        if (this.keyPrefix != null) {
            this.recalcSuffixes(new byte[0], keyVal, idx);
        } else {
            this.entryKeyVals[idx] = keyVal;
        }
        return false;
    }

    private void recalcSuffixes(byte[] newPrefix, byte[] keyVal, int idx) {
        for (int i = 0; i < this.nEntries; ++i) {
            byte[] curKey = i == idx ? keyVal : this.getKey(i);
            this.entryKeyVals[i] = this.computeKeySuffix(newPrefix, curKey);
        }
        this.setKeyPrefix(newPrefix);
    }

    boolean compareToKeyPrefix(byte[] newKey) {
        if (this.keyPrefix == null || this.keyPrefix.length == 0) {
            return false;
        }
        int newKeyLen = newKey.length;
        for (int i = 0; i < this.keyPrefix.length; ++i) {
            if (i < newKeyLen && this.keyPrefix[i] == newKey[i]) continue;
            return false;
        }
        return true;
    }

    private byte[] computeKeyPrefix(int excludeIdx) {
        if (!this.databaseImpl.getKeyPrefixing() || this.nEntries == 0) {
            return null;
        }
        int startIdx = 1;
        byte[] curPrefixKey = null;
        if (excludeIdx == 0) {
            startIdx = 2;
            curPrefixKey = this.getKey(1);
        } else {
            curPrefixKey = this.getKey(0);
        }
        int prefixLen = curPrefixKey.length;
        for (int i = startIdx; i < this.nEntries; ++i) {
            byte[] curKey = this.getKey(i);
            if (curPrefixKey == null || curKey == null) {
                return null;
            }
            int newPrefixLen = Key.getKeyPrefixLength(curPrefixKey, prefixLen, curKey);
            if (newPrefixLen >= prefixLen) continue;
            curPrefixKey = curKey;
            prefixLen = newPrefixLen;
        }
        byte[] ret = new byte[prefixLen];
        System.arraycopy(curPrefixKey, 0, ret, 0, prefixLen);
        return ret;
    }

    private byte[] computeKeySuffix(byte[] newPrefix, byte[] keyVal) {
        int prefixLen;
        int n = prefixLen = newPrefix == null ? 0 : newPrefix.length;
        if (prefixLen == 0) {
            return keyVal;
        }
        int suffixLen = keyVal.length - prefixLen;
        byte[] ret = new byte[suffixLen];
        System.arraycopy(keyVal, prefixLen, ret, 0, suffixLen);
        return ret;
    }

    boolean verifyKeyPrefix() {
        byte[] computedKeyPrefix = this.computeKeyPrefix(-1);
        if (this.keyPrefix == null) {
            return computedKeyPrefix == null;
        }
        if (computedKeyPrefix == null || computedKeyPrefix.length < this.keyPrefix.length) {
            System.out.println("VerifyKeyPrefix failed");
            System.out.println(this.dumpString(0, false));
            return false;
        }
        for (int i = 0; i < this.keyPrefix.length; ++i) {
            if (this.keyPrefix[i] == computedKeyPrefix[i]) continue;
            System.out.println("VerifyKeyPrefix failed");
            System.out.println(this.dumpString(0, false));
            return false;
        }
        return true;
    }

    public boolean getMigrate(int idx) {
        return (this.entryStates[idx] & 4) != 0;
    }

    public void setMigrate(int idx, boolean migrate) {
        if (migrate) {
            int n = idx;
            this.entryStates[n] = (byte)(this.entryStates[n] | 4);
        } else {
            int n = idx;
            this.entryStates[n] = (byte)(this.entryStates[n] & 0xFFFFFFFB);
        }
    }

    public byte getState(int idx) {
        return this.entryStates[idx];
    }

    public Node getTarget(int idx) {
        return this.entryTargets[idx];
    }

    void setTarget(int idx, Node target) {
        assert (this.isLatchOwnerForWrite()) : "Not latched for write " + this.getClass().getName() + " id=" + this.getNodeId();
        this.entryTargets[idx] = target;
    }

    public long getLsn(int idx) {
        if (this.entryLsnLongArray == null) {
            int offset = idx << 2;
            int fileOffset = this.getFileOffset(offset);
            if (fileOffset == -1) {
                return -1L;
            }
            return DbLsn.makeLsn(this.baseFileNumber + (long)this.getFileNumberOffset(offset), fileOffset);
        }
        return this.entryLsnLongArray[idx];
    }

    private void setLsn(int idx, long lsn) {
        int oldSize = this.computeLsnOverhead();
        this.setLsnElement(idx, lsn);
        this.changeMemorySize(this.computeLsnOverhead() - oldSize);
        int n = idx;
        this.entryStates[n] = (byte)(this.entryStates[n] | 2);
    }

    long[] getEntryLsnLongArray() {
        return this.entryLsnLongArray;
    }

    byte[] getEntryLsnByteArray() {
        return this.entryLsnByteArray;
    }

    void initEntryLsn(int capacity) {
        this.entryLsnLongArray = null;
        this.entryLsnByteArray = new byte[capacity << 2];
        this.baseFileNumber = -1L;
    }

    void setLsnElement(int idx, long value) {
        int offset = idx << 2;
        if (this.entryLsnLongArray != null) {
            this.entryLsnLongArray[idx] = value;
            return;
        }
        if (value == -1L) {
            this.setFileNumberOffset(offset, (byte)0);
            this.setFileOffset(offset, -1);
            return;
        }
        long thisFileNumber = DbLsn.getFileNumber(value);
        if (this.baseFileNumber == -1L) {
            this.baseFileNumber = thisFileNumber;
            this.setFileNumberOffset(offset, (byte)0);
        } else {
            long fileNumberDifference;
            if (thisFileNumber < this.baseFileNumber) {
                if (!this.adjustFileNumbers(thisFileNumber)) {
                    this.mutateToLongArray(idx, value);
                    return;
                }
                this.baseFileNumber = thisFileNumber;
            }
            if ((fileNumberDifference = thisFileNumber - this.baseFileNumber) > 127L) {
                this.mutateToLongArray(idx, value);
                return;
            }
            this.setFileNumberOffset(offset, (byte)(thisFileNumber - this.baseFileNumber));
        }
        int fileOffset = (int)DbLsn.getFileOffset(value);
        if (fileOffset > 0xFFFFFE) {
            this.mutateToLongArray(idx, value);
            return;
        }
        this.setFileOffset(offset, fileOffset);
    }

    private void mutateToLongArray(int idx, long value) {
        int nElts = this.entryLsnByteArray.length >> 2;
        long[] newArr = new long[nElts];
        for (int i = 0; i < nElts; ++i) {
            newArr[i] = this.getLsn(i);
        }
        newArr[idx] = value;
        this.entryLsnLongArray = newArr;
        this.entryLsnByteArray = null;
    }

    private boolean adjustFileNumbers(long newBaseFileNumber) {
        long oldBaseFileNumber = this.baseFileNumber;
        for (int i = 0; i < this.entryLsnByteArray.length; i += 4) {
            if (this.getFileOffset(i) == -1) continue;
            long curEntryFileNumber = oldBaseFileNumber + (long)this.getFileNumberOffset(i);
            long newCurEntryFileNumberOffset = curEntryFileNumber - newBaseFileNumber;
            if (newCurEntryFileNumberOffset > 127L) {
                long undoOffset = oldBaseFileNumber - newBaseFileNumber;
                for (int j = i - 4; j >= 0; j -= 4) {
                    if (this.getFileOffset(j) == -1) continue;
                    this.setFileNumberOffset(j, (byte)((long)this.getFileNumberOffset(j) - undoOffset));
                }
                return false;
            }
            this.setFileNumberOffset(i, (byte)newCurEntryFileNumberOffset);
        }
        return true;
    }

    private void setFileNumberOffset(int offset, byte fileNumberOffset) {
        this.entryLsnByteArray[offset] = fileNumberOffset;
    }

    private byte getFileNumberOffset(int offset) {
        return this.entryLsnByteArray[offset];
    }

    private void setFileOffset(int offset, int fileOffset) {
        this.put3ByteInt(offset + 1, fileOffset);
    }

    private int getFileOffset(int offset) {
        return this.get3ByteInt(offset + 1);
    }

    private void put3ByteInt(int offset, int value) {
        this.entryLsnByteArray[offset++] = (byte)(value >>> 0);
        this.entryLsnByteArray[offset++] = (byte)(value >>> 8);
        this.entryLsnByteArray[offset] = (byte)(value >>> 16);
    }

    private int get3ByteInt(int offset) {
        int ret = (this.entryLsnByteArray[offset++] & 0xFF) << 0;
        ret += (this.entryLsnByteArray[offset++] & 0xFF) << 8;
        if ((ret += (this.entryLsnByteArray[offset] & 0xFF) << 16) == 0xFFFFFF) {
            ret = -1;
        }
        return ret;
    }

    public boolean isEntryPendingDeleted(int idx) {
        return (this.entryStates[idx] & 8) != 0;
    }

    public void setPendingDeleted(int idx) {
        int n = idx;
        this.entryStates[n] = (byte)(this.entryStates[n] | 8);
        int n2 = idx;
        this.entryStates[n2] = (byte)(this.entryStates[n2] | 2);
    }

    public void clearPendingDeleted(int idx) {
        int n = idx;
        this.entryStates[n] = (byte)(this.entryStates[n] & 0xFFFFFFF7);
        int n2 = idx;
        this.entryStates[n2] = (byte)(this.entryStates[n2] | 2);
    }

    public boolean isEntryKnownDeleted(int idx) {
        return (this.entryStates[idx] & 1) != 0;
    }

    void setKnownDeleted(int idx) {
        int n = idx;
        this.entryStates[n] = (byte)(this.entryStates[n] | 1);
        int n2 = idx;
        this.entryStates[n2] = (byte)(this.entryStates[n2] | 2);
    }

    void clearKnownDeleted(int idx) {
        int n = idx;
        this.entryStates[n] = (byte)(this.entryStates[n] & 0xFFFFFFFE);
        int n2 = idx;
        this.entryStates[n2] = (byte)(this.entryStates[n2] | 2);
    }

    boolean isDirty(int idx) {
        return (this.entryStates[idx] & 2) != 0;
    }

    public int getNEntries() {
        return this.nEntries;
    }

    static boolean isStateKnownDeleted(byte state) {
        return (state & 1) != 0;
    }

    static boolean isStatePendingDeleted(byte state) {
        return (state & 8) != 0;
    }

    int getMaxEntries() {
        return this.entryTargets.length;
    }

    public final Node fetchTargetWithExclusiveLatch(int idx) throws DatabaseException {
        try {
            return this.fetchTarget(idx);
        }
        catch (RelatchRequiredException e) {
            throw EnvironmentFailureException.unexpectedException(e);
        }
    }

    public Node fetchTarget(int idx) throws RelatchRequiredException, DatabaseException {
        EnvironmentImpl envImpl = this.databaseImpl.getDbEnvironment();
        boolean isMiss = false;
        if (this.entryTargets[idx] == null) {
            long lsn = this.getLsn(idx);
            if (lsn == -1L) {
                if (!this.isEntryKnownDeleted(idx)) {
                    throw EnvironmentFailureException.unexpectedState(IN.makeFetchErrorMsg("NULL_LSN without KnownDeleted", this, lsn, this.entryStates[idx]));
                }
            } else {
                if (!this.isLatchOwnerForWrite()) {
                    throw RelatchRequiredException.relatchRequiredException;
                }
                try {
                    LogEntry logEntry = envImpl.getLogManager().getLogEntryAllowInvisibleAtRecovery(lsn);
                    Node node = (Node)logEntry.getMainItem();
                    node.postFetchInit(this.databaseImpl, lsn);
                    byte[] lnSlotKey = null;
                    if (logEntry instanceof LNLogEntry) {
                        LNLogEntry lnEntry = (LNLogEntry)logEntry;
                        lnSlotKey = this.containsDuplicates() ? lnEntry.getDupKey() : lnEntry.getKey();
                    }
                    this.updateNode(idx, node, lnSlotKey);
                    isMiss = true;
                }
                catch (FileNotFoundException e) {
                    if (!this.isEntryKnownDeleted(idx) && !this.isEntryPendingDeleted(idx)) {
                        throw new EnvironmentFailureException(envImpl, EnvironmentFailureReason.LOG_FILE_NOT_FOUND, IN.makeFetchErrorMsg(null, this, lsn, this.entryStates[idx]), e);
                    }
                }
                catch (EnvironmentFailureException e) {
                    e.addErrorMessage(IN.makeFetchErrorMsg(null, this, lsn, this.entryStates[idx]));
                    throw e;
                }
                catch (RuntimeException e) {
                    throw new EnvironmentFailureException(envImpl, EnvironmentFailureReason.LOG_INTEGRITY, IN.makeFetchErrorMsg(e.toString(), this, lsn, this.entryStates[idx]), e);
                }
            }
        }
        if (this.entryTargets[idx] != null) {
            this.entryTargets[idx].incFetchStats(envImpl, isMiss);
        }
        return this.entryTargets[idx];
    }

    static String makeFetchErrorMsg(String msg, IN in, long lsn, byte state) {
        StringBuffer sb = new StringBuffer();
        sb.append("fetchTarget of ");
        if (lsn == -1L) {
            sb.append("null lsn");
        } else {
            sb.append(DbLsn.getNoFormatString(lsn));
        }
        if (in != null) {
            sb.append(" parent IN=").append(in.getNodeId());
            sb.append(" IN class=").append(in.getClass().getName());
            sb.append(" lastFullVersion=");
            sb.append(DbLsn.getNoFormatString(in.getLastFullVersion()));
            sb.append(" parent.getDirty()=").append(in.getDirty());
        }
        sb.append(" state=").append(state);
        if (msg != null) {
            sb.append(" ").append(msg);
        }
        return sb.toString();
    }

    public void setEntry(int idx, Node target, byte[] keyVal, long lsn, byte state) {
        long oldSize = this.computeLsnOverhead();
        int newNEntries = idx + 1;
        if (newNEntries > this.nEntries) {
            this.nEntries = newNEntries;
        } else {
            oldSize += this.getEntryInMemorySize(idx);
        }
        this.entryTargets[idx] = target;
        this.setKeyAndPrefix(idx, keyVal);
        this.setLsnElement(idx, lsn);
        this.entryStates[idx] = state;
        long newSize = this.getEntryInMemorySize(idx) + (long)this.computeLsnOverhead();
        this.updateMemorySize(oldSize, newSize);
        this.setDirty(true);
    }

    public void clearLsn(int idx) {
        assert (this.getDatabase().isTemporary());
        this.setLsn(idx, -1L);
    }

    public void updateNode(int idx, Node node, long oldSize, long lsn, byte[] lnSlotKey) {
        long newSize = node.getMemorySizeIncludedByParent();
        boolean suffixesChanged = this.setLNSlotKey(idx, node, lnSlotKey);
        if (suffixesChanged) {
            long curInMemorySize = this.inMemorySize;
            this.updateMemorySize(curInMemorySize, this.computeMemorySize());
        }
        if (this.notOverwritingDeferredWriteEntry(lsn)) {
            this.setLsn(idx, lsn);
        }
        if (!suffixesChanged) {
            this.updateMemorySize(oldSize, newSize);
        }
        this.setDirty(true);
    }

    public void updateNode(int idx, Node node, byte[] lnSlotKey) {
        long oldSize = this.getEntryInMemorySize(idx);
        this.setTarget(idx, node);
        this.setLNSlotKey(idx, node, lnSlotKey);
        long newSize = this.getEntryInMemorySize(idx);
        this.updateMemorySize(oldSize, newSize);
    }

    public void updateNode(int idx, Node node, long lsn, byte[] lnSlotKey) {
        long oldSize = this.getEntryInMemorySize(idx);
        if (this.notOverwritingDeferredWriteEntry(lsn)) {
            this.setLsn(idx, lsn);
        }
        this.setTarget(idx, node);
        this.setLNSlotKey(idx, node, lnSlotKey);
        long newSize = this.getEntryInMemorySize(idx);
        this.updateMemorySize(oldSize, newSize);
        this.setDirty(true);
    }

    private boolean setLNSlotKey(int idx, Node node, byte[] newKey) {
        assert (newKey == null || node instanceof LN);
        if (newKey != null && this.getKeyComparator() != null && !Arrays.equals(newKey, this.getKey(idx))) {
            this.setKeyAndDirty(idx, newKey);
            this.setDirty(true);
            return true;
        }
        return false;
    }

    public void updateEntry(int idx, Node node, long lsn, byte[] key) {
        long oldSize = this.getEntryInMemorySize(idx);
        if (this.notOverwritingDeferredWriteEntry(lsn)) {
            this.setLsn(idx, lsn);
        }
        this.setTarget(idx, node);
        boolean suffixesChanged = this.setKeyAndDirty(idx, key);
        if (suffixesChanged) {
            long curInMemorySize = this.inMemorySize;
            this.updateMemorySize(curInMemorySize, this.computeMemorySize());
        } else {
            long newSize = this.getEntryInMemorySize(idx);
            this.updateMemorySize(oldSize, newSize);
        }
        this.setDirty(true);
    }

    public void updateEntry(int idx, long lsn) {
        if (this.notOverwritingDeferredWriteEntry(lsn)) {
            this.setLsn(idx, lsn);
        }
        this.setDirty(true);
    }

    public void updateEntry(int idx, long lsn, byte state) {
        if (this.notOverwritingDeferredWriteEntry(lsn)) {
            this.setLsn(idx, lsn);
        }
        this.entryStates[idx] = state;
        this.setDirty(true);
    }

    private void updateEntryCompareKey(int idx, Node node, long lsn, byte[] key) {
        long oldSize = this.getEntryInMemorySize(idx);
        if (this.notOverwritingDeferredWriteEntry(lsn)) {
            this.setLsn(idx, lsn);
        }
        this.setTarget(idx, node);
        byte[] existingKey = this.getKey(idx);
        int s = Key.compareKeys(key, existingKey, this.getKeyComparator());
        boolean suffixesChanged = false;
        if (s < 0) {
            suffixesChanged = this.setKeyAndDirty(idx, key);
        }
        if (suffixesChanged) {
            long curInMemorySize = this.inMemorySize;
            this.updateMemorySize(curInMemorySize, this.computeMemorySize());
        } else {
            long newSize = this.getEntryInMemorySize(idx);
            this.updateMemorySize(oldSize, newSize);
        }
        this.setDirty(true);
    }

    boolean notOverwritingDeferredWriteEntry(long newLsn) {
        return !this.databaseImpl.isDeferredWriteMode() || newLsn != -1L;
    }

    public boolean verifyMemorySize() {
        long calcMemorySize = this.computeMemorySize();
        if (calcMemorySize != this.inMemorySize) {
            String msg = "-Warning: Out of sync. Should be " + calcMemorySize + " / actual: " + this.inMemorySize + " node: " + this.getNodeId();
            LoggerUtils.envLogMsg(Level.INFO, this.databaseImpl.getDbEnvironment(), msg);
            System.out.println(msg);
            return false;
        }
        return true;
    }

    public long getBudgetedMemorySize() {
        return this.inMemorySize - (long)this.accumulatedDelta;
    }

    public long resetAndGetMemorySize() {
        this.accumulatedDelta = 0;
        return this.inMemorySize;
    }

    public long getTreeAdminMemorySize() {
        return 0L;
    }

    public long getInMemorySize() {
        return this.inMemorySize;
    }

    private long getEntryInMemorySize(int idx) {
        return this.getEntryInMemorySize(this.entryKeyVals[idx], this.entryTargets[idx]);
    }

    protected long getEntryInMemorySize(byte[] key, Node target) {
        long ret = 0L;
        if (key != null) {
            ret += (long)MemoryBudget.byteArraySize(key.length);
        }
        if (target != null) {
            ret += target.getMemorySizeIncludedByParent();
        }
        return ret;
    }

    protected long computeMemorySize() {
        MemoryBudget mb = this.databaseImpl.getDbEnvironment().getMemoryBudget();
        long calcMemorySize = this.getMemoryOverhead(mb);
        calcMemorySize += (long)this.computeLsnOverhead();
        for (int i = 0; i < this.nEntries; ++i) {
            calcMemorySize += this.getEntryInMemorySize(i);
        }
        if (this.keyPrefix != null) {
            calcMemorySize += (long)MemoryBudget.byteArraySize(this.keyPrefix.length);
        }
        if (this.provisionalObsolete != null) {
            calcMemorySize += (long)this.provisionalObsolete.getMemorySize();
        }
        return calcMemorySize;
    }

    public static long computeOverhead(DbConfigManager configManager) {
        return (long)MemoryBudget.IN_FIXED_OVERHEAD + IN.computeArraysOverhead(configManager);
    }

    private int computeLsnOverhead() {
        if (this.entryLsnLongArray == null) {
            return MemoryBudget.byteArraySize(this.entryLsnByteArray.length);
        }
        return MemoryBudget.ARRAY_OVERHEAD + this.entryLsnLongArray.length * 8;
    }

    protected static long computeArraysOverhead(DbConfigManager configManager) {
        int capacity = configManager.getInt(EnvironmentParams.NODE_MAX);
        return MemoryBudget.byteArraySize(capacity) + capacity * (2 * MemoryBudget.OBJECT_ARRAY_ITEM_OVERHEAD);
    }

    protected long getMemoryOverhead(MemoryBudget mb) {
        return mb.getINOverhead();
    }

    protected void updateMemorySize(ChildReference oldRef, ChildReference newRef) {
        long delta = 0L;
        if (newRef != null) {
            delta = this.getEntryInMemorySize(newRef.getKey(), newRef.getTarget());
        }
        if (oldRef != null) {
            delta -= this.getEntryInMemorySize(oldRef.getKey(), oldRef.getTarget());
        }
        this.changeMemorySize(delta);
    }

    protected void updateMemorySize(long oldSize, long newSize) {
        long delta = newSize - oldSize;
        this.changeMemorySize(delta);
    }

    void updateMemorySize(Node oldNode, Node newNode) {
        long delta = 0L;
        if (newNode != null) {
            delta = newNode.getMemorySizeIncludedByParent();
        }
        if (oldNode != null) {
            delta -= oldNode.getMemorySizeIncludedByParent();
        }
        this.changeMemorySize(delta);
    }

    private void changeMemorySize(long delta) {
        this.inMemorySize += delta;
        if (this.inListResident) {
            EnvironmentImpl env = this.databaseImpl.getDbEnvironment();
            this.accumulatedDelta = (int)((long)this.accumulatedDelta + delta);
            if (this.accumulatedDelta > ACCUMULATED_LIMIT || this.accumulatedDelta < -ACCUMULATED_LIMIT) {
                env.getInMemoryINs().memRecalcUpdate(this, this.accumulatedDelta);
                env.getMemoryBudget().updateTreeMemoryUsage(this.accumulatedDelta);
                this.accumulatedDelta = 0;
            }
        }
    }

    public void setInListResident(boolean resident) {
        this.inListResident = resident;
    }

    public boolean getInListResident() {
        return this.inListResident;
    }

    public boolean isKeyInBounds(byte[] keyVal) {
        if (this.nEntries < 2) {
            return false;
        }
        Comparator<byte[]> userCompareToFcn = this.getKeyComparator();
        byte[] myKey = this.getKey(0);
        int cmp = Key.compareKeys(keyVal, myKey, userCompareToFcn);
        if (cmp < 0) {
            return false;
        }
        myKey = this.getKey(this.nEntries - 1);
        cmp = Key.compareKeys(keyVal, myKey, userCompareToFcn);
        return cmp <= 0;
    }

    public int findEntry(byte[] key, boolean indicateIfDuplicate, boolean exact) {
        boolean entryZeroSpecialCompare;
        int high = this.nEntries - 1;
        int low = 0;
        int middle = 0;
        Comparator<byte[]> userCompareToFcn = this.getKeyComparator();
        boolean bl = entryZeroSpecialCompare = this.entryZeroKeyComparesLow() && !exact && !indicateIfDuplicate;
        assert (this.nEntries >= 0);
        while (low <= high) {
            int s;
            middle = (high + low) / 2;
            byte[] middleKey = null;
            if (middle == 0 && entryZeroSpecialCompare) {
                s = 1;
            } else {
                middleKey = this.getKey(middle);
                s = Key.compareKeys(key, middleKey, userCompareToFcn);
            }
            if (s < 0) {
                high = middle - 1;
                continue;
            }
            if (s > 0) {
                low = middle + 1;
                continue;
            }
            int ret = indicateIfDuplicate ? middle | 0x10000 : middle;
            if (ret >= 0 && exact && this.isEntryKnownDeleted(ret & 0xFFFF)) {
                return -1;
            }
            return ret;
        }
        if (exact) {
            return -1;
        }
        return high;
    }

    public boolean insertEntry(ChildReference entry) throws DatabaseException {
        return (this.insertEntry1(entry) & 0x20000) != 0;
    }

    public int insertEntry1(ChildReference entry) throws DatabaseException {
        if (this.nEntries >= this.entryTargets.length) {
            this.compress(null, true, null);
        }
        if (this.nEntries < this.entryTargets.length) {
            int oldSize;
            byte[] key = entry.getKey();
            int index = this.findEntry(key, true, false);
            if (index >= 0 && (index & 0x10000) != 0) {
                return index;
            }
            if (++index < this.nEntries) {
                oldSize = this.computeLsnOverhead();
                this.shiftEntriesRight(index);
                this.changeMemorySize(this.computeLsnOverhead() - oldSize);
            }
            oldSize = this.computeLsnOverhead();
            this.entryTargets[index] = entry.getTarget();
            this.setLsnElement(index, entry.getLsn());
            this.entryStates[index] = entry.getState();
            ++this.nEntries;
            boolean suffixesChanged = this.setKeyAndPrefix(index, key);
            this.adjustCursorsForInsert(index);
            this.updateMemorySize(oldSize, this.getEntryInMemorySize(index) + (long)this.computeLsnOverhead());
            this.setDirty(true);
            if (suffixesChanged) {
                long curInMemorySize = this.inMemorySize;
                this.updateMemorySize(curInMemorySize, this.computeMemorySize());
            }
            return index | 0x20000;
        }
        throw EnvironmentFailureException.unexpectedState("Node " + this.getNodeId() + " should have been split before calling insertEntry");
    }

    boolean deleteEntry(byte[] key, boolean maybeValidate) throws DatabaseException {
        if (this.nEntries == 0) {
            return false;
        }
        int index = this.findEntry(key, false, true);
        if (index < 0) {
            return false;
        }
        return this.deleteEntry(index, maybeValidate);
    }

    public boolean deleteEntry(int index, boolean maybeValidate) throws DatabaseException {
        if (this.nEntries == 0) {
            return false;
        }
        assert (!maybeValidate || this.validateSubtreeBeforeDelete(index));
        if (index < this.nEntries) {
            this.updateMemorySize(this.getEntryInMemorySize(index), 0L);
            int oldLSNArraySize = this.computeLsnOverhead();
            this.copyEntries(index + 1, index, this.nEntries - index - 1);
            this.clearEntry(this.nEntries - 1);
            this.updateMemorySize(oldLSNArraySize, this.computeLsnOverhead());
            --this.nEntries;
            this.setDirty(true);
            this.setProhibitNextDelta();
            this.traceDelete(Level.FINEST, index);
            return true;
        }
        return false;
    }

    public void setProhibitNextDelta() {
    }

    public boolean compress(BINReference binRef, boolean canFetch, LocalUtilizationTracker localTracker) throws DatabaseException {
        return false;
    }

    public boolean isCompressible() {
        return false;
    }

    boolean validateSubtreeBeforeDelete(int index) throws DatabaseException {
        if (index >= this.nEntries) {
            return true;
        }
        Node child = this.fetchTargetWithExclusiveLatch(index);
        return child != null && child.isValidForDelete();
    }

    public boolean needsSplitting() {
        return this.entryTargets.length - this.nEntries < 1;
    }

    boolean entryZeroKeyComparesLow() {
        return true;
    }

    void split(IN parent, int childIndex, int maxEntries, CacheMode cacheMode) throws DatabaseException {
        this.splitInternal(parent, childIndex, maxEntries, -1, cacheMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void splitInternal(IN parent, int childIndex, int maxEntries, int splitIndex, CacheMode cacheMode) throws DatabaseException {
        int high;
        int low;
        if (this.identifierKey == null) {
            throw EnvironmentFailureException.unexpectedState();
        }
        int idKeyIndex = this.findEntry(this.identifierKey, false, false);
        if (splitIndex < 0) {
            splitIndex = this.nEntries / 2;
        }
        IN newSibling = null;
        if (idKeyIndex < splitIndex) {
            low = splitIndex;
            high = this.nEntries;
        } else {
            low = 0;
            high = splitIndex;
        }
        byte[] newIdKey = this.getKey(low);
        long parentLsn = -1L;
        newSibling = this.createNewInstance(newIdKey, maxEntries, this.level);
        newSibling.latch(cacheMode);
        long oldMemorySize = this.inMemorySize;
        try {
            int toIdx = 0;
            boolean deletedEntrySeen = false;
            BINReference binRef = null;
            for (int i = low; i < high; ++i) {
                byte[] thisKey = this.getKey(i);
                if (this.isEntryPendingDeleted(i)) {
                    if (!deletedEntrySeen) {
                        deletedEntrySeen = true;
                        assert (newSibling instanceof BIN);
                        binRef = ((BIN)newSibling).createReference();
                    }
                    binRef.addDeletedKey(new Key(thisKey));
                }
                newSibling.setEntry(toIdx++, this.entryTargets[i], thisKey, this.getLsn(i), this.entryStates[i]);
                this.clearEntry(i);
            }
            if (deletedEntrySeen) {
                this.databaseImpl.getDbEnvironment().addToCompressorQueue(binRef, false);
            }
            int newSiblingNEntries = high - low;
            if (low == 0) {
                this.shiftEntriesLeft(newSiblingNEntries);
            }
            newSibling.nEntries = toIdx;
            this.nEntries -= newSiblingNEntries;
            this.setDirty(true);
            this.adjustCursors(newSibling, low, high);
            EnvironmentImpl env = this.databaseImpl.getDbEnvironment();
            LogManager logManager = env.getLogManager();
            INList inMemoryINs = env.getInMemoryINs();
            long newSiblingLsn = newSibling.optionalLogProvisional(logManager, parent);
            long myNewLsn = this.optionalLogProvisional(logManager, parent);
            if (low == 0) {
                if (childIndex == 0) {
                    parent.updateEntryCompareKey(childIndex, newSibling, newSiblingLsn, newIdKey);
                } else {
                    parent.updateNode(childIndex, newSibling, newSiblingLsn, null);
                }
                byte[] ourKey = this.getKey(0);
                boolean insertOk = parent.insertEntry(new ChildReference(this, ourKey, myNewLsn));
                assert (insertOk);
            } else {
                if (childIndex == 0) {
                    parent.updateEntryCompareKey(childIndex, this, myNewLsn, this.getKey(0));
                } else {
                    parent.updateNode(childIndex, this, myNewLsn, null);
                }
                boolean insertOk = parent.insertEntry(new ChildReference(newSibling, newIdKey, newSiblingLsn));
                assert (insertOk);
            }
            byte[] newKeyPrefix = this.computeKeyPrefix(-1);
            this.recalcSuffixes(newKeyPrefix, null, -1);
            if (newSibling.getNEntries() > 1) {
                byte[] newSiblingPrefix = newSibling.getKeyPrefix();
                newSiblingPrefix = newSibling.computeKeyPrefix(-1);
                newSibling.recalcSuffixes(newSiblingPrefix, null, -1);
                newSibling.initMemorySize();
            }
            parentLsn = parent.optionalLog(logManager);
            if (parent.isRoot()) {
                parent.setDirty(true);
            }
            long newSize = this.computeMemorySize();
            this.updateMemorySize(oldMemorySize, newSize);
            inMemoryINs.add(newSibling);
            this.traceSplit(Level.FINE, parent, newSibling, parentLsn, myNewLsn, newSiblingLsn, splitIndex, idKeyIndex, childIndex);
            Object var30_27 = null;
            newSibling.releaseLatch();
        }
        catch (Throwable throwable) {
            Object var30_28 = null;
            newSibling.releaseLatch();
            throw throwable;
        }
    }

    void splitSpecial(IN parent, int parentIndex, int maxEntriesPerNode, byte[] key, boolean leftSide, CacheMode cacheMode) throws DatabaseException {
        int index = this.findEntry(key, false, false);
        if (leftSide && index == 0) {
            this.splitInternal(parent, parentIndex, maxEntriesPerNode, 1, cacheMode);
        } else if (!leftSide && index == this.nEntries - 1) {
            this.splitInternal(parent, parentIndex, maxEntriesPerNode, this.nEntries - 1, cacheMode);
        } else {
            this.split(parent, parentIndex, maxEntriesPerNode, cacheMode);
        }
    }

    void adjustCursors(IN newSibling, int newSiblingLow, int newSiblingHigh) {
    }

    void adjustCursorsForInsert(int insertIndex) {
    }

    public Comparator<byte[]> getKeyComparator() {
        return this.databaseImpl.getBtreeComparator();
    }

    private void shiftEntriesRight(int index) {
        this.copyEntries(index, index + 1, this.nEntries - index);
        this.clearEntry(index);
        this.setDirty(true);
    }

    private void shiftEntriesLeft(int byHowMuch) {
        this.copyEntries(byHowMuch, 0, this.nEntries - byHowMuch);
        for (int i = this.nEntries - byHowMuch; i < this.nEntries; ++i) {
            this.clearEntry(i);
        }
        this.setDirty(true);
    }

    @Override
    public void verify(byte[] maxKey) throws EnvironmentFailureException {
    }

    @Override
    void rebuildINList(INList inList) throws DatabaseException {
        this.initMemorySize();
        inList.add(this);
        for (int i = 0; i < this.nEntries; ++i) {
            Node n = this.getTarget(i);
            if (n == null) continue;
            n.rebuildINList(inList);
        }
    }

    @Override
    void accountForSubtreeRemoval(INList inList, LocalUtilizationTracker localTracker) throws DatabaseException {
        if (this.nEntries > 1) {
            throw EnvironmentFailureException.unexpectedState("Found non-deletable IN " + this.getNodeId() + " while flushing INList. nEntries = " + this.nEntries);
        }
        inList.remove(this);
        if (this.lastFullVersion != -1L) {
            localTracker.countObsoleteNode(this.lastFullVersion, this.getLogType(), 0, this.databaseImpl);
        }
        for (int i = 0; i < this.nEntries; ++i) {
            Node n = this.fetchTargetWithExclusiveLatch(i);
            if (n == null) continue;
            n.accountForSubtreeRemoval(inList, localTracker);
        }
    }

    @Override
    boolean isValidForDelete() throws DatabaseException {
        if (this.nEntries > 1) {
            return false;
        }
        if (this.nEntries == 1) {
            Node child = this.fetchTargetWithExclusiveLatch(0);
            if (child == null) {
                return false;
            }
            child.latchShared(CacheMode.UNCHANGED);
            boolean ret = child.isValidForDelete();
            child.releaseLatch();
            return ret;
        }
        return true;
    }

    void findParent(Tree.SearchType searchType, long targetNodeId, boolean targetContainsDuplicates, boolean targetIsRoot, byte[] targetMainTreeKey, byte[] targetDupTreeKey, SearchResult result, boolean requireExactMatch, CacheMode cacheMode, int targetLevel, List<TrackingInfo> trackingList, boolean doFetch) throws RelatchRequiredException, DatabaseException {
        assert (this.isLatchOwnerForWrite());
        if (this.getNodeId() == targetNodeId) {
            this.releaseLatch();
            result.exactParentFound = false;
            result.keepSearching = false;
            result.parent = null;
            return;
        }
        if (this.getNEntries() == 0) {
            result.keepSearching = false;
            result.exactParentFound = false;
            if (requireExactMatch) {
                this.releaseLatch();
                result.parent = null;
            } else {
                result.parent = this;
                result.index = -1;
            }
            return;
        }
        if (searchType == Tree.SearchType.NORMAL) {
            result.index = this.findEntry(this.selectKey(targetMainTreeKey, targetDupTreeKey), false, false);
        } else if (searchType == Tree.SearchType.LEFT) {
            result.index = 0;
        } else if (searchType == Tree.SearchType.RIGHT) {
            result.index = this.nEntries - 1;
        } else {
            throw EnvironmentFailureException.unexpectedState("Invalid value of searchType: " + searchType);
        }
        if (result.index < 0) {
            result.keepSearching = false;
            result.exactParentFound = false;
            if (requireExactMatch) {
                this.releaseLatch();
                result.parent = null;
            } else {
                result.parent = this;
            }
            return;
        }
        Node child = null;
        boolean isDeleted = false;
        if (this.isEntryKnownDeleted(result.index)) {
            isDeleted = true;
        } else if (doFetch) {
            child = this.fetchTarget(result.index);
            if (child == null) {
                isDeleted = true;
            }
        } else {
            child = this.getTarget(result.index);
        }
        if (isDeleted) {
            result.exactParentFound = false;
            result.keepSearching = false;
            if (requireExactMatch) {
                result.parent = null;
                this.releaseLatch();
            } else {
                result.parent = this;
            }
            return;
        }
        if (targetLevel >= 0 && this.level == targetLevel + 1) {
            result.exactParentFound = true;
            result.parent = this;
            result.keepSearching = false;
            return;
        }
        if (child == null) {
            assert (!doFetch);
            result.keepSearching = false;
            result.exactParentFound = false;
            result.parent = this;
            result.childNotResident = true;
            return;
        }
        long childLsn = this.getLsn(result.index);
        if (child.isSoughtNode(targetNodeId, cacheMode, doFetch)) {
            result.exactParentFound = true;
            result.parent = this;
            result.keepSearching = false;
            return;
        }
        this.descendOnParentSearch(result, targetContainsDuplicates, targetIsRoot, targetNodeId, child, requireExactMatch);
        if (trackingList != null && result.parent != this && result.parent != null) {
            trackingList.add(new TrackingInfo(childLsn, child.getNodeId()));
        }
    }

    protected void descendOnParentSearch(SearchResult result, boolean targetContainsDuplicates, boolean targetIsRoot, long targetNodeId, Node child, boolean requireExactMatch) throws DatabaseException {
        if (child.canBeAncestor(targetContainsDuplicates)) {
            this.releaseLatch();
            result.parent = (IN)child;
        } else {
            ((IN)child).releaseLatch();
            result.exactParentFound = false;
            result.keepSearching = false;
            if (requireExactMatch) {
                this.releaseLatch();
                result.parent = null;
            } else {
                result.parent = this;
            }
        }
    }

    @Override
    protected boolean isSoughtNode(long nid, CacheMode cacheMode, boolean doFetch) throws DatabaseException {
        this.latch(cacheMode);
        if (this.getNodeId() == nid) {
            this.releaseLatch();
            return true;
        }
        return false;
    }

    @Override
    protected boolean canBeAncestor(boolean targetContainsDuplicates) {
        return true;
    }

    public boolean isEvictable() {
        if (this.isEvictionProhibited()) {
            return false;
        }
        if (this.hasPinnedChildren()) {
            return false;
        }
        for (int i = 0; i < this.getNEntries(); ++i) {
            if (this.getLsn(i) != -1L || this.getTarget(i) != null) continue;
            return false;
        }
        return true;
    }

    public int getEvictionType() {
        if (this.isEvictionProhibited()) {
            return 0;
        }
        return this.getChildEvictionType();
    }

    boolean isEvictionProhibited() {
        if (this.isDbRoot()) {
            if (this.databaseImpl.isDeferredWriteMode() && this.getDirty()) {
                return true;
            }
            DatabaseId dbId = this.databaseImpl.getId();
            if (dbId.equals(DbTree.ID_DB_ID) || dbId.equals(DbTree.NAME_DB_ID)) {
                return true;
            }
        }
        return false;
    }

    boolean hasPinnedChildren() {
        return this.hasResidentChildren();
    }

    int getChildEvictionType() {
        return this.hasResidentChildren() ? 0 : 2;
    }

    final boolean hasResidentChildren() {
        for (int i = 0; i < this.getNEntries(); ++i) {
            if (this.getTarget(i) == null) continue;
            return true;
        }
        return false;
    }

    void accumulateStats(TreeWalkerStatsAccumulator acc) {
        acc.processIN(this, this.getNodeId(), this.getLevel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logDirtyChildren() throws DatabaseException {
        EnvironmentImpl envImpl = this.getDatabase().getDbEnvironment();
        for (int i = 0; i < this.getNEntries(); ++i) {
            Object var7_5;
            IN child = (IN)this.getTarget(i);
            if (child == null) continue;
            child.latch(CacheMode.UNCHANGED);
            try {
                if (child.getDirty()) {
                    child.logDirtyChildren();
                    long childLsn = child.log(envImpl.getLogManager(), false, true, true, this);
                    this.updateEntry(i, childLsn);
                }
                var7_5 = null;
                child.releaseLatch();
                continue;
            }
            catch (Throwable throwable) {
                var7_5 = null;
                child.releaseLatch();
                throw throwable;
            }
        }
    }

    public long log(LogManager logManager) throws DatabaseException {
        return this.logInternal(logManager, false, Provisional.NO, false, null);
    }

    public long log(LogManager logManager, boolean allowDeltas, boolean isProvisional, boolean backgroundIO, IN parent) throws DatabaseException {
        return this.logInternal(logManager, allowDeltas, isProvisional ? Provisional.YES : Provisional.NO, backgroundIO, parent);
    }

    public long log(LogManager logManager, boolean allowDeltas, Provisional provisional, boolean backgroundIO, IN parent) throws DatabaseException {
        return this.logInternal(logManager, allowDeltas, provisional, backgroundIO, parent);
    }

    public long optionalLog(LogManager logManager) throws DatabaseException {
        if (this.databaseImpl.isDeferredWriteMode()) {
            return -1L;
        }
        return this.logInternal(logManager, false, Provisional.NO, false, null);
    }

    public long optionalLogProvisional(LogManager logManager, IN parent) throws DatabaseException {
        if (this.databaseImpl.isDeferredWriteMode()) {
            return -1L;
        }
        return this.logInternal(logManager, false, Provisional.YES, false, parent);
    }

    private long logInternal(LogManager logManager, boolean allowDeltas, Provisional provisional, boolean backgroundIO, IN parent) throws DatabaseException {
        INLogItem item = new INLogItem();
        item.provisional = provisional;
        item.parent = parent;
        item.repContext = ReplicationContext.NO_REPLICATE;
        INLogContext context = new INLogContext();
        context.nodeDb = this.getDatabase();
        context.backgroundIO = backgroundIO;
        context.allowDeltas = allowDeltas;
        this.beforeLog(logManager, item, context);
        logManager.log(item, context);
        this.afterLog(logManager, item, context);
        return item.newLsn;
    }

    public void beforeLog(LogManager logManager, INLogItem item, INLogContext context) throws DatabaseException {
        assert (this.isLatchOwnerForWrite());
        assert (item.parent == null || item.parent.isLatchOwnerForWrite());
        item.entry = new INLogEntry(this);
        if (this.countObsoleteDuringLogging(item.provisional)) {
            item.oldLsn = this.lastFullVersion;
            context.packedObsoleteInfo = this.provisionalObsolete;
        }
    }

    public void afterLog(LogManager logManager, INLogItem item, INLogContext context) throws DatabaseException {
        if (this.countObsoleteDuringLogging(item.provisional)) {
            this.discardProvisionalObsolete(logManager);
        } else if (item.parent != null) {
            item.parent.trackProvisionalObsolete(this, this.lastFullVersion, false, 0);
        }
        this.setLastFullLsn(item.newLsn);
        this.setDirty(false);
    }

    private boolean countObsoleteDuringLogging(Provisional provisional) {
        return provisional != Provisional.YES || this.databaseImpl.isTemporary();
    }

    void trackProvisionalObsolete(IN childIN, long obsoleteLsn, boolean isObsoleteLN, int obsoleteSize) {
        int oldMemSize;
        int n = oldMemSize = this.provisionalObsolete != null ? this.provisionalObsolete.getMemorySize() : 0;
        if (childIN != null && childIN.provisionalObsolete != null) {
            if (this.provisionalObsolete != null) {
                this.provisionalObsolete.copyObsoleteInfo(childIN.provisionalObsolete);
            } else {
                this.provisionalObsolete = childIN.provisionalObsolete;
            }
            childIN.changeMemorySize(0 - childIN.provisionalObsolete.getMemorySize());
            childIN.provisionalObsolete = null;
        }
        if (obsoleteLsn != -1L) {
            if (this.provisionalObsolete == null) {
                this.provisionalObsolete = new PackedObsoleteInfo();
            }
            this.provisionalObsolete.addObsoleteInfo(obsoleteLsn, isObsoleteLN, obsoleteSize);
        }
        this.updateMemorySize(oldMemSize, this.provisionalObsolete != null ? (long)this.provisionalObsolete.getMemorySize() : 0L);
    }

    private void discardProvisionalObsolete(LogManager logManager) throws DatabaseException {
        if (this.provisionalObsolete != null) {
            this.changeMemorySize(0 - this.provisionalObsolete.getMemorySize());
            this.provisionalObsolete = null;
        }
    }

    public void incEvictStats(Evictor.EvictionSource source) {
        this.databaseImpl.getDbEnvironment().getEvictor().incINEvictStats(source);
    }

    @Override
    public void incFetchStats(EnvironmentImpl envImpl, boolean isMiss) {
        envImpl.getEvictor().incINFetchStats(isMiss);
    }

    @Override
    public LogEntryType getLogType() {
        return LogEntryType.LOG_IN;
    }

    @Override
    public int getLogSize() {
        boolean compactLsnsRep;
        int size = super.getLogSize();
        size += LogUtils.getByteArrayLogSize(this.identifierKey);
        if (this.keyPrefix != null) {
            size += LogUtils.getByteArrayLogSize(this.keyPrefix);
        }
        ++size;
        size += LogUtils.getPackedIntLogSize(this.nEntries);
        size += LogUtils.getPackedIntLogSize(this.level);
        size += LogUtils.getPackedIntLogSize(this.entryTargets.length);
        size += LogUtils.getBooleanLogSize();
        boolean bl = compactLsnsRep = this.entryLsnLongArray == null;
        if (compactLsnsRep) {
            size += 4;
        }
        for (int i = 0; i < this.nEntries; ++i) {
            size += LogUtils.getByteArrayLogSize(this.entryKeyVals[i]) + (compactLsnsRep ? 4 : LogUtils.getLongLogSize()) + 1;
        }
        return size;
    }

    @Override
    public void writeToLog(ByteBuffer logBuffer) {
        super.writeToLog(logBuffer);
        boolean hasKeyPrefix = this.keyPrefix != null;
        LogUtils.writeByteArray(logBuffer, this.identifierKey);
        byte booleans = (byte)(this.isRoot() ? 1 : 0);
        booleans = (byte)(booleans | (hasKeyPrefix ? 2 : 0));
        logBuffer.put(booleans);
        if (hasKeyPrefix) {
            LogUtils.writeByteArray(logBuffer, this.keyPrefix);
        }
        LogUtils.writePackedInt(logBuffer, this.nEntries);
        LogUtils.writePackedInt(logBuffer, this.level);
        LogUtils.writePackedInt(logBuffer, this.entryTargets.length);
        boolean compactLsnsRep = this.entryLsnLongArray == null;
        LogUtils.writeBoolean(logBuffer, compactLsnsRep);
        if (compactLsnsRep) {
            LogUtils.writeInt(logBuffer, (int)this.baseFileNumber);
        }
        int i = 0;
        while (i < this.nEntries) {
            LogUtils.writeByteArray(logBuffer, this.entryKeyVals[i]);
            assert (this.checkForNullLSN(i)) : "logging IN " + this.getNodeId() + " with null lsn child " + " db=" + this.databaseImpl.getDebugName() + " isDeferredWriteMode=" + this.databaseImpl.isDeferredWriteMode() + " isTemporary=" + this.databaseImpl.isTemporary();
            if (compactLsnsRep) {
                int offset = i << 2;
                int fileOffset = this.getFileOffset(offset);
                logBuffer.put(this.getFileNumberOffset(offset));
                logBuffer.put((byte)(fileOffset >>> 0 & 0xFF));
                logBuffer.put((byte)(fileOffset >>> 8 & 0xFF));
                logBuffer.put((byte)(fileOffset >>> 16 & 0xFF));
            } else {
                LogUtils.writeLong(logBuffer, this.entryLsnLongArray[i]);
            }
            logBuffer.put(this.entryStates[i]);
            int n = i++;
            this.entryStates[n] = (byte)(this.entryStates[n] & 0xFFFFFFFD);
        }
    }

    private boolean checkForNullLSN(int index) {
        boolean ok = this instanceof BIN ? this.getLsn(index) != -1L || (this.entryStates[index] & 1) != 0 : this.getLsn(index) != -1L;
        return ok;
    }

    @Override
    public void readFromLog(ByteBuffer itemBuffer, int entryVersion) {
        super.readFromLog(itemBuffer, entryVersion);
        boolean unpacked = entryVersion < 6;
        this.identifierKey = LogUtils.readByteArray(itemBuffer, unpacked);
        byte booleans = itemBuffer.get();
        this.setIsRootFlag((booleans & 1) != 0);
        if ((booleans & 2) != 0) {
            this.keyPrefix = LogUtils.readByteArray(itemBuffer, unpacked);
        }
        this.nEntries = LogUtils.readInt(itemBuffer, unpacked);
        this.level = LogUtils.readInt(itemBuffer, unpacked);
        int length = LogUtils.readInt(itemBuffer, unpacked);
        this.entryTargets = new Node[length];
        this.entryKeyVals = new byte[length][];
        this.baseFileNumber = -1L;
        long storedBaseFileNumber = -1L;
        this.entryLsnByteArray = new byte[length << 2];
        this.entryLsnLongArray = null;
        this.entryStates = new byte[length];
        boolean compactLsnsRep = false;
        if (entryVersion > 1 && (compactLsnsRep = LogUtils.readBoolean(itemBuffer))) {
            storedBaseFileNumber = this.baseFileNumber = (long)(LogUtils.readInt(itemBuffer) & 0xFFFFFFFF);
        }
        for (int i = 0; i < this.nEntries; ++i) {
            long lsn;
            this.entryKeyVals[i] = LogUtils.readByteArray(itemBuffer, unpacked);
            if (compactLsnsRep) {
                byte fileNumberOffset = itemBuffer.get();
                int fileOffset = itemBuffer.get() & 0xFF;
                fileOffset |= (itemBuffer.get() & 0xFF) << 8;
                lsn = (fileOffset |= (itemBuffer.get() & 0xFF) << 16) == 0xFFFFFF ? -1L : DbLsn.makeLsn(storedBaseFileNumber + (long)fileNumberOffset, fileOffset);
            } else {
                lsn = LogUtils.readLong(itemBuffer);
            }
            this.setLsnElement(i, lsn);
            byte entryState = itemBuffer.get();
            entryState = (byte)(entryState & 0xFFFFFFFD);
            entryState = (byte)(entryState & 0xFFFFFFFB);
            if (lsn == -1L) {
                entryState = (byte)(entryState | 1);
            }
            this.entryStates[i] = entryState;
        }
        this.latch.setName(this.shortClassName() + this.getNodeId());
    }

    @Override
    public void dumpLog(StringBuilder sb, boolean verbose) {
        boolean compactLsnsRep;
        sb.append(this.beginTag());
        super.dumpLog(sb, verbose);
        sb.append(Key.dumpString(this.identifierKey, 0));
        sb.append("<isRoot val=\"");
        sb.append(this.isRoot());
        sb.append("\"/>");
        sb.append("<level val=\"");
        sb.append(Integer.toHexString(this.level));
        sb.append("\"/>");
        if (this.keyPrefix != null) {
            sb.append("<keyPrefix>");
            sb.append(Key.dumpString(this.keyPrefix, 0));
            sb.append("</keyPrefix>");
        }
        sb.append("<entries numEntries=\"");
        sb.append(this.nEntries);
        sb.append("\" length=\"");
        sb.append(this.entryTargets.length);
        boolean bl = compactLsnsRep = this.entryLsnLongArray == null;
        if (compactLsnsRep) {
            sb.append("\" baseFileNumber=\"");
            sb.append(this.baseFileNumber);
        }
        sb.append("\">");
        if (verbose) {
            for (int i = 0; i < this.nEntries; ++i) {
                sb.append("<ref kd=\"").append(this.isEntryKnownDeleted(i));
                sb.append("\" pd=\"").append(this.isEntryPendingDeleted(i));
                sb.append("\">");
                sb.append(Key.dumpString(this.entryKeyVals[i], 0));
                sb.append(DbLsn.toString(this.getLsn(i)));
                sb.append("</ref>");
            }
        }
        sb.append("</entries>");
        this.dumpLogAdditional(sb);
        sb.append(this.endTag());
    }

    @Override
    public boolean logicalEquals(Loggable other) {
        return false;
    }

    protected void dumpLogAdditional(StringBuilder sb) {
    }

    public String beginTag() {
        return BEGIN_TAG;
    }

    public String endTag() {
        return END_TAG;
    }

    void dumpKeys() {
        for (int i = 0; i < this.nEntries; ++i) {
            System.out.println(Key.dumpString(this.entryKeyVals[i], 0));
        }
    }

    @Override
    public String dumpString(int nSpaces, boolean dumpTags) {
        StringBuilder sb = new StringBuilder();
        if (dumpTags) {
            sb.append(TreeUtils.indent(nSpaces));
            sb.append(this.beginTag());
            sb.append('\n');
        }
        sb.append(super.dumpString(nSpaces + 2, true));
        sb.append('\n');
        sb.append(TreeUtils.indent(nSpaces + 2));
        sb.append("<idkey>");
        sb.append(this.identifierKey == null ? "" : Key.dumpString(this.identifierKey, 0));
        sb.append("</idkey>");
        sb.append('\n');
        sb.append(TreeUtils.indent(nSpaces + 2));
        sb.append("<prefix>");
        sb.append(this.keyPrefix == null ? "" : Key.dumpString(this.keyPrefix, 0));
        sb.append("</prefix>\n");
        sb.append(TreeUtils.indent(nSpaces + 2));
        sb.append("<dirty val=\"").append(this.getDirty()).append("\"/>");
        sb.append('\n');
        sb.append(TreeUtils.indent(nSpaces + 2));
        sb.append("<generation val=\"").append(this.generation).append("\"/>");
        sb.append('\n');
        sb.append(TreeUtils.indent(nSpaces + 2));
        sb.append("<level val=\"");
        sb.append(Integer.toHexString(this.level)).append("\"/>");
        sb.append('\n');
        sb.append(TreeUtils.indent(nSpaces + 2));
        sb.append("<isRoot val=\"").append(this.isRoot()).append("\"/>");
        sb.append('\n');
        sb.append(TreeUtils.indent(nSpaces + 2));
        sb.append("<entries nEntries=\"");
        sb.append(this.nEntries);
        sb.append("\">");
        sb.append('\n');
        for (int i = 0; i < this.nEntries; ++i) {
            sb.append(TreeUtils.indent(nSpaces + 4));
            sb.append("<entry id=\"" + i + "\">");
            sb.append('\n');
            if (this.getLsn(i) == -1L) {
                sb.append(TreeUtils.indent(nSpaces + 6));
                sb.append("<lsn/>");
            } else {
                sb.append(DbLsn.dumpString(this.getLsn(i), nSpaces + 6));
            }
            sb.append('\n');
            if (this.entryKeyVals[i] == null) {
                sb.append(TreeUtils.indent(nSpaces + 6));
                sb.append("<key/>");
            } else {
                sb.append(Key.dumpString(this.entryKeyVals[i], nSpaces + 6));
            }
            sb.append('\n');
            if (this.entryTargets[i] == null) {
                sb.append(TreeUtils.indent(nSpaces + 6));
                sb.append("<target/>");
            } else {
                sb.append(this.entryTargets[i].dumpString(nSpaces + 6, true));
            }
            sb.append('\n');
            sb.append(TreeUtils.indent(nSpaces + 6));
            IN.dumpDeletedState(sb, this.getState(i));
            sb.append("<dirty val=\"").append(this.isDirty(i)).append("\"/>");
            sb.append('\n');
            sb.append(TreeUtils.indent(nSpaces + 4));
            sb.append("</entry>");
            sb.append('\n');
        }
        sb.append(TreeUtils.indent(nSpaces + 2));
        sb.append("</entries>");
        sb.append('\n');
        if (dumpTags) {
            sb.append(TreeUtils.indent(nSpaces));
            sb.append(this.endTag());
        }
        return sb.toString();
    }

    static void dumpDeletedState(StringBuilder sb, byte state) {
        sb.append("<knownDeleted val=\"");
        sb.append(IN.isStateKnownDeleted(state)).append("\"/>");
        sb.append("<pendingDeleted val=\"");
        sb.append(IN.isStatePendingDeleted(state)).append("\"/>");
    }

    @Override
    public String toString() {
        return this.dumpString(0, true);
    }

    public String shortClassName() {
        return "IN";
    }

    private void traceSplit(Level level, IN parent, IN newSibling, long parentLsn, long myNewLsn, long newSiblingLsn, int splitIndex, int idKeyIndex, int childIndex) {
        Logger logger = this.databaseImpl.getDbEnvironment().getLogger();
        if (logger.isLoggable(level)) {
            StringBuffer sb = new StringBuffer();
            sb.append(TRACE_SPLIT);
            sb.append(" parent=");
            sb.append(parent.getNodeId());
            sb.append(" child=");
            sb.append(this.getNodeId());
            sb.append(" newSibling=");
            sb.append(newSibling.getNodeId());
            sb.append(" parentLsn = ");
            sb.append(DbLsn.getNoFormatString(parentLsn));
            sb.append(" childLsn = ");
            sb.append(DbLsn.getNoFormatString(myNewLsn));
            sb.append(" newSiblingLsn = ");
            sb.append(DbLsn.getNoFormatString(newSiblingLsn));
            sb.append(" splitIdx=");
            sb.append(splitIndex);
            sb.append(" idKeyIdx=");
            sb.append(idKeyIndex);
            sb.append(" childIdx=");
            sb.append(childIndex);
            LoggerUtils.logMsg(logger, this.databaseImpl.getDbEnvironment(), level, sb.toString());
        }
    }

    private void traceDelete(Level level, int index) {
        Logger logger = this.databaseImpl.getDbEnvironment().getLogger();
        if (logger.isLoggable(level)) {
            StringBuffer sb = new StringBuffer();
            sb.append(TRACE_DELETE);
            sb.append(" in=").append(this.getNodeId());
            sb.append(" index=");
            sb.append(index);
            LoggerUtils.logMsg(logger, this.databaseImpl.getDbEnvironment(), level, sb.toString());
        }
    }
}

