/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockConflictException;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.latch.Latch;
import com.sleepycat.je.txn.Lock;
import com.sleepycat.je.txn.LockAttemptResult;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.LockManager;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.utilint.StatGroup;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncedLockManager
extends LockManager {
    public SyncedLockManager(EnvironmentImpl envImpl) {
        super(envImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Lock lookupLock(Long nodeId) {
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        synchronized (latch) {
            return this.lookupLockInternal(nodeId, lockTableIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    LockAttemptResult attemptLock(Long nodeId, Locker locker, LockType type, boolean nonBlockingRequest) throws DatabaseException {
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        synchronized (latch) {
            return this.attemptLockInternal(nodeId, locker, type, nonBlockingRequest, lockTableIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    LockConflictException makeTimeoutMsg(boolean isLockNotTxnTimeout, Locker locker, long nodeId, LockType type, LockGrantType grantType, Lock useLock, long timeout, long start, long now, DatabaseImpl database) {
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        synchronized (latch) {
            return this.makeTimeoutMsgInternal(isLockNotTxnTimeout, locker, nodeId, type, grantType, useLock, timeout, start, now, database);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Set<Locker> releaseAndFindNotifyTargets(long nodeId, Locker locker) {
        long nid = nodeId;
        int lockTableIndex = this.getLockTableIndex(nid);
        Latch latch = this.lockTableLatches[lockTableIndex];
        synchronized (latch) {
            return this.releaseAndFindNotifyTargetsInternal(nodeId, locker, lockTableIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void transfer(long nodeId, Locker owningLocker, Locker destLocker, boolean demoteToRead) throws DatabaseException {
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        synchronized (latch) {
            this.transferInternal(nodeId, owningLocker, destLocker, demoteToRead, lockTableIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void transferMultiple(long nodeId, Locker owningLocker, Locker[] destLockers) throws DatabaseException {
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        synchronized (latch) {
            this.transferMultipleInternal(nodeId, owningLocker, destLockers, lockTableIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void demote(long nodeId, Locker locker) {
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        synchronized (latch) {
            this.demoteInternal(nodeId, locker, lockTableIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean isLocked(Long nodeId) {
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        synchronized (latch) {
            return this.isLockedInternal(nodeId, lockTableIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean isOwner(Long nodeId, Locker locker, LockType type) {
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        synchronized (latch) {
            return this.isOwnerInternal(nodeId, locker, type, lockTableIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean isWaiter(Long nodeId, Locker locker) {
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        synchronized (latch) {
            return this.isWaiterInternal(nodeId, locker, lockTableIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    int nWaiters(Long nodeId) {
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        synchronized (latch) {
            return this.nWaitersInternal(nodeId, lockTableIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    int nOwners(Long nodeId) {
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        synchronized (latch) {
            return this.nOwnersInternal(nodeId, lockTableIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Locker getWriteOwnerLocker(Long nodeId) {
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        synchronized (latch) {
            return this.getWriteOwnerLockerInternal(nodeId, lockTableIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean validateOwnership(Long nodeId, Locker locker, LockType type, boolean flushFromWaiters, MemoryBudget mb) {
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        synchronized (latch) {
            return this.validateOwnershipInternal(nodeId, locker, type, flushFromWaiters, mb, lockTableIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected LockAttemptResult stealLock(Long nodeId, Locker locker, LockType lockType, MemoryBudget mb) throws DatabaseException {
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        synchronized (latch) {
            return this.stealLockInternal(nodeId, locker, lockType, mb, lockTableIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void dumpLockTable(StatGroup stats, boolean clear) {
        for (int i = 0; i < this.nLockTables; ++i) {
            Latch latch = this.lockTableLatches[i];
            synchronized (latch) {
                this.dumpLockTableInternal(stats, i, clear);
                continue;
            }
        }
    }
}

