/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.Loggable;
import java.nio.ByteBuffer;
import java.sql.Timestamp;

public class Matchpoint
implements Loggable {
    private Timestamp time;
    private int repMasterNodeId;

    public Matchpoint(int repMasterNodeId) {
        this.repMasterNodeId = repMasterNodeId;
        this.time = new Timestamp(System.currentTimeMillis());
    }

    public Matchpoint() {
    }

    public int getMasterNodeId() {
        return this.repMasterNodeId;
    }

    public int getLogSize() {
        return LogUtils.getTimestampLogSize(this.time) + LogUtils.getPackedIntLogSize(this.repMasterNodeId);
    }

    public void writeToLog(ByteBuffer logBuffer) {
        LogUtils.writeTimestamp(logBuffer, this.time);
        LogUtils.writePackedInt(logBuffer, this.repMasterNodeId);
    }

    public void readFromLog(ByteBuffer logBuffer, int entryVersion) {
        this.time = LogUtils.readTimestamp(logBuffer, false);
        this.repMasterNodeId = LogUtils.readInt(logBuffer, false);
    }

    public void dumpLog(StringBuilder sb, boolean verbose) {
        sb.append("<Matchpoint");
        sb.append("\" time=\"").append(this.time);
        sb.append("\" master=\"").append(this.repMasterNodeId);
        sb.append("\">");
    }

    public long getTransactionId() {
        return 0L;
    }

    public boolean logicalEquals(Loggable other) {
        if (!(other instanceof Matchpoint)) {
            return false;
        }
        Matchpoint otherMatchpoint = (Matchpoint)other;
        return otherMatchpoint.time.equals(this.time) && otherMatchpoint.repMasterNodeId == this.repMasterNodeId;
    }
}

