/*
 * Decompiled with CFR 0.152.
 */
package org.opends.admin.ads;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapName;
import org.opends.admin.ads.ADSContext;
import org.opends.admin.ads.ADSContextException;
import org.opends.admin.ads.ReplicaDescriptor;
import org.opends.admin.ads.ServerDescriptor;
import org.opends.admin.ads.SuffixDescriptor;
import org.opends.admin.ads.TopologyCacheException;
import org.opends.admin.ads.TopologyCacheFilter;
import org.opends.admin.ads.util.ApplicationTrustManager;
import org.opends.admin.ads.util.ConnectionUtils;
import org.opends.admin.ads.util.PreferredConnection;
import org.opends.admin.ads.util.ServerLoader;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopologyCache {
    private ADSContext adsContext;
    private ApplicationTrustManager trustManager;
    private int timeout;
    private String dn;
    private String pwd;
    private Set<ServerDescriptor> servers = new HashSet<ServerDescriptor>();
    private Set<SuffixDescriptor> suffixes = new HashSet<SuffixDescriptor>();
    private LinkedHashSet<PreferredConnection> preferredConnections = new LinkedHashSet();
    private TopologyCacheFilter filter = new TopologyCacheFilter();
    private final boolean isMultiThreaded = true;
    private static final int MULTITHREAD_TIMEOUT = 90000;
    private static final Logger LOG = Logger.getLogger(TopologyCache.class.getName());

    public TopologyCache(ADSContext aDSContext, ApplicationTrustManager applicationTrustManager, int n) {
        this.adsContext = aDSContext;
        this.trustManager = applicationTrustManager;
        this.timeout = n;
        this.dn = ConnectionUtils.getBindDN(aDSContext.getDirContext());
        this.pwd = ConnectionUtils.getBindPassword(aDSContext.getDirContext());
    }

    public void reloadTopology() throws TopologyCacheException {
        this.suffixes.clear();
        this.servers.clear();
        try {
            Set<Map<ADSContext.ServerProperty, Object>> set = this.adsContext.readServerRegistry();
            HashSet<ServerLoader> hashSet = new HashSet<ServerLoader>();
            for (Map<ADSContext.ServerProperty, Object> object : set) {
                ServerLoader serverLoader = this.getServerLoader(object);
                serverLoader.start();
                hashSet.add(serverLoader);
            }
            this.joinThreadSet(hashSet);
            HashMap hashMap = new HashMap();
            for (ServerLoader serverLoader : hashSet) {
                ServerDescriptor serverDescriptor = serverLoader.getServerDescriptor();
                for (ReplicaDescriptor replicaDescriptor : serverDescriptor.getReplicas()) {
                    LOG.log(Level.INFO, "Handling replica with dn: " + replicaDescriptor.getSuffix().getDN());
                    boolean bl = false;
                    LdapName ldapName = new LdapName(replicaDescriptor.getSuffix().getDN());
                    HashSet<SuffixDescriptor> hashSet2 = (HashSet<SuffixDescriptor>)hashMap.get(ldapName);
                    if (hashSet2 != null) {
                        Iterator iterator = hashSet2.iterator();
                        while (iterator.hasNext() && !bl) {
                            SuffixDescriptor suffixDescriptor = (SuffixDescriptor)iterator.next();
                            Iterator<String> iterator2 = suffixDescriptor.getReplicationServers().iterator();
                            while (iterator2.hasNext() && !bl) {
                                if (!replicaDescriptor.getReplicationServers().contains(iterator2.next())) continue;
                                bl = true;
                                Set<ReplicaDescriptor> set2 = suffixDescriptor.getReplicas();
                                set2.add(replicaDescriptor);
                                suffixDescriptor.setReplicas(set2);
                                replicaDescriptor.setSuffix(suffixDescriptor);
                            }
                        }
                    }
                    if (bl) continue;
                    if (hashSet2 == null) {
                        hashSet2 = new HashSet<SuffixDescriptor>();
                        hashMap.put(ldapName, hashSet2);
                    }
                    hashSet2.add(replicaDescriptor.getSuffix());
                    this.suffixes.add(replicaDescriptor.getSuffix());
                }
                this.servers.add(serverDescriptor);
            }
            if (this.getFilter().searchMonitoringInformation()) {
                this.readReplicationMonitoring();
            }
        }
        catch (ADSContextException aDSContextException) {
            throw new TopologyCacheException(aDSContextException);
        }
        catch (Throwable throwable) {
            throw new TopologyCacheException(TopologyCacheException.Type.BUG, throwable);
        }
    }

    public ApplicationTrustManager getTrustManager() {
        return this.trustManager;
    }

    public int getConnectTimeout() {
        return this.timeout;
    }

    private void readReplicationMonitoring() {
        HashSet<ReplicaDescriptor> hashSet = new HashSet<ReplicaDescriptor>();
        for (ServerDescriptor serverDescriptor : this.getServers()) {
            for (ReplicaDescriptor object : serverDescriptor.getReplicas()) {
                if (!object.isReplicated()) continue;
                hashSet.add(object);
            }
        }
        for (ServerDescriptor serverDescriptor : this.getServers()) {
            if (serverDescriptor.isReplicationServer()) {
                HashSet hashSet2 = new HashSet();
                String string = serverDescriptor.getReplicationServerHostPort();
                block5: for (SuffixDescriptor suffixDescriptor : this.getSuffixes()) {
                    Set<String> set = suffixDescriptor.getReplicationServers();
                    for (String string2 : set) {
                        if (!string2.equalsIgnoreCase(string)) continue;
                        hashSet2.addAll(suffixDescriptor.getReplicas());
                        continue block5;
                    }
                }
                if (!hashSet2.isEmpty()) {
                    HashSet hashSet3 = new HashSet();
                    try {
                        this.updateReplicas(serverDescriptor, hashSet2, hashSet3);
                    }
                    catch (NamingException namingException) {
                        serverDescriptor.setLastException(new TopologyCacheException(TopologyCacheException.Type.GENERIC_READING_SERVER, (Throwable)namingException));
                    }
                    hashSet.removeAll(hashSet3);
                }
            }
            if (!hashSet.isEmpty()) continue;
            break;
        }
    }

    public void setPreferredConnections(LinkedHashSet<PreferredConnection> linkedHashSet) {
        this.preferredConnections.clear();
        this.preferredConnections.addAll(linkedHashSet);
    }

    public LinkedHashSet<PreferredConnection> getPreferredConnections() {
        return new LinkedHashSet<PreferredConnection>(this.preferredConnections);
    }

    public Set<ServerDescriptor> getServers() {
        HashSet<ServerDescriptor> hashSet = new HashSet<ServerDescriptor>();
        hashSet.addAll(this.servers);
        return hashSet;
    }

    public Set<SuffixDescriptor> getSuffixes() {
        HashSet<SuffixDescriptor> hashSet = new HashSet<SuffixDescriptor>();
        hashSet.addAll(this.suffixes);
        return hashSet;
    }

    public TopologyCacheFilter getFilter() {
        return this.filter;
    }

    private void joinThreadSet(Set<ServerLoader> set) {
        Date date = new Date();
        for (ServerLoader serverLoader : set) {
            long l = 90000L - System.currentTimeMillis() + date.getTime();
            try {
                if (l > 0L) {
                    serverLoader.join(90000L);
                }
            }
            catch (InterruptedException interruptedException) {
                LOG.log(Level.INFO, interruptedException + " caught and ignored", interruptedException);
            }
            if (!serverLoader.isAlive()) continue;
            serverLoader.interrupt();
        }
        Date date2 = new Date();
        long l = date2.getTime() - date.getTime();
        LOG.log(Level.INFO, "Loading ended at " + l + " ms");
    }

    private ServerLoader getServerLoader(Map<ADSContext.ServerProperty, Object> map) {
        return new ServerLoader(map, this.dn, this.pwd, this.trustManager == null ? null : this.trustManager.createCopy(), this.timeout, this.getPreferredConnections(), this.getFilter());
    }

    public ADSContext getAdsContext() {
        return this.adsContext;
    }

    public LinkedHashSet<Message> getErrorMessages() {
        HashSet<TopologyCacheException> hashSet = new HashSet<TopologyCacheException>();
        Set<ServerDescriptor> set = this.getServers();
        LinkedHashSet<Message> linkedHashSet = new LinkedHashSet<Message>();
        for (ServerDescriptor object : set) {
            TopologyCacheException topologyCacheException = object.getLastException();
            if (topologyCacheException == null) continue;
            hashSet.add(topologyCacheException);
        }
        block5: for (TopologyCacheException topologyCacheException : hashSet) {
            switch (topologyCacheException.getType()) {
                case NOT_GLOBAL_ADMINISTRATOR: {
                    linkedHashSet.add(QuickSetupMessages.INFO_NOT_GLOBAL_ADMINISTRATOR_PROVIDED.get());
                    continue block5;
                }
                case GENERIC_CREATING_CONNECTION: {
                    if (topologyCacheException.getCause() != null && Utils.isCertificateException(topologyCacheException.getCause())) {
                        linkedHashSet.add(QuickSetupMessages.INFO_ERROR_READING_CONFIG_LDAP_CERTIFICATE_SERVER.get(topologyCacheException.getHostPort(), topologyCacheException.getCause().getMessage()));
                        continue block5;
                    }
                    linkedHashSet.add(Utils.getMessage(topologyCacheException));
                    continue block5;
                }
            }
            linkedHashSet.add(Utils.getMessage(topologyCacheException));
        }
        return linkedHashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateReplicas(ServerDescriptor serverDescriptor, Collection<ReplicaDescriptor> collection, Collection<ReplicaDescriptor> collection2) throws NamingException {
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        searchControls.setReturningAttributes(new String[]{"approx-older-change-not-synchronized-millis", "missing-changes", "domain-name", "server-id"});
        String string = "(missing-changes=*)";
        LdapName ldapName = new LdapName("cn=monitor");
        InitialLdapContext initialLdapContext = null;
        NamingEnumeration<SearchResult> namingEnumeration = null;
        try {
            ServerLoader serverLoader = this.getServerLoader(serverDescriptor.getAdsProperties());
            initialLdapContext = serverLoader.createContext();
            namingEnumeration = initialLdapContext.search((Name)ldapName, string, searchControls);
            while (namingEnumeration.hasMore()) {
                SearchResult searchResult = namingEnumeration.next();
                String string2 = ConnectionUtils.getFirstValue(searchResult, "domain-name");
                int n = -1;
                try {
                    n = new Integer(ConnectionUtils.getFirstValue(searchResult, "server-id"));
                }
                catch (Throwable throwable) {
                    LOG.log(Level.WARNING, "Unexpected error reading replica ID: " + throwable, throwable);
                }
                for (ReplicaDescriptor replicaDescriptor : collection) {
                    if (!Utils.areDnsEqual(string2, replicaDescriptor.getSuffix().getDN()) || !replicaDescriptor.isReplicated() || replicaDescriptor.getReplicationId() != n) continue;
                    try {
                        replicaDescriptor.setAgeOfOldestMissingChange(new Long(ConnectionUtils.getFirstValue(searchResult, "approx-older-change-not-synchronized-millis")));
                    }
                    catch (Throwable throwable) {
                        LOG.log(Level.WARNING, "Unexpected error reading age of oldest change: " + throwable, throwable);
                    }
                    try {
                        replicaDescriptor.setMissingChanges(new Integer(ConnectionUtils.getFirstValue(searchResult, "missing-changes")));
                    }
                    catch (Throwable throwable) {
                        LOG.log(Level.WARNING, "Unexpected error reading missing changes: " + throwable, throwable);
                    }
                    collection2.add(replicaDescriptor);
                }
            }
        }
        catch (NameNotFoundException nameNotFoundException) {
        }
        finally {
            if (namingEnumeration != null) {
                namingEnumeration.close();
            }
            if (initialLdapContext != null) {
                initialLdapContext.close();
            }
        }
    }
}

