/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EnumSet;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.BuildInformation;

public class HistoricalRecord {
    private static final Logger LOG = Logger.getLogger(HistoricalRecord.class.getName());
    private static Message OPERATION = QuickSetupMessages.INFO_UPGRADE_LOG_FIELD_OP.get();
    private static Message TIME = QuickSetupMessages.INFO_UPGRADE_LOG_FIELD_TIME.get();
    private static Message FROM = QuickSetupMessages.INFO_UPGRADE_LOG_FIELD_FROM.get();
    private static Message TO = QuickSetupMessages.INFO_UPGRADE_LOG_FIELD_TO.get();
    private static Message STATUS = QuickSetupMessages.INFO_UPGRADE_LOG_FIELD_STATUS.get();
    private static Message NOTE = QuickSetupMessages.INFO_UPGRADE_LOG_FIELD_NOTE.get();
    private static String SEPARATOR = " ";
    private static String DATE_FORMAT = "yyyyMMddHHmmss";
    private Long operationId;
    private BuildInformation from;
    private BuildInformation to;
    private Status status;
    private Date date;
    private String note;
    private Exception creationError;

    public static HistoricalRecord fromString(String s) throws IllegalArgumentException {
        Long operationid = null;
        BuildInformation from = null;
        BuildInformation to = null;
        Status outcome = null;
        Date date = null;
        String note = null;
        Exception creationError = null;
        try {
            StringTokenizer st = new StringTokenizer(s, SEPARATOR);
            String token = st.nextToken();
            String operationIdString = token.substring(OPERATION.length());
            operationid = Long.parseLong(operationIdString);
            token = st.nextToken();
            String timeString = token.substring(TIME.length());
            date = new SimpleDateFormat(DATE_FORMAT).parse(timeString);
            token = st.nextToken();
            String fromString = token.substring(FROM.length());
            from = BuildInformation.fromBuildString(fromString);
            token = st.nextToken();
            String toString = token.substring(TO.length());
            to = BuildInformation.fromBuildString(toString);
            token = st.nextToken();
            String outcomeString = token.substring(STATUS.length());
            outcome = Status.fromString(outcomeString);
            if (st.hasMoreTokens() && (token = st.nextToken("")) != null) {
                note = token.substring(NOTE.length());
            }
        }
        catch (Exception e) {
            LOG.log(Level.INFO, "error creating historical log record", e);
            creationError = e;
        }
        return new HistoricalRecord(operationid, date, from, to, outcome, note, creationError);
    }

    public HistoricalRecord(BuildInformation from, BuildInformation to, Status status, String note) {
        this.from = from;
        this.to = to;
        this.status = status;
        this.date = new Date();
        this.operationId = this.date.getTime();
        this.note = note;
    }

    public HistoricalRecord(Long operationId, BuildInformation from, BuildInformation to, Status status, String note) {
        this.from = from;
        this.to = to;
        this.status = status;
        this.date = new Date();
        this.operationId = operationId;
        this.note = note;
    }

    private HistoricalRecord(Long operationId, Date date, BuildInformation from, BuildInformation to, Status status, String note, Exception creationError) {
        this.operationId = operationId;
        this.from = from;
        this.to = to;
        this.status = status;
        this.date = date;
        this.note = note;
        this.creationError = creationError;
    }

    public Long getOperationId() {
        return this.operationId;
    }

    public Date getDate() {
        return this.date;
    }

    public BuildInformation getFromVersion() {
        return this.from;
    }

    public BuildInformation getToVersion() {
        return this.to;
    }

    public Exception getCreationError() {
        return this.creationError;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OPERATION);
        sb.append(this.operationId != null ? this.operationId : QuickSetupMessages.INFO_GENERAL_UNSET.get());
        sb.append(SEPARATOR);
        sb.append(TIME);
        sb.append(new SimpleDateFormat(DATE_FORMAT).format(this.date));
        sb.append(SEPARATOR);
        sb.append(FROM);
        sb.append(this.from != null ? this.from.getBuildString() : QuickSetupMessages.INFO_GENERAL_UNSET.get());
        sb.append(SEPARATOR);
        sb.append(TO);
        sb.append(this.to != null ? this.to.getBuildString() : QuickSetupMessages.INFO_GENERAL_UNSET.get());
        sb.append(SEPARATOR);
        sb.append(STATUS);
        sb.append((Object)this.status);
        if (this.note != null) {
            sb.append(SEPARATOR).append(NOTE).append(this.note);
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        STARTED(QuickSetupMessages.INFO_UPGRADE_LOG_STATUS_STARTED.get()),
        SUCCESS(QuickSetupMessages.INFO_UPGRADE_LOG_STATUS_SUCCESS.get()),
        FAILURE(QuickSetupMessages.INFO_UPGRADE_LOG_STATUS_FAILURE.get()),
        CANCEL(QuickSetupMessages.INFO_UPGRADE_LOG_STATUS_CANCEL.get());

        private Message representation;

        public static Status fromString(String s) {
            Status retOc = null;
            EnumSet<Status> all = EnumSet.allOf(Status.class);
            for (Status oc : all) {
                if (!oc.toString().equals(s)) continue;
                retOc = oc;
            }
            return retOc;
        }

        public String toString() {
            return String.valueOf(this.representation);
        }

        private Status(Message representation) {
            this.representation = representation;
        }
    }
}

