/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.snmp;

import com.sun.management.snmp.UserAcl;
import java.util.SortedSet;
import org.opends.server.admin.std.meta.SNMPConnectionHandlerCfgDefn;
import org.opends.server.admin.std.server.SNMPConnectionHandlerCfg;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.snmp.SNMPConnectionHandlerDefinitions;

public class SNMPUserAcl
implements UserAcl {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final String ALL_USERS_ALLOWED = "*";
    private static final String DEFAULT_USER = "defaultUser";
    private static final String ADMIN_USER = "snmpAdmin";
    private SNMPConnectionHandlerCfg currentConfig;
    private SortedSet usersList;
    private SortedSet trapDestinations;
    private String contextName;
    private int securityLevel;

    public SNMPUserAcl(SNMPConnectionHandlerCfg configuration) {
        this.currentConfig = configuration;
        this.contextName = this.currentConfig.getCommunity();
        this.usersList = this.currentConfig.getAllowedUser();
        this.trapDestinations = this.currentConfig.getTrapsDestination();
        SNMPConnectionHandlerCfgDefn.SecurityLevel level = this.currentConfig.getSecurityLevel();
        this.securityLevel = SNMPConnectionHandlerDefinitions.SECURITY_LEVELS.get(level.toString());
    }

    public String getName() {
        return "OpenDS";
    }

    public boolean checkReadPermission(String user) {
        if (user.equals(DEFAULT_USER)) {
            return false;
        }
        if (user.equals(ADMIN_USER)) {
            return false;
        }
        return this.usersList.contains(ALL_USERS_ALLOWED) || this.usersList.contains(user);
    }

    public boolean checkReadPermission(String user, String contextName, int securityLevel) {
        if (user.equals(ADMIN_USER) && contextName.equals("null") && this.checkSecurityLevel(securityLevel)) {
            return true;
        }
        return this.checkReadPermission(user) && this.checkContextName(contextName) && this.checkSecurityLevel(securityLevel);
    }

    public boolean checkContextName(String contextName) {
        return this.contextName.equals(contextName);
    }

    public boolean checkWritePermission(String user) {
        return user.equals(ADMIN_USER);
    }

    public boolean checkWritePermission(String user, String contextName, int securityLevel) {
        return this.checkWritePermission(user) && contextName.equals("null") && this.checkSecurityLevel(securityLevel);
    }

    private boolean checkSecurityLevel(int securityLevel) {
        return securityLevel >= this.securityLevel;
    }
}

