/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel;

import java.io.File;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opends.guitools.controlpanel.ControlPanelArgumentParser;
import org.opends.guitools.controlpanel.ControlPanelSplashScreen;
import org.opends.guitools.controlpanel.ErrorReturnCode;
import org.opends.guitools.controlpanel.util.ControlPanelLog;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.quicksetup.ui.UIFactory;
import org.opends.quicksetup.util.Utils;
import org.opends.server.util.DynamicConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;

public class ControlPanelLauncher {
    private static ControlPanelArgumentParser argParser;
    public static final String LOG_FILE_PREFIX = "opends-control-panel-";
    public static final String LOG_FILE_SUFFIX = ".log";
    private static final Logger LOG;

    public static void main(String[] args) {
        int exitCode;
        try {
            ControlPanelLog.initLogFileHandler(File.createTempFile(LOG_FILE_PREFIX, LOG_FILE_SUFFIX));
        }
        catch (Throwable t) {
            System.err.println("Unable to initialize log");
            t.printStackTrace();
        }
        argParser = new ControlPanelArgumentParser(ControlPanelLauncher.class.getName(), AdminToolMessages.INFO_CONTROL_PANEL_LAUNCHER_USAGE_DESCRIPTION.get());
        try {
            argParser.initializeArguments();
            argParser.parseArguments(args);
        }
        catch (ArgumentException ae) {
            Message message = ToolMessages.ERR_ERROR_PARSING_ARGS.get(ae.getMessage());
            System.err.println(message);
            System.out.println(Message.raw(argParser.getUsage(), new Object[0]));
            System.exit(ErrorReturnCode.ERROR_PARSING_ARGS.getReturnCode());
        }
        if (!argParser.usageOrVersionDisplayed() && (exitCode = ControlPanelLauncher.launchControlPanel(args)) != 0) {
            String logFileName = null;
            if (ControlPanelLog.getLogFile() != null) {
                logFileName = ControlPanelLog.getLogFile().toString();
            }
            if (logFileName != null) {
                System.err.println(StaticUtils.wrapText(AdminToolMessages.ERR_CONTROL_PANEL_LAUNCHER_GUI_LAUNCH_FAILED_DETAILS.get(logFileName), Utils.getCommandLineMaxLineWidth()));
            } else {
                System.err.println(StaticUtils.wrapText(AdminToolMessages.ERR_CONTROL_PANEL_LAUNCHER_GUI_LAUNCH_FAILED.get(), Utils.getCommandLineMaxLineWidth()));
            }
            System.exit(exitCode);
        }
    }

    private static int launchControlPanel(final String[] args) {
        final int[] returnValue = new int[]{-1};
        Thread t = new Thread(new Runnable(){

            public void run() {
                block6: {
                    try {
                        try {
                            ControlPanelLauncher.initLookAndFeel();
                        }
                        catch (Throwable t) {
                            LOG.log(Level.WARNING, "Error setting look and feel: " + t, t);
                        }
                        ControlPanelSplashScreen.main(args);
                        returnValue[0] = 0;
                    }
                    catch (Throwable t) {
                        if (!ControlPanelLog.isInitialized()) break block6;
                        LOG.log(Level.WARNING, "Error launching GUI: " + t);
                        StringBuilder buf = new StringBuilder();
                        while (t != null) {
                            StackTraceElement[] stack = t.getStackTrace();
                            for (int i = 0; i < stack.length; ++i) {
                                buf.append(stack[i].toString() + "\n");
                            }
                            if ((t = t.getCause()) == null) continue;
                            buf.append("Root cause:\n");
                        }
                        LOG.log(Level.WARNING, buf.toString());
                    }
                }
            }
        });
        PrintStream printStream = System.err;
        System.setErr(Utils.getEmptyPrintStream());
        t.start();
        try {
            t.join();
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        System.setErr(printStream);
        return returnValue[0];
    }

    private static void initLookAndFeel() throws Throwable {
        Message title = Utils.getCustomizedObject("INFO_CONTROL_PANEL_TITLE", AdminToolMessages.INFO_CONTROL_PANEL_TITLE.get(DynamicConstants.PRODUCT_NAME), Message.class);
        Utils.setMacOSXMenuBar(title);
        UIFactory.initializeLookAndFeel();
    }

    static {
        LOG = Logger.getLogger(ControlPanelLauncher.class.getName());
    }
}

