/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.opends.guitools.controlpanel.event.ConfigurationChangeEvent;
import org.opends.guitools.controlpanel.task.AddToGroupTask;
import org.opends.guitools.controlpanel.task.Task;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.GenericDialog;
import org.opends.guitools.controlpanel.ui.LDAPEntrySelectionPanel;
import org.opends.guitools.controlpanel.ui.ProgressDialog;
import org.opends.guitools.controlpanel.ui.StatusGenericPanel;
import org.opends.guitools.controlpanel.ui.nodes.BrowserNodeInfo;
import org.opends.guitools.controlpanel.ui.nodes.DndBrowserNodes;
import org.opends.guitools.controlpanel.util.BackgroundTask;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.server.types.DN;
import org.opends.server.types.OpenDsException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddToGroupPanel
extends StatusGenericPanel {
    private static final long serialVersionUID = 1837745944604435848L;
    private JTextArea groups;
    private JTextArea entries;
    private JScrollPane scrollEntries;
    private JLabel lEntries = Utilities.createDefaultLabel();
    private JLabel lGroups = Utilities.createDefaultLabel();
    private LinkedHashSet<DN> dns = new LinkedHashSet();
    private GenericDialog browseGroupDlg;
    private LDAPEntrySelectionPanel browseGroupPanel;

    public AddToGroupPanel() {
        this.createLayout();
    }

    public void setEntriesToAdd(Set<DN> dns) {
        ArrayList<String> sDns = new ArrayList<String>();
        for (DN dn : dns) {
            sDns.add(dn.toString());
        }
        if (dns.size() > 5) {
            this.entries.setText(Utilities.getStringFromCollection(sDns, "\n"));
            this.scrollEntries.setVisible(true);
            this.lEntries.setVisible(false);
        } else {
            this.lEntries.setText("<html>" + Utilities.applyFont("<li>" + Utilities.getStringFromCollection(sDns, "<li>"), ColorAndFontConstants.defaultFont));
            this.scrollEntries.setVisible(false);
            this.lEntries.setVisible(true);
        }
        this.dns.clear();
        this.dns.addAll(dns);
        this.packParentDialog();
    }

    @Override
    public Component getPreferredFocusComponent() {
        return this.groups;
    }

    @Override
    public void okClicked() {
        final ArrayList errors = new ArrayList();
        BackgroundTask<Void> worker = new BackgroundTask<Void>(){

            @Override
            public Void processBackgroundTask() {
                try {
                    Thread.sleep(2000L);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                AddToGroupPanel.this.updateErrors(errors);
                return null;
            }

            @Override
            public void backgroundTaskCompleted(Void returnValue, Throwable t) {
                if (t != null) {
                    errors.add(AdminToolMessages.ERR_CTRL_PANEL_UNEXPECTED_DETAILS.get(t.toString()));
                }
                AddToGroupPanel.this.displayMainPanel();
                AddToGroupPanel.this.setEnabledCancel(true);
                AddToGroupPanel.this.setEnabledOK(true);
                AddToGroupPanel.this.handleErrorsAndLaunchTask(errors);
            }
        };
        this.displayMessage(AdminToolMessages.INFO_CTRL_PANEL_CHECKING_SUMMARY.get());
        this.setEnabledCancel(false);
        this.setEnabledOK(false);
        worker.startBackgroundTask();
    }

    @Override
    public Message getTitle() {
        return AdminToolMessages.INFO_CTRL_PANEL_ADD_TO_GROUP_TITLE.get();
    }

    @Override
    public void configurationChanged(ConfigurationChangeEvent ev) {
    }

    private void createLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        JLabel l = Utilities.createDefaultLabel(AdminToolMessages.INFO_CTRL_PANEL_ADD_TO_GROUP_ENTRIES_LABEL.get());
        this.add((Component)l, gbc);
        gbc.insets.top = 5;
        this.entries = Utilities.createNonEditableTextArea(Message.EMPTY, 6, 40);
        this.scrollEntries = Utilities.createScrollPane(this.entries);
        gbc.weighty = 0.1;
        gbc.fill = 1;
        ++gbc.gridy;
        this.add((Component)this.scrollEntries, gbc);
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.insets.top = 0;
        this.add((Component)this.lEntries, gbc);
        gbc.insets.top = 10;
        ++gbc.gridy;
        this.lGroups.setText(AdminToolMessages.INFO_CTRL_PANEL_ADD_TO_GROUP_GROUPS_LABEL.get().toString());
        this.add((Component)this.lGroups, gbc);
        gbc.insets.top = 5;
        gbc.gridwidth = 1;
        this.groups = Utilities.createTextArea(Message.EMPTY, 8, 40);
        JScrollPane scrollGroups = Utilities.createScrollPane(this.groups);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        ++gbc.gridy;
        this.add((Component)scrollGroups, gbc);
        ++gbc.gridx;
        gbc.insets.left = 5;
        gbc.weightx = 0.0;
        gbc.fill = 2;
        JButton browse = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_ADD_GROUPS_BUTTON_LABEL.get());
        gbc.anchor = 11;
        this.add((Component)browse, gbc);
        browse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                AddToGroupPanel.this.browseGroupsClicked();
            }
        });
        DropTargetListener dropTargetlistener = new DropTargetListener(){

            public void dragEnter(DropTargetDragEvent e) {
            }

            public void dragExit(DropTargetEvent e) {
            }

            public void dragOver(DropTargetDragEvent e) {
            }

            public void dropActionChanged(DropTargetDragEvent e) {
            }

            public void drop(DropTargetDropEvent e) {
                try {
                    Transferable tr = e.getTransferable();
                    if (!tr.isDataFlavorSupported(DndBrowserNodes.INFO_FLAVOR)) {
                        e.rejectDrop();
                    }
                    DndBrowserNodes nodes = (DndBrowserNodes)tr.getTransferData(DndBrowserNodes.INFO_FLAVOR);
                    StringBuilder sb = new StringBuilder();
                    sb.append(AddToGroupPanel.this.groups.getText());
                    for (BrowserNodeInfo node : nodes.getNodes()) {
                        if (sb.length() > 0) {
                            sb.append("\n");
                        }
                        sb.append(node.getNode().getDN());
                    }
                    AddToGroupPanel.this.groups.setText(sb.toString());
                    AddToGroupPanel.this.groups.setCaretPosition(sb.length());
                    e.acceptDrop(3);
                    e.getDropTargetContext().dropComplete(true);
                }
                catch (IOException io) {
                    e.rejectDrop();
                }
                catch (UnsupportedFlavorException ufe) {
                    e.rejectDrop();
                }
            }
        };
        new DropTarget(this.groups, dropTargetlistener);
    }

    private void browseGroupsClicked() {
        if (this.browseGroupDlg == null) {
            this.browseGroupPanel = new LDAPEntrySelectionPanel();
            this.browseGroupPanel.setTitle(AdminToolMessages.INFO_CTRL_PANEL_CHOOSE_GROUP_TITLE.get());
            this.browseGroupPanel.setFilter(LDAPEntrySelectionPanel.Filter.STATIC_GROUPS);
            this.browseGroupPanel.setMultipleSelection(true);
            this.browseGroupPanel.setInfo(this.getInfo());
            this.browseGroupDlg = new GenericDialog(Utilities.getFrame(this), this.browseGroupPanel);
            Utilities.centerGoldenMean(this.browseGroupDlg, Utilities.getParentDialog(this));
            this.browseGroupDlg.setModal(true);
        }
        this.browseGroupDlg.setVisible(true);
        String[] dns = this.browseGroupPanel.getDNs();
        if (dns.length > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.groups.getText());
            for (String dn : dns) {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(dn);
            }
            this.groups.setText(sb.toString());
            this.groups.setCaretPosition(sb.length());
        }
    }

    private void updateErrors(List<Message> errors) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AddToGroupPanel.this.setPrimaryValid(AddToGroupPanel.this.lGroups);
            }
        });
        String[] grs = this.groups.getText().split("\n");
        boolean oneGroupDefined = false;
        for (String groupDn : grs) {
            if ((groupDn = groupDn.trim()).length() <= 0) continue;
            try {
                DN.decode(groupDn);
                if (!this.entryExists(groupDn)) {
                    errors.add(AdminToolMessages.ERR_CTRL_PANEL_GROUP_COULD_NOT_BE_FOUND.get(groupDn));
                    continue;
                }
                if (!this.hasObjectClass(groupDn, "groupOfUniqueNames")) {
                    errors.add(AdminToolMessages.ERR_CTRL_PANEL_NOT_A_STATIC_GROUP.get(groupDn));
                    continue;
                }
                oneGroupDefined = true;
            }
            catch (OpenDsException ode) {
                errors.add(AdminToolMessages.INFO_CTRL_PANEL_INVALID_DN_DETAILS.get(groupDn, ode.getMessageObject().toString()));
            }
        }
        if (!oneGroupDefined && errors.isEmpty()) {
            errors.add(AdminToolMessages.ERR_CTRL_PANEL_GROUP_NOT_PROVIDED.get());
        }
        if (!errors.isEmpty()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    AddToGroupPanel.this.setPrimaryInvalid(AddToGroupPanel.this.lGroups);
                }
            });
        }
    }

    private void handleErrorsAndLaunchTask(ArrayList<Message> errors) {
        if (errors.size() == 0) {
            ProgressDialog dlg = new ProgressDialog(Utilities.createFrame(), Utilities.getParentDialog(this), AdminToolMessages.INFO_CTRL_PANEL_ADD_TO_GROUP_TITLE.get(), this.getInfo());
            LinkedHashSet<DN> groupDns = new LinkedHashSet<DN>();
            String[] grs = this.groups.getText().split("\n");
            try {
                for (String groupDn : grs) {
                    if ((groupDn = groupDn.trim()).length() <= 0) continue;
                    groupDns.add(DN.decode(groupDn));
                }
            }
            catch (OpenDsException ode) {
                throw new RuntimeException("Unexpected error decoding dn. Details: " + ode.getMessageObject(), ode);
            }
            try {
                AddToGroupTask newTask = new AddToGroupTask(this.getInfo(), dlg, this.dns, groupDns);
                for (Task task : this.getInfo().getTasks()) {
                    task.canLaunch(newTask, errors);
                }
                if (errors.size() == 0) {
                    this.launchOperation(newTask, AdminToolMessages.INFO_CTRL_PANEL_ADDING_TO_GROUP_SUMMARY.get(), AdminToolMessages.INFO_CTRL_PANEL_ADDING_TO_GROUP_SUCCESSFUL_SUMMARY.get(), AdminToolMessages.INFO_CTRL_PANEL_ADDING_TO_GROUP_SUCCESSFUL_DETAILS.get(), AdminToolMessages.ERR_CTRL_PANEL_ADDING_TO_GROUP_ERROR_SUMMARY.get(), AdminToolMessages.ERR_CTRL_PANEL_ADDING_TO_GROUP_ERROR_DETAILS.get(), null, dlg);
                    dlg.setVisible(true);
                    Utilities.getParentDialog(this).setVisible(false);
                }
            }
            catch (Throwable t) {
                throw new RuntimeException("Unexpected error: " + t, t);
            }
        }
        if (errors.size() > 0) {
            this.displayErrorDialog(errors);
        }
    }
}

