/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.opends.guitools.controlpanel.datamodel.ControlPanelInfo;
import org.opends.guitools.controlpanel.datamodel.CustomSearchResult;
import org.opends.guitools.controlpanel.datamodel.ServerDescriptor;
import org.opends.guitools.controlpanel.datamodel.TaskTableModel;
import org.opends.guitools.controlpanel.event.ConfigurationChangeEvent;
import org.opends.guitools.controlpanel.task.CancelTaskTask;
import org.opends.guitools.controlpanel.task.Task;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.GenericDialog;
import org.opends.guitools.controlpanel.ui.MainMenuBar;
import org.opends.guitools.controlpanel.ui.MonitoringAttributesViewPanel;
import org.opends.guitools.controlpanel.ui.ProgressDialog;
import org.opends.guitools.controlpanel.ui.StatusGenericPanel;
import org.opends.guitools.controlpanel.ui.renderer.TaskCellRenderer;
import org.opends.guitools.controlpanel.util.ConfigFromFile;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.quicksetup.util.Utils;
import org.opends.server.core.DirectoryServer;
import org.opends.server.tools.tasks.TaskEntry;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeBuilder;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AttributeValues;
import org.opends.server.types.ByteString;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.OpenDsException;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManageTasksPanel
extends StatusGenericPanel {
    private static final long serialVersionUID = -8034784684412532193L;
    private JLabel lNoTasksFound;
    private JButton cancelTask;
    private JScrollPane tableScroll;
    private JTable taskTable;
    private TaskTableModel tableModel;
    private ManageTasksMenuBar menuBar;
    private MonitoringAttributesViewPanel<Message> operationViewPanel;
    private GenericDialog operationViewDlg;
    private JPanel detailsPanel;
    private JLabel noDetailsLabel;
    private JPanel detailsSubpanel;
    private JLabel logsLabel;
    private JScrollPane logsScroll;
    private JTextArea logs;
    private JLabel noLogsLabel;
    private static final Logger LOG = Logger.getLogger(ManageTasksPanel.class.getName());

    public ManageTasksPanel() {
        this.createLayout();
    }

    @Override
    public Message getTitle() {
        return AdminToolMessages.INFO_CTRL_PANEL_TASK_TO_SCHEDULE_LIST_TITLE.get();
    }

    @Override
    public boolean requiresScroll() {
        return false;
    }

    @Override
    public GenericDialog.ButtonType getButtonType() {
        return GenericDialog.ButtonType.CLOSE;
    }

    @Override
    public void okClicked() {
    }

    @Override
    public JMenuBar getMenuBar() {
        if (this.menuBar == null) {
            this.menuBar = new ManageTasksMenuBar(this.getInfo());
        }
        return this.menuBar;
    }

    @Override
    public Component getPreferredFocusComponent() {
        return this.taskTable;
    }

    private List<TaskEntry> getSelectedTasks(boolean onlyCancelable) {
        int[] rows;
        ArrayList<TaskEntry> tasks = new ArrayList<TaskEntry>();
        for (int row : rows = this.taskTable.getSelectedRows()) {
            if (row == -1) continue;
            TaskEntry task = this.tableModel.get(row);
            if (onlyCancelable && !task.isCancelable()) continue;
            tasks.add(task);
        }
        return tasks;
    }

    private void createLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        this.addErrorPane(gbc);
        gbc.weightx = 0.0;
        ++gbc.gridy;
        gbc.anchor = 17;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.gridwidth = 2;
        gbc.insets.left = 0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.lNoTasksFound = Utilities.createDefaultLabel(AdminToolMessages.INFO_CTRL_PANEL_NO_TASKS_FOUND.get());
        ++gbc.gridy;
        gbc.anchor = 10;
        gbc.gridheight = 2;
        this.add((Component)this.lNoTasksFound, gbc);
        this.lNoTasksFound.setVisible(false);
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets.top = 10;
        gbc.anchor = 18;
        this.tableModel = new TaskTableModel(){
            private static final long serialVersionUID = 55555512319230987L;

            public void forceResort() {
                Set selectedIds = ManageTasksPanel.this.getSelectedIds();
                super.forceResort();
                ManageTasksPanel.this.setSelectedIds(selectedIds);
            }
        };
        this.tableModel.setData(this.createDummyTaskList());
        this.taskTable = Utilities.createSortableTable(this.tableModel, new TaskCellRenderer());
        this.taskTable.getSelectionModel().setSelectionMode(2);
        this.tableScroll = Utilities.createScrollPane(this.taskTable);
        this.add((Component)this.tableScroll, gbc);
        this.updateTableSizes();
        int height = this.taskTable.getPreferredScrollableViewportSize().height;
        this.add(Box.createVerticalStrut(height), gbc);
        gbc.gridx = 1;
        gbc.gridheight = 1;
        gbc.anchor = 13;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.cancelTask = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_CANCEL_TASK_BUTTON_LABEL.get());
        this.cancelTask.setOpaque(false);
        gbc.insets.left = 10;
        this.add((Component)this.cancelTask, gbc);
        ++gbc.gridy;
        gbc.weighty = 1.0;
        gbc.fill = 3;
        this.add(Box.createVerticalGlue(), gbc);
        this.cancelTask.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                ManageTasksPanel.this.cancelTaskClicked();
            }
        });
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.insets.top = 15;
        gbc.insets.left = 0;
        this.logsLabel = Utilities.createDefaultLabel(AdminToolMessages.INFO_CTRL_PANEL_TASK_LOG_LABEL.get());
        this.logsLabel.setFont(ColorAndFontConstants.titleFont);
        this.add((Component)this.logsLabel, gbc);
        this.logs = Utilities.createNonEditableTextArea(Message.EMPTY, 5, 50);
        this.logs.setFont(ColorAndFontConstants.defaultFont);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.7;
        ++gbc.gridy;
        gbc.insets.top = 5;
        this.logsScroll = Utilities.createScrollPane(this.logs);
        this.add((Component)this.logsScroll, gbc);
        height = this.logs.getPreferredSize().height;
        this.add(Box.createVerticalStrut(height), gbc);
        this.logsScroll.setVisible(false);
        gbc.anchor = 10;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.noLogsLabel = Utilities.createDefaultLabel(AdminToolMessages.INFO_CTRL_PANEL_NO_TASK_SELECTED.get());
        this.add((Component)this.noLogsLabel, gbc);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.8;
        ++gbc.gridy;
        gbc.insets.left = 0;
        gbc.insets.top = 15;
        this.createDetailsPanel();
        this.add((Component)this.detailsPanel, gbc);
        ListSelectionListener listener = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent ev) {
                ManageTasksPanel.this.tableSelected();
            }
        };
        this.taskTable.getSelectionModel().addListSelectionListener(listener);
        listener.valueChanged(null);
    }

    private void createDetailsPanel() {
        this.detailsPanel = new JPanel(new GridBagLayout());
        this.detailsPanel.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 18;
        JLabel label = Utilities.createDefaultLabel(AdminToolMessages.INFO_CTRL_PANEL_TASK_SPECIFIC_DETAILS.get());
        label.setFont(ColorAndFontConstants.titleFont);
        this.detailsPanel.add((Component)label, gbc);
        ++gbc.gridy;
        gbc.anchor = 10;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.noDetailsLabel = Utilities.createDefaultLabel(AdminToolMessages.INFO_CTRL_PANEL_NO_TASK_SELECTED.get());
        gbc.gridwidth = 2;
        this.detailsPanel.add((Component)this.noDetailsLabel, gbc);
        this.detailsSubpanel = new JPanel(new GridBagLayout());
        this.detailsSubpanel.setOpaque(false);
        gbc.anchor = 18;
        gbc.fill = 1;
        this.detailsPanel.add((Component)Utilities.createBorderLessScrollBar(this.detailsSubpanel), gbc);
        this.detailsPanel.add(Box.createVerticalStrut(this.logs.getPreferredSize().height), gbc);
    }

    private void tableSelected() {
        List<TaskEntry> tasks = this.getSelectedTasks(true);
        this.cancelTask.setEnabled(!tasks.isEmpty());
        this.detailsSubpanel.removeAll();
        tasks = this.getSelectedTasks(false);
        boolean displayContents = false;
        if (tasks.isEmpty()) {
            this.noDetailsLabel.setText(AdminToolMessages.INFO_CTRL_PANEL_NO_TASK_SELECTED.get().toString());
            this.logsScroll.setVisible(false);
            this.noLogsLabel.setText(AdminToolMessages.INFO_CTRL_PANEL_NO_TASK_SELECTED.get().toString());
            this.noLogsLabel.setVisible(true);
        } else if (tasks.size() > 1) {
            this.noDetailsLabel.setText(AdminToolMessages.INFO_CTRL_PANEL_MULTIPLE_TASKS_SELECTED.get().toString());
            this.logsScroll.setVisible(false);
            this.noLogsLabel.setText(AdminToolMessages.INFO_CTRL_PANEL_MULTIPLE_TASKS_SELECTED.get().toString());
            this.noLogsLabel.setVisible(true);
        } else {
            TaskEntry taskEntry = tasks.iterator().next();
            Map<Message, List<String>> taskSpecificAttrs = taskEntry.getTaskSpecificAttributeValuePairs();
            List<Message> lastLogMessages = taskEntry.getLogMessages();
            if (!lastLogMessages.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (Message msg : lastLogMessages) {
                    if (sb.length() != 0) {
                        sb.append("\n");
                    }
                    sb.append(msg);
                }
                this.logs.setText(sb.toString());
            } else {
                this.logs.setText("");
            }
            this.logsScroll.setVisible(true);
            this.noLogsLabel.setVisible(false);
            if (taskSpecificAttrs.isEmpty()) {
                this.noDetailsLabel.setText(AdminToolMessages.INFO_CTRL_PANEL_NO_TASK_SPECIFIC_DETAILS.get().toString());
            } else {
                displayContents = true;
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridy = 0;
                gbc.fill = 0;
                gbc.anchor = 18;
                gbc.insets.top = 10;
                for (Message label : taskSpecificAttrs.keySet()) {
                    List<String> values = taskSpecificAttrs.get(label);
                    gbc.gridx = 0;
                    gbc.insets.left = 10;
                    gbc.insets.right = 0;
                    this.detailsSubpanel.add((Component)Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_OPERATION_NAME_AS_LABEL.get(label.toString())), gbc);
                    gbc.gridx = 1;
                    gbc.insets.right = 10;
                    String s = Utils.getStringFromCollection(values, "\n");
                    this.detailsSubpanel.add((Component)Utilities.makeHtmlPane(s, ColorAndFontConstants.defaultFont), gbc);
                    ++gbc.gridy;
                }
                gbc.gridx = 0;
                gbc.gridwidth = 2;
                gbc.weightx = 1.0;
                gbc.weighty = 1.0;
                gbc.fill = 1;
                this.detailsSubpanel.add(Box.createGlue(), gbc);
            }
        }
        this.noDetailsLabel.setVisible(!displayContents);
        this.revalidate();
        this.repaint();
    }

    private Set<TaskEntry> createRandomTasksList() {
        HashSet<TaskEntry> list = new HashSet<TaskEntry>();
        Random r = new Random();
        int numberTasks = r.nextInt(10);
        for (int i = 0; i < numberTasks; ++i) {
            CustomSearchResult csr = new CustomSearchResult("cn=mytask" + i + ",cn=tasks");
            String p = "ds-task-";
            String[] attrNames = new String[]{p + "id", p + "class-name", p + "state", p + "scheduled-start-time", p + "actual-start-time", p + "completion-time", p + "dependency-id", p + "failed-dependency-action", p + "log-message", p + "notify-on-error", p + "notify-on-completion", p + "ds-recurring-task-schedule"};
            String[] values = new String[]{"ID", "TheClassName", "TheState", "Schedule Start Time", "Actual Start Time", "Completion Time", "Dependency ID", "Failed Dependency Action", "Log Message.                              Should be pretty longLog Message.                              Should be pretty longLog Message.                              Should be pretty longLog Message.                              Should be pretty longLog Message.                              Should be pretty long", "Notify On Error", "Notify On Completion", "Recurring Task Schedule"};
            for (int j = 0; j < attrNames.length; ++j) {
                ArrayList<Object> attrValues = new ArrayList<Object>(1);
                attrValues.add(values[j] + r.nextInt());
                csr.set(attrNames[j], attrValues);
            }
            try {
                Entry entry = ManageTasksPanel.getEntry(csr);
                TaskEntry task = new TaskEntry(entry);
                list.add(task);
                continue;
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, "Error getting entry '" + csr.getDN() + "': " + t, t);
            }
        }
        return list;
    }

    private Set<TaskEntry> createDummyTaskList() {
        HashSet<TaskEntry> list = new HashSet<TaskEntry>();
        for (int i = 0; i < 10; ++i) {
            CustomSearchResult csr = new CustomSearchResult("cn=mytask" + i + ",cn=tasks");
            String p = "ds-task-";
            String[] attrNames = new String[]{p + "id", p + "class-name", p + "state", p + "scheduled-start-time", p + "actual-start-time", p + "completion-time", p + "dependency-id", p + "failed-dependency-action", p + "log-message", p + "notify-on-error", p + "notify-on-completion", p + "ds-recurring-task-schedule"};
            String[] values = new String[]{"A very 29-backup - Sun Mar 29 00:00:00 MET 2009", "A long task type", "A very long task status", "Schedule Start Time", "Actual Start Time", "Completion Time", "Dependency ID", "Failed Dependency Action", "Log Message.                              Should be pretty long\nLog Message.                              Should be pretty long\nLog Message.                              Should be pretty long\nLog Message.                              Should be pretty long\nLog Message.                              Should be pretty long\n", "Notify On Error", "Notify On Completion", "Recurring Task Schedule"};
            for (int j = 0; j < attrNames.length; ++j) {
                ArrayList<Object> attrValues = new ArrayList<Object>(1);
                attrValues.add(values[j]);
                csr.set(attrNames[j], attrValues);
            }
            try {
                Entry entry = ManageTasksPanel.getEntry(csr);
                TaskEntry task = new TaskEntry(entry);
                list.add(task);
                continue;
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, "Error getting entry '" + csr.getDN() + "': " + t, t);
            }
        }
        return list;
    }

    private void cancelTaskClicked() {
        boolean confirmed;
        ArrayList<Message> errors = new ArrayList<Message>();
        ProgressDialog dlg = new ProgressDialog(Utilities.createFrame(), Utilities.getParentDialog(this), AdminToolMessages.INFO_CTRL_PANEL_CANCEL_TASK_TITLE.get(), this.getInfo());
        List<TaskEntry> tasks = this.getSelectedTasks(true);
        CancelTaskTask newTask = new CancelTaskTask(this.getInfo(), dlg, tasks);
        for (Task task : this.getInfo().getTasks()) {
            task.canLaunch(newTask, errors);
        }
        if (errors.size() == 0 && (confirmed = this.displayConfirmationDialog(AdminToolMessages.INFO_CTRL_PANEL_CONFIRMATION_REQUIRED_SUMMARY.get(), AdminToolMessages.INFO_CTRL_PANEL_CANCEL_TASK_MSG.get()))) {
            this.launchOperation(newTask, AdminToolMessages.INFO_CTRL_PANEL_CANCELING_TASK_SUMMARY.get(), AdminToolMessages.INFO_CTRL_PANEL_CANCELING_TASK_COMPLETE.get(), AdminToolMessages.INFO_CTRL_PANEL_CANCELING_TASK_SUCCESSFUL.get(), AdminToolMessages.ERR_CTRL_PANEL_CANCELING_TASK_ERROR_SUMMARY.get(), AdminToolMessages.ERR_CTRL_PANEL_CANCELING_TASK_ERROR_DETAILS.get(), null, dlg);
            dlg.setVisible(true);
        }
    }

    public static Entry getEntry(CustomSearchResult csr) throws OpenDsException {
        DN dn = DN.decode(csr.getDN());
        HashMap<ObjectClass, String> objectClasses = new HashMap<ObjectClass, String>();
        HashMap<AttributeType, List<Attribute>> userAttributes = new HashMap<AttributeType, List<Attribute>>();
        HashMap<AttributeType, List<Attribute>> operationalAttributes = new HashMap<AttributeType, List<Attribute>>();
        for (String wholeName : csr.getAttributeNames()) {
            Attribute attribute = ManageTasksPanel.parseAttrDescription(wholeName);
            String attrName = attribute.getName();
            String lowerName = StaticUtils.toLowerCase(attrName);
            if (lowerName.equals("objectclass")) {
                for (Object value : csr.getAttributeValues(attrName)) {
                    String ocName = value.toString().trim();
                    String lowerOCName = StaticUtils.toLowerCase(ocName);
                    ObjectClass objectClass = DirectoryServer.getObjectClass(lowerOCName);
                    if (objectClass == null) {
                        objectClass = DirectoryServer.getDefaultObjectClass(ocName);
                    }
                    objectClasses.put(objectClass, ocName);
                }
                continue;
            }
            AttributeType attrType = DirectoryServer.getAttributeType(lowerName);
            if (attrType == null) {
                attrType = DirectoryServer.getDefaultAttributeType(attrName);
            }
            AttributeBuilder builder = new AttributeBuilder(attribute, true);
            for (Object value : csr.getAttributeValues(attrName)) {
                ByteString bs = value instanceof byte[] ? ByteString.wrap((byte[])value) : ByteString.valueOf(value.toString());
                AttributeValue attributeValue = AttributeValues.create(attrType, bs);
                builder.add(attributeValue);
            }
            ArrayList<Attribute> attrList = new ArrayList<Attribute>(1);
            attrList.add(builder.toAttribute());
            if (attrType.isOperational()) {
                operationalAttributes.put(attrType, attrList);
                continue;
            }
            userAttributes.put(attrType, attrList);
        }
        return new Entry(dn, objectClasses, userAttributes, operationalAttributes);
    }

    private static Attribute parseAttrDescription(String attrDescr) {
        AttributeBuilder builder;
        int semicolonPos = attrDescr.indexOf(59);
        if (semicolonPos > 0) {
            String option;
            builder = new AttributeBuilder(attrDescr.substring(0, semicolonPos));
            int nextPos = attrDescr.indexOf(59, semicolonPos + 1);
            while (nextPos > 0) {
                option = attrDescr.substring(semicolonPos + 1, nextPos);
                if (option.length() <= 0) continue;
                builder.setOption(option);
                semicolonPos = nextPos;
                nextPos = attrDescr.indexOf(59, semicolonPos + 1);
            }
            option = attrDescr.substring(semicolonPos + 1);
            if (option.length() > 0) {
                builder.setOption(option);
            }
        } else {
            builder = new AttributeBuilder(attrDescr);
        }
        if (builder.getAttributeType().isBinary()) {
            builder.setOption("binary");
        }
        return builder.toAttribute();
    }

    public static void main(String[] args) {
        new ConfigFromFile();
        final ManageTasksPanel p = new ManageTasksPanel();
        Thread t = new Thread(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(5000L);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                while (p.isVisible()) {
                    try {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                boolean visible;
                                Set tasks = p.createRandomTasksList();
                                p.tableModel.setData(tasks);
                                boolean bl = visible = p.tableModel.getRowCount() > 0;
                                if (visible) {
                                    p.updateTableSizes();
                                }
                                p.tableModel.fireTableDataChanged();
                                p.lNoTasksFound.setVisible(!visible);
                                p.tableScroll.setVisible(visible);
                                p.cancelTask.setVisible(visible);
                            }
                        });
                        Thread.sleep(5000L);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        t.start();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GenericDialog dlg = new GenericDialog(Utilities.createFrame(), p);
                dlg.setModal(true);
                dlg.pack();
                dlg.setVisible(true);
            }
        });
        t = null;
    }

    private void operationViewClicked() {
        if (this.operationViewDlg == null) {
            this.operationViewPanel = MonitoringAttributesViewPanel.createMessageInstance(this.tableModel.getAllAttributes());
            this.operationViewDlg = new GenericDialog(Utilities.getFrame(this), this.operationViewPanel);
            Utilities.centerGoldenMean(this.operationViewDlg, Utilities.getParentDialog(this));
            this.operationViewDlg.setModal(true);
        }
        this.operationViewPanel.setSelectedAttributes(this.tableModel.getDisplayedAttributes());
        this.operationViewDlg.setVisible(true);
        if (!this.operationViewPanel.isCanceled()) {
            LinkedHashSet<Message> displayedAttributes = this.operationViewPanel.getAttributes();
            this.setAttributesToDisplay(displayedAttributes);
            this.updateTableSizes();
        }
    }

    @Override
    public void configurationChanged(ConfigurationChangeEvent ev) {
        boolean changed;
        this.updateErrorPaneIfServerRunningAndAuthRequired(ev.getNewDescriptor(), AdminToolMessages.INFO_CTRL_PANEL_SCHEDULED_TASK_LIST_REQUIRES_SERVER_RUNNING.get(), AdminToolMessages.INFO_CTRL_PANEL_SCHEDULED_TASK_LIST_AUTHENTICATION.get());
        ServerDescriptor server = ev.getNewDescriptor();
        final Set<TaskEntry> tasks = server.getTaskEntries();
        boolean bl = changed = this.tableModel.getRowCount() != tasks.size();
        if (!changed) {
            for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
                if (tasks.contains(this.tableModel.get(i))) continue;
                changed = true;
                break;
            }
        }
        if (changed) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    boolean visible;
                    Set selectedIds = ManageTasksPanel.this.getSelectedIds();
                    ManageTasksPanel.this.tableModel.setData(tasks);
                    boolean bl = visible = ManageTasksPanel.this.tableModel.getRowCount() > 0;
                    if (visible) {
                        ManageTasksPanel.this.updateTableSizes();
                        ManageTasksPanel.this.setSelectedIds(selectedIds);
                    } else {
                        ManageTasksPanel.this.logsLabel.setVisible(false);
                        ManageTasksPanel.this.logsScroll.setVisible(false);
                    }
                    ManageTasksPanel.this.tableModel.fireTableDataChanged();
                    ManageTasksPanel.this.lNoTasksFound.setVisible(!visible && !ManageTasksPanel.this.errorPane.isVisible());
                    ManageTasksPanel.this.tableScroll.setVisible(visible);
                    ManageTasksPanel.this.cancelTask.setVisible(visible);
                    ManageTasksPanel.this.detailsPanel.setVisible(visible);
                }
            });
        }
    }

    private void updateTableSizes() {
        Utilities.updateTableSizes(this.taskTable, 5);
        Utilities.updateScrollMode(this.tableScroll, this.taskTable);
    }

    private void setAttributesToDisplay(LinkedHashSet<Message> attributes) {
        Set<String> selectedIds = this.getSelectedIds();
        this.tableModel.setAttributes(attributes);
        this.tableModel.forceDataStructureChange();
        this.setSelectedIds(selectedIds);
    }

    private Set<String> getSelectedIds() {
        HashSet<String> selectedIds = new HashSet<String>();
        int[] indexes = this.taskTable.getSelectedRows();
        if (indexes != null) {
            for (int index : indexes) {
                TaskEntry taskEntry = this.tableModel.get(index);
                selectedIds.add(taskEntry.getId());
            }
        }
        return selectedIds;
    }

    private void setSelectedIds(Set<String> ids) {
        this.taskTable.getSelectionModel().clearSelection();
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            TaskEntry taskEntry = this.tableModel.get(i);
            if (!ids.contains(taskEntry.getId())) continue;
            this.taskTable.getSelectionModel().addSelectionInterval(i, i);
        }
    }

    class ManageTasksMenuBar
    extends MainMenuBar {
        private static final long serialVersionUID = 5051878116443370L;

        public ManageTasksMenuBar(ControlPanelInfo info) {
            super(info);
        }

        protected void addMenus() {
            this.add(this.createViewMenuBar());
            this.add(this.createHelpMenuBar());
        }

        protected JMenu createViewMenuBar() {
            JMenu menu = Utilities.createMenu(AdminToolMessages.INFO_CTRL_PANEL_CONNECTION_HANDLER_VIEW_MENU.get(), AdminToolMessages.INFO_CTRL_PANEL_CONNECTION_HANDLER_VIEW_MENU_DESCRIPTION.get());
            menu.setMnemonic(86);
            JMenuItem viewOperations = Utilities.createMenuItem(AdminToolMessages.INFO_CTRL_PANEL_TASK_ATTRIBUTES_VIEW.get());
            menu.add(viewOperations);
            viewOperations.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    ManageTasksPanel.this.operationViewClicked();
                }
            });
            return menu;
        }
    }
}

