/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui.renderer;

import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JList;
import org.opends.guitools.controlpanel.ui.renderer.CustomListCellRenderer;
import org.opends.messages.AdminToolMessages;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.MatchingRule;
import org.opends.server.types.AttributeUsage;
import org.opends.server.types.CommonSchemaElements;
import org.opends.server.types.ObjectClassType;

public class SchemaElementComboBoxCellRenderer
extends CustomListCellRenderer {
    public SchemaElementComboBoxCellRenderer(JComboBox combo) {
        super(combo);
    }

    public SchemaElementComboBoxCellRenderer(JList list) {
        super(list);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value instanceof AttributeSyntax) {
            String syntaxName = ((AttributeSyntax)value).getSyntaxName();
            value = syntaxName == null ? ((AttributeSyntax)value).getOID() : syntaxName;
        } else if (value instanceof CommonSchemaElements) {
            value = ((CommonSchemaElements)value).getNameOrOID();
        } else if (value instanceof MatchingRule) {
            value = ((MatchingRule)value).getNameOrOID();
        } else if (value instanceof AttributeUsage) {
            boolean isOperational = ((AttributeUsage)((Object)value)).isOperational();
            if (isOperational) {
                value = AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTE_USAGE_OPERATIONAL.get(value.toString());
            }
        } else if (value instanceof ObjectClassType) {
            switch ((ObjectClassType)((Object)value)) {
                case AUXILIARY: {
                    value = AdminToolMessages.INFO_CTRL_PANEL_OBJECTCLASS_AUXILIARY_LABEL.get().toString();
                    break;
                }
                case STRUCTURAL: {
                    value = AdminToolMessages.INFO_CTRL_PANEL_OBJECTCLASS_STRUCTURAL_LABEL.get().toString();
                    break;
                }
                case ABSTRACT: {
                    value = AdminToolMessages.INFO_CTRL_PANEL_OBJECTCLASS_ABSTRACT_LABEL.get().toString();
                }
            }
        }
        Component comp = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        return comp;
    }
}

