/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui.renderer;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JTable;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.renderer.CustomCellRenderer;

public class SelectableTableCellRenderer
extends CustomCellRenderer {
    private static final long serialVersionUID = 6855042914121526677L;
    private boolean hasMouseOver;
    private boolean isBeingPressed;
    private int lastRowMouseOver;
    private static final Color pressedBackground = ColorAndFontConstants.pressedBackground;
    private static final Color pressedForeground = ColorAndFontConstants.pressedForeground;
    private static final Color mouseOverBackground = ColorAndFontConstants.mouseOverBackground;
    private static final Color mouseOverForeground = ColorAndFontConstants.mouseOverForeground;

    public void setTable(final JTable table) {
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mousePressed(MouseEvent ev) {
                SelectableTableCellRenderer.this.isBeingPressed = true;
                table.repaint();
            }

            public void mouseReleased(MouseEvent ev) {
                SelectableTableCellRenderer.this.isBeingPressed = false;
            }

            public void mouseExited(MouseEvent ev) {
                SelectableTableCellRenderer.this.hasMouseOver = false;
                SelectableTableCellRenderer.this.lastRowMouseOver = -1;
                table.repaint();
            }

            public void mouseEntered(MouseEvent ev) {
                if (ev.getSource() == table) {
                    SelectableTableCellRenderer.this.hasMouseOver = true;
                    SelectableTableCellRenderer.this.lastRowMouseOver = table.rowAtPoint(ev.getPoint());
                } else {
                    this.mouseExited(ev);
                }
            }
        };
        MouseMotionAdapter mouseMotionAdapter = new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent ev) {
                SelectableTableCellRenderer.this.lastRowMouseOver = table.rowAtPoint(ev.getPoint());
                table.repaint();
            }

            public void mouseDragged(MouseEvent ev) {
                SelectableTableCellRenderer.this.lastRowMouseOver = -1;
                table.repaint();
            }
        };
        table.addMouseListener(mouseListener);
        table.addMouseMotionListener(mouseMotionAdapter);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.updateComponent(this, table, row, column, isSelected);
        return this;
    }

    protected void updateComponent(Component comp, JTable table, int row, int column, boolean isSelected) {
        if (table.isCellEditable(row, column) && !isSelected) {
            comp.setBackground(ColorAndFontConstants.treeBackground);
            comp.setForeground(ColorAndFontConstants.treeForeground);
        } else if (this.isBeingPressed && this.hasMouseOver && row == this.lastRowMouseOver) {
            comp.setBackground(pressedBackground);
            comp.setForeground(pressedForeground);
        } else if (this.hasMouseOver && row == this.lastRowMouseOver || isSelected) {
            comp.setBackground(mouseOverBackground);
            comp.setForeground(mouseOverForeground);
        } else {
            comp.setBackground(ColorAndFontConstants.treeBackground);
            comp.setForeground(ColorAndFontConstants.treeForeground);
        }
    }
}

