/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.opends.messages.AdminMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.server.admin.OperationsException;
import org.opends.server.admin.PropertyIsMandatoryException;
import org.opends.server.util.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MissingMandatoryPropertiesException
extends OperationsException {
    private static final long serialVersionUID = 6342522125252055588L;
    private final Collection<PropertyIsMandatoryException> causes;
    private final boolean isCreate;
    private final Message ufn;

    private static Message createMessage(Collection<PropertyIsMandatoryException> causes) {
        Validator.ensureNotNull(causes);
        Validator.ensureTrue(!causes.isEmpty());
        if (causes.size() == 1) {
            return AdminMessages.ERR_MISSING_MANDATORY_PROPERTIES_EXCEPTION_SINGLE.get(causes.iterator().next().getPropertyDefinition().getName());
        }
        MessageBuilder builder = new MessageBuilder();
        boolean isFirst = true;
        for (PropertyIsMandatoryException cause : causes) {
            if (!isFirst) {
                builder.append(", ");
            }
            builder.append(cause.getPropertyDefinition().getName());
            isFirst = false;
        }
        return AdminMessages.ERR_MISSING_MANDATORY_PROPERTIES_EXCEPTION_PLURAL.get(builder.toMessage());
    }

    public MissingMandatoryPropertiesException(Message ufn, Collection<PropertyIsMandatoryException> causes, boolean isCreate) {
        super(MissingMandatoryPropertiesException.createMessage(causes));
        this.causes = new ArrayList<PropertyIsMandatoryException>(causes);
        this.ufn = ufn;
        this.isCreate = isCreate;
    }

    @Override
    public PropertyIsMandatoryException getCause() {
        return this.causes.iterator().next();
    }

    public Collection<PropertyIsMandatoryException> getCauses() {
        return Collections.unmodifiableCollection(this.causes);
    }

    public Message getUserFriendlyName() {
        return this.ufn;
    }

    public boolean isCreate() {
        return this.isCreate;
    }
}

