/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.authorization.dseecompat;

import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.opends.server.authorization.dseecompat.Aci;
import org.opends.server.authorization.dseecompat.AciEvalContext;
import org.opends.server.authorization.dseecompat.AciHandler;
import org.opends.server.authorization.dseecompat.AciLDAPOperationContainer;
import org.opends.server.authorization.dseecompat.EnumEvalReason;
import org.opends.server.core.DirectoryServer;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AttributeValues;
import org.opends.server.types.Attributes;
import org.opends.server.types.SearchResultEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AciEffectiveRights {
    private static final int ACL_RIGHTS = 1;
    private static final int ACL_RIGHTS_INFO = 2;
    private static final int ACL_TARGATTR_DENY_MATCH = 4;
    private static final int ACL_TARGATTR_ALLOW_MATCH = 8;
    private static final String aclRightsAttrStr = "aclRights";
    private static final String aclRightsInfoAttrStr = "aclRightsInfo";
    private static final String entryLevelStr = "entryLevel";
    private static final String attributeLevelStr = "attributeLevel";
    private static final String aclRightsEntryLevelStr = "aclRights;entryLevel";
    private static final String aclRightsAttributeLevelStr = "aclRights;attributeLevel";
    private static final String aclRightsInfoAttrLogsStr = "aclRightsInfo;logs;attributeLevel";
    private static final String aclRightsInfoEntryLogsStr = "aclRightsInfo;logs;entryLevel";
    private static AttributeType aclRights = null;
    private static AttributeType aclRightsInfo = null;
    private static AttributeType dnAttributeType = null;
    private static final String dnAttrStr = "distinguishedname";
    private static String ALLOWED = "access allowed";
    private static String NOT_ALLOWED = "access not allowed";
    private static String anonymous = "anonymous";
    private static String summaryFormatStr = "acl_summary(%s): %s(%s) on entry/attr(%s, %s) to (%s) (not proxied) ( reason: %s %s)";
    private static String EVALUATED_ALLOW = "evaluated allow";
    private static String EVALUATED_DENY = "evaluated deny";
    private static String NO_ALLOWS = "no acis matched the resource";
    private static String NO_ALLOWS_MATCHED = "no acis matched the subject";
    private static String SKIP_ACI = "user has bypass-acl privileges";

    public static SearchResultEntry addRightsToEntry(AciHandler handler, LinkedHashSet<String> searchAttributes, AciLDAPOperationContainer container, SearchResultEntry e, boolean skipCheck) {
        LinkedList<AttributeType> nonRightsAttrs = new LinkedList<AttributeType>();
        int attrMask = 0;
        if (aclRights == null) {
            aclRights = DirectoryServer.getAttributeType(aclRightsAttrStr.toLowerCase());
        }
        if (aclRightsInfo == null) {
            aclRightsInfo = DirectoryServer.getAttributeType(aclRightsInfoAttrStr.toLowerCase());
        }
        if (dnAttributeType == null) {
            dnAttributeType = DirectoryServer.getAttributeType(dnAttrStr);
        }
        for (String a : searchAttributes) {
            if (a.equalsIgnoreCase(aclRightsAttrStr)) {
                attrMask |= 1;
                continue;
            }
            if (a.equalsIgnoreCase(aclRightsInfoAttrStr)) {
                attrMask |= 2;
                continue;
            }
            if (a.equals("*")) {
                AttributeType ocType = DirectoryServer.getObjectClassAttributeType();
                nonRightsAttrs.add(ocType);
                nonRightsAttrs.addAll(e.getUserAttributes().keySet());
                continue;
            }
            if (a.equals("+")) {
                nonRightsAttrs.addAll(e.getOperationalAttributes().keySet());
                continue;
            }
            AttributeType attrType = DirectoryServer.getAttributeType(a.toLowerCase());
            if (attrType == null) {
                attrType = DirectoryServer.getDefaultAttributeType(a.toLowerCase());
            }
            nonRightsAttrs.add(attrType);
        }
        if (attrMask == 0 || !skipCheck && !AciEffectiveRights.rightsAccessAllowed(container, handler, attrMask)) {
            return e;
        }
        container.setGetEffectiveRightsEval();
        container.useAuthzid(true);
        if (nonRightsAttrs.isEmpty()) {
            e = AciEffectiveRights.addAttributeLevelRights(container, handler, attrMask, e, container.getSpecificAttributes(), skipCheck, true);
            e = AciEffectiveRights.addEntryLevelRights(container, handler, attrMask, e, skipCheck);
        } else {
            e = AciEffectiveRights.addAttributeLevelRights(container, handler, attrMask, e, nonRightsAttrs, skipCheck, false);
            e = AciEffectiveRights.addAttributeLevelRights(container, handler, attrMask, e, container.getSpecificAttributes(), skipCheck, true);
            e = AciEffectiveRights.addEntryLevelRights(container, handler, attrMask, e, skipCheck);
        }
        return e;
    }

    private static SearchResultEntry addAttributeLevelRights(AciLDAPOperationContainer container, AciHandler handler, int mask, SearchResultEntry retEntry, List<AttributeType> attrList, boolean skipCheck, boolean specificAttr) {
        if (attrList == null) {
            return retEntry;
        }
        for (AttributeType a : attrList) {
            StringBuilder evalInfo = new StringBuilder();
            container.setCurrentAttributeType(a);
            container.setCurrentAttributeValue(null);
            container.setRights(0x400002);
            evalInfo.append(AciEffectiveRights.rightsString(container, handler, skipCheck, "search"));
            AciEffectiveRights.addAttrLevelRightsInfo(container, mask, a, retEntry, "search");
            evalInfo.append(',');
            container.setRights(0x400004);
            evalInfo.append(AciEffectiveRights.rightsString(container, handler, skipCheck, "read"));
            AciEffectiveRights.addAttrLevelRightsInfo(container, mask, a, retEntry, "read");
            evalInfo.append(',');
            container.setRights(0x400001);
            evalInfo.append(AciEffectiveRights.rightsString(container, handler, skipCheck, "compare"));
            AciEffectiveRights.addAttrLevelRightsInfo(container, mask, a, retEntry, "compare");
            evalInfo.append(',');
            AttributeValue val = AttributeValues.create(a, "dum###Val");
            container.setCurrentAttributeValue(val);
            evalInfo.append(AciEffectiveRights.attributeLevelWriteRights(container, handler, skipCheck));
            AciEffectiveRights.addAttrLevelRightsInfo(container, mask, a, retEntry, "write");
            evalInfo.append(',');
            AttributeValue val1 = AttributeValues.create(a, container.getClientDN().toString());
            if (!specificAttr) {
                container.setCurrentAttributeType(dnAttributeType);
            }
            container.setCurrentAttributeValue(val1);
            container.setRights(0x400800);
            evalInfo.append(AciEffectiveRights.rightsString(container, handler, skipCheck, "selfwrite_add"));
            AciEffectiveRights.addAttrLevelRightsInfo(container, mask, a, retEntry, "selfwrite_add");
            evalInfo.append(',');
            container.setRights(0x400400);
            evalInfo.append(AciEffectiveRights.rightsString(container, handler, skipCheck, "selfwrite_delete"));
            AciEffectiveRights.addAttrLevelRightsInfo(container, mask, a, retEntry, "selfwrite_delete");
            evalInfo.append(',');
            container.setCurrentAttributeType(a);
            container.setCurrentAttributeValue(null);
            container.setRights(0x400080);
            evalInfo.append(AciEffectiveRights.rightsString(container, handler, skipCheck, "proxy"));
            AciEffectiveRights.addAttrLevelRightsInfo(container, mask, a, retEntry, "proxy");
            if (!AciEffectiveRights.hasAttrMask(mask, 1)) continue;
            String typeStr = "aclRights;attributeLevel;" + a.getNormalizedPrimaryName();
            AttributeType attributeType = DirectoryServer.getDefaultAttributeType(typeStr);
            Attribute attr = Attributes.create(attributeType, evalInfo.toString());
            if (retEntry.hasAttribute(attributeType)) continue;
            retEntry.addAttribute(attr, null);
        }
        container.setCurrentAttributeValue(null);
        container.setCurrentAttributeType(null);
        return retEntry;
    }

    private static String attributeLevelWriteRights(AciLDAPOperationContainer container, AciHandler handler, boolean skipCheck) {
        boolean addRet = false;
        boolean delRet = false;
        StringBuilder resString = new StringBuilder();
        if (skipCheck && container.isAuthzidAuthorizationDN()) {
            resString.append("write").append(":1");
            container.setEvalReason(EnumEvalReason.SKIP_ACI);
            container.setDecidingAci(null);
            AciEffectiveRights.createSummary(container, true, "main");
        } else {
            container.resetEffectiveRightsParams();
            container.setTargAttrFiltersAciName(null);
            container.setRights(0x400800);
            if (handler.accessAllowed(container) && container.getTargAttrFiltersAciName() == null) {
                addRet = true;
            }
            container.setRights(0x400400);
            if (handler.accessAllowed(container) && container.getTargAttrFiltersAciName() == null) {
                delRet = true;
            }
            if (addRet && delRet) {
                resString.append("write").append(":1");
            } else if (container.getTargAttrFiltersAciName() != null) {
                resString.append("write").append(":?");
            } else {
                resString.append("write").append(":0");
            }
        }
        return resString.toString();
    }

    private static SearchResultEntry addEntryLevelRights(AciLDAPOperationContainer container, AciHandler handler, int mask, SearchResultEntry retEntry, boolean skipCheck) {
        StringBuilder evalInfo = new StringBuilder();
        container.setCurrentAttributeType(null);
        container.setRights(0x400020);
        evalInfo.append(AciEffectiveRights.rightsString(container, handler, skipCheck, "add"));
        AciEffectiveRights.addEntryLevelRightsInfo(container, mask, retEntry, "add");
        evalInfo.append(',');
        container.setCurrentAttributeType(null);
        container.setRights(0x400010);
        evalInfo.append(AciEffectiveRights.rightsString(container, handler, skipCheck, "delete"));
        AciEffectiveRights.addEntryLevelRightsInfo(container, mask, retEntry, "delete");
        evalInfo.append(',');
        container.setCurrentAttributeType(null);
        container.useFullResourceEntry(true);
        container.setRights(0x400004);
        evalInfo.append(AciEffectiveRights.rightsString(container, handler, skipCheck, "read"));
        AciEffectiveRights.addEntryLevelRightsInfo(container, mask, retEntry, "read");
        evalInfo.append(',');
        container.useFullResourceEntry(false);
        container.setCurrentAttributeType(null);
        container.setRights(0x400008);
        evalInfo.append(AciEffectiveRights.rightsString(container, handler, skipCheck, "write"));
        AciEffectiveRights.addEntryLevelRightsInfo(container, mask, retEntry, "write");
        evalInfo.append(',');
        container.setCurrentAttributeType(null);
        container.setRights(0x400080);
        evalInfo.append(AciEffectiveRights.rightsString(container, handler, skipCheck, "proxy"));
        AciEffectiveRights.addEntryLevelRightsInfo(container, mask, retEntry, "proxy");
        if (AciEffectiveRights.hasAttrMask(mask, 1)) {
            AttributeType attributeType = DirectoryServer.getDefaultAttributeType(aclRightsEntryLevelStr);
            Attribute attr = Attributes.create(attributeType, evalInfo.toString());
            retEntry.addAttribute(attr, null);
        }
        return retEntry;
    }

    private static String rightsString(AciLDAPOperationContainer container, AciHandler handler, boolean skipCheck, String rightStr) {
        StringBuilder resString = new StringBuilder();
        container.resetEffectiveRightsParams();
        if (skipCheck && container.isAuthzidAuthorizationDN()) {
            resString.append(rightStr).append(":1");
            container.setEvalReason(EnumEvalReason.SKIP_ACI);
            container.setDecidingAci(null);
            AciEffectiveRights.createSummary(container, true, "main");
        } else {
            boolean ret = container.hasRights(4) && container.getCurrentAttributeType() == null ? handler.accessAllowedEntry(container) : handler.accessAllowed(container);
            if (ret) {
                resString.append(rightStr).append(":1");
            } else {
                resString.append(rightStr).append(":0");
            }
        }
        return resString.toString();
    }

    private static boolean rightsAccessAllowed(AciLDAPOperationContainer container, AciHandler handler, int mask) {
        boolean retRight = true;
        boolean retInfo = true;
        if (AciEffectiveRights.hasAttrMask(mask, 1)) {
            container.setCurrentAttributeType(aclRights);
            container.setRights(0x400004);
            retRight = handler.accessAllowed(container);
        }
        if (AciEffectiveRights.hasAttrMask(mask, 2)) {
            container.setCurrentAttributeType(aclRightsInfo);
            container.setRights(0x400004);
            retInfo = handler.accessAllowed(container);
        }
        return retRight && retInfo;
    }

    private static void addAttrLevelRightsInfo(AciLDAPOperationContainer container, int mask, AttributeType aType, SearchResultEntry retEntry, String rightStr) {
        if (AciEffectiveRights.hasAttrMask(mask, 2)) {
            String typeStr = "aclRightsInfo;logs;attributeLevel;" + rightStr + ";" + aType.getPrimaryName();
            AttributeType attributeType = DirectoryServer.getDefaultAttributeType(typeStr);
            Attribute attr = Attributes.create(attributeType, container.getEvalSummary());
            if (!retEntry.hasAttribute(attributeType)) {
                retEntry.addAttribute(attr, null);
            }
        }
    }

    private static void addEntryLevelRightsInfo(AciLDAPOperationContainer container, int mask, SearchResultEntry retEntry, String rightStr) {
        if (AciEffectiveRights.hasAttrMask(mask, 2)) {
            String typeStr = "aclRightsInfo;logs;entryLevel;" + rightStr;
            AttributeType attributeType = DirectoryServer.getDefaultAttributeType(typeStr);
            Attribute attr = Attributes.create(attributeType, container.getEvalSummary());
            retEntry.addAttribute(attr, null);
        }
    }

    private static boolean hasAttrMask(int mask, int rightsAttr) {
        return (mask & rightsAttr) != 0;
    }

    public static void createSummary(AciEvalContext evalCtx, boolean evalRet, String srcStr) {
        String accessStatus = NOT_ALLOWED;
        if (evalRet) {
            accessStatus = ALLOWED;
        }
        String accessReason = "";
        StringBuilder decideAci = new StringBuilder("");
        if (evalCtx.getEvalReason() == EnumEvalReason.EVALUATED_ALLOW_ACI) {
            accessReason = EVALUATED_ALLOW;
            decideAci.append(", deciding_aci: ").append(evalCtx.getDecidingAciName());
        } else if (evalCtx.getEvalReason() == EnumEvalReason.EVALUATED_DENY_ACI) {
            accessReason = EVALUATED_DENY;
            decideAci.append(", deciding_aci: ").append(evalCtx.getDecidingAciName());
        } else if (evalCtx.getEvalReason() == EnumEvalReason.NO_ALLOW_ACIS) {
            accessReason = NO_ALLOWS;
        } else if (evalCtx.getEvalReason() == EnumEvalReason.NO_MATCHED_ALLOWS_ACIS) {
            accessReason = NO_ALLOWS_MATCHED;
        } else if (evalCtx.getEvalReason() == EnumEvalReason.SKIP_ACI) {
            accessReason = SKIP_ACI;
        }
        if (!evalCtx.isTargAttrFilterMatchAciEmpty() && !evalCtx.hasRights(64)) {
            if (evalCtx.getAllowList().isEmpty()) {
                evalCtx.setTargAttrFiltersAciName(null);
            } else if (evalRet) {
                if (!evalCtx.hasTargAttrFiltersMatchOp(4)) {
                    evalCtx.setTargAttrFiltersAciName(null);
                }
            } else if (evalCtx.getEvalReason() == EnumEvalReason.EVALUATED_DENY_ACI) {
                evalCtx.setTargAttrFiltersAciName(null);
            } else if (!evalCtx.hasTargAttrFiltersMatchOp(8)) {
                evalCtx.setTargAttrFiltersAciName(null);
            }
        }
        String user = anonymous;
        if (!evalCtx.getClientDN().isNullDN()) {
            user = evalCtx.getClientDN().toString();
        }
        String right = evalCtx.rightToString();
        AttributeType aType = evalCtx.getCurrentAttributeType();
        String attrStr = "NULL";
        if (aType != null) {
            attrStr = aType.getPrimaryName();
        }
        if (evalCtx.getTargAttrFiltersAciName() != null) {
            decideAci.append(", access depends on attr value");
        }
        String summaryStr = String.format(summaryFormatStr, srcStr, accessStatus, right, evalCtx.getResourceDN().toString(), attrStr, user, accessReason, decideAci.toString());
        evalCtx.setEvalSummary(summaryStr);
    }

    public static boolean setTargAttrAci(AciEvalContext evalCtx, Aci aci, boolean denyAci) {
        boolean ret = false;
        if (evalCtx.hasTargAttrFiltersMatchAci(aci)) {
            if (denyAci) {
                evalCtx.setTargAttrFiltersMatchOp(4);
            } else {
                evalCtx.setTargAttrFiltersMatchOp(8);
            }
            ret = true;
        }
        return ret;
    }

    public static void finalizeOnShutdown() {
        aclRights = null;
        aclRightsInfo = null;
        dnAttributeType = null;
    }
}

