/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.opends.messages.ConfigMessages;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.meta.PasswordPolicyCfgDefn;
import org.opends.server.admin.std.server.PasswordPolicyCfg;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.PasswordPolicy;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SubEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubentryPasswordPolicy
implements PasswordPolicyCfg {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private final String PWD_OC_POLICY = "pwdpolicy";
    private final String PWD_ATTR_ATTRIBUTE = "pwdattribute";
    private final String PWD_ATTR_MINAGE = "pwdminage";
    private final String PWD_ATTR_MAXAGE = "pwdmaxage";
    private final String PWD_ATTR_INHISTORY = "pwdinhistory";
    private final String PWD_ATTR_CHECKQUALITY = "pwdcheckquality";
    private final String PWD_ATTR_MINLENGTH = "pwdminlength";
    private final String PWD_ATTR_EXPIREWARNING = "pwdexpirewarning";
    private final String PWD_ATTR_GRACEAUTHNLIMIT = "pwdgraceauthnlimit";
    private final String PWD_ATTR_LOCKOUT = "pwdlockout";
    private final String PWD_ATTR_LOCKOUTDURATION = "pwdlockoutduration";
    private final String PWD_ATTR_MAXFAILURE = "pwdmaxfailure";
    private final String PWD_ATTR_MUSTCHANGE = "pwdmustchange";
    private final String PWD_ATTR_ALLOWUSERCHANGE = "pwdallowuserchange";
    private final String PWD_ATTR_SAFEMODIFY = "pwdsafemodify";
    private final String PWD_ATTR_FAILURECOUNTINTERVAL = "pwdfailurecountinterval";
    private final DN passwordPolicySubentryDN;
    private final SortedSet<String> pAccountStatusNotificationHandler;
    private final boolean pAllowExpiredPasswordChanges;
    private final boolean pAllowMultiplePasswordValues;
    private final boolean pAllowPreEncodedPasswords;
    private final boolean pAllowUserPasswordChanges;
    private final SortedSet<String> pDefaultPasswordStorageScheme;
    private final SortedSet<String> pDeprecatedPasswordStorageScheme;
    private final boolean pExpirePasswordsWithoutWarning;
    private final boolean pForceChangeOnAdd;
    private final boolean pForceChangeOnReset;
    private final int pGraceLoginCount;
    private final long pIdleLockoutInterval;
    private final AttributeType pLastLoginTimeAttribute;
    private final String pLastLoginTimeFormat;
    private final long pLockoutDuration;
    private final int pLockoutFailureCount;
    private final long pLockoutFailureExpirationInterval;
    private final long pMaxPasswordAge;
    private final long pMaxPasswordResetAge;
    private final long pMinPasswordAge;
    private final AttributeType pPasswordAttribute;
    private final boolean pPasswordChangeRequiresCurrentPassword;
    private final long pPasswordExpirationWarningInterval;
    private final String pPasswordGenerator;
    private final int pPasswordHistoryCount;
    private final long pPasswordHistoryDuration;
    private final SortedSet<String> pPasswordValidator;
    private final SortedSet<String> pPreviousLastLoginTimeFormat;
    private final String pRequireChangeByTime;
    private final boolean pRequireSecureAuthentication;
    private final boolean pRequireSecurePasswordChanges;
    private final boolean pSkipValidationForAdministrators;
    private final PasswordPolicyCfgDefn.StateUpdateFailurePolicy pStateUpdateFailurePolicy;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SubentryPasswordPolicy(SubEntry subentry) throws DirectoryException {
        ObjectClass pwdPolicyOC = DirectoryServer.getObjectClass("pwdpolicy");
        Entry entry = subentry.getEntry();
        Map<ObjectClass, String> objectClasses = entry.getObjectClasses();
        if (pwdPolicyOC == null) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugWarning("No %s objectclass is defined in the server schema.", "pwdpolicy");
            }
            for (String ocName : objectClasses.values()) {
                if (ocName.equalsIgnoreCase("pwdpolicy")) break;
            }
            Message message = CoreMessages.ERR_PWPOLICY_NO_PWDPOLICY_OC.get(subentry.getDN().toString());
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
        }
        if (!objectClasses.containsKey(pwdPolicyOC)) {
            Message message = CoreMessages.ERR_PWPOLICY_NO_PWDPOLICY_OC.get(subentry.getDN().toString());
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
        }
        PasswordPolicy defaultPasswordPolicy = DirectoryServer.getDefaultPasswordPolicy();
        if (defaultPasswordPolicy == null) {
            throw new DirectoryException(ResultCode.OPERATIONS_ERROR, ConfigMessages.ERR_CONFIG_PWPOLICY_NO_DEFAULT_POLICY.get());
        }
        this.passwordPolicySubentryDN = subentry.getDN();
        AttributeValue value = this.getAttrValue(entry, "pwdattribute");
        if (value != null && ((Object)value).toString().length() > 0) {
            this.pPasswordAttribute = DirectoryServer.getAttributeType(((Object)value).toString().toLowerCase(), false);
            if (this.pPasswordAttribute == null) {
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, CoreMessages.ERR_PWPOLICY_UNDEFINED_PASSWORD_ATTRIBUTE.get(this.passwordPolicySubentryDN.toNormalizedString(), ((Object)value).toString()));
            }
        } else {
            this.pPasswordAttribute = defaultPasswordPolicy.getPasswordAttribute();
        }
        if ((value = this.getAttrValue(entry, "pwdminage")) != null && ((Object)value).toString().length() > 0) {
            try {
                this.pMinPasswordAge = Long.parseLong(((Object)value).toString());
                this.checkIntegerAttr("pwdminage", this.pMinPasswordAge, 0L, Integer.MAX_VALUE);
            }
            catch (NumberFormatException ne) {
                throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, ConfigMessages.ERR_CONFIG_ATTR_INVALID_INT_VALUE.get("pwdminage", ((Object)value).toString(), ne.getLocalizedMessage()));
            }
        } else {
            this.pMinPasswordAge = defaultPasswordPolicy.getMinimumPasswordAge();
        }
        value = this.getAttrValue(entry, "pwdmaxage");
        if (value != null && ((Object)value).toString().length() > 0) {
            try {
                this.pMaxPasswordAge = Long.parseLong(((Object)value).toString());
                this.checkIntegerAttr("pwdmaxage", this.pMaxPasswordAge, 0L, Integer.MAX_VALUE);
            }
            catch (NumberFormatException ne) {
                throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, ConfigMessages.ERR_CONFIG_ATTR_INVALID_INT_VALUE.get("pwdminage", ((Object)value).toString(), ne.getLocalizedMessage()));
            }
        } else {
            this.pMaxPasswordAge = defaultPasswordPolicy.getMaximumPasswordAge();
        }
        value = this.getAttrValue(entry, "pwdinhistory");
        if (value != null && ((Object)value).toString().length() > 0) {
            try {
                this.pPasswordHistoryCount = Integer.parseInt(((Object)value).toString());
                this.checkIntegerAttr("pwdinhistory", this.pPasswordHistoryCount, 0L, Integer.MAX_VALUE);
            }
            catch (NumberFormatException ne) {
                throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, ConfigMessages.ERR_CONFIG_ATTR_INVALID_INT_VALUE.get("pwdminage", ((Object)value).toString(), ne.getLocalizedMessage()));
            }
        } else {
            this.pPasswordHistoryCount = defaultPasswordPolicy.getPasswordHistoryCount();
        }
        value = this.getAttrValue(entry, "pwdcheckquality");
        if (value != null && ((Object)value).toString().length() > 0) {
            try {
                int pwdCheckQuality = Integer.parseInt(((Object)value).toString());
                this.checkIntegerAttr("pwdcheckquality", pwdCheckQuality, 0L, 2L);
            }
            catch (NumberFormatException ne) {
                throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, ConfigMessages.ERR_CONFIG_ATTR_INVALID_INT_VALUE.get("pwdminage", ((Object)value).toString(), ne.getLocalizedMessage()));
            }
        }
        if ((value = this.getAttrValue(entry, "pwdminlength")) != null && ((Object)value).toString().length() > 0) {
            try {
                int pwdMinLength = Integer.parseInt(((Object)value).toString());
                this.checkIntegerAttr("pwdminlength", pwdMinLength, 0L, Integer.MAX_VALUE);
            }
            catch (NumberFormatException ne) {
                throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, ConfigMessages.ERR_CONFIG_ATTR_INVALID_INT_VALUE.get("pwdminage", ((Object)value).toString(), ne.getLocalizedMessage()));
            }
        }
        if ((value = this.getAttrValue(entry, "pwdlockout")) != null && ((Object)value).toString().length() > 0) {
            if (!((Object)value).toString().equalsIgnoreCase(Boolean.TRUE.toString()) && !((Object)value).toString().equalsIgnoreCase(Boolean.FALSE.toString())) throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, ConfigMessages.ERR_CONFIG_ATTR_INVALID_BOOLEAN_VALUE.get("pwdmustchange", ((Object)value).toString()));
            Boolean.parseBoolean(((Object)value).toString());
        }
        if ((value = this.getAttrValue(entry, "pwdexpirewarning")) != null && ((Object)value).toString().length() > 0) {
            try {
                this.pPasswordExpirationWarningInterval = Long.parseLong(((Object)value).toString());
                this.checkIntegerAttr("pwdexpirewarning", this.pPasswordExpirationWarningInterval, 0L, Integer.MAX_VALUE);
            }
            catch (NumberFormatException ne) {
                throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, ConfigMessages.ERR_CONFIG_ATTR_INVALID_INT_VALUE.get("pwdminage", ((Object)value).toString(), ne.getLocalizedMessage()));
            }
        } else {
            this.pPasswordExpirationWarningInterval = defaultPasswordPolicy.getWarningInterval();
        }
        value = this.getAttrValue(entry, "pwdgraceauthnlimit");
        if (value != null && ((Object)value).toString().length() > 0) {
            try {
                this.pGraceLoginCount = Integer.parseInt(((Object)value).toString());
                this.checkIntegerAttr("pwdgraceauthnlimit", this.pGraceLoginCount, 0L, Integer.MAX_VALUE);
            }
            catch (NumberFormatException ne) {
                throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, ConfigMessages.ERR_CONFIG_ATTR_INVALID_INT_VALUE.get("pwdminage", ((Object)value).toString(), ne.getLocalizedMessage()));
            }
        } else {
            this.pGraceLoginCount = defaultPasswordPolicy.getGraceLoginCount();
        }
        value = this.getAttrValue(entry, "pwdlockoutduration");
        if (value != null && ((Object)value).toString().length() > 0) {
            try {
                this.pLockoutDuration = Long.parseLong(((Object)value).toString());
                this.checkIntegerAttr("pwdlockoutduration", this.pLockoutDuration, 0L, Integer.MAX_VALUE);
            }
            catch (NumberFormatException ne) {
                throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, ConfigMessages.ERR_CONFIG_ATTR_INVALID_INT_VALUE.get("pwdminage", ((Object)value).toString(), ne.getLocalizedMessage()));
            }
        } else {
            this.pLockoutDuration = defaultPasswordPolicy.getLockoutDuration();
        }
        value = this.getAttrValue(entry, "pwdmaxfailure");
        if (value != null && ((Object)value).toString().length() > 0) {
            try {
                this.pLockoutFailureCount = Integer.parseInt(((Object)value).toString());
                this.checkIntegerAttr("pwdmaxfailure", this.pLockoutFailureCount, 0L, Integer.MAX_VALUE);
            }
            catch (NumberFormatException ne) {
                throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, ConfigMessages.ERR_CONFIG_ATTR_INVALID_INT_VALUE.get("pwdminage", ((Object)value).toString(), ne.getLocalizedMessage()));
            }
        } else {
            this.pLockoutFailureCount = defaultPasswordPolicy.getLockoutFailureCount();
        }
        value = this.getAttrValue(entry, "pwdmustchange");
        if (value != null && ((Object)value).toString().length() > 0) {
            if (!((Object)value).toString().equalsIgnoreCase(Boolean.TRUE.toString()) && !((Object)value).toString().equalsIgnoreCase(Boolean.FALSE.toString())) throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, ConfigMessages.ERR_CONFIG_ATTR_INVALID_BOOLEAN_VALUE.get("pwdmustchange", ((Object)value).toString()));
            this.pForceChangeOnReset = Boolean.parseBoolean(((Object)value).toString());
        } else {
            this.pForceChangeOnReset = defaultPasswordPolicy.forceChangeOnReset();
        }
        value = this.getAttrValue(entry, "pwdallowuserchange");
        if (value != null && ((Object)value).toString().length() > 0) {
            if (!((Object)value).toString().equalsIgnoreCase(Boolean.TRUE.toString()) && !((Object)value).toString().equalsIgnoreCase(Boolean.FALSE.toString())) throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, ConfigMessages.ERR_CONFIG_ATTR_INVALID_BOOLEAN_VALUE.get("pwdallowuserchange", ((Object)value).toString()));
            this.pAllowUserPasswordChanges = Boolean.parseBoolean(((Object)value).toString());
        } else {
            this.pAllowUserPasswordChanges = defaultPasswordPolicy.allowUserPasswordChanges();
        }
        value = this.getAttrValue(entry, "pwdsafemodify");
        if (value != null && ((Object)value).toString().length() > 0) {
            if (!((Object)value).toString().equalsIgnoreCase(Boolean.TRUE.toString()) && !((Object)value).toString().equalsIgnoreCase(Boolean.FALSE.toString())) throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, ConfigMessages.ERR_CONFIG_ATTR_INVALID_BOOLEAN_VALUE.get("pwdsafemodify", ((Object)value).toString()));
            this.pPasswordChangeRequiresCurrentPassword = Boolean.parseBoolean(((Object)value).toString());
        } else {
            this.pPasswordChangeRequiresCurrentPassword = defaultPasswordPolicy.requireCurrentPassword();
        }
        value = this.getAttrValue(entry, "pwdfailurecountinterval");
        if (value != null && ((Object)value).toString().length() > 0) {
            try {
                this.pLockoutFailureExpirationInterval = Long.parseLong(((Object)value).toString());
                this.checkIntegerAttr("pwdfailurecountinterval", this.pLockoutFailureExpirationInterval, 0L, Integer.MAX_VALUE);
            }
            catch (NumberFormatException ne) {
                throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, ConfigMessages.ERR_CONFIG_ATTR_INVALID_INT_VALUE.get("pwdfailurecountinterval", ((Object)value).toString(), ne.getLocalizedMessage()));
            }
        } else {
            this.pLockoutFailureExpirationInterval = defaultPasswordPolicy.getLockoutFailureExpirationInterval();
        }
        TreeSet<String> accountStatusNotificationHandlerSet = new TreeSet<String>();
        Set accountStatusNotificationHandlerDNSet = defaultPasswordPolicy.getAccountStatusNotificationHandlers().keySet();
        for (DN dn : accountStatusNotificationHandlerDNSet) {
            accountStatusNotificationHandlerSet.add(dn.toNormalizedString());
        }
        this.pAccountStatusNotificationHandler = accountStatusNotificationHandlerSet;
        this.pAllowExpiredPasswordChanges = defaultPasswordPolicy.allowExpiredPasswordChanges();
        this.pAllowMultiplePasswordValues = defaultPasswordPolicy.allowMultiplePasswordValues();
        this.pAllowPreEncodedPasswords = defaultPasswordPolicy.allowPreEncodedPasswords();
        TreeSet<String> passwordStorageSchemeSet = new TreeSet<String>();
        for (DN dn : defaultPasswordPolicy.getDefaultStorageSchemeDNs()) {
            passwordStorageSchemeSet.add(dn.toNormalizedString());
        }
        this.pDefaultPasswordStorageScheme = passwordStorageSchemeSet;
        TreeSet<String> deprecatedPasswordStorageSchemeSet = new TreeSet<String>();
        for (DN dn : defaultPasswordPolicy.getDeprecatedStorageSchemeDNs()) {
            deprecatedPasswordStorageSchemeSet.add(dn.toNormalizedString());
        }
        this.pDeprecatedPasswordStorageScheme = deprecatedPasswordStorageSchemeSet;
        this.pExpirePasswordsWithoutWarning = defaultPasswordPolicy.expirePasswordsWithoutWarning();
        this.pForceChangeOnAdd = defaultPasswordPolicy.forceChangeOnAdd();
        this.pIdleLockoutInterval = defaultPasswordPolicy.getIdleLockoutInterval();
        this.pLastLoginTimeAttribute = defaultPasswordPolicy.getLastLoginTimeAttribute();
        this.pLastLoginTimeFormat = defaultPasswordPolicy.getLastLoginTimeFormat();
        this.pMaxPasswordResetAge = defaultPasswordPolicy.getMaximumPasswordResetAge();
        this.pPasswordGenerator = defaultPasswordPolicy.getPasswordGeneratorDN().toNormalizedString();
        this.pPasswordHistoryDuration = defaultPasswordPolicy.getPasswordHistoryDuration();
        TreeSet<String> passwordValidatorSet = new TreeSet<String>();
        Set passwordValidatorDNSet = defaultPasswordPolicy.getPasswordValidators().keySet();
        for (DN dn : passwordValidatorDNSet) {
            passwordValidatorSet.add(dn.toNormalizedString());
        }
        this.pPasswordValidator = passwordValidatorSet;
        this.pPreviousLastLoginTimeFormat = new TreeSet<String>(defaultPasswordPolicy.getPreviousLastLoginTimeFormats());
        long requireChangeByTime = defaultPasswordPolicy.getRequireChangeByTime();
        this.pRequireChangeByTime = requireChangeByTime > 0L ? Long.toString(requireChangeByTime) : null;
        this.pRequireSecureAuthentication = defaultPasswordPolicy.requireSecureAuthentication();
        this.pRequireSecurePasswordChanges = defaultPasswordPolicy.requireSecurePasswordChanges();
        this.pSkipValidationForAdministrators = defaultPasswordPolicy.skipValidationForAdministrators();
        this.pStateUpdateFailurePolicy = defaultPasswordPolicy.getStateUpdateFailurePolicy();
    }

    private void checkIntegerAttr(String attrName, long attrValue, long lowerBound, long upperBound) throws DirectoryException {
        if (attrValue < lowerBound) {
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, ConfigMessages.ERR_CONFIG_ATTR_INT_BELOW_LOWER_BOUND.get(attrName, attrValue, lowerBound));
        }
        if (attrValue > upperBound) {
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, ConfigMessages.ERR_CONFIG_ATTR_INT_ABOVE_UPPER_BOUND.get(attrName, attrValue, upperBound));
        }
    }

    private AttributeValue getAttrValue(Entry entry, String pwdAttrName) {
        AttributeType pwdAttrType = DirectoryServer.getAttributeType(pwdAttrName, true);
        List<Attribute> pwdAttrList = entry.getAttribute(pwdAttrType);
        if (pwdAttrList != null && !pwdAttrList.isEmpty()) {
            for (Attribute attr : pwdAttrList) {
                Iterator<AttributeValue> i$ = attr.iterator();
                if (!i$.hasNext()) continue;
                AttributeValue value = i$.next();
                return value;
            }
        }
        return null;
    }

    @Override
    public void addChangeListener(ConfigurationChangeListener<PasswordPolicyCfg> listener) {
    }

    @Override
    public void removeChangeListener(ConfigurationChangeListener<PasswordPolicyCfg> listener) {
    }

    @Override
    public SortedSet<String> getAccountStatusNotificationHandler() {
        return this.pAccountStatusNotificationHandler;
    }

    @Override
    public SortedSet<DN> getAccountStatusNotificationHandlerDNs() {
        SortedSet<String> values = this.getAccountStatusNotificationHandler();
        TreeSet<DN> dnValues = new TreeSet<DN>();
        for (String value : values) {
            try {
                dnValues.add(DN.decode(value));
            }
            catch (DirectoryException de) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
        }
        return dnValues;
    }

    @Override
    public boolean isAllowExpiredPasswordChanges() {
        return this.pAllowExpiredPasswordChanges;
    }

    @Override
    public boolean isAllowMultiplePasswordValues() {
        return this.pAllowMultiplePasswordValues;
    }

    @Override
    public boolean isAllowPreEncodedPasswords() {
        return this.pAllowPreEncodedPasswords;
    }

    @Override
    public boolean isAllowUserPasswordChanges() {
        return this.pAllowUserPasswordChanges;
    }

    @Override
    public SortedSet<String> getDefaultPasswordStorageScheme() {
        return this.pDefaultPasswordStorageScheme;
    }

    @Override
    public SortedSet<DN> getDefaultPasswordStorageSchemeDNs() {
        SortedSet<String> values = this.getDefaultPasswordStorageScheme();
        TreeSet<DN> dnValues = new TreeSet<DN>();
        for (String value : values) {
            try {
                dnValues.add(DN.decode(value));
            }
            catch (DirectoryException de) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
        }
        return dnValues;
    }

    @Override
    public SortedSet<String> getDeprecatedPasswordStorageScheme() {
        return this.pDeprecatedPasswordStorageScheme;
    }

    @Override
    public SortedSet<DN> getDeprecatedPasswordStorageSchemeDNs() {
        SortedSet<String> values = this.getDeprecatedPasswordStorageScheme();
        TreeSet<DN> dnValues = new TreeSet<DN>();
        for (String value : values) {
            try {
                dnValues.add(DN.decode(value));
            }
            catch (DirectoryException de) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
        }
        return dnValues;
    }

    @Override
    public boolean isExpirePasswordsWithoutWarning() {
        return this.pExpirePasswordsWithoutWarning;
    }

    @Override
    public boolean isForceChangeOnAdd() {
        return this.pForceChangeOnAdd;
    }

    @Override
    public boolean isForceChangeOnReset() {
        return this.pForceChangeOnReset;
    }

    @Override
    public int getGraceLoginCount() {
        return this.pGraceLoginCount;
    }

    @Override
    public long getIdleLockoutInterval() {
        return this.pIdleLockoutInterval;
    }

    @Override
    public AttributeType getLastLoginTimeAttribute() {
        return this.pLastLoginTimeAttribute;
    }

    @Override
    public String getLastLoginTimeFormat() {
        return this.pLastLoginTimeFormat;
    }

    @Override
    public long getLockoutDuration() {
        return this.pLockoutDuration;
    }

    @Override
    public int getLockoutFailureCount() {
        return this.pLockoutFailureCount;
    }

    @Override
    public long getLockoutFailureExpirationInterval() {
        return this.pLockoutFailureExpirationInterval;
    }

    @Override
    public long getMaxPasswordAge() {
        return this.pMaxPasswordAge;
    }

    @Override
    public long getMaxPasswordResetAge() {
        return this.pMaxPasswordResetAge;
    }

    @Override
    public long getMinPasswordAge() {
        return this.pMinPasswordAge;
    }

    @Override
    public AttributeType getPasswordAttribute() {
        return this.pPasswordAttribute;
    }

    @Override
    public boolean isPasswordChangeRequiresCurrentPassword() {
        return this.pPasswordChangeRequiresCurrentPassword;
    }

    @Override
    public long getPasswordExpirationWarningInterval() {
        return this.pPasswordExpirationWarningInterval;
    }

    @Override
    public String getPasswordGenerator() {
        return this.pPasswordGenerator;
    }

    @Override
    public DN getPasswordGeneratorDN() {
        String value = this.getPasswordGenerator();
        if (value == null) {
            return null;
        }
        try {
            return DN.decode(value);
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            return null;
        }
    }

    @Override
    public int getPasswordHistoryCount() {
        return this.pPasswordHistoryCount;
    }

    @Override
    public long getPasswordHistoryDuration() {
        return this.pPasswordHistoryDuration;
    }

    @Override
    public SortedSet<String> getPasswordValidator() {
        return this.pPasswordValidator;
    }

    @Override
    public SortedSet<DN> getPasswordValidatorDNs() {
        SortedSet<String> values = this.getPasswordValidator();
        TreeSet<DN> dnValues = new TreeSet<DN>();
        for (String value : values) {
            try {
                dnValues.add(DN.decode(value));
            }
            catch (DirectoryException de) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
        }
        return dnValues;
    }

    @Override
    public SortedSet<String> getPreviousLastLoginTimeFormat() {
        return this.pPreviousLastLoginTimeFormat;
    }

    @Override
    public String getRequireChangeByTime() {
        return this.pRequireChangeByTime;
    }

    @Override
    public boolean isRequireSecureAuthentication() {
        return this.pRequireSecureAuthentication;
    }

    @Override
    public boolean isRequireSecurePasswordChanges() {
        return this.pRequireSecurePasswordChanges;
    }

    @Override
    public boolean isSkipValidationForAdministrators() {
        return this.pSkipValidationForAdministrators;
    }

    @Override
    public PasswordPolicyCfgDefn.StateUpdateFailurePolicy getStateUpdateFailurePolicy() {
        return this.pStateUpdateFailurePolicy;
    }

    @Override
    public Class<? extends PasswordPolicyCfg> configurationClass() {
        return PasswordPolicyCfg.class;
    }

    @Override
    public DN dn() {
        return this.passwordPolicySubentryDN;
    }
}

