/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.asn1;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1Reader;
import org.opends.server.types.ByteString;
import org.opends.server.types.ByteStringBuilder;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.util.SizeLimitInputStream;

final class ASN1InputStreamReader
implements ASN1Reader {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private int state = 0;
    private byte peekType = 0;
    private int peekLength = -1;
    private int lengthBytesNeeded = 0;
    private final int maxElementSize;
    private InputStream in;
    private final LinkedList<InputStream> streamStack;
    private byte[] buffer;

    ASN1InputStreamReader(InputStream stream, int maxElementSize) {
        this.in = stream;
        this.streamStack = new LinkedList();
        this.buffer = new byte[512];
        this.maxElementSize = maxElementSize;
    }

    public boolean elementAvailable() throws ASN1Exception {
        try {
            if (this.state == 0 && !this.needTypeState(false, false)) {
                return false;
            }
            if (this.state == 1 && !this.needFirstLengthByteState(false, false)) {
                return false;
            }
            if (this.state == 2 && !this.needAdditionalLengthBytesState(false, false)) {
                return false;
            }
            return this.peekLength <= this.in.available();
        }
        catch (IOException ioe) {
            Message message = ProtocolMessages.ERR_ASN1_READ_ERROR.get(ioe.toString());
            throw new ASN1Exception(message, (Throwable)ioe);
        }
    }

    public boolean hasNextElement() throws ASN1Exception {
        try {
            if (!this.streamStack.isEmpty()) {
                SizeLimitInputStream subSq = (SizeLimitInputStream)this.in;
                return subSq.getSizeLimit() - subSq.getBytesRead() > 0;
            }
            return this.state != 0 || this.needTypeState(true, false);
        }
        catch (IOException ioe) {
            Message message = ProtocolMessages.ERR_ASN1_READ_ERROR.get(ioe.toString());
            throw new ASN1Exception(message, (Throwable)ioe);
        }
    }

    private boolean needTypeState(boolean isBlocking, boolean throwEofException) throws IOException, ASN1Exception {
        if (!isBlocking && this.in.available() <= 0) {
            return false;
        }
        int type = this.in.read();
        if (type == -1) {
            if (throwEofException) {
                Message message = ProtocolMessages.ERR_ASN1_TRUCATED_TYPE_BYTE.get();
                throw new ASN1Exception(message);
            }
            return false;
        }
        this.peekType = (byte)type;
        this.state = 1;
        return true;
    }

    private boolean needFirstLengthByteState(boolean isBlocking, boolean throwEofException) throws IOException, ASN1Exception {
        if (!isBlocking && this.in.available() <= 0) {
            return false;
        }
        int readByte = this.in.read();
        if (readByte == -1) {
            if (throwEofException) {
                Message message = ProtocolMessages.ERR_ASN1_TRUNCATED_LENGTH_BYTE.get();
                throw new ASN1Exception(message);
            }
            return false;
        }
        this.peekLength = readByte & 0x7F;
        if (this.peekLength != readByte) {
            this.lengthBytesNeeded = this.peekLength;
            if (this.lengthBytesNeeded > 4) {
                Message message = ProtocolMessages.ERR_ASN1_INVALID_NUM_LENGTH_BYTES.get(this.lengthBytesNeeded);
                throw new ASN1Exception(message);
            }
            this.peekLength = 0;
            if (!isBlocking && this.in.available() < this.lengthBytesNeeded) {
                this.state = 2;
                return false;
            }
            while (this.lengthBytesNeeded > 0) {
                readByte = this.in.read();
                if (readByte == -1) {
                    this.state = 2;
                    if (throwEofException) {
                        Message message = ProtocolMessages.ERR_ASN1_TRUNCATED_LENGTH_BYTES.get(this.lengthBytesNeeded);
                        throw new ASN1Exception(message);
                    }
                    return false;
                }
                this.peekLength = this.peekLength << 8 | readByte & 0xFF;
                --this.lengthBytesNeeded;
            }
        }
        if (this.maxElementSize > 0 && this.peekLength > this.maxElementSize) {
            Message m = ProtocolMessages.ERR_LDAP_CLIENT_DECODE_MAX_REQUEST_SIZE_EXCEEDED.get(this.peekLength, this.maxElementSize);
            throw new ASN1Exception(m);
        }
        this.state = 3;
        return true;
    }

    private boolean needAdditionalLengthBytesState(boolean isBlocking, boolean throwEofException) throws IOException, ASN1Exception {
        if (!isBlocking && this.in.available() < this.lengthBytesNeeded) {
            return false;
        }
        while (this.lengthBytesNeeded > 0) {
            int readByte = this.in.read();
            if (readByte == -1) {
                this.state = 2;
                if (throwEofException) {
                    Message message = ProtocolMessages.ERR_ASN1_TRUNCATED_LENGTH_BYTES.get(this.lengthBytesNeeded);
                    throw new ASN1Exception(message);
                }
                return false;
            }
            this.peekLength = this.peekLength << 8 | readByte & 0xFF;
            --this.lengthBytesNeeded;
        }
        if (this.maxElementSize > 0 && this.peekLength > this.maxElementSize) {
            Message m = ProtocolMessages.ERR_LDAP_CLIENT_DECODE_MAX_REQUEST_SIZE_EXCEEDED.get(this.peekLength, this.maxElementSize);
            throw new ASN1Exception(m);
        }
        this.state = 3;
        return true;
    }

    public byte peekType() throws ASN1Exception {
        try {
            if (this.state == 0) {
                this.needTypeState(true, true);
            }
            return this.peekType;
        }
        catch (IOException ioe) {
            Message message = ProtocolMessages.ERR_ASN1_READ_ERROR.get(ioe.toString());
            throw new ASN1Exception(message, (Throwable)ioe);
        }
    }

    public int peekLength() throws ASN1Exception {
        this.peekType();
        try {
            switch (this.state) {
                case 1: {
                    this.needFirstLengthByteState(true, true);
                    break;
                }
                case 2: {
                    this.needAdditionalLengthBytesState(true, true);
                }
            }
            return this.peekLength;
        }
        catch (IOException ioe) {
            Message message = ProtocolMessages.ERR_ASN1_READ_ERROR.get(ioe.toString());
            throw new ASN1Exception(message, (Throwable)ioe);
        }
    }

    public boolean readBoolean() throws ASN1Exception {
        this.peekLength();
        if (this.peekLength != 1) {
            Message message = ProtocolMessages.ERR_ASN1_BOOLEAN_INVALID_LENGTH.get(this.peekLength);
            throw new ASN1Exception(message);
        }
        try {
            int readByte = this.in.read();
            if (readByte == -1) {
                Message message = ProtocolMessages.ERR_ASN1_BOOLEAN_TRUNCATED_VALUE.get(this.peekLength);
                throw new ASN1Exception(message);
            }
            if (DebugLogger.debugEnabled()) {
                TRACER.debugProtocolElement(DebugLogLevel.VERBOSE, String.format("READ ASN.1 BOOLEAN(type=0x%x, length=%d, value=%s)", this.peekType, this.peekLength, String.valueOf(readByte != 0)));
            }
            this.state = 0;
            return readByte != 0;
        }
        catch (IOException ioe) {
            Message message = ProtocolMessages.ERR_ASN1_READ_ERROR.get(ioe.toString());
            throw new ASN1Exception(message, (Throwable)ioe);
        }
    }

    public int readEnumerated() throws ASN1Exception {
        this.peekLength();
        if (this.peekLength < 1 || this.peekLength > 4) {
            Message message = ProtocolMessages.ERR_ASN1_INTEGER_INVALID_LENGTH.get(this.peekLength);
            throw new ASN1Exception(message);
        }
        return (int)this.readInteger();
    }

    public long readInteger() throws ASN1Exception {
        this.peekLength();
        if (this.peekLength < 1 || this.peekLength > 8) {
            Message message = ProtocolMessages.ERR_ASN1_INTEGER_INVALID_LENGTH.get(this.peekLength);
            throw new ASN1Exception(message);
        }
        try {
            if (this.peekLength > 4) {
                long longValue = 0L;
                for (int i = 0; i < this.peekLength; ++i) {
                    int readByte = this.in.read();
                    if (readByte == -1) {
                        Message message = ProtocolMessages.ERR_ASN1_INTEGER_TRUNCATED_VALUE.get(this.peekLength);
                        throw new ASN1Exception(message);
                    }
                    if (i == 0 && (byte)readByte < 0) {
                        longValue = -1L;
                    }
                    longValue = longValue << 8 | (long)(readByte & 0xFF);
                }
                this.state = 0;
                return longValue;
            }
            int intValue = 0;
            for (int i = 0; i < this.peekLength; ++i) {
                int readByte = this.in.read();
                if (readByte == -1) {
                    Message message = ProtocolMessages.ERR_ASN1_INTEGER_TRUNCATED_VALUE.get(this.peekLength);
                    throw new ASN1Exception(message);
                }
                if (i == 0 && (byte)readByte < 0) {
                    intValue = -1;
                }
                intValue = intValue << 8 | readByte & 0xFF;
            }
            if (DebugLogger.debugEnabled()) {
                TRACER.debugProtocolElement(DebugLogLevel.VERBOSE, String.format("READ ASN.1 INTEGER(type=0x%x, length=%d, value=%d)", this.peekType, this.peekLength, intValue));
            }
            this.state = 0;
            return intValue;
        }
        catch (IOException ioe) {
            Message message = ProtocolMessages.ERR_ASN1_READ_ERROR.get(ioe.toString());
            throw new ASN1Exception(message, (Throwable)ioe);
        }
    }

    public void readNull() throws ASN1Exception {
        this.peekLength();
        if (this.peekLength != 0) {
            Message message = ProtocolMessages.ERR_ASN1_NULL_INVALID_LENGTH.get(this.peekLength);
            throw new ASN1Exception(message);
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugProtocolElement(DebugLogLevel.VERBOSE, String.format("READ ASN.1 NULL(type=0x%x, length=%d)", this.peekType, this.peekLength));
        }
        this.state = 0;
    }

    public ByteString readOctetString() throws ASN1Exception {
        this.peekLength();
        if (this.peekLength == 0) {
            this.state = 0;
            return ByteString.empty();
        }
        try {
            int bytesRead;
            byte[] value = new byte[this.peekLength];
            for (int bytesNeeded = this.peekLength; bytesNeeded > 0; bytesNeeded -= bytesRead) {
                bytesRead = this.in.read(value, this.peekLength - bytesNeeded, bytesNeeded);
                if (bytesRead >= 0) continue;
                Message message = ProtocolMessages.ERR_ASN1_OCTET_STRING_TRUNCATED_VALUE.get(this.peekLength);
                throw new ASN1Exception(message);
            }
            if (DebugLogger.debugEnabled()) {
                TRACER.debugProtocolElement(DebugLogLevel.VERBOSE, String.format("READ ASN.1 OCTETSTRING(type=0x%x, length=%d)", this.peekType, this.peekLength));
            }
            this.state = 0;
            return ByteString.wrap(value);
        }
        catch (IOException ioe) {
            Message message = ProtocolMessages.ERR_ASN1_READ_ERROR.get(ioe.toString());
            throw new ASN1Exception(message, (Throwable)ioe);
        }
    }

    public String readOctetStringAsString() throws ASN1Exception {
        return this.readOctetStringAsString("UTF-8");
    }

    public String readOctetStringAsString(String charSet) throws ASN1Exception {
        String str;
        this.peekLength();
        if (this.peekLength == 0) {
            this.state = 0;
            return "";
        }
        if (this.peekLength > this.buffer.length) {
            this.buffer = new byte[this.peekLength];
        }
        try {
            int bytesRead;
            for (int bytesNeeded = this.peekLength; bytesNeeded > 0; bytesNeeded -= bytesRead) {
                bytesRead = this.in.read(this.buffer, this.peekLength - bytesNeeded, bytesNeeded);
                if (bytesRead >= 0) continue;
                Message message = ProtocolMessages.ERR_ASN1_OCTET_STRING_TRUNCATED_VALUE.get(this.peekLength);
                throw new ASN1Exception(message);
            }
            this.state = 0;
        }
        catch (IOException ioe) {
            Message message = ProtocolMessages.ERR_ASN1_READ_ERROR.get(ioe.toString());
            throw new ASN1Exception(message, (Throwable)ioe);
        }
        try {
            str = new String(this.buffer, 0, this.peekLength, charSet);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            str = new String(this.buffer, 0, this.peekLength);
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugProtocolElement(DebugLogLevel.VERBOSE, String.format("READ ASN.1 OCTETSTRING(type=0x%x, length=%d, value=%s)", this.peekType, this.peekLength, str));
        }
        return str;
    }

    public void readOctetString(ByteStringBuilder buffer) throws ASN1Exception {
        this.peekLength();
        if (this.peekLength == 0) {
            this.state = 0;
            return;
        }
        try {
            int bytesRead;
            for (int bytesNeeded = this.peekLength; bytesNeeded > 0; bytesNeeded -= bytesRead) {
                bytesRead = buffer.append(this.in, bytesNeeded);
                if (bytesRead >= 0) continue;
                Message message = ProtocolMessages.ERR_ASN1_OCTET_STRING_TRUNCATED_VALUE.get(this.peekLength);
                throw new ASN1Exception(message);
            }
            if (DebugLogger.debugEnabled()) {
                TRACER.debugProtocolElement(DebugLogLevel.VERBOSE, String.format("READ ASN.1 OCTETSTRING(type=0x%x, length=%d)", this.peekType, this.peekLength));
            }
            this.state = 0;
        }
        catch (IOException ioe) {
            Message message = ProtocolMessages.ERR_ASN1_READ_ERROR.get(ioe.toString());
            throw new ASN1Exception(message, (Throwable)ioe);
        }
    }

    public void readStartSequence() throws ASN1Exception {
        this.peekLength();
        SizeLimitInputStream subStream = new SizeLimitInputStream(this.in, this.peekLength);
        if (DebugLogger.debugEnabled()) {
            TRACER.debugProtocolElement(DebugLogLevel.VERBOSE, String.format("READ ASN.1 SEQUENCE(type=0x%x, length=%d)", this.peekType, this.peekLength));
        }
        this.streamStack.addFirst(this.in);
        this.in = subStream;
        this.state = 0;
    }

    public void readStartSet() throws ASN1Exception {
        this.readStartSequence();
    }

    public void readEndSequence() throws ASN1Exception {
        if (this.streamStack.isEmpty()) {
            Message message = ProtocolMessages.ERR_ASN1_SEQUENCE_READ_NOT_STARTED.get();
            throw new ASN1Exception(message);
        }
        SizeLimitInputStream subSq = (SizeLimitInputStream)this.in;
        if (subSq.getSizeLimit() - subSq.getBytesRead() > 0) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugWarning("Ignoring %d unused trailing bytes in ASN.1 SEQUENCE", subSq.getSizeLimit() - subSq.getBytesRead());
            }
            try {
                subSq.skip(subSq.getSizeLimit() - subSq.getBytesRead());
            }
            catch (IOException ioe) {
                Message message = ProtocolMessages.ERR_ASN1_READ_ERROR.get(ioe.toString());
                throw new ASN1Exception(message, (Throwable)ioe);
            }
        }
        this.in = this.streamStack.removeFirst();
        this.state = 0;
    }

    public void readEndSet() throws ASN1Exception {
        this.readEndSequence();
    }

    public void skipElement() throws ASN1Exception {
        this.peekLength();
        try {
            long bytesSkipped = this.in.skip(this.peekLength);
            if (bytesSkipped != (long)this.peekLength) {
                Message message = ProtocolMessages.ERR_ASN1_SKIP_TRUNCATED_VALUE.get(this.peekLength);
                throw new ASN1Exception(message);
            }
            this.state = 0;
        }
        catch (IOException ioe) {
            Message message = ProtocolMessages.ERR_ASN1_READ_ERROR.get(ioe.toString());
            throw new ASN1Exception(message, (Throwable)ioe);
        }
    }

    public void close() throws IOException {
        this.in.close();
        this.streamStack.clear();
    }
}

