/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.plugin;

import java.util.ArrayList;
import java.util.Iterator;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.plugin.AttributeInfo;
import org.opends.server.replication.plugin.HistKey;
import org.opends.server.replication.plugin.ValueInfo;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeBuilder;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.Entry;
import org.opends.server.types.Modification;
import org.opends.server.types.ModificationType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttrInfoMultiple
extends AttributeInfo {
    private ChangeNumber deleteTime;
    private ChangeNumber lastUpdateTime;
    private ArrayList<ValueInfo> valuesInfo;

    public AttrInfoMultiple(ChangeNumber deleteTime, ChangeNumber updateTime, ArrayList<ValueInfo> valuesInfo) {
        this.deleteTime = deleteTime;
        this.lastUpdateTime = updateTime;
        this.valuesInfo = valuesInfo == null ? new ArrayList() : valuesInfo;
    }

    public AttrInfoMultiple() {
        this.deleteTime = null;
        this.lastUpdateTime = null;
        this.valuesInfo = new ArrayList();
    }

    private ChangeNumber getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @Override
    public ChangeNumber getDeleteTime() {
        return this.deleteTime;
    }

    AttrInfoMultiple duplicate() {
        AttrInfoMultiple dup = new AttrInfoMultiple(this.deleteTime, this.lastUpdateTime, this.valuesInfo);
        return dup;
    }

    protected void delete(ChangeNumber CN) {
        Iterator<ValueInfo> it = this.valuesInfo.iterator();
        while (it.hasNext()) {
            ValueInfo info = it.next();
            if (!CN.newerOrEquals(info.getValueUpdateTime()) || !CN.newerOrEquals(info.getValueDeleteTime())) continue;
            it.remove();
        }
        if (CN.newer(this.deleteTime)) {
            this.deleteTime = CN;
        }
        if (CN.newer(this.lastUpdateTime)) {
            this.lastUpdateTime = CN;
        }
    }

    protected void delete(AttributeValue val, ChangeNumber CN) {
        ValueInfo info = new ValueInfo(val, null, CN);
        this.valuesInfo.remove(info);
        this.valuesInfo.add(info);
        if (CN.newer(this.lastUpdateTime)) {
            this.lastUpdateTime = CN;
        }
    }

    protected void delete(Attribute attr, ChangeNumber CN) {
        for (AttributeValue val : attr) {
            ValueInfo info = new ValueInfo(val, null, CN);
            this.valuesInfo.remove(info);
            this.valuesInfo.add(info);
            if (!CN.newer(this.lastUpdateTime)) continue;
            this.lastUpdateTime = CN;
        }
    }

    protected void add(AttributeValue val, ChangeNumber CN) {
        ValueInfo info = new ValueInfo(val, CN, null);
        this.valuesInfo.remove(info);
        this.valuesInfo.add(info);
        if (CN.newer(this.lastUpdateTime)) {
            this.lastUpdateTime = CN;
        }
    }

    private void add(Attribute attr, ChangeNumber CN) {
        for (AttributeValue val : attr) {
            ValueInfo info = new ValueInfo(val, CN, null);
            this.valuesInfo.remove(info);
            this.valuesInfo.add(info);
            if (!CN.newer(this.lastUpdateTime)) continue;
            this.lastUpdateTime = CN;
        }
    }

    @Override
    public ArrayList<ValueInfo> getValuesInfo() {
        return this.valuesInfo;
    }

    @Override
    public boolean replayOperation(Iterator<Modification> modsIterator, ChangeNumber changeNumber, Entry modifiedEntry, Modification m) {
        if (ChangeNumber.compare(changeNumber, this.getLastUpdateTime()) <= 0 || m.getModificationType() != ModificationType.REPLACE) {
            switch (m.getModificationType()) {
                case DELETE: {
                    if (changeNumber.older(this.getDeleteTime()).booleanValue()) {
                        modsIterator.remove();
                        break;
                    }
                    if (this.conflictDelete(changeNumber, m, modifiedEntry)) break;
                    modsIterator.remove();
                    break;
                }
                case ADD: {
                    this.conflictAdd(changeNumber, m, modsIterator);
                    break;
                }
                case REPLACE: {
                    if (changeNumber.older(this.getDeleteTime()).booleanValue()) {
                        modsIterator.remove();
                        break;
                    }
                    Attribute addedValues = m.getAttribute();
                    m.setAttribute(new AttributeBuilder(addedValues, true).toAttribute());
                    this.conflictDelete(changeNumber, m, modifiedEntry);
                    Attribute keptValues = m.getAttribute();
                    m.setAttribute(addedValues);
                    this.conflictAdd(changeNumber, m, modsIterator);
                    AttributeBuilder builder = new AttributeBuilder(keptValues);
                    builder.addAll(m.getAttribute());
                    m.setAttribute(builder.toAttribute());
                    break;
                }
            }
            return true;
        }
        this.processLocalOrNonConflictModification(changeNumber, m);
        return false;
    }

    @Override
    public void processLocalOrNonConflictModification(ChangeNumber changeNumber, Modification mod) {
        Attribute modAttr = mod.getAttribute();
        AttributeType type = modAttr.getAttributeType();
        switch (mod.getModificationType()) {
            case DELETE: {
                if (modAttr.isEmpty()) {
                    this.delete(changeNumber);
                    break;
                }
                this.delete(modAttr, changeNumber);
                break;
            }
            case ADD: {
                if (type.isSingleValue()) {
                    this.delete(changeNumber);
                }
                this.add(modAttr, changeNumber);
                break;
            }
            case REPLACE: {
                this.delete(changeNumber);
                this.add(modAttr, changeNumber);
                break;
            }
        }
    }

    private boolean conflictDelete(ChangeNumber changeNumber, Modification m, Entry modifiedEntry) {
        Attribute modAttr = m.getAttribute();
        if (modAttr.isEmpty()) {
            m.setModificationType(ModificationType.REPLACE);
            AttributeBuilder builder = new AttributeBuilder(modAttr, true);
            Iterator<ValueInfo> it = this.getValuesInfo().iterator();
            while (it.hasNext()) {
                ValueInfo valInfo = it.next();
                if (changeNumber.older(valInfo.getValueUpdateTime()).booleanValue()) {
                    builder.add(valInfo.getValue());
                    continue;
                }
                if (!changeNumber.newerOrEquals(valInfo.getValueDeleteTime())) continue;
                it.remove();
            }
            m.setAttribute(builder.toAttribute());
            if (changeNumber.newer(this.getDeleteTime())) {
                this.deleteTime = changeNumber;
            }
            if (changeNumber.newer(this.getLastUpdateTime())) {
                this.lastUpdateTime = changeNumber;
            }
        } else {
            ArrayList<ValueInfo> valuesInfo = this.getValuesInfo();
            AttributeBuilder builder = new AttributeBuilder(modAttr);
            for (AttributeValue val : modAttr) {
                Boolean deleteIt = true;
                Boolean addedInCurrentOp = false;
                ValueInfo valInfo = new ValueInfo(val, null, changeNumber);
                int index = valuesInfo.indexOf(valInfo);
                if (index != -1) {
                    ValueInfo oldValInfo = valuesInfo.get(index);
                    if (changeNumber.equals(oldValInfo.getValueUpdateTime())) {
                        addedInCurrentOp = true;
                    }
                    if (changeNumber.newerOrEquals(oldValInfo.getValueDeleteTime()) && changeNumber.newerOrEquals(oldValInfo.getValueUpdateTime())) {
                        valuesInfo.remove(index);
                        valuesInfo.add(valInfo);
                    } else if (oldValInfo.isUpdate()) {
                        deleteIt = false;
                    }
                } else {
                    valuesInfo.add(valInfo);
                }
                if (deleteIt.booleanValue() && (modifiedEntry.hasValue(modAttr.getAttributeType(), modAttr.getOptions(), val) || addedInCurrentOp.booleanValue())) continue;
                builder.remove(val);
                if (!builder.isEmpty()) continue;
                return false;
            }
            m.setAttribute(builder.toAttribute());
            if (changeNumber.newer(this.getLastUpdateTime())) {
                this.lastUpdateTime = changeNumber;
            }
        }
        return true;
    }

    private boolean conflictAdd(ChangeNumber changeNumber, Modification m, Iterator<Modification> modsIterator) {
        if (changeNumber.older(this.getDeleteTime()).booleanValue()) {
            modsIterator.remove();
            return false;
        }
        AttributeBuilder builder = new AttributeBuilder(m.getAttribute());
        for (AttributeValue addVal : m.getAttribute()) {
            ValueInfo valInfo;
            ArrayList<ValueInfo> valuesInfo = this.getValuesInfo();
            int index = valuesInfo.indexOf(valInfo = new ValueInfo(addVal, changeNumber, null));
            if (index == -1) {
                valuesInfo.add(valInfo);
                continue;
            }
            ValueInfo oldValueInfo = valuesInfo.get(index);
            if (oldValueInfo.isUpdate()) {
                if (changeNumber.newer(oldValueInfo.getValueUpdateTime())) {
                    valuesInfo.remove(index);
                    valuesInfo.add(valInfo);
                }
                builder.remove(addVal);
                continue;
            }
            if (changeNumber.newerOrEquals(oldValueInfo.getValueDeleteTime())) {
                valuesInfo.remove(index);
                valuesInfo.add(valInfo);
                continue;
            }
            builder.remove(addVal);
        }
        Attribute attr = builder.toAttribute();
        m.setAttribute(attr);
        if (attr.isEmpty()) {
            modsIterator.remove();
        }
        if (changeNumber.newer(this.getLastUpdateTime())) {
            this.lastUpdateTime = changeNumber;
        }
        return true;
    }

    @Override
    public void load(HistKey histKey, AttributeValue value, ChangeNumber cn) {
        switch (histKey) {
            case ADD: {
                if (value == null) break;
                this.add(value, cn);
                break;
            }
            case DEL: {
                if (value == null) break;
                this.delete(value, cn);
                break;
            }
            case REPL: {
                this.delete(cn);
                if (value == null) break;
                this.add(value, cn);
                break;
            }
            case DELATTR: {
                this.delete(cn);
            }
        }
    }
}

