/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.plugin;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.opends.messages.Message;
import org.opends.messages.ReplicationMessages;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.plugin.AttrInfoWithOptions;
import org.opends.server.replication.plugin.AttributeInfo;
import org.opends.server.replication.plugin.FakeAddOperation;
import org.opends.server.replication.plugin.FakeModdnOperation;
import org.opends.server.replication.plugin.FakeModifyOperation;
import org.opends.server.replication.plugin.FakeOperation;
import org.opends.server.replication.plugin.HistKey;
import org.opends.server.replication.plugin.HistVal;
import org.opends.server.replication.plugin.ValueInfo;
import org.opends.server.replication.protocol.OperationContext;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeBuilder;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AttributeValues;
import org.opends.server.types.Attributes;
import org.opends.server.types.Entry;
import org.opends.server.types.Modification;
import org.opends.server.types.ModificationType;
import org.opends.server.types.operation.PreOperationAddOperation;
import org.opends.server.types.operation.PreOperationModifyDNOperation;
import org.opends.server.types.operation.PreOperationModifyOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Historical {
    public static final String HISTORICALATTRIBUTENAME = "ds-sync-hist";
    public static final String HISTORICAL = "ds-synch-historical";
    public static final String ENTRYUIDNAME = "entryuuid";
    private HashMap<AttributeType, AttrInfoWithOptions> attributesInfo = new HashMap();
    private ChangeNumber ADDDate = null;
    private ChangeNumber MODDNDate = null;

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.encode());
        return builder.toString();
    }

    public boolean replayOperation(PreOperationModifyOperation modifyOperation, Entry modifiedEntry) {
        boolean bConflict = false;
        List<Modification> mods = modifyOperation.getModifications();
        ChangeNumber changeNumber = OperationContext.getChangeNumber(modifyOperation);
        Iterator<Modification> modsIterator = mods.iterator();
        while (modsIterator.hasNext()) {
            Modification m = modsIterator.next();
            AttributeInfo attrInfo = this.getAttrInfo(m);
            if (!attrInfo.replayOperation(modsIterator, changeNumber, modifiedEntry, m)) continue;
            bConflict = true;
        }
        return bConflict;
    }

    public void generateState(PreOperationModifyOperation modifyOperation) {
        Modification mod2;
        List<Modification> mods = modifyOperation.getModifications();
        Entry modifiedEntry = modifyOperation.getModifiedEntry();
        ChangeNumber changeNumber = OperationContext.getChangeNumber(modifyOperation);
        if (!modifyOperation.isSynchronizationOperation()) {
            for (Modification mod2 : mods) {
                AttributeInfo attrInfo = this.getAttrInfo(mod2);
                if (attrInfo == null) continue;
                attrInfo.processLocalOrNonConflictModification(changeNumber, mod2);
            }
        }
        Attribute attr = this.encode();
        mod2 = new Modification(ModificationType.REPLACE, attr);
        mods.add(mod2);
        modifiedEntry.replaceAttribute(attr);
    }

    public void generateState(PreOperationModifyDNOperation modifyDNOperation) {
        this.MODDNDate = OperationContext.getChangeNumber(modifyDNOperation);
        Entry modifiedEntry = modifyDNOperation.getUpdatedEntry();
        List<Modification> mods = modifyDNOperation.getModifications();
        Attribute attr = this.encode();
        Modification mod = new Modification(ModificationType.REPLACE, attr);
        mods.add(mod);
        modifiedEntry.removeAttribute(attr.getAttributeType());
        modifiedEntry.addAttribute(attr, null);
    }

    public static void generateState(PreOperationAddOperation addOperation) {
        AttributeType historicalAttrType = DirectoryServer.getSchema().getAttributeType(HISTORICALATTRIBUTENAME);
        Attribute attr = Attributes.create(historicalAttrType, Historical.encodeAddHistorical(OperationContext.getChangeNumber(addOperation)));
        LinkedList<Attribute> attrList = new LinkedList<Attribute>();
        attrList.add(attr);
        addOperation.setAttribute(historicalAttrType, attrList);
    }

    private static AttributeValue encodeAddHistorical(ChangeNumber cn) {
        AttributeType historicalAttrType = DirectoryServer.getSchema().getAttributeType(HISTORICALATTRIBUTENAME);
        String strValue = "dn:" + cn.toString() + ":add";
        AttributeValue val = AttributeValues.create(historicalAttrType, strValue);
        return val;
    }

    private static AttributeValue encodeMODDNHistorical(ChangeNumber cn) {
        AttributeType historicalAttrType = DirectoryServer.getSchema().getAttributeType(HISTORICALATTRIBUTENAME);
        String strValue = "dn:" + cn.toString() + ":moddn";
        AttributeValue val = AttributeValues.create(historicalAttrType, strValue);
        return val;
    }

    private AttributeInfo getAttrInfo(Modification mod) {
        AttributeInfo attrInfo;
        Attribute modAttr = mod.getAttribute();
        if (Historical.isHistoricalAttribute(modAttr)) {
            return null;
        }
        Set<String> options = modAttr.getOptions();
        AttributeType type = modAttr.getAttributeType();
        AttrInfoWithOptions attrInfoWithOptions = this.attributesInfo.get(type);
        if (attrInfoWithOptions != null) {
            attrInfo = attrInfoWithOptions.get(options);
        } else {
            attrInfoWithOptions = new AttrInfoWithOptions();
            this.attributesInfo.put(type, attrInfoWithOptions);
            attrInfo = null;
        }
        if (attrInfo == null) {
            attrInfo = AttributeInfo.createAttributeInfo(type);
            attrInfoWithOptions.put(options, attrInfo);
        }
        return attrInfo;
    }

    public Attribute encode() {
        AttributeType historicalAttrType = DirectoryServer.getSchema().getAttributeType(HISTORICALATTRIBUTENAME);
        AttributeBuilder builder = new AttributeBuilder(historicalAttrType);
        for (Map.Entry<AttributeType, AttrInfoWithOptions> entryWithOptions : this.attributesInfo.entrySet()) {
            AttributeType type = entryWithOptions.getKey();
            HashMap<Set<String>, AttributeInfo> attrwithoptions = entryWithOptions.getValue().getAttributesInfo();
            for (Map.Entry<Set<String>, AttributeInfo> entry : attrwithoptions.entrySet()) {
                ChangeNumber deleteTime;
                boolean delAttr = false;
                Set<String> options = entry.getKey();
                String optionsString = "";
                AttributeInfo info = entry.getValue();
                if (options != null) {
                    StringBuilder optionsBuilder = new StringBuilder();
                    for (String s : options) {
                        optionsBuilder.append(';');
                        optionsBuilder.append(s);
                    }
                    optionsString = optionsBuilder.toString();
                }
                if ((deleteTime = info.getDeleteTime()) != null) {
                    delAttr = true;
                }
                for (ValueInfo valInfo : info.getValuesInfo()) {
                    AttributeValue val;
                    String strValue;
                    if (valInfo.getValueDeleteTime() != null) {
                        strValue = type.getNormalizedPrimaryName() + optionsString + ":" + valInfo.getValueDeleteTime().toString() + ":del:" + ((Object)valInfo.getValue()).toString();
                        val = AttributeValues.create(historicalAttrType, strValue);
                        builder.add(val);
                        continue;
                    }
                    if (valInfo.getValueUpdateTime() == null) continue;
                    if (delAttr && valInfo.getValueUpdateTime() == deleteTime && valInfo.getValue() != null) {
                        strValue = type.getNormalizedPrimaryName() + optionsString + ":" + valInfo.getValueUpdateTime().toString() + ":repl:" + ((Object)valInfo.getValue()).toString();
                        delAttr = false;
                    } else {
                        strValue = valInfo.getValue() == null ? type.getNormalizedPrimaryName() + optionsString + ":" + valInfo.getValueUpdateTime().toString() + ":add" : type.getNormalizedPrimaryName() + optionsString + ":" + valInfo.getValueUpdateTime().toString() + ":add:" + ((Object)valInfo.getValue()).toString();
                    }
                    val = AttributeValues.create(historicalAttrType, strValue);
                    builder.add(val);
                }
                if (!delAttr) continue;
                String strValue = type.getNormalizedPrimaryName() + optionsString + ":" + deleteTime.toString() + ":attrDel";
                AttributeValue val = AttributeValues.create(historicalAttrType, strValue);
                builder.add(val);
            }
        }
        if (this.ADDDate != null) {
            builder.add(Historical.encodeAddHistorical(this.ADDDate));
        }
        if (this.MODDNDate != null) {
            builder.add(Historical.encodeMODDNHistorical(this.MODDNDate));
        }
        return builder.toAttribute();
    }

    public boolean AddedOrRenamedAfter(ChangeNumber cn) {
        return cn.older(this.ADDDate) != false || cn.older(this.MODDNDate) != false;
    }

    public ChangeNumber getDNDate() {
        if (this.ADDDate == null) {
            return this.MODDNDate;
        }
        if (this.MODDNDate == null) {
            return this.ADDDate;
        }
        if (this.MODDNDate.older(this.ADDDate).booleanValue()) {
            return this.MODDNDate;
        }
        return this.ADDDate;
    }

    public static Historical load(Entry entry) {
        List<Attribute> hist = Historical.getHistoricalAttr(entry);
        Historical histObj = new Historical();
        AttributeType lastAttrType = null;
        Set<Object> lastOptions = new HashSet();
        AttributeInfo attrInfo = null;
        AttrInfoWithOptions attrInfoWithOptions = null;
        if (hist == null) {
            return histObj;
        }
        try {
            for (Attribute attr : hist) {
                for (AttributeValue val : attr) {
                    HistVal histVal = new HistVal(val.getValue().toString());
                    AttributeType attrType = histVal.getAttrType();
                    Set<String> options = histVal.getOptions();
                    ChangeNumber cn = histVal.getCn();
                    AttributeValue value = histVal.getAttributeValue();
                    HistKey histKey = histVal.getHistKey();
                    if (histVal.isADDOperation()) {
                        histObj.ADDDate = cn;
                        continue;
                    }
                    if (histVal.isMODDNOperation()) {
                        histObj.MODDNDate = cn;
                        continue;
                    }
                    if (attrType == null) {
                        Message message = ReplicationMessages.ERR_UNKNOWN_ATTRIBUTE_IN_HISTORICAL.get(entry.getDN().toNormalizedString(), histVal.getAttrString());
                        ErrorLogger.logError(message);
                        continue;
                    }
                    if (attrType != lastAttrType) {
                        attrInfo = AttributeInfo.createAttributeInfo(attrType);
                        attrInfoWithOptions = new AttrInfoWithOptions();
                        attrInfoWithOptions.put(options, attrInfo);
                        histObj.attributesInfo.put(attrType, attrInfoWithOptions);
                        lastAttrType = attrType;
                        lastOptions = options;
                    } else if (!((Object)options).equals(lastOptions)) {
                        attrInfo = AttributeInfo.createAttributeInfo(attrType);
                        attrInfoWithOptions.put(options, attrInfo);
                        lastOptions = options;
                    }
                    attrInfo.load(histKey, value, cn);
                }
            }
        }
        catch (Exception e) {
            Message message = ReplicationMessages.ERR_BAD_HISTORICAL.get(entry.getDN().toString());
            ErrorLogger.logError(message);
        }
        return histObj;
    }

    public static Iterable<FakeOperation> generateFakeOperations(Entry entry) {
        TreeMap<ChangeNumber, FakeOperation> operations = new TreeMap<ChangeNumber, FakeOperation>();
        List<Attribute> attrs = Historical.getHistoricalAttr(entry);
        if (attrs != null) {
            for (Attribute attr : attrs) {
                for (AttributeValue val : attr) {
                    FakeModifyOperation modifyFakeOperation;
                    HistVal histVal = new HistVal(val.getValue().toString());
                    if (histVal.isADDOperation()) {
                        operations.put(histVal.getCn(), new FakeAddOperation(histVal.getCn(), entry));
                        continue;
                    }
                    if (histVal.isMODDNOperation()) {
                        operations.put(histVal.getCn(), new FakeModdnOperation(histVal.getCn(), entry));
                        continue;
                    }
                    ChangeNumber cn = histVal.getCn();
                    Modification mod = histVal.generateMod();
                    FakeOperation fakeOperation = (FakeOperation)operations.get(cn);
                    if (fakeOperation != null && fakeOperation instanceof FakeModifyOperation) {
                        modifyFakeOperation = (FakeModifyOperation)fakeOperation;
                        modifyFakeOperation.addModification(mod);
                        continue;
                    }
                    String uuidString = Historical.getEntryUuid(entry);
                    if (uuidString == null) continue;
                    modifyFakeOperation = new FakeModifyOperation(entry.getDN(), cn, uuidString);
                    modifyFakeOperation.addModification(mod);
                    operations.put(histVal.getCn(), modifyFakeOperation);
                }
            }
        }
        return operations.values();
    }

    public static List<Attribute> getHistoricalAttr(Entry entry) {
        return entry.getAttribute(HISTORICALATTRIBUTENAME);
    }

    public static String getEntryUuid(Entry entry) {
        Attribute uuid;
        String uuidString = null;
        AttributeType entryuuidAttrType = DirectoryServer.getSchema().getAttributeType(ENTRYUIDNAME);
        List<Attribute> uuidAttrs = entry.getOperationalAttribute(entryuuidAttrType);
        if (uuidAttrs != null && !(uuid = uuidAttrs.get(0)).isEmpty()) {
            AttributeValue uuidVal = uuid.iterator().next();
            uuidString = uuidVal.getValue().toString();
        }
        return uuidString;
    }

    public static String getEntryUuid(PreOperationAddOperation op) {
        Attribute uuid;
        AttributeType entryuuidAttrType;
        String uuidString = null;
        Map<AttributeType, List<Attribute>> attrs = op.getOperationalAttributes();
        List<Attribute> uuidAttrs = attrs.get(entryuuidAttrType = DirectoryServer.getSchema().getAttributeType(ENTRYUIDNAME));
        if (uuidAttrs != null && !(uuid = uuidAttrs.get(0)).isEmpty()) {
            AttributeValue uuidVal = uuid.iterator().next();
            uuidString = uuidVal.getValue().toString();
        }
        return uuidString;
    }

    public static boolean isHistoricalAttribute(Attribute attr) {
        AttributeType attrType = attr.getAttributeType();
        return attrType.getNameOrOID().equals(HISTORICALATTRIBUTENAME);
    }
}

