/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.plugin;

import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.TreeMap;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.common.ChangeNumberGenerator;
import org.opends.server.replication.plugin.PendingChange;
import org.opends.server.replication.protocol.LDAPUpdateMsg;
import org.opends.server.replication.service.ReplicationDomain;
import org.opends.server.types.operation.PluginOperation;

public class PendingChanges {
    private SortedMap<ChangeNumber, PendingChange> pendingChanges = new TreeMap<ChangeNumber, PendingChange>();
    private ChangeNumberGenerator changeNumberGenerator;
    private ReplicationDomain domain;
    private boolean recoveringOldChanges = false;

    public PendingChanges(ChangeNumberGenerator changeNumberGenerator, ReplicationDomain domain) {
        this.changeNumberGenerator = changeNumberGenerator;
        this.domain = domain;
    }

    public synchronized LDAPUpdateMsg remove(ChangeNumber changeNumber) {
        return ((PendingChange)this.pendingChanges.remove(changeNumber)).getMsg();
    }

    public int size() {
        return this.pendingChanges.size();
    }

    public synchronized void commit(ChangeNumber changeNumber, LDAPUpdateMsg msg) {
        this._commit(changeNumber, msg);
    }

    public void _commit(ChangeNumber changeNumber, LDAPUpdateMsg msg) {
        PendingChange curChange = (PendingChange)this.pendingChanges.get(changeNumber);
        if (curChange == null) {
            throw new NoSuchElementException();
        }
        curChange.setCommitted(true);
        curChange.setMsg(msg);
    }

    public synchronized void commit(ChangeNumber changeNumber) {
        PendingChange curChange = (PendingChange)this.pendingChanges.get(changeNumber);
        if (curChange == null) {
            throw new NoSuchElementException();
        }
        curChange.setCommitted(true);
    }

    public synchronized ChangeNumber putLocalOperation(PluginOperation operation) {
        return this._putLocalOperation(operation);
    }

    public ChangeNumber _putLocalOperation(PluginOperation operation) {
        ChangeNumber changeNumber = this.changeNumberGenerator.newChangeNumber();
        PendingChange change = new PendingChange(changeNumber, operation, null);
        this.pendingChanges.put(changeNumber, change);
        return changeNumber;
    }

    public synchronized int pushCommittedChanges() {
        return this._pushCommittedChanges();
    }

    public int _pushCommittedChanges() {
        int numSentUpdates = 0;
        if (this.pendingChanges.isEmpty()) {
            return numSentUpdates;
        }
        ChangeNumber firstChangeNumber = this.pendingChanges.firstKey();
        PendingChange firstChange = (PendingChange)this.pendingChanges.get(firstChangeNumber);
        while (firstChange != null && firstChange.isCommitted()) {
            if (firstChange.getOp() != null && !firstChange.getOp().isSynchronizationOperation()) {
                ++numSentUpdates;
                LDAPUpdateMsg updateMsg = firstChange.getMsg();
                if (!this.recoveringOldChanges) {
                    this.domain.publish(updateMsg);
                } else {
                    this.domain.getServerState().update(updateMsg.getChangeNumber());
                }
            }
            this.pendingChanges.remove(firstChangeNumber);
            if (this.pendingChanges.isEmpty()) {
                firstChange = null;
                continue;
            }
            firstChangeNumber = this.pendingChanges.firstKey();
            firstChange = (PendingChange)this.pendingChanges.get(firstChangeNumber);
        }
        return numSentUpdates;
    }

    public synchronized int commitAndPushCommittedChanges(ChangeNumber changeNumber, LDAPUpdateMsg msg) {
        this._commit(changeNumber, msg);
        return this._pushCommittedChanges();
    }

    public void setRecovering(boolean b) {
        this.recoveringOldChanges = b;
    }

    public synchronized boolean RecoveryUntil(ChangeNumber recovered) {
        ChangeNumber lastLocalChange = this.domain.getLastLocalChange();
        if (recovered != null && recovered.newerOrEquals(lastLocalChange)) {
            this.recoveringOldChanges = false;
        }
        return this.recoveringOldChanges;
    }
}

