/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.protocol;

import java.io.UnsupportedEncodingException;
import java.util.zip.DataFormatException;
import org.opends.server.replication.protocol.ProtocolVersion;
import org.opends.server.replication.protocol.RoutableMsg;

public class EntryMsg
extends RoutableMsg {
    private byte[] entryByteArray;
    private int msgId = -1;

    public EntryMsg(int sender, int destination, byte[] entryBytes, int msgId) {
        super(sender, destination);
        this.entryByteArray = new byte[entryBytes.length];
        System.arraycopy(entryBytes, 0, this.entryByteArray, 0, entryBytes.length);
        this.msgId = msgId;
    }

    public EntryMsg(int serverID, int i, byte[] entryBytes, int pos, int length, int msgId) {
        super(serverID, i);
        this.entryByteArray = new byte[length];
        System.arraycopy(entryBytes, pos, this.entryByteArray, 0, length);
        this.msgId = msgId;
    }

    public EntryMsg(byte[] in, short version) throws DataFormatException {
        try {
            if (in[0] != 12) {
                throw new DataFormatException("input is not a valid " + this.getClass().getCanonicalName());
            }
            int pos = 1;
            int length = this.getNextLength(in, pos);
            String senderIDString = new String(in, pos, length, "UTF-8");
            this.senderID = Integer.valueOf(senderIDString);
            pos += length + 1;
            length = this.getNextLength(in, pos);
            String destinationString = new String(in, pos, length, "UTF-8");
            this.destination = Integer.valueOf(destinationString);
            pos += length + 1;
            if (version >= 4) {
                length = this.getNextLength(in, pos);
                String msgcntString = new String(in, pos, length, "UTF-8");
                this.msgId = Integer.valueOf(msgcntString);
                pos += length + 1;
            }
            length = in.length - (pos + 1);
            this.entryByteArray = new byte[length];
            for (int i = 0; i < length; ++i) {
                this.entryByteArray[i] = in[pos + i];
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new DataFormatException("UTF-8 is not supported by this jvm.");
        }
    }

    public byte[] getEntryBytes() {
        return this.entryByteArray;
    }

    public byte[] getBytes() throws UnsupportedEncodingException {
        return this.getBytes(ProtocolVersion.getCurrentVersion());
    }

    public byte[] getBytes(short version) {
        try {
            byte[] senderBytes = String.valueOf(this.senderID).getBytes("UTF-8");
            byte[] destinationBytes = String.valueOf(this.destination).getBytes("UTF-8");
            byte[] msgCntBytes = null;
            byte[] entryBytes = this.entryByteArray;
            int length = 1 + senderBytes.length + 1 + destinationBytes.length + 1 + entryBytes.length + 1;
            if (version >= 4) {
                msgCntBytes = String.valueOf(this.msgId).getBytes("UTF-8");
                length += 1 + msgCntBytes.length;
            }
            byte[] resultByteArray = new byte[length];
            resultByteArray[0] = 12;
            int pos = 1;
            pos = EntryMsg.addByteArray(senderBytes, resultByteArray, pos);
            pos = EntryMsg.addByteArray(destinationBytes, resultByteArray, pos);
            if (version >= 4) {
                pos = EntryMsg.addByteArray(msgCntBytes, resultByteArray, pos);
            }
            pos = EntryMsg.addByteArray(entryBytes, resultByteArray, pos);
            return resultByteArray;
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public int getMsgId() {
        return this.msgId;
    }

    public void setMsgId(int msgId) {
        this.msgId = msgId;
    }
}

