/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.protocol;

import java.io.UnsupportedEncodingException;
import java.util.zip.DataFormatException;
import org.opends.server.replication.protocol.ProtocolVersion;
import org.opends.server.replication.protocol.RoutableMsg;

public class InitializeTargetMsg
extends RoutableMsg {
    private String baseDN = null;
    private long entryCount;
    private int requestorID;
    private int initWindow;

    public InitializeTargetMsg(String baseDN, int serverID, int target, int target2, long entryCount, int initWindow) {
        super(serverID, target);
        this.requestorID = target2;
        this.baseDN = baseDN;
        this.entryCount = entryCount;
        this.initWindow = initWindow;
    }

    public InitializeTargetMsg(byte[] in, short version) throws DataFormatException {
        try {
            if (in[0] != 11) {
                throw new DataFormatException("input is not a valid InitializeDestinationMessage");
            }
            int pos = 1;
            int length = this.getNextLength(in, pos);
            String destinationString = new String(in, pos, length, "UTF-8");
            this.destination = Integer.valueOf(destinationString);
            pos += length + 1;
            length = this.getNextLength(in, pos);
            this.baseDN = new String(in, pos, length, "UTF-8");
            pos += length + 1;
            length = this.getNextLength(in, pos);
            String senderString = new String(in, pos, length, "UTF-8");
            this.senderID = Integer.valueOf(senderString);
            pos += length + 1;
            length = this.getNextLength(in, pos);
            String requestorString = new String(in, pos, length, "UTF-8");
            this.requestorID = Integer.valueOf(requestorString);
            pos += length + 1;
            length = this.getNextLength(in, pos);
            String entryCountString = new String(in, pos, length, "UTF-8");
            this.entryCount = Long.valueOf(entryCountString);
            pos += length + 1;
            if (version >= 4) {
                length = this.getNextLength(in, pos);
                String initWindowString = new String(in, pos, length, "UTF-8");
                this.initWindow = Integer.valueOf(initWindowString);
                pos += length + 1;
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new DataFormatException("UTF-8 is not supported by this jvm.");
        }
    }

    public long getEntryCount() {
        return this.entryCount;
    }

    public long getInitiatorID() {
        return this.requestorID;
    }

    public String getBaseDN() {
        return this.baseDN;
    }

    public int getInitWindow() {
        return this.initWindow;
    }

    public byte[] getBytes() throws UnsupportedEncodingException {
        return this.getBytes(ProtocolVersion.getCurrentVersion());
    }

    public byte[] getBytes(short version) throws UnsupportedEncodingException {
        try {
            byte[] byteDestination = String.valueOf(this.destination).getBytes("UTF-8");
            byte[] byteDn = this.baseDN.getBytes("UTF-8");
            byte[] byteSender = String.valueOf(this.senderID).getBytes("UTF-8");
            byte[] byteRequestor = String.valueOf(this.requestorID).getBytes("UTF-8");
            byte[] byteEntryCount = String.valueOf(this.entryCount).getBytes("UTF-8");
            byte[] byteInitWindow = null;
            int length = 1 + byteDestination.length + 1 + byteDn.length + 1 + byteSender.length + 1 + byteRequestor.length + 1 + byteEntryCount.length + 1;
            if (version >= 4) {
                byteInitWindow = String.valueOf(this.initWindow).getBytes("UTF-8");
                length += byteInitWindow.length + 1;
            }
            byte[] resultByteArray = new byte[length];
            resultByteArray[0] = 11;
            int pos = 1;
            pos = InitializeTargetMsg.addByteArray(byteDestination, resultByteArray, pos);
            pos = InitializeTargetMsg.addByteArray(byteDn, resultByteArray, pos);
            pos = InitializeTargetMsg.addByteArray(byteSender, resultByteArray, pos);
            pos = InitializeTargetMsg.addByteArray(byteRequestor, resultByteArray, pos);
            pos = InitializeTargetMsg.addByteArray(byteEntryCount, resultByteArray, pos);
            if (version >= 4) {
                pos = InitializeTargetMsg.addByteArray(byteInitWindow, resultByteArray, pos);
            }
            return resultByteArray;
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public void setInitWindow(int initWindow) {
        this.initWindow = initWindow;
    }
}

