/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server;

import java.util.SortedMap;
import java.util.TreeMap;
import org.opends.messages.Message;
import org.opends.messages.ReplicationMessages;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.protocol.UpdateMsg;

public class MsgQueue {
    private SortedMap<ChangeNumber, UpdateMsg> map = new TreeMap<ChangeNumber, UpdateMsg>();
    private final Object lock = new Object();
    private int bytesCount = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdateMsg first() {
        Object object = this.lock;
        synchronized (object) {
            return (UpdateMsg)this.map.get(this.map.firstKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdateMsg last() {
        Object object = this.lock;
        synchronized (object) {
            return (UpdateMsg)this.map.get(this.map.lastKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int count() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int bytesCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.bytesCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(UpdateMsg update) {
        Object object = this.lock;
        synchronized (object) {
            UpdateMsg msgSameChangeNumber = this.map.put(update.getChangeNumber(), update);
            if (msgSameChangeNumber != null) {
                boolean sameMsgs = false;
                try {
                    if (msgSameChangeNumber.getBytes().length == update.getBytes().length && msgSameChangeNumber.isAssured() == update.isAssured() && msgSameChangeNumber.getVersion() == update.getVersion()) {
                        sameMsgs = true;
                    }
                    if (!sameMsgs) {
                        this.bytesCount += update.size() - msgSameChangeNumber.size();
                        Message errMsg = ReplicationMessages.ERR_RSQUEUE_DIFFERENT_MSGS_WITH_SAME_CN.get(msgSameChangeNumber.getChangeNumber().toString(), msgSameChangeNumber.toString(), update.toString());
                        ErrorLogger.logError(errMsg);
                    }
                }
                catch (Exception e) {}
            } else {
                this.bytesCount += update.size();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdateMsg removeFirst() {
        Object object = this.lock;
        synchronized (object) {
            UpdateMsg update = (UpdateMsg)this.map.get(this.map.firstKey());
            this.map.remove(update.getChangeNumber());
            this.bytesCount -= update.size();
            if (this.map.size() == 0 && this.bytesCount != 0) {
                Message msg = ReplicationMessages.ERR_BYTE_COUNT.get(Integer.toString(this.bytesCount));
                ErrorLogger.logError(msg);
                this.bytesCount = 0;
            }
            return update;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(UpdateMsg msg) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.containsKey(msg.getChangeNumber());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.map.clear();
            this.bytesCount = 0;
        }
    }
}

