/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockConflictException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.zip.DataFormatException;
import org.opends.messages.MessageBuilder;
import org.opends.messages.ReplicationMessages;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.protocol.UpdateMsg;
import org.opends.server.replication.server.ReplicationData;
import org.opends.server.replication.server.ReplicationDbEnv;
import org.opends.server.replication.server.ReplicationKey;
import org.opends.server.replication.server.ReplicationServer;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicationDB {
    private Database db = null;
    private ReplicationDbEnv dbenv = null;
    private ReplicationServer replicationServer;
    private int serverId;
    private String baseDn;
    private static final int DEADLOCK_RETRIES = 10;
    private ReentrantReadWriteLock dbCloseLock;
    private int counterCurrValue = 1;
    private long counterTsLimit = 0L;
    private int counterWindowSize = 1000;

    public ReplicationDB(int serverId, String baseDn, ReplicationServer replicationServer, ReplicationDbEnv dbenv) throws DatabaseException {
        this.serverId = serverId;
        this.baseDn = baseDn;
        this.dbenv = dbenv;
        this.replicationServer = replicationServer;
        this.db = dbenv.getOrAddDb(serverId, baseDn, replicationServer.getReplicationServerDomain(baseDn, true).getGenerationId());
        this.dbCloseLock = new ReentrantReadWriteLock(true);
        Cursor cursor = null;
        Transaction txn = null;
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry data = new DatabaseEntry();
        int distBackToCounterRecord = 0;
        this.counterCurrValue = 1;
        cursor = this.db.openCursor(txn, null);
        OperationStatus status = cursor.getLast(key, data, LockMode.DEFAULT);
        while (status == OperationStatus.SUCCESS) {
            try {
                ChangeNumber cn = new ChangeNumber(new String(key.getData(), "UTF-8"));
                if (!ReplicationDB.isaCounter(cn)) {
                    status = cursor.getPrev(key, data, LockMode.DEFAULT);
                    ++distBackToCounterRecord;
                    continue;
                }
                this.counterCurrValue = ReplicationDB.decodeCounterValue(data.getData()) + 1;
                this.counterTsLimit = cn.getTime();
                break;
            }
            catch (UnsupportedEncodingException e) {
                MessageBuilder mb = new MessageBuilder();
                mb.append(ReplicationMessages.ERR_CHANGELOG_UNSUPPORTED_UTF8_ENCODING.get());
                mb.append(StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(mb.toMessage());
                replicationServer.shutdown();
                if (txn != null) {
                    try {
                        txn.abort();
                    }
                    catch (DatabaseException e1) {
                        // empty catch block
                    }
                }
                replicationServer.shutdown();
            }
            catch (DataFormatException e) {
            }
        }
        this.counterCurrValue += distBackToCounterRecord;
        cursor.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntries(List<UpdateMsg> changes) {
        Transaction txn = null;
        try {
            int tries = 0;
            boolean done = false;
            while (tries++ < 10 && !done) {
                this.dbCloseLock.readLock().lock();
                try {
                    txn = this.dbenv.beginTransaction();
                    for (UpdateMsg change : changes) {
                        ReplicationKey key = new ReplicationKey(change.getChangeNumber());
                        ReplicationData data = new ReplicationData(change);
                        if (this.counterCurrValue != 0 && this.counterCurrValue % this.counterWindowSize == 0) {
                            this.counterTsLimit = change.getChangeNumber().getTime();
                        }
                        if (this.counterTsLimit != 0L && change.getChangeNumber().getTime() != this.counterTsLimit) {
                            ReplicationKey counterKey = new ReplicationKey(new ChangeNumber(change.getChangeNumber().getTime(), 0, 0));
                            DatabaseEntry counterValue = ReplicationDB.encodeCounterValue(this.counterCurrValue - 1);
                            this.db.put(txn, (DatabaseEntry)counterKey, counterValue);
                            this.counterTsLimit = 0L;
                        }
                        this.db.put(txn, (DatabaseEntry)key, (DatabaseEntry)data);
                        ++this.counterCurrValue;
                    }
                    txn.commitWriteNoSync();
                    txn = null;
                    done = true;
                }
                catch (LockConflictException e) {
                    if (txn != null) {
                        txn.abort();
                    }
                    txn = null;
                }
                finally {
                    this.dbCloseLock.readLock().unlock();
                }
            }
            if (!done) {
                MessageBuilder mb = new MessageBuilder();
                mb.append(ReplicationMessages.ERR_CHANGELOG_SHUTDOWN_DATABASE_ERROR.get());
                ErrorLogger.logError(mb.toMessage());
                if (txn != null) {
                    txn.abort();
                }
                this.replicationServer.shutdown();
            }
        }
        catch (DatabaseException e) {
            MessageBuilder mb = new MessageBuilder();
            mb.append(ReplicationMessages.ERR_CHANGELOG_SHUTDOWN_DATABASE_ERROR.get());
            mb.append(StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(mb.toMessage());
            if (txn != null) {
                try {
                    txn.abort();
                }
                catch (DatabaseException e1) {
                    // empty catch block
                }
            }
            this.replicationServer.shutdown();
        }
        catch (UnsupportedEncodingException e) {
            MessageBuilder mb = new MessageBuilder();
            mb.append(ReplicationMessages.ERR_CHANGELOG_UNSUPPORTED_UTF8_ENCODING.get());
            mb.append(StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(mb.toMessage());
            this.replicationServer.shutdown();
            if (txn != null) {
                try {
                    txn.abort();
                }
                catch (DatabaseException e1) {
                    // empty catch block
                }
            }
            this.replicationServer.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        try {
            this.dbCloseLock.writeLock().lock();
            try {
                this.db.close();
            }
            finally {
                this.dbCloseLock.writeLock().unlock();
            }
        }
        catch (DatabaseException e) {
            MessageBuilder mb = new MessageBuilder();
            mb.append(ReplicationMessages.NOTE_EXCEPTION_CLOSING_DATABASE.get(this.toString()));
            mb.append(StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(mb.toMessage());
        }
    }

    public ReplServerDBCursor openReadCursor(ChangeNumber changeNumber) throws DatabaseException, Exception {
        return new ReplServerDBCursor(changeNumber);
    }

    public ReplServerDBCursor openDeleteCursor() throws DatabaseException, Exception {
        return new ReplServerDBCursor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeLockedCursor(Cursor cursor) throws DatabaseException {
        try {
            if (cursor != null) {
                cursor.close();
            }
        }
        finally {
            this.dbCloseLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ChangeNumber readFirstChange() {
        Cursor cursor = null;
        String str = null;
        ChangeNumber cn = null;
        try {
            this.dbCloseLock.readLock().lock();
            cursor = this.db.openCursor(null, null);
        }
        catch (DatabaseException e1) {
            this.dbCloseLock.readLock().unlock();
            return null;
        }
        try {
            DatabaseEntry key;
            block12: {
                OperationStatus status;
                DatabaseEntry data;
                block11: {
                    key = new DatabaseEntry();
                    data = new DatabaseEntry();
                    status = cursor.getFirst(key, data, LockMode.DEFAULT);
                    if (status == OperationStatus.SUCCESS) break block11;
                    ChangeNumber changeNumber = null;
                    this.closeLockedCursor(cursor);
                    return changeNumber;
                }
                str = new String(key.getData(), "UTF-8");
                cn = new ChangeNumber(str);
                if (!ReplicationDB.isaCounter(cn)) return cn;
                status = cursor.getNext(key, data, LockMode.DEFAULT);
                if (status == OperationStatus.SUCCESS) break block12;
                ChangeNumber changeNumber = null;
                this.closeLockedCursor(cursor);
                return changeNumber;
            }
            try {
                try {
                    cn = new ChangeNumber(new String(key.getData(), "UTF-8"));
                    return cn;
                }
                catch (UnsupportedEncodingException e) {
                    // empty catch block
                    return cn;
                }
            }
            finally {
                this.closeLockedCursor(cursor);
            }
        }
        catch (DatabaseException e) {
            MessageBuilder mb = new MessageBuilder();
            mb.append(ReplicationMessages.ERR_CHANGELOG_SHUTDOWN_DATABASE_ERROR.get());
            mb.append(StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(mb.toMessage());
            this.replicationServer.shutdown();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ChangeNumber readLastChange() {
        Cursor cursor = null;
        ChangeNumber cn = null;
        try {
            DatabaseEntry data;
            DatabaseEntry key;
            block8: {
                ChangeNumber changeNumber;
                this.dbCloseLock.readLock().lock();
                try {
                    cursor = this.db.openCursor(null, null);
                    key = new DatabaseEntry();
                    data = new DatabaseEntry();
                    OperationStatus status = cursor.getLast(key, data, LockMode.DEFAULT);
                    if (status == OperationStatus.SUCCESS) break block8;
                    changeNumber = null;
                }
                catch (Throwable throwable) {
                    this.closeLockedCursor(cursor);
                    throw throwable;
                }
                this.closeLockedCursor(cursor);
                return changeNumber;
            }
            try {
                String str = new String(key.getData(), "UTF-8");
                cn = new ChangeNumber(str);
                if (ReplicationDB.isaCounter(cn) && cursor.getPrev(key, data, LockMode.DEFAULT) != OperationStatus.SUCCESS) {
                    cn = null;
                }
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
            this.closeLockedCursor(cursor);
            return cn;
        }
        catch (DatabaseException e) {
            MessageBuilder mb = new MessageBuilder();
            mb.append(ReplicationMessages.ERR_CHANGELOG_SHUTDOWN_DATABASE_ERROR.get());
            mb.append(StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(mb.toMessage());
            this.replicationServer.shutdown();
            return null;
        }
    }

    public String toString() {
        return this.serverId + this.baseDn.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws Exception, DatabaseException {
        this.dbCloseLock.writeLock().lock();
        try {
            String dbName = this.db.getDatabaseName();
            this.dbenv.clearServerId(this.baseDn, this.serverId);
            this.db.close();
            this.dbenv.clearDb(dbName);
            this.db = this.dbenv.getOrAddDb(this.serverId, this.baseDn, -1L);
        }
        catch (Exception e) {
            MessageBuilder mb = new MessageBuilder();
            mb.append(ReplicationMessages.ERR_ERROR_CLEARING_DB.get(this.toString(), e.getMessage() + " " + StaticUtils.stackTraceToSingleLineString(e)));
            ErrorLogger.logError(mb.toMessage());
        }
        finally {
            this.dbCloseLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int count(ChangeNumber start, ChangeNumber stop) {
        int counterRecord1 = 0;
        int counterRecord2 = 0;
        int distToCounterRecord1 = 0;
        int distBackToCounterRecord2 = 0;
        int count = 0;
        Cursor cursor = null;
        Transaction txn = null;
        try {
            ChangeNumber cn;
            OperationStatus status;
            if (start == null && stop == null) {
                int n = (int)this.db.count();
                return n;
            }
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            cursor = this.db.openCursor(txn, null);
            if (start != null) {
                key = new ReplicationKey(start);
                status = cursor.getSearchKey(key, data, LockMode.DEFAULT);
                if (status == OperationStatus.NOTFOUND) {
                    status = cursor.getSearchKeyRange(key, data, LockMode.DEFAULT);
                }
            } else {
                status = cursor.getNext(key, data, LockMode.DEFAULT);
            }
            while (status == OperationStatus.SUCCESS) {
                String csnString = new String(key.getData(), "UTF-8");
                cn = new ChangeNumber(csnString);
                if (cn.getServerId() != 0) {
                    if (cn.newer(stop)) break;
                    ++distToCounterRecord1;
                    status = cursor.getNext(key, data, LockMode.DEFAULT);
                    continue;
                }
                counterRecord1 = ReplicationDB.decodeCounterValue(data.getData());
                break;
            }
            cursor.close();
            if (counterRecord1 == 0) {
                int n = distToCounterRecord1;
                return n;
            }
            txn = null;
            data = new DatabaseEntry();
            key = new ReplicationKey(stop);
            cursor = this.db.openCursor(txn, null);
            status = cursor.getSearchKey(key, data, LockMode.DEFAULT);
            if (status == OperationStatus.SUCCESS) {
                cn = new ChangeNumber(new String(key.getData(), "UTF-8"));
            } else {
                key = new DatabaseEntry();
                data = new DatabaseEntry();
                status = cursor.getLast(key, data, LockMode.DEFAULT);
                if (status != OperationStatus.SUCCESS) {
                    int n = 0;
                    return n;
                }
            }
            while (status == OperationStatus.SUCCESS) {
                cn = new ChangeNumber(new String(key.getData(), "UTF-8"));
                if (!ReplicationDB.isaCounter(cn)) {
                    if (cn.older(start).booleanValue()) break;
                    ++distBackToCounterRecord2;
                    status = cursor.getPrev(key, data, LockMode.DEFAULT);
                    continue;
                }
                counterRecord2 = ReplicationDB.decodeCounterValue(data.getData());
                break;
            }
            cursor.close();
            if (counterRecord1 == 0) return count;
            if (counterRecord1 == counterRecord2) {
                count = distToCounterRecord1 + distBackToCounterRecord2;
                return count;
            }
            count = distToCounterRecord1 + (counterRecord2 - counterRecord1) + distBackToCounterRecord2;
            return count;
        }
        catch (UnsupportedEncodingException e) {
            MessageBuilder mb = new MessageBuilder();
            mb.append(ReplicationMessages.ERR_CHANGELOG_UNSUPPORTED_UTF8_ENCODING.get());
            mb.append(StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(mb.toMessage());
            this.replicationServer.shutdown();
            return count;
        }
        catch (DataFormatException e) {
            return count;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            if (txn != null) {
                try {
                    txn.abort();
                }
                catch (DatabaseException e1) {}
            }
        }
    }

    private static boolean isaCounter(ChangeNumber cn) {
        return cn.getServerId() == 0 && cn.getSeqnum() == 0;
    }

    private static int decodeCounterValue(byte[] entry) throws DataFormatException {
        try {
            String numAckStr = new String(entry, 0, entry.length, "UTF-8");
            return Integer.parseInt(numAckStr);
        }
        catch (UnsupportedEncodingException e) {
            throw new DataFormatException("UTF-8 is not supported by this jvm.");
        }
    }

    private static DatabaseEntry encodeCounterValue(int value) throws UnsupportedEncodingException {
        DatabaseEntry entry = new DatabaseEntry();
        entry.setData(String.valueOf(value).getBytes("UTF-8"));
        return entry;
    }

    public void setCounterWindowSize(int size) {
        this.counterWindowSize = size;
    }

    public class ReplServerDBCursor {
        private Cursor cursor = null;
        private Transaction txn = null;
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry data = new DatabaseEntry();

        private ReplServerDBCursor(ChangeNumber startingChangeNumber) throws Exception {
            try {
                ReplicationDB.this.dbCloseLock.readLock().lock();
                this.cursor = ReplicationDB.this.db.openCursor(this.txn, null);
                if (startingChangeNumber != null) {
                    this.key = new ReplicationKey(startingChangeNumber);
                    this.data = new DatabaseEntry();
                    if (this.cursor.getSearchKey(this.key, this.data, LockMode.DEFAULT) != OperationStatus.SUCCESS) {
                        if (this.cursor.getSearchKeyRange(this.key, this.data, LockMode.DEFAULT) != OperationStatus.SUCCESS) {
                            throw new Exception("ChangeNumber not available");
                        }
                        DatabaseEntry key = new DatabaseEntry();
                        DatabaseEntry data = new DatabaseEntry();
                        if (this.cursor.getPrev(key, data, LockMode.DEFAULT) != OperationStatus.SUCCESS) {
                            ReplicationDB.this.closeLockedCursor(this.cursor);
                            ReplicationDB.this.dbCloseLock.readLock().lock();
                            this.cursor = ReplicationDB.this.db.openCursor(this.txn, null);
                        }
                    }
                }
            }
            catch (Exception e) {
                ReplicationDB.this.closeLockedCursor(this.cursor);
                throw e;
            }
        }

        private ReplServerDBCursor() throws DatabaseException {
            try {
                ReplicationDB.this.dbCloseLock.readLock().lock();
                this.txn = ReplicationDB.this.dbenv.beginTransaction();
                this.cursor = ReplicationDB.this.db.openCursor(this.txn, null);
            }
            catch (DatabaseException e) {
                if (this.txn != null) {
                    try {
                        this.txn.abort();
                    }
                    catch (DatabaseException databaseException) {
                        // empty catch block
                    }
                }
                ReplicationDB.this.closeLockedCursor(this.cursor);
                throw e;
            }
        }

        public void close() {
            MessageBuilder mb;
            try {
                ReplicationDB.this.closeLockedCursor(this.cursor);
                this.cursor = null;
            }
            catch (DatabaseException e) {
                mb = new MessageBuilder();
                mb.append(ReplicationMessages.ERR_CHANGELOG_SHUTDOWN_DATABASE_ERROR.get());
                mb.append(StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(mb.toMessage());
                ReplicationDB.this.replicationServer.shutdown();
            }
            if (this.txn != null) {
                try {
                    this.txn.commit();
                }
                catch (DatabaseException e) {
                    mb = new MessageBuilder();
                    mb.append(ReplicationMessages.ERR_CHANGELOG_SHUTDOWN_DATABASE_ERROR.get());
                    mb.append(StaticUtils.stackTraceToSingleLineString(e));
                    ErrorLogger.logError(mb.toMessage());
                    ReplicationDB.this.replicationServer.shutdown();
                }
            }
        }

        public void abort() {
            MessageBuilder mb;
            if (this.cursor == null) {
                return;
            }
            try {
                ReplicationDB.this.closeLockedCursor(this.cursor);
                this.cursor = null;
            }
            catch (LockConflictException e1) {
            }
            catch (DatabaseException e) {
                mb = new MessageBuilder();
                mb.append(ReplicationMessages.ERR_CHANGELOG_SHUTDOWN_DATABASE_ERROR.get());
                mb.append(StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(mb.toMessage());
                ReplicationDB.this.replicationServer.shutdown();
            }
            if (this.txn != null) {
                try {
                    this.txn.abort();
                }
                catch (DatabaseException e) {
                    mb = new MessageBuilder();
                    mb.append(ReplicationMessages.ERR_CHANGELOG_SHUTDOWN_DATABASE_ERROR.get());
                    mb.append(StaticUtils.stackTraceToSingleLineString(e));
                    ErrorLogger.logError(mb.toMessage());
                    ReplicationDB.this.replicationServer.shutdown();
                }
            }
        }

        public ChangeNumber nextChangeNumber() throws DatabaseException {
            OperationStatus status = this.cursor.getNext(this.key, this.data, LockMode.DEFAULT);
            if (status != OperationStatus.SUCCESS) {
                return null;
            }
            try {
                String csnString = new String(this.key.getData(), "UTF-8");
                return new ChangeNumber(csnString);
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
        }

        public UpdateMsg next() {
            UpdateMsg currentChange = null;
            while (currentChange == null) {
                try {
                    OperationStatus status = this.cursor.getNext(this.key, this.data, LockMode.DEFAULT);
                    if (status != OperationStatus.SUCCESS) {
                        return null;
                    }
                }
                catch (DatabaseException e) {
                    return null;
                }
                try {
                    ChangeNumber cn = new ChangeNumber(new String(this.key.getData(), "UTF-8"));
                    if (ReplicationDB.isaCounter(cn)) continue;
                    currentChange = ReplicationData.generateChange(this.data.getData());
                }
                catch (Exception exception) {}
            }
            return currentChange;
        }

        public void delete() throws DatabaseException {
            this.cursor.delete();
        }
    }
}

