/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.opends.messages.Message;
import org.opends.messages.ReplicationMessages;
import org.opends.server.admin.std.server.MonitorProviderCfg;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.replication.common.AssuredMode;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.common.RSInfo;
import org.opends.server.replication.common.ServerStatus;
import org.opends.server.replication.protocol.AckMsg;
import org.opends.server.replication.protocol.ChangeTimeHeartbeatMsg;
import org.opends.server.replication.protocol.EntryMsg;
import org.opends.server.replication.protocol.ErrorMsg;
import org.opends.server.replication.protocol.HeartbeatThread;
import org.opends.server.replication.protocol.InitializeRequestMsg;
import org.opends.server.replication.protocol.InitializeTargetMsg;
import org.opends.server.replication.protocol.MonitorMsg;
import org.opends.server.replication.protocol.ProtocolSession;
import org.opends.server.replication.protocol.ProtocolVersion;
import org.opends.server.replication.protocol.ReplicationMsg;
import org.opends.server.replication.protocol.ResetGenerationIdMsg;
import org.opends.server.replication.protocol.RoutableMsg;
import org.opends.server.replication.protocol.StartECLSessionMsg;
import org.opends.server.replication.protocol.StartMsg;
import org.opends.server.replication.protocol.StartSessionMsg;
import org.opends.server.replication.protocol.StopMsg;
import org.opends.server.replication.protocol.TopologyMsg;
import org.opends.server.replication.protocol.UpdateMsg;
import org.opends.server.replication.protocol.WindowMsg;
import org.opends.server.replication.protocol.WindowProbeMsg;
import org.opends.server.replication.server.MessageHandler;
import org.opends.server.replication.server.ReplicationServer;
import org.opends.server.replication.server.ReplicationServerDomain;
import org.opends.server.replication.server.ServerReader;
import org.opends.server.replication.server.ServerWriter;
import org.opends.server.types.Attribute;
import org.opends.server.types.Attributes;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.TimeThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServerHandler
extends MessageHandler {
    private static final int SHUTDOWN_JOIN_TIMEOUT = 30000;
    protected int serverId;
    protected ProtocolSession session;
    protected String serverURL;
    protected int assuredSrReceivedUpdates = 0;
    protected AtomicInteger assuredSrReceivedUpdatesTimeout = new AtomicInteger();
    protected int assuredSrSentUpdates = 0;
    protected AtomicInteger assuredSrSentUpdatesTimeout = new AtomicInteger();
    protected int assuredSdReceivedUpdates = 0;
    protected AtomicInteger assuredSdReceivedUpdatesTimeout = new AtomicInteger();
    protected int assuredSdSentUpdates = 0;
    protected AtomicInteger assuredSdSentUpdatesTimeout = new AtomicInteger();
    protected ServerReader reader;
    protected ServerWriter writer = null;
    private int rcvWindow;
    private int rcvWindowSizeHalf;
    protected int maxRcvWindow;
    protected Semaphore sendWindow;
    int sendWindowSize;
    protected short protocolVersion = (short)-1;
    protected long generationId = -1L;
    protected long localGenerationId = -1L;
    protected long oldGenerationId = -1L;
    protected byte groupId = (byte)-1;
    protected boolean sslEncryption;
    protected long heartbeatInterval = 0L;
    HeartbeatThread heartbeatThread = null;
    protected boolean shutdownWriter = false;
    private AtomicBoolean shuttingDown = new AtomicBoolean(false);
    protected int weight = 1;

    protected static void closeSession(ProtocolSession providedSession, Message providedMsg, ServerHandler handler) {
        if (providedMsg != null) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("In " + (handler != null ? handler.toString() : "Replication Server") + " closing session with err=" + providedMsg.toString());
            }
            ErrorLogger.logError(providedMsg);
        }
        try {
            if (providedSession != null) {
                providedSession.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public ServerHandler(ProtocolSession session, int queueSize, String replicationServerURL, int replicationServerId, ReplicationServer replicationServer, int rcvWindowSize) {
        super(queueSize, replicationServerURL, replicationServerId, replicationServer);
        this.session = session;
        this.protocolVersion = ProtocolVersion.getCurrentVersion();
        this.rcvWindowSizeHalf = rcvWindowSize / 2;
        this.maxRcvWindow = rcvWindowSize;
        this.rcvWindow = rcvWindowSize;
    }

    protected void abortStart(Message reason) {
        if (this.session != null) {
            ServerHandler.closeSession(this.session, reason, this);
        }
        if (this.replicationServerDomain != null && this.replicationServerDomain.hasLock()) {
            this.replicationServerDomain.release();
        }
        if (this.oldGenerationId != -100L && this.replicationServerDomain != null) {
            this.replicationServerDomain.changeGenerationId(this.oldGenerationId, false);
        }
    }

    public synchronized void checkWindow() throws IOException {
        if (this.rcvWindow < this.rcvWindowSizeHalf) {
            WindowMsg msg = new WindowMsg(this.rcvWindowSizeHalf);
            this.session.publish(msg);
            this.rcvWindow += this.rcvWindowSizeHalf;
        }
    }

    public synchronized void decAndCheckWindow() throws IOException {
        --this.rcvWindow;
        this.checkWindow();
    }

    @Override
    public boolean engageShutdown() {
        return this.shuttingDown.getAndSet(true);
    }

    public boolean shuttingDown() {
        return this.shuttingDown.get();
    }

    protected void finalizeStart() throws DirectoryException {
        if (this.session != null) {
            try {
                this.session.setSoTimeout(0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.sendWindow = new Semaphore(this.sendWindowSize);
            this.writer = new ServerWriter(this.session, this.serverId, this, this.replicationServerDomain);
            this.reader = new ServerReader(this.session, this);
            this.reader.start();
            this.writer.start();
            if (this.heartbeatInterval > 0L) {
                this.heartbeatThread = new HeartbeatThread("Replication Heartbeat to " + this + " in RS " + this.replicationServerDomain.getReplicationServer().getMonitorInstanceName(), this.session, this.heartbeatInterval / 3L);
                this.heartbeatThread.start();
            }
        }
        DirectoryServer.deregisterMonitorProvider(this.getMonitorInstanceName());
        DirectoryServer.registerMonitorProvider(this);
    }

    public void send(ReplicationMsg msg) throws IOException {
        this.session.publish(msg);
    }

    @Override
    public long getApproxDelay() {
        long olderUpdateTime = this.getOlderUpdateTime();
        if (olderUpdateTime == 0L) {
            return 0L;
        }
        long currentTime = TimeThread.getTime();
        return (currentTime - olderUpdateTime) / 1000L;
    }

    @Override
    public Long getApproxFirstMissingDate() {
        Long result = 0L;
        ChangeNumber olderUpdateCN = this.getOlderUpdateCN();
        if (olderUpdateCN != null) {
            result = olderUpdateCN.getTime();
        }
        return result;
    }

    public int getAssuredSdReceivedUpdates() {
        return this.assuredSdReceivedUpdates;
    }

    public AtomicInteger getAssuredSdReceivedUpdatesTimeout() {
        return this.assuredSdReceivedUpdatesTimeout;
    }

    public int getAssuredSdSentUpdates() {
        return this.assuredSdSentUpdates;
    }

    public AtomicInteger getAssuredSdSentUpdatesTimeout() {
        return this.assuredSdSentUpdatesTimeout;
    }

    public int getAssuredSrReceivedUpdates() {
        return this.assuredSrReceivedUpdates;
    }

    public AtomicInteger getAssuredSrReceivedUpdatesTimeout() {
        return this.assuredSrReceivedUpdatesTimeout;
    }

    public int getAssuredSrSentUpdates() {
        return this.assuredSrSentUpdates;
    }

    public AtomicInteger getAssuredSrSentUpdatesTimeout() {
        return this.assuredSrSentUpdatesTimeout;
    }

    public ReplicationServerDomain getDomain() {
        return this.replicationServerDomain;
    }

    public long getGenerationId() {
        return this.generationId;
    }

    public byte getGroupId() {
        return this.groupId;
    }

    public long getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    @Override
    public int getInCount() {
        return this.inCount;
    }

    @Override
    public ArrayList<Attribute> getMonitorData() {
        List attributes = super.getMonitorData();
        ((ArrayList)attributes).add(Attributes.create("server-id", String.valueOf(this.serverId)));
        ((ArrayList)attributes).add(Attributes.create("domain-name", this.getServiceId().toString()));
        ((ArrayList)attributes).add(Attributes.create("max-waiting-changes", String.valueOf(this.maxQueueSize)));
        ((ArrayList)attributes).add(Attributes.create("sent-updates", String.valueOf(this.getOutCount())));
        ((ArrayList)attributes).add(Attributes.create("received-updates", String.valueOf(this.getInCount())));
        ((ArrayList)attributes).add(Attributes.create("assured-sr-received-updates", String.valueOf(this.getAssuredSrReceivedUpdates())));
        ((ArrayList)attributes).add(Attributes.create("assured-sr-received-updates-timeout", String.valueOf(this.getAssuredSrReceivedUpdatesTimeout())));
        ((ArrayList)attributes).add(Attributes.create("assured-sr-sent-updates", String.valueOf(this.getAssuredSrSentUpdates())));
        ((ArrayList)attributes).add(Attributes.create("assured-sr-sent-updates-timeout", String.valueOf(this.getAssuredSrSentUpdatesTimeout())));
        ((ArrayList)attributes).add(Attributes.create("assured-sd-received-updates", String.valueOf(this.getAssuredSdReceivedUpdates())));
        if (!this.isDataServer()) {
            ((ArrayList)attributes).add(Attributes.create("assured-sd-sent-updates", String.valueOf(this.getAssuredSdSentUpdates())));
            ((ArrayList)attributes).add(Attributes.create("assured-sd-sent-updates-timeout", String.valueOf(this.getAssuredSdSentUpdatesTimeout())));
        } else {
            ((ArrayList)attributes).add(Attributes.create("assured-sd-received-updates-timeout", String.valueOf(this.getAssuredSdReceivedUpdatesTimeout())));
        }
        ((ArrayList)attributes).add(Attributes.create("max-send-window", String.valueOf(this.sendWindowSize)));
        ((ArrayList)attributes).add(Attributes.create("current-send-window", String.valueOf(this.sendWindow.availablePermits())));
        ((ArrayList)attributes).add(Attributes.create("max-rcv-window", String.valueOf(this.maxRcvWindow)));
        ((ArrayList)attributes).add(Attributes.create("current-rcv-window", String.valueOf(this.rcvWindow)));
        ((ArrayList)attributes).add(Attributes.create("ssl-encryption", String.valueOf(this.session.isEncrypted())));
        ((ArrayList)attributes).add(Attributes.create("generation-id", String.valueOf(this.generationId)));
        return attributes;
    }

    @Override
    public abstract String getMonitorInstanceName();

    @Override
    public long getOlderUpdateTime() {
        ChangeNumber olderUpdateCN = this.getOlderUpdateCN();
        if (olderUpdateCN == null) {
            return 0L;
        }
        return olderUpdateCN.getTime();
    }

    @Override
    public int getOutCount() {
        return this.outCount;
    }

    public short getProtocolVersion() {
        return this.protocolVersion;
    }

    public int getServerId() {
        return this.serverId;
    }

    public String getServerURL() {
        return this.serverURL;
    }

    protected abstract ServerStatus getStatus();

    @Override
    public long getUpdateInterval() {
        return 0L;
    }

    public void incrementAssuredSdReceivedUpdates() {
        ++this.assuredSdReceivedUpdates;
    }

    public void incrementAssuredSdReceivedUpdatesTimeout() {
        this.assuredSdReceivedUpdatesTimeout.incrementAndGet();
    }

    public void incrementAssuredSdSentUpdates() {
        ++this.assuredSdSentUpdates;
    }

    public void incrementAssuredSdSentUpdatesTimeout() {
        this.assuredSdSentUpdatesTimeout.incrementAndGet();
    }

    public void incrementAssuredSrReceivedUpdates() {
        ++this.assuredSrReceivedUpdates;
    }

    public void incrementAssuredSrReceivedUpdatesTimeout() {
        this.assuredSrReceivedUpdatesTimeout.incrementAndGet();
    }

    public void incrementAssuredSrSentUpdates() {
        ++this.assuredSrSentUpdates;
    }

    public void incrementAssuredSrSentUpdatesTimeout() {
        this.assuredSrSentUpdatesTimeout.incrementAndGet();
    }

    @Override
    public void incrementInCount() {
        ++this.inCount;
    }

    @Override
    public void incrementOutCount() {
        ++this.outCount;
    }

    @Override
    public void initializeMonitorProvider(MonitorProviderCfg configuration) throws ConfigException, InitializationException {
    }

    public abstract boolean isDataServer();

    public boolean isReplicationServer() {
        return !this.isDataServer();
    }

    protected void lockDomain(boolean timedout) throws DirectoryException {
        try {
            if (!timedout) {
                if (!this.replicationServerDomain.hasLock()) {
                    this.replicationServerDomain.lock();
                }
            } else {
                Random random = new Random();
                int randomTime = random.nextInt(6);
                long timeout = 3000 + randomTime * 1000;
                boolean noTimeout = this.replicationServerDomain.tryLock(timeout);
                if (!noTimeout) {
                    Message message = ReplicationMessages.NOTE_TIMEOUT_WHEN_CROSS_CONNECTION.get(this.getServiceId(), Integer.toString(this.serverId), Integer.toString(this.replicationServerId));
                    throw new DirectoryException(ResultCode.OTHER, message);
                }
            }
        }
        catch (InterruptedException e) {
            Message message = ReplicationMessages.ERR_EXCEPTION_LOCKING_RS_DOMAIN.get(e.getMessage());
            ErrorLogger.logError(message);
        }
    }

    public void process(RoutableMsg msg) {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("In " + this.replicationServerDomain.getReplicationServer().getMonitorInstanceName() + this + " processes routable msg received:" + msg);
        }
        this.replicationServerDomain.process(msg, this);
    }

    public void process(ChangeTimeHeartbeatMsg msg) {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("In " + this.replicationServerDomain.getReplicationServer().getMonitorInstanceName() + this + " processes received msg:\n" + msg);
        }
        this.replicationServerDomain.processChangeTimeHeartbeatMsg(this, msg);
    }

    public void process(WindowProbeMsg windowProbeMsg) throws IOException {
        if (this.rcvWindow > 0) {
            WindowMsg msg = new WindowMsg(this.rcvWindow);
            this.session.publish(msg);
        } else {
            this.checkWindow();
        }
    }

    public void send(RoutableMsg msg) throws IOException {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("In " + this.replicationServerDomain.getReplicationServer().getMonitorInstanceName() + this + " publishes message:\n" + msg);
        }
        if (msg instanceof MonitorMsg || msg instanceof ErrorMsg || msg instanceof EntryMsg || msg instanceof InitializeRequestMsg || msg instanceof InitializeTargetMsg) {
            this.session.publish(msg, this.protocolVersion);
        } else {
            this.session.publish(msg);
        }
    }

    public void sendAck(AckMsg ack) throws IOException {
        this.session.publish(ack);
    }

    public void sendError(ErrorMsg errorMsg) throws IOException {
        this.session.publish(errorMsg);
    }

    public void sendTopoInfo(TopologyMsg topoMsg) throws IOException {
        if (this.protocolVersion > 1) {
            this.session.publish(topoMsg, this.protocolVersion);
        }
    }

    public void setGenerationId(long generationId) {
        this.generationId = generationId;
    }

    protected void setReplicationServerDomain(ReplicationServerDomain rsd) {
        this.replicationServerDomain = rsd;
    }

    protected void setSendWindowSize(int size) {
        this.sendWindowSize = size;
    }

    protected void shutdownWriter() {
        this.shutdownWriter = true;
    }

    @Override
    public void shutdown() {
        this.shutdownWriter();
        this.setConsumerActive(false);
        super.shutdown();
        if (this.session != null) {
            if (this.protocolVersion >= 4) {
                try {
                    this.session.publish(new StopMsg());
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            try {
                this.session.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (this.heartbeatThread != null) {
            this.heartbeatThread.shutdown();
        }
        DirectoryServer.deregisterMonitorProvider(this.getMonitorInstanceName());
        try {
            if (this.writer != null && !Thread.currentThread().equals(this.writer)) {
                this.writer.join(30000L);
            }
            if (this.reader != null && !Thread.currentThread().equals(this.reader)) {
                this.reader.join(30000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("SH.shutdowned(" + this + ")");
        }
    }

    public UpdateMsg take() {
        boolean interrupted = true;
        UpdateMsg msg = this.getnextMessage(true);
        boolean acquired = false;
        do {
            try {
                acquired = this.sendWindow.tryAcquire(500L, TimeUnit.MILLISECONDS);
                interrupted = false;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        } while ((interrupted || !acquired) && !this.shutdownWriter);
        if (msg != null) {
            this.incrementOutCount();
            if (msg.isAssured()) {
                if (msg.getAssuredMode() == AssuredMode.SAFE_READ_MODE) {
                    this.incrementAssuredSrSentUpdates();
                } else if (!this.isDataServer()) {
                    this.incrementAssuredSdSentUpdates();
                }
            }
        }
        return msg;
    }

    public RSInfo toRSInfo() {
        RSInfo rsInfo = new RSInfo(this.serverId, this.serverURL, this.generationId, this.groupId, this.weight);
        return rsInfo;
    }

    protected void createMonitoringPublisher() {
        if (!this.replicationServerDomain.isRunningMonitoringPublisher()) {
            this.replicationServerDomain.startMonitoringPublisher();
        }
    }

    @Override
    public void updateMonitorData() {
    }

    public void updateWindow(WindowMsg windowMsg) {
        this.sendWindow.release(windowMsg.getNumAck());
    }

    protected void logStartHandshakeRCVandSND(StartMsg inStartMsg, StartMsg outStartMsg) {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("In " + this.replicationServer.getMonitorInstanceName() + ", " + this.getClass().getSimpleName() + " " + this + ":" + "\nSH START HANDSHAKE RECEIVED:\n" + inStartMsg.toString() + "\nAND REPLIED:\n" + outStartMsg.toString());
        }
    }

    protected void logStartHandshakeSNDandRCV(StartMsg outStartMsg, StartMsg inStartMsg) {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("In " + this.replicationServer.getMonitorInstanceName() + ", " + this.getClass().getSimpleName() + " " + this + ":" + "\nSH START HANDSHAKE SENT(" + this + "):\n" + outStartMsg.toString() + "\nAND RECEIVED:\n" + inStartMsg.toString());
        }
    }

    protected void logTopoHandshakeRCVandSND(TopologyMsg inTopoMsg, TopologyMsg outTopoMsg) {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("In " + this.replicationServer.getMonitorInstanceName() + ", " + this.getClass().getSimpleName() + " " + this + ":" + "\nSH TOPO HANDSHAKE RECEIVED:\n" + inTopoMsg.toString() + "\nAND REPLIED:\n" + outTopoMsg.toString());
        }
    }

    protected void logTopoHandshakeSNDandRCV(TopologyMsg outTopoMsg, TopologyMsg inTopoMsg) {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("In " + this.replicationServer.getMonitorInstanceName() + ", " + this.getClass().getSimpleName() + " " + this + ":" + "\nSH TOPO HANDSHAKE SENT:\n" + outTopoMsg.toString() + "\nAND RECEIVED:\n" + inTopoMsg.toString());
        }
    }

    protected void logStartSessionHandshake(StartSessionMsg inStartSessionMsg, TopologyMsg outTopoMsg) {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("In " + this.replicationServer.getMonitorInstanceName() + ", " + this.getClass().getSimpleName() + " " + this + " :" + "\nSH SESSION HANDSHAKE RECEIVED:\n" + inStartSessionMsg.toString() + "\nAND REPLIED:\n" + outTopoMsg.toString());
        }
    }

    protected void logStopReceived() {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("In " + this.replicationServer.getMonitorInstanceName() + ", " + this.getClass().getSimpleName() + " " + this + " :" + "\nSH SESSION HANDSHAKE RECEIVED A STOP MESSAGE");
        }
    }

    protected void logStartECLSessionHandshake(StartECLSessionMsg inStartECLSessionMsg) {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("In " + this.replicationServer.getMonitorInstanceName() + ", " + this.getClass().getSimpleName() + " " + this + " :" + "\nSH SESSION HANDSHAKE RECEIVED:\n" + inStartECLSessionMsg.toString());
        }
    }

    public void processAck(AckMsg ack) {
        if (this.replicationServerDomain != null) {
            this.replicationServerDomain.processAck(ack, this);
        }
    }

    public long getReferenceGenId() {
        long refgenid = -1L;
        if (this.replicationServerDomain != null) {
            refgenid = this.replicationServerDomain.getGenerationId();
        }
        return refgenid;
    }

    public void processResetGenId(ResetGenerationIdMsg msg) {
        if (this.replicationServerDomain != null) {
            this.replicationServerDomain.resetGenerationId(this, msg);
        }
    }

    public void put(UpdateMsg update) throws IOException {
        if (this.replicationServerDomain != null) {
            this.replicationServerDomain.put(update, this);
        }
    }

    public void doStop() {
        if (this.replicationServerDomain != null) {
            this.replicationServerDomain.stopServer(this, false);
        }
    }
}

