/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server;

import java.io.IOException;
import org.opends.messages.ReplicationMessages;
import org.opends.server.api.DirectoryThread;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.replication.common.ServerStatus;
import org.opends.server.replication.protocol.AckMsg;
import org.opends.server.replication.protocol.ChangeStatusMsg;
import org.opends.server.replication.protocol.ChangeTimeHeartbeatMsg;
import org.opends.server.replication.protocol.DoneMsg;
import org.opends.server.replication.protocol.EntryMsg;
import org.opends.server.replication.protocol.ErrorMsg;
import org.opends.server.replication.protocol.InitializeRcvAckMsg;
import org.opends.server.replication.protocol.InitializeRequestMsg;
import org.opends.server.replication.protocol.InitializeTargetMsg;
import org.opends.server.replication.protocol.MonitorMsg;
import org.opends.server.replication.protocol.MonitorRequestMsg;
import org.opends.server.replication.protocol.NotSupportedOldVersionPDUException;
import org.opends.server.replication.protocol.ProtocolSession;
import org.opends.server.replication.protocol.ResetGenerationIdMsg;
import org.opends.server.replication.protocol.StopMsg;
import org.opends.server.replication.protocol.TopologyMsg;
import org.opends.server.replication.protocol.UpdateMsg;
import org.opends.server.replication.protocol.WindowMsg;
import org.opends.server.replication.protocol.WindowProbeMsg;
import org.opends.server.replication.server.DataServerHandler;
import org.opends.server.replication.server.ReplicationServerHandler;
import org.opends.server.replication.server.ServerHandler;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.util.StaticUtils;

public class ServerReader
extends DirectoryThread {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ProtocolSession session;
    private ServerHandler handler;

    public ServerReader(ProtocolSession session, ServerHandler handler) {
        super("Replication Reader Thread for RS handler " + handler.getMonitorInstanceName());
        this.session = session;
        this.handler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block85: {
            block79: {
                block73: {
                    block84: {
                        block78: {
                            block72: {
                                errMessage = null;
                                if (DebugLogger.debugEnabled()) {
                                    ServerReader.TRACER.debugInfo(this.getName() + " starting");
                                }
                                try {
                                    try lbl-1000:
                                    // 2 sources

                                    {
                                        while (true) {
                                            block71: {
                                                try {
                                                    while (true) {
                                                        msg = this.session.receive();
                                                        if (DebugLogger.debugEnabled()) {
                                                            ServerReader.TRACER.debugInfo("In " + this.getName() + " receives " + msg);
                                                        }
                                                        if (msg instanceof AckMsg) {
                                                            ack = (AckMsg)msg;
                                                            this.handler.checkWindow();
                                                            this.handler.processAck(ack);
                                                            continue;
                                                        }
                                                        if (msg instanceof UpdateMsg) {
                                                            filtered = false;
                                                            if (this.handler.isDataServer()) {
                                                                dsStatus = this.handler.getStatus();
                                                                if (dsStatus == ServerStatus.BAD_GEN_ID_STATUS || dsStatus == ServerStatus.FULL_UPDATE_STATUS) {
                                                                    referenceGenerationId = this.handler.getReferenceGenId();
                                                                    if (dsStatus == ServerStatus.BAD_GEN_ID_STATUS) {
                                                                        ErrorLogger.logError(ReplicationMessages.ERR_IGNORING_UPDATE_FROM_DS_BADGENID.get(Integer.toString(this.handler.getReplicationServerId()), this.handler.getServiceId(), ((UpdateMsg)msg).getChangeNumber().toString(), Integer.toString(this.handler.getServerId()), Long.toString(referenceGenerationId), Long.toString(this.handler.getGenerationId())));
                                                                    }
                                                                    if (dsStatus == ServerStatus.FULL_UPDATE_STATUS) {
                                                                        ErrorLogger.logError(ReplicationMessages.ERR_IGNORING_UPDATE_FROM_DS_FULLUP.get(Integer.toString(this.handler.getReplicationServerId()), this.handler.getServiceId(), ((UpdateMsg)msg).getChangeNumber().toString(), Integer.toString(this.handler.getServerId())));
                                                                    }
                                                                    filtered = true;
                                                                }
                                                            } else {
                                                                referenceGenerationId = this.handler.getReferenceGenId();
                                                                if (referenceGenerationId > 0L && referenceGenerationId != this.handler.getGenerationId()) {
                                                                    ErrorLogger.logError(ReplicationMessages.ERR_IGNORING_UPDATE_FROM_RS.get(Integer.toString(this.handler.getReplicationServerId()), this.handler.getServiceId(), ((UpdateMsg)msg).getChangeNumber().toString(), Integer.toString(this.handler.getServerId()), Long.toString(referenceGenerationId), Long.toString(this.handler.getGenerationId())));
                                                                    filtered = true;
                                                                }
                                                            }
                                                            if (filtered) continue;
                                                            update = (UpdateMsg)msg;
                                                            this.handler.decAndCheckWindow();
                                                            this.handler.put(update);
                                                            continue;
                                                        }
                                                        if (msg instanceof WindowMsg) {
                                                            windowMsg = (WindowMsg)msg;
                                                            this.handler.updateWindow(windowMsg);
                                                            continue;
                                                        }
                                                        if (msg instanceof InitializeRequestMsg) {
                                                            initializeMsg /* !! */  = (InitializeRequestMsg)msg;
                                                            this.handler.process(initializeMsg /* !! */ );
                                                            continue;
                                                        }
                                                        if (msg instanceof InitializeRcvAckMsg) {
                                                            initializeRcvAckMsg = (InitializeRcvAckMsg)msg;
                                                            this.handler.process(initializeRcvAckMsg);
                                                            continue;
                                                        }
                                                        if (msg instanceof InitializeTargetMsg) {
                                                            initializeMsg /* !! */  = (InitializeTargetMsg)msg;
                                                            this.handler.process(initializeMsg /* !! */ );
                                                            continue;
                                                        }
                                                        if (msg instanceof EntryMsg) {
                                                            entryMsg = (EntryMsg)msg;
                                                            this.handler.process(entryMsg);
                                                            continue;
                                                        }
                                                        if (msg instanceof DoneMsg) {
                                                            doneMsg = (DoneMsg)msg;
                                                            this.handler.process(doneMsg);
                                                            continue;
                                                        }
                                                        if (msg instanceof ErrorMsg) {
                                                            errorMsg = (ErrorMsg)msg;
                                                            this.handler.process(errorMsg);
                                                            continue;
                                                        }
                                                        if (msg instanceof ResetGenerationIdMsg) {
                                                            genIdMsg = (ResetGenerationIdMsg)msg;
                                                            this.handler.processResetGenId(genIdMsg);
                                                            continue;
                                                        }
                                                        if (msg instanceof WindowProbeMsg) {
                                                            windowProbeMsg = (WindowProbeMsg)msg;
                                                            this.handler.process(windowProbeMsg);
                                                            continue;
                                                        }
                                                        if (msg instanceof TopologyMsg) {
                                                            topoMsg = (TopologyMsg)msg;
                                                            try {
                                                                rsh = (ReplicationServerHandler)this.handler;
                                                                rsh.receiveTopoInfoFromRS(topoMsg);
                                                            }
                                                            catch (Exception e) {
                                                                ServerReader.TRACER.debugCaught(DebugLogLevel.ERROR, e);
                                                                errMessage = ReplicationMessages.ERR_REPLICATION_PROTOCOL_MESSAGE_TYPE.get("TopologyMsg", "other");
                                                                ErrorLogger.logError(errMessage);
                                                            }
                                                            continue;
                                                        }
                                                        if (msg instanceof ChangeStatusMsg) {
                                                            csMsg = (ChangeStatusMsg)msg;
                                                            try {
                                                                dsh = (DataServerHandler)this.handler;
                                                                dsh.receiveNewStatus(csMsg);
                                                            }
                                                            catch (Exception e) {
                                                                errMessage = ReplicationMessages.ERR_RECEIVED_CHANGE_STATUS_NOT_FROM_DS.get(this.handler.getServiceId(), Integer.toString(this.handler.getServerId()), csMsg.toString());
                                                                ErrorLogger.logError(errMessage);
                                                            }
                                                            continue;
                                                        }
                                                        if (msg instanceof MonitorRequestMsg) {
                                                            replServerMonitorRequestMsg = (MonitorRequestMsg)msg;
                                                            this.handler.process(replServerMonitorRequestMsg);
                                                            continue;
                                                        }
                                                        if (msg instanceof MonitorMsg) {
                                                            replServerMonitorMsg = (MonitorMsg)msg;
                                                            this.handler.process(replServerMonitorMsg);
                                                            continue;
                                                        }
                                                        if (!(msg instanceof ChangeTimeHeartbeatMsg)) break;
                                                        cthbMsg = (ChangeTimeHeartbeatMsg)msg;
                                                        this.handler.process(cthbMsg);
                                                    }
                                                    if (msg instanceof StopMsg) {
                                                        if (!DebugLogger.debugEnabled()) break block71;
                                                        ServerReader.TRACER.debugInfo(this.handler.toString() + " has properly " + "disconnected from this replication server " + Integer.toString(this.handler.getReplicationServerId()));
                                                    }
                                                    break;
                                                }
                                                catch (NotSupportedOldVersionPDUException e) {
                                                    if (!DebugLogger.debugEnabled()) continue;
                                                    ServerReader.TRACER.debugInfo("In " + this.getName() + " " + StaticUtils.stackTraceToSingleLineString(e));
                                                    continue;
                                                }
                                            }
                                            var8_14 = null;
                                            break block72;
                                            break;
                                        }
                                        {
                                            if (msg == null) ** break;
                                            ** continue;
                                            errMessage = ReplicationMessages.NOTE_READER_NULL_MSG.get(this.handler.toString());
                                            ErrorLogger.logError(errMessage);
                                        }
                                        break block73;
                                    }
                                    catch (IOException e) {
                                        if (DebugLogger.debugEnabled()) {
                                            ServerReader.TRACER.debugInfo("In " + this.getName() + " " + StaticUtils.stackTraceToSingleLineString(e));
                                        }
                                        if (!this.handler.shuttingDown()) {
                                            errMessage = ReplicationMessages.ERR_SERVER_BADLY_DISCONNECTED.get(this.handler.toString(), Integer.toString(this.handler.getReplicationServerId()));
                                            ErrorLogger.logError(errMessage);
                                        }
                                        var8_16 = null;
                                        try {
                                            if (this.handler.getProtocolVersion() >= 4) {
                                                try {
                                                    this.session.publish(new StopMsg());
                                                }
                                                catch (IOException ioe) {
                                                    // empty catch block
                                                }
                                            }
                                            if (DebugLogger.debugEnabled()) {
                                                ServerReader.TRACER.debugInfo("In " + this.getName() + " closing the session");
                                            }
                                            this.session.close();
                                        }
                                        catch (IOException e) {
                                            // empty catch block
                                        }
                                        this.handler.doStop();
                                        if (DebugLogger.debugEnabled() == false) return;
                                        ServerReader.TRACER.debugInfo(this.getName() + " stopped " + errMessage);
                                        return;
                                    }
                                    catch (ClassNotFoundException e) {
                                        block81: {
                                            block76: {
                                                if (DebugLogger.debugEnabled()) {
                                                    ServerReader.TRACER.debugInfo("In " + this.getName() + " " + StaticUtils.stackTraceToSingleLineString(e));
                                                }
                                                errMessage = ReplicationMessages.ERR_UNKNOWN_MESSAGE.get(this.handler.toString());
                                                ErrorLogger.logError(errMessage);
                                                var8_17 = null;
                                                ** try [egrp 6[TRYBLOCK] [20 : 1213->1296)] { 
lbl160:
                                                // 1 sources

                                                if (this.handler.getProtocolVersion() >= 4) {
                                                    ** try [egrp 7[TRYBLOCK] [19 : 1224->1243)] { 
lbl162:
                                                    // 1 sources

                                                    this.session.publish(new StopMsg());
                                                    break block76;
lbl164:
                                                    // 1 sources

                                                    catch (IOException ioe) {
                                                        // empty catch block
                                                    }
                                                }
                                            }
                                            if (DebugLogger.debugEnabled()) {
                                                ServerReader.TRACER.debugInfo("In " + this.getName() + " closing the session");
                                            }
                                            this.session.close();
                                            break block81;
lbl171:
                                            // 1 sources

                                            catch (IOException e) {
                                                // empty catch block
                                            }
                                        }
                                        this.handler.doStop();
                                        if (DebugLogger.debugEnabled() == false) return;
                                        ServerReader.TRACER.debugInfo(this.getName() + " stopped " + errMessage);
                                        return;
                                    }
                                    catch (Exception e) {
                                        block82: {
                                            block77: {
                                                if (DebugLogger.debugEnabled()) {
                                                    ServerReader.TRACER.debugInfo("In " + this.getName() + " " + StaticUtils.stackTraceToSingleLineString(e));
                                                }
                                                errMessage = ReplicationMessages.NOTE_READER_EXCEPTION.get(this.handler.toString());
                                                ErrorLogger.logError(errMessage);
                                                var8_18 = null;
                                                ** try [egrp 6[TRYBLOCK] [20 : 1213->1296)] { 
lbl186:
                                                // 1 sources

                                                if (this.handler.getProtocolVersion() >= 4) {
                                                    ** try [egrp 7[TRYBLOCK] [19 : 1224->1243)] { 
lbl188:
                                                    // 1 sources

                                                    this.session.publish(new StopMsg());
                                                    break block77;
lbl190:
                                                    // 1 sources

                                                    catch (IOException ioe) {
                                                        // empty catch block
                                                    }
                                                }
                                            }
                                            if (DebugLogger.debugEnabled()) {
                                                ServerReader.TRACER.debugInfo("In " + this.getName() + " closing the session");
                                            }
                                            this.session.close();
                                            break block82;
lbl197:
                                            // 1 sources

                                            catch (IOException e) {
                                                // empty catch block
                                            }
                                        }
                                        this.handler.doStop();
                                        if (DebugLogger.debugEnabled() == false) return;
                                        ServerReader.TRACER.debugInfo(this.getName() + " stopped " + errMessage);
                                        return;
                                    }
                                }
                                catch (Throwable var7_32) {
                                    block83: {
                                        block80: {
                                            var8_19 = null;
                                            ** try [egrp 6[TRYBLOCK] [20 : 1213->1296)] { 
lbl208:
                                            // 1 sources

                                            if (this.handler.getProtocolVersion() >= 4) {
                                                ** try [egrp 7[TRYBLOCK] [19 : 1224->1243)] { 
lbl210:
                                                // 1 sources

                                                this.session.publish(new StopMsg());
                                                break block80;
lbl212:
                                                // 1 sources

                                                catch (IOException ioe) {
                                                    // empty catch block
                                                }
                                            }
                                        }
                                        if (DebugLogger.debugEnabled()) {
                                            ServerReader.TRACER.debugInfo("In " + this.getName() + " closing the session");
                                        }
                                        this.session.close();
                                        break block83;
lbl219:
                                        // 1 sources

                                        catch (IOException e) {
                                            // empty catch block
                                        }
                                    }
                                    this.handler.doStop();
                                    if (DebugLogger.debugEnabled() == false) throw var7_32;
                                    ServerReader.TRACER.debugInfo(this.getName() + " stopped " + errMessage);
                                    throw var7_32;
                                }
                            }
                            ** try [egrp 6[TRYBLOCK] [20 : 1213->1296)] { 
lbl228:
                            // 1 sources

                            if (this.handler.getProtocolVersion() >= 4) {
                                ** try [egrp 7[TRYBLOCK] [19 : 1224->1243)] { 
lbl230:
                                // 1 sources

                                this.session.publish(new StopMsg());
                                break block78;
lbl232:
                                // 1 sources

                                catch (IOException ioe) {
                                    // empty catch block
                                }
                            }
                        }
                        if (DebugLogger.debugEnabled()) {
                            ServerReader.TRACER.debugInfo("In " + this.getName() + " closing the session");
                        }
                        this.session.close();
                        break block84;
lbl239:
                        // 1 sources

                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    this.handler.doStop();
                    if (DebugLogger.debugEnabled() == false) return;
                    ServerReader.TRACER.debugInfo(this.getName() + " stopped " + errMessage);
                    return;
                }
                var8_15 = null;
                ** try [egrp 6[TRYBLOCK] [20 : 1213->1296)] { 
lbl249:
                // 1 sources

                if (this.handler.getProtocolVersion() >= 4) {
                    ** try [egrp 7[TRYBLOCK] [19 : 1224->1243)] { 
lbl251:
                    // 1 sources

                    this.session.publish(new StopMsg());
                    break block79;
lbl253:
                    // 1 sources

                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
            }
            if (DebugLogger.debugEnabled()) {
                ServerReader.TRACER.debugInfo("In " + this.getName() + " closing the session");
            }
            this.session.close();
            break block85;
lbl260:
            // 1 sources

            catch (IOException e) {
                // empty catch block
            }
        }
        this.handler.doStop();
        if (DebugLogger.debugEnabled() == false) return;
        ServerReader.TRACER.debugInfo(this.getName() + " stopped " + errMessage);
    }
}

