/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server;

import org.opends.server.api.DirectoryThread;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.replication.common.ServerStatus;
import org.opends.server.replication.common.StatusMachineEvent;
import org.opends.server.replication.server.DataServerHandler;
import org.opends.server.replication.server.ReplicationServerDomain;

public class StatusAnalyzer
extends DirectoryThread {
    private boolean finished = false;
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ReplicationServerDomain replicationServerDomain;
    private int degradedStatusThreshold = -1;
    private int STATUS_ANALYZER_SLEEP_TIME = 5000;
    private boolean done = false;
    private Object sleeper = new Object();

    public StatusAnalyzer(ReplicationServerDomain replicationServerDomain, int degradedStatusThreshold) {
        super("Replication Server Status Analyzer for " + replicationServerDomain.getBaseDn() + " in RS " + replicationServerDomain.getReplicationServer().getServerId());
        this.replicationServerDomain = replicationServerDomain;
        this.degradedStatusThreshold = degradedStatusThreshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Directory server status analyzer starting for dn " + this.replicationServerDomain.getBaseDn().toString());
        }
        boolean interrupted = false;
        block5: while (!this.finished && !interrupted) {
            try {
                Object object = this.sleeper;
                synchronized (object) {
                    this.sleeper.wait(this.STATUS_ANALYZER_SLEEP_TIME);
                }
            }
            catch (InterruptedException ex) {
                TRACER.debugInfo("Status analyzer for dn " + this.replicationServerDomain.getBaseDn().toString() + " in RS " + this.replicationServerDomain.getReplicationServer().getServerId() + " has been interrupted while sleeping.");
            }
            for (DataServerHandler serverHandler : this.replicationServerDomain.getConnectedDSs().values()) {
                int nChanges = serverHandler.getRcvMsgQueueSize();
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo("Status analyzer for dn " + this.replicationServerDomain.getBaseDn().toString() + " DS " + Integer.toString(serverHandler.getServerId()) + " has " + nChanges + " message(s) in writer queue. This is in RS " + this.replicationServerDomain.getReplicationServer().getServerId());
                }
                if (this.degradedStatusThreshold <= 0) continue;
                if (nChanges >= this.degradedStatusThreshold) {
                    if (serverHandler.getStatus() != ServerStatus.NORMAL_STATUS || !(interrupted = this.replicationServerDomain.changeStatusFromStatusAnalyzer(serverHandler, StatusMachineEvent.TO_DEGRADED_STATUS_EVENT))) continue;
                    TRACER.debugInfo("Status analyzer for dn " + this.replicationServerDomain.getBaseDn().toString() + " has been interrupted and will die. This is in RS " + this.replicationServerDomain.getReplicationServer().getServerId());
                    continue block5;
                }
                if (serverHandler.getStatus() != ServerStatus.DEGRADED_STATUS || !(interrupted = this.replicationServerDomain.changeStatusFromStatusAnalyzer(serverHandler, StatusMachineEvent.TO_NORMAL_STATUS_EVENT))) continue;
                TRACER.debugInfo("Status analyzer for dn " + this.replicationServerDomain.getBaseDn().toString() + " has been interrupted and will die. This is in RS " + this.replicationServerDomain.getReplicationServer().getServerId());
                continue block5;
            }
        }
        this.done = true;
        TRACER.debugInfo("Status analyzer for dn " + this.replicationServerDomain.getBaseDn().toString() + " is terminated." + " This is in RS " + this.replicationServerDomain.getReplicationServer().getServerId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Shutting down status analyzer for dn " + this.replicationServerDomain.getBaseDn().toString() + " in RS " + this.replicationServerDomain.getReplicationServer().getServerId());
        }
        this.finished = true;
        Object object = this.sleeper;
        synchronized (object) {
            this.sleeper.notify();
        }
    }

    public void waitForShutdown() {
        try {
            int FACTOR = 40;
            int n = 0;
            while (!this.done && this.isAlive()) {
                Thread.sleep(50L);
                if (++n < FACTOR) continue;
                TRACER.debugInfo("Interrupting status analyzer for dn " + this.replicationServerDomain.getBaseDn().toString() + " in RS " + this.replicationServerDomain.getReplicationServer().getServerId());
                this.interrupt();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void setDeradedStatusThreshold(int degradedStatusThreshold) {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Directory server status analyzer for dn " + this.replicationServerDomain.getBaseDn().toString() + " changing threshold" + " value to " + degradedStatusThreshold);
        }
        this.degradedStatusThreshold = degradedStatusThreshold;
    }
}

