/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.opends.messages.Category;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.ReplicationMessages;
import org.opends.messages.Severity;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.common.DSInfo;
import org.opends.server.replication.common.MutableBoolean;
import org.opends.server.replication.common.RSInfo;
import org.opends.server.replication.common.ServerState;
import org.opends.server.replication.common.ServerStatus;
import org.opends.server.replication.protocol.ChangeStatusMsg;
import org.opends.server.replication.protocol.HeartbeatMonitor;
import org.opends.server.replication.protocol.MonitorMsg;
import org.opends.server.replication.protocol.MonitorRequestMsg;
import org.opends.server.replication.protocol.ProtocolSession;
import org.opends.server.replication.protocol.ProtocolVersion;
import org.opends.server.replication.protocol.ReplServerStartDSMsg;
import org.opends.server.replication.protocol.ReplServerStartMsg;
import org.opends.server.replication.protocol.ReplSessionSecurity;
import org.opends.server.replication.protocol.ReplicationMsg;
import org.opends.server.replication.protocol.ServerStartECLMsg;
import org.opends.server.replication.protocol.ServerStartMsg;
import org.opends.server.replication.protocol.StartECLSessionMsg;
import org.opends.server.replication.protocol.StartSessionMsg;
import org.opends.server.replication.protocol.StopMsg;
import org.opends.server.replication.protocol.TopologyMsg;
import org.opends.server.replication.protocol.UpdateMsg;
import org.opends.server.replication.protocol.WindowMsg;
import org.opends.server.replication.protocol.WindowProbeMsg;
import org.opends.server.replication.server.ReplicationServer;
import org.opends.server.replication.service.CTHeartbeatPublisherThread;
import org.opends.server.replication.service.ReplicationDomain;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicationBroker {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private boolean shutdown = false;
    private Collection<String> servers;
    private boolean connected = false;
    private String replicationServer = "Not connected";
    private ProtocolSession session = null;
    private final ServerState state;
    private final String baseDn;
    private final int serverId;
    private Semaphore sendWindow;
    private int maxSendWindow;
    private int rcvWindow = 100;
    private int halfRcvWindow = this.rcvWindow / 2;
    private int maxRcvWindow = this.rcvWindow;
    private int timeout = 0;
    private short protocolVersion;
    private ReplSessionSecurity replSessionSecurity;
    private byte groupId = (byte)-1;
    private byte rsGroupId = (byte)-1;
    private Integer rsServerId = -1;
    private String rsServerUrl = null;
    private ReplicationDomain domain = null;
    private final MutableBoolean monitorResponse = new MutableBoolean(false);
    private HashMap<Integer, ServerState> replicaStates = new HashMap();
    private long heartbeatInterval = 0L;
    private HeartbeatMonitor heartbeatMonitor = null;
    private int numLostConnections = 0;
    private boolean connectionError = false;
    private final Object connectPhaseLock = new Object();
    private CTHeartbeatPublisherThread ctHeartbeatPublisherThread = null;
    private long changeTimeHeartbeatSendInterval = 0L;
    private List<DSInfo> dsList = new ArrayList<DSInfo>();
    private long generationID;
    private int updateDoneCount = 0;
    private boolean connectRequiresRecovery = false;
    private Map<Integer, ReplicationServerInfo> replicationServerInfos = null;
    private int mustRunBestServerCheckingAlgorithm = 0;

    public ReplicationBroker(ReplicationDomain replicationDomain, ServerState state, String baseDn, int serverID2, int window, long generationId, long heartbeatInterval, ReplSessionSecurity replSessionSecurity, byte groupId, long changeTimeHeartbeatInterval) {
        this.domain = replicationDomain;
        this.baseDn = baseDn;
        this.serverId = serverID2;
        this.state = state;
        this.protocolVersion = ProtocolVersion.getCurrentVersion();
        this.replSessionSecurity = replSessionSecurity;
        this.groupId = groupId;
        this.generationID = generationId;
        this.heartbeatInterval = heartbeatInterval;
        this.maxRcvWindow = window;
        this.maxRcvWindow = window;
        this.halfRcvWindow = window / 2;
        this.changeTimeHeartbeatSendInterval = changeTimeHeartbeatInterval;
    }

    public void start() {
        this.shutdown = false;
        this.rcvWindow = this.maxRcvWindow;
        this.connect();
    }

    public void start(Collection<String> servers) {
        this.shutdown = false;
        this.servers = servers;
        if (servers.size() < 1) {
            Message message = ReplicationMessages.NOTE_NEED_MORE_THAN_ONE_CHANGELOG_SERVER.get();
            ErrorLogger.logError(message);
        }
        this.rcvWindow = this.maxRcvWindow;
        this.connect();
    }

    public byte getRsGroupId() {
        return this.rsGroupId;
    }

    public Integer getRsServerId() {
        return this.rsServerId;
    }

    public int getServerId() {
        return this.serverId;
    }

    private long getGenerationID() {
        if (this.domain != null) {
            this.generationID = this.domain.getGenerationID();
        }
        return this.generationID;
    }

    public void setGenerationID(long generationID) {
        this.generationID = generationID;
    }

    public String getRsServerUrl() {
        return this.rsServerUrl;
    }

    private void updateRSInfoLocallyConfiguredStatus(ReplicationServerInfo replicationServerInfo) {
        String rsUrl = replicationServerInfo.getServerURL();
        if (rsUrl == null) {
            replicationServerInfo.setLocallyConfigured(false);
            return;
        }
        for (String serverUrl : this.servers) {
            if (!ReplicationBroker.isSameReplicationServerUrl(serverUrl, rsUrl)) continue;
            replicationServerInfo.setLocallyConfigured(true);
            return;
        }
        replicationServerInfo.setLocallyConfigured(false);
    }

    private static boolean isSameReplicationServerUrl(String rs1Url, String rs2Url) {
        int separator1 = rs1Url.lastIndexOf(58);
        if (separator1 < 0) {
            return false;
        }
        int rs1Port = Integer.parseInt(rs1Url.substring(separator1 + 1));
        int separator2 = rs2Url.lastIndexOf(58);
        if (separator2 < 0) {
            return false;
        }
        int rs2Port = Integer.parseInt(rs2Url.substring(separator2 + 1));
        if (rs1Port != rs2Port) {
            return false;
        }
        String rs1 = rs1Url.substring(0, separator1);
        InetAddress[] rs1Addresses = null;
        try {
            if (rs1.equals("localhost") || rs1.equals("127.0.0.1")) {
                rs1 = InetAddress.getLocalHost().getHostName();
            }
            rs1Addresses = InetAddress.getAllByName(rs1);
        }
        catch (UnknownHostException ex) {
            return false;
        }
        String rs2 = rs2Url.substring(0, separator2);
        InetAddress[] rs2Addresses = null;
        try {
            if (rs2.equals("localhost") || rs2.equals("127.0.0.1")) {
                rs2 = InetAddress.getLocalHost().getHostName();
            }
            rs2Addresses = InetAddress.getAllByName(rs2);
        }
        catch (UnknownHostException ex) {
            return false;
        }
        for (int i = 0; i < rs1Addresses.length; ++i) {
            InetAddress inetAddress1 = rs1Addresses[i];
            for (int j = 0; j < rs2Addresses.length; ++j) {
                InetAddress inetAddress2 = rs2Addresses[j];
                if (!inetAddress2.equals(inetAddress1)) continue;
                return true;
            }
        }
        return false;
    }

    private void connect() {
        if (this.baseDn.compareToIgnoreCase("cn=changelog") == 0) {
            this.connectAsECL();
        } else {
            this.connectAsDataServer();
        }
    }

    private Map<Integer, ReplicationServerInfo> collectReplicationServersInfo() {
        HashMap<Integer, ReplicationServerInfo> rsInfos = new HashMap<Integer, ReplicationServerInfo>();
        for (String server : this.servers) {
            ReplicationServerInfo replicationServerInfo = this.performPhaseOneHandshake(server, false);
            if (replicationServerInfo == null) continue;
            rsInfos.put(replicationServerInfo.getServerId(), replicationServerInfo);
        }
        return rsInfos;
    }

    private void connectAsECL() {
        String bestServer = this.servers.iterator().next();
        ReplServerStartDSMsg inReplServerStartDSMsg = this.performECLPhaseOneHandshake(bestServer, true);
        if (inReplServerStartDSMsg != null) {
            this.performECLPhaseTwoHandshake(bestServer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectAsDataServer() {
        if (this.domain != null) {
            this.domain.toNotConnectedStatus();
        }
        this.stopRSHeartBeatMonitoring();
        this.stopChangeTimeHeartBeatPublishing();
        this.mustRunBestServerCheckingAlgorithm = 0;
        boolean newServerWithSameGroupId = false;
        Object object = this.connectPhaseLock;
        synchronized (object) {
            Message message;
            if (this.debugEnabled()) {
                ReplicationBroker.debugInfo("serverId: " + this.serverId + " phase 1 : will perform PhaseOneH with each RS in " + " order to elect the preferred one");
            }
            this.replicationServerInfos = this.collectReplicationServersInfo();
            ReplicationServerInfo replicationServerInfo = null;
            if (this.replicationServerInfos.size() > 0) {
                replicationServerInfo = ReplicationBroker.computeBestReplicationServer(true, -1, this.state, this.replicationServerInfos, this.serverId, this.baseDn, this.groupId, this.getGenerationID());
                if (this.debugEnabled()) {
                    ReplicationBroker.debugInfo("serverId: " + this.serverId + " phase 2 : will perform PhaseOneH with the preferred RS=" + replicationServerInfo);
                }
                if ((replicationServerInfo = this.performPhaseOneHandshake(replicationServerInfo.getServerURL(), true)) != null) {
                    this.replicationServerInfos.put(replicationServerInfo.getServerId(), replicationServerInfo);
                    ServerStatus initStatus = this.computeInitialServerStatus(replicationServerInfo.getGenerationId(), replicationServerInfo.getServerState(), replicationServerInfo.getDegradedStatusThreshold(), this.getGenerationID());
                    TopologyMsg topologyMsg = this.performPhaseTwoHandshake(replicationServerInfo.getServerURL(), initStatus);
                    if (topologyMsg != null) {
                        try {
                            byte tmpRsGroupId = replicationServerInfo.getGroupId();
                            boolean someServersWithSameGroupId = this.hasSomeServerWithSameGroupId(topologyMsg.getRsList());
                            if (tmpRsGroupId == this.groupId || tmpRsGroupId != this.groupId && !someServersWithSameGroupId) {
                                this.replicationServer = this.session.getReadableRemoteAddress();
                                this.maxSendWindow = replicationServerInfo.getWindowSize();
                                this.rsGroupId = replicationServerInfo.getGroupId();
                                this.rsServerId = replicationServerInfo.getServerId();
                                this.rsServerUrl = replicationServerInfo.getServerURL();
                                this.receiveTopo(topologyMsg);
                                this.connectionError = false;
                                if (this.sendWindow != null) {
                                    this.sendWindow.release(Integer.MAX_VALUE);
                                }
                                this.sendWindow = new Semaphore(this.maxSendWindow);
                                this.rcvWindow = this.maxRcvWindow;
                                this.connected = true;
                                if (this.domain != null) {
                                    this.domain.sessionInitiated(initStatus, replicationServerInfo.getServerState(), replicationServerInfo.getGenerationId(), this.session);
                                }
                                if (this.getRsGroupId() != this.groupId) {
                                    Message message2 = ReplicationMessages.WARN_CONNECTED_TO_SERVER_WITH_WRONG_GROUP_ID.get(Byte.toString(this.groupId), Integer.toString(this.rsServerId), replicationServerInfo.getServerURL(), Byte.toString(this.getRsGroupId()), this.baseDn.toString(), Integer.toString(this.serverId));
                                    ErrorLogger.logError(message2);
                                }
                                this.startRSHeartBeatMonitoring();
                                if (replicationServerInfo.getProtocolVersion() >= 3) {
                                    this.startChangeTimeHeartBeatPublishing();
                                }
                            } else {
                                Message message3 = ReplicationMessages.NOTE_NEW_SERVER_WITH_SAME_GROUP_ID.get(Byte.toString(this.groupId), this.baseDn.toString(), Integer.toString(this.serverId));
                                ErrorLogger.logError(message3);
                                newServerWithSameGroupId = true;
                            }
                        }
                        catch (Exception e) {
                            Message message4 = ReplicationMessages.ERR_COMPUTING_FAKE_OPS.get(this.baseDn, replicationServerInfo.getServerURL(), e.getLocalizedMessage() + StaticUtils.stackTraceToSingleLineString(e));
                            ErrorLogger.logError(message4);
                        }
                        finally {
                            if (!this.connected && this.session != null) {
                                try {
                                    this.session.close();
                                }
                                catch (IOException e) {}
                                this.session = null;
                            }
                        }
                    }
                }
            }
            if (this.connected) {
                this.connectPhaseLock.notify();
                if (replicationServerInfo.getGenerationId() == this.getGenerationID() || replicationServerInfo.getGenerationId() == -1L) {
                    message = ReplicationMessages.NOTE_NOW_FOUND_SAME_GENERATION_CHANGELOG.get(this.baseDn.toString(), Integer.toString(this.rsServerId), this.replicationServer, Integer.toString(this.serverId), Long.toString(this.getGenerationID()));
                    ErrorLogger.logError(message);
                } else {
                    message = ReplicationMessages.NOTE_NOW_FOUND_BAD_GENERATION_CHANGELOG.get(this.baseDn.toString(), this.replicationServer, Long.toString(this.getGenerationID()), Long.toString(replicationServerInfo.getGenerationId()));
                    ErrorLogger.logError(message);
                }
            } else if (!this.connectionError && !newServerWithSameGroupId) {
                this.connectionError = true;
                this.connectPhaseLock.notify();
                message = ReplicationMessages.NOTE_COULD_NOT_FIND_CHANGELOG.get(this.baseDn.toString());
                ErrorLogger.logError(message);
            }
        }
    }

    private boolean hasSomeServerWithSameGroupId(List<RSInfo> rsInfos) {
        for (RSInfo rsInfo : rsInfos) {
            if (rsInfo.getGroupId() != this.groupId) continue;
            return true;
        }
        return false;
    }

    public ServerStatus computeInitialServerStatus(long rsGenId, ServerState rsState, int degradedStatusThreshold, long dsGenId) {
        if (rsGenId == -1L) {
            return ServerStatus.NORMAL_STATUS;
        }
        if (rsGenId == dsGenId) {
            ServerStatus initStatus = ServerStatus.INVALID_STATUS;
            int nChanges = ServerState.diffChanges(rsState, this.state);
            if (this.debugEnabled()) {
                ReplicationBroker.debugInfo("RB for dn " + this.baseDn + " and with server id " + Integer.toString(this.serverId) + " computed " + Integer.toString(nChanges) + " changes late.");
            }
            initStatus = degradedStatusThreshold > 0 ? (nChanges >= degradedStatusThreshold ? ServerStatus.DEGRADED_STATUS : ServerStatus.NORMAL_STATUS) : ServerStatus.NORMAL_STATUS;
            return initStatus;
        }
        return ServerStatus.BAD_GEN_ID_STATUS;
    }

    private ReplicationServerInfo performPhaseOneHandshake(String server, boolean keepConnection) {
        ReplicationServerInfo replServerInfo = null;
        int separator = server.lastIndexOf(58);
        String port = server.substring(separator + 1);
        String hostname = server.substring(0, separator);
        ProtocolSession localSession = null;
        boolean error = false;
        try {
            String repDn;
            int intPort = Integer.parseInt(port);
            InetSocketAddress serverAddr = new InetSocketAddress(InetAddress.getByName(hostname), intPort);
            Socket socket = new Socket();
            socket.setReceiveBufferSize(1000000);
            socket.setTcpNoDelay(true);
            socket.connect(serverAddr, 500);
            localSession = this.replSessionSecurity.createClientSession(server, socket, 4000);
            boolean isSslEncryption = this.replSessionSecurity.isSslEncryption(server);
            ServerStartMsg serverStartMsg = new ServerStartMsg(this.serverId, this.baseDn, this.maxRcvWindow, this.heartbeatInterval, this.state, ProtocolVersion.getCurrentVersion(), this.getGenerationID(), isSslEncryption, this.groupId);
            localSession.publish(serverStartMsg);
            ReplicationMsg msg = localSession.receive();
            if (this.debugEnabled()) {
                ReplicationBroker.debugInfo("In RB for " + this.baseDn + "\nRB HANDSHAKE SENT:\n" + serverStartMsg.toString() + "\nAND RECEIVED:\n" + msg.toString());
            }
            if (!this.baseDn.equals(repDn = (replServerInfo = ReplicationServerInfo.newInstance(msg)).getBaseDn())) {
                Message message = ReplicationMessages.ERR_DS_DN_DOES_NOT_MATCH.get(repDn.toString(), this.baseDn);
                ErrorLogger.logError(message);
                error = true;
            }
            this.protocolVersion = ProtocolVersion.minWithCurrent(replServerInfo.getProtocolVersion());
            localSession.setProtocolVersion(this.protocolVersion);
            if (!isSslEncryption) {
                localSession.stopEncryption();
            }
        }
        catch (ConnectException e) {
            if (!this.connectionError) {
                Message message = ReplicationMessages.NOTE_NO_CHANGELOG_SERVER_LISTENING.get(server);
                if (keepConnection) {
                    ErrorLogger.logError(message);
                } else if (this.debugEnabled()) {
                    ReplicationBroker.debugInfo(message.toString());
                }
            }
            error = true;
        }
        catch (Exception e) {
            if (e instanceof SocketTimeoutException && this.debugEnabled()) {
                ReplicationBroker.debugInfo("Timeout trying to connect to RS " + server + " for dn: " + this.baseDn);
            }
            Message message = ReplicationMessages.ERR_EXCEPTION_STARTING_SESSION_PHASE.get("1", this.baseDn, server, e.getLocalizedMessage() + StaticUtils.stackTraceToSingleLineString(e));
            if (keepConnection) {
                ErrorLogger.logError(message);
            } else if (this.debugEnabled()) {
                ReplicationBroker.debugInfo(message.toString());
            }
            error = true;
        }
        if (!keepConnection || error) {
            if (localSession != null) {
                if (this.debugEnabled()) {
                    ReplicationBroker.debugInfo("In RB, closing session after phase 1");
                }
                if (this.protocolVersion >= 4 && !error) {
                    try {
                        localSession.publish(new StopMsg());
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
                try {
                    localSession.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                localSession = null;
            }
            if (error) {
                replServerInfo = null;
            }
        }
        if (keepConnection) {
            this.session = localSession;
        }
        return replServerInfo;
    }

    private ReplServerStartDSMsg performECLPhaseOneHandshake(String server, boolean keepConnection) {
        ReplServerStartDSMsg replServerStartDSMsg = null;
        int separator = server.lastIndexOf(58);
        String port = server.substring(separator + 1);
        String hostname = server.substring(0, separator);
        ProtocolSession localSession = null;
        boolean error = false;
        try {
            String repDn;
            int intPort = Integer.parseInt(port);
            InetSocketAddress serverAddr = new InetSocketAddress(InetAddress.getByName(hostname), intPort);
            Socket socket = new Socket();
            socket.setReceiveBufferSize(1000000);
            socket.setTcpNoDelay(true);
            socket.connect(serverAddr, 500);
            localSession = this.replSessionSecurity.createClientSession(server, socket, 4000);
            boolean isSslEncryption = this.replSessionSecurity.isSslEncryption(server);
            ServerStartECLMsg serverStartECLMsg = new ServerStartECLMsg(this.baseDn, 0, 0, 0, 0, this.maxRcvWindow, this.heartbeatInterval, this.state, ProtocolVersion.getCurrentVersion(), this.getGenerationID(), isSslEncryption, this.groupId);
            localSession.publish(serverStartECLMsg);
            replServerStartDSMsg = (ReplServerStartDSMsg)localSession.receive();
            if (this.debugEnabled()) {
                ReplicationBroker.debugInfo("In RB for " + this.baseDn + "\nRB HANDSHAKE SENT:\n" + serverStartECLMsg.toString() + "\nAND RECEIVED:\n" + replServerStartDSMsg.toString());
            }
            if (!this.baseDn.equals(repDn = replServerStartDSMsg.getBaseDn())) {
                Message message = ReplicationMessages.ERR_DS_DN_DOES_NOT_MATCH.get(repDn.toString(), this.baseDn);
                ErrorLogger.logError(message);
                error = true;
            }
            if (keepConnection) {
                this.protocolVersion = ProtocolVersion.minWithCurrent(replServerStartDSMsg.getVersion());
            }
            localSession.setProtocolVersion(this.protocolVersion);
            if (!isSslEncryption) {
                localSession.stopEncryption();
            }
        }
        catch (ConnectException e) {
            if (!this.connectionError) {
                Message message = ReplicationMessages.NOTE_NO_CHANGELOG_SERVER_LISTENING.get(server);
                if (keepConnection) {
                    ErrorLogger.logError(message);
                } else if (this.debugEnabled()) {
                    ReplicationBroker.debugInfo(message.toString());
                }
            }
            error = true;
        }
        catch (Exception e) {
            if (e instanceof SocketTimeoutException && this.debugEnabled()) {
                ReplicationBroker.debugInfo("Timeout trying to connect to RS " + server + " for dn: " + this.baseDn);
            }
            Message message = ReplicationMessages.ERR_EXCEPTION_STARTING_SESSION_PHASE.get("1", this.baseDn, server, e.getLocalizedMessage() + StaticUtils.stackTraceToSingleLineString(e));
            if (keepConnection) {
                ErrorLogger.logError(message);
            } else if (this.debugEnabled()) {
                ReplicationBroker.debugInfo(message.toString());
            }
            error = true;
        }
        if (!keepConnection || error) {
            if (localSession != null) {
                if (this.debugEnabled()) {
                    ReplicationBroker.debugInfo("In RB, closing session after phase 1");
                }
                if (!error) {
                    try {
                        localSession.publish(new StopMsg());
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
                try {
                    localSession.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                localSession = null;
            }
            if (error) {
                replServerStartDSMsg = null;
            }
        }
        if (keepConnection) {
            this.session = localSession;
        }
        return replServerStartDSMsg;
    }

    private TopologyMsg performECLPhaseTwoHandshake(String server) {
        TopologyMsg topologyMsg = null;
        try {
            StartECLSessionMsg startECLSessionMsg = null;
            startECLSessionMsg = new StartECLSessionMsg();
            startECLSessionMsg.setOperationId("-1");
            this.session.publish(startECLSessionMsg);
            if (this.debugEnabled()) {
                ReplicationBroker.debugInfo("In RB for " + this.baseDn + "\nRB HANDSHAKE SENT:\n" + startECLSessionMsg.toString());
            }
            this.session.setSoTimeout(this.timeout);
            this.connected = true;
        }
        catch (Exception e) {
            Message message = ReplicationMessages.ERR_EXCEPTION_STARTING_SESSION_PHASE.get("2", this.baseDn, server, e.getLocalizedMessage() + StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(message);
            if (this.session != null) {
                try {
                    this.session.close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
                this.session = null;
            }
            topologyMsg = null;
        }
        return topologyMsg;
    }

    private TopologyMsg performPhaseTwoHandshake(String server, ServerStatus initStatus) {
        TopologyMsg topologyMsg = null;
        try {
            StartSessionMsg startSessionMsg = null;
            if (this.domain != null) {
                startSessionMsg = new StartSessionMsg(initStatus, this.domain.getRefUrls(), this.domain.isAssured(), this.domain.getAssuredMode(), this.domain.getAssuredSdLevel());
                startSessionMsg.setEclIncludes(this.domain.getEclInclude(this.domain.getServerId()));
            } else {
                startSessionMsg = new StartSessionMsg(initStatus, new ArrayList<String>());
            }
            this.session.publish(startSessionMsg);
            topologyMsg = (TopologyMsg)this.session.receive();
            if (this.debugEnabled()) {
                ReplicationBroker.debugInfo("In RB for " + this.baseDn + "\nRB HANDSHAKE SENT:\n" + startSessionMsg.toString() + "\nAND RECEIVED:\n" + topologyMsg.toString());
            }
            this.session.setSoTimeout(this.timeout);
        }
        catch (Exception e) {
            Message message = ReplicationMessages.ERR_EXCEPTION_STARTING_SESSION_PHASE.get("2", this.baseDn, server, e.getLocalizedMessage() + StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(message);
            if (this.session != null) {
                try {
                    this.session.close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
                this.session = null;
            }
            topologyMsg = null;
        }
        return topologyMsg;
    }

    public static ReplicationServerInfo computeBestReplicationServer(boolean firstConnection, int rsServerId, ServerState myState, Map<Integer, ReplicationServerInfo> rsInfos, int localServerId, String baseDn, byte groupId, long generationId) {
        if (rsInfos.size() == 1) {
            return rsInfos.values().iterator().next();
        }
        Map<Integer, ReplicationServerInfo> bestServers = rsInfos;
        block6: for (int filterLevel = 1; filterLevel <= 4; ++filterLevel) {
            Map<Integer, ReplicationServerInfo> newBestServers = null;
            switch (filterLevel) {
                case 1: {
                    bestServers = ReplicationBroker.filterServersLocallyConfigured(bestServers);
                    continue block6;
                }
                case 2: {
                    newBestServers = ReplicationBroker.filterServersWithSameGroupId(bestServers, groupId);
                    if (newBestServers.size() <= 0) continue block6;
                    bestServers = newBestServers;
                    continue block6;
                }
                case 3: {
                    newBestServers = ReplicationBroker.filterServersWithSameGenerationId(bestServers, generationId);
                    if (newBestServers.size() <= 0 || (newBestServers = ReplicationBroker.filterServersWithAllLocalDSChanges(bestServers = newBestServers, myState, localServerId)).size() <= 0) continue block6;
                    bestServers = newBestServers;
                    continue block6;
                }
                case 4: {
                    newBestServers = ReplicationBroker.filterServersInSameVM(bestServers);
                    if (newBestServers.size() <= 0) continue block6;
                    bestServers = newBestServers;
                }
            }
        }
        if (bestServers.size() > 1) {
            if (firstConnection) {
                return ReplicationBroker.computeBestServerForWeight(bestServers, -1, -1);
            }
            return ReplicationBroker.computeBestServerForWeight(bestServers, rsServerId, localServerId);
        }
        return bestServers.values().iterator().next();
    }

    private static Map<Integer, ReplicationServerInfo> filterServersLocallyConfigured(Map<Integer, ReplicationServerInfo> bestServers) {
        HashMap<Integer, ReplicationServerInfo> result = new HashMap<Integer, ReplicationServerInfo>();
        for (Integer rsId : bestServers.keySet()) {
            ReplicationServerInfo replicationServerInfo = bestServers.get(rsId);
            if (!replicationServerInfo.isLocallyConfigured()) continue;
            result.put(rsId, replicationServerInfo);
        }
        return result;
    }

    private static Map<Integer, ReplicationServerInfo> filterServersWithSameGroupId(Map<Integer, ReplicationServerInfo> bestServers, byte groupId) {
        HashMap<Integer, ReplicationServerInfo> result = new HashMap<Integer, ReplicationServerInfo>();
        for (Integer rsId : bestServers.keySet()) {
            ReplicationServerInfo replicationServerInfo = bestServers.get(rsId);
            if (replicationServerInfo.getGroupId() != groupId) continue;
            result.put(rsId, replicationServerInfo);
        }
        return result;
    }

    private static Map<Integer, ReplicationServerInfo> filterServersWithSameGenerationId(Map<Integer, ReplicationServerInfo> bestServers, long generationId) {
        ReplicationServerInfo replicationServerInfo;
        HashMap<Integer, ReplicationServerInfo> result = new HashMap<Integer, ReplicationServerInfo>();
        boolean emptyState = true;
        for (Integer rsId : bestServers.keySet()) {
            replicationServerInfo = bestServers.get(rsId);
            if (replicationServerInfo.getGenerationId() != generationId) continue;
            result.put(rsId, replicationServerInfo);
            if (replicationServerInfo.serverState.isEmpty()) continue;
            emptyState = false;
        }
        if (emptyState) {
            for (Integer rsId : bestServers.keySet()) {
                replicationServerInfo = bestServers.get(rsId);
                if (replicationServerInfo.getGenerationId() != -1L) continue;
                result.put(rsId, replicationServerInfo);
            }
        }
        return result;
    }

    private static Map<Integer, ReplicationServerInfo> filterServersWithAllLocalDSChanges(Map<Integer, ReplicationServerInfo> bestServers, ServerState localState, int localServerId) {
        HashMap<Integer, ReplicationServerInfo> upToDateServers = new HashMap<Integer, ReplicationServerInfo>();
        HashMap<Integer, ReplicationServerInfo> moreUpToDateServers = new HashMap<Integer, ReplicationServerInfo>();
        ChangeNumber myChangeNumber = localState.getMaxChangeNumber(localServerId);
        if (myChangeNumber == null) {
            myChangeNumber = new ChangeNumber(0L, 0, localServerId);
        }
        ChangeNumber latestRsChangeNumber = null;
        for (Integer rsId : bestServers.keySet()) {
            ReplicationServerInfo replicationServerInfo = bestServers.get(rsId);
            ServerState rsState = replicationServerInfo.getServerState();
            ChangeNumber rsChangeNumber = rsState.getMaxChangeNumber(localServerId);
            if (rsChangeNumber == null) {
                rsChangeNumber = new ChangeNumber(0L, 0, localServerId);
            }
            if (!myChangeNumber.olderOrEqual(rsChangeNumber).booleanValue()) continue;
            if (myChangeNumber.equals(rsChangeNumber)) {
                upToDateServers.put(rsId, replicationServerInfo);
                continue;
            }
            if (latestRsChangeNumber == null) {
                latestRsChangeNumber = rsChangeNumber;
            }
            if (!rsChangeNumber.newerOrEquals(latestRsChangeNumber)) continue;
            if (rsChangeNumber.equals(latestRsChangeNumber)) {
                moreUpToDateServers.put(rsId, replicationServerInfo);
                continue;
            }
            moreUpToDateServers.clear();
            moreUpToDateServers.put(rsId, replicationServerInfo);
            latestRsChangeNumber = rsChangeNumber;
        }
        if (moreUpToDateServers.size() > 0) {
            return moreUpToDateServers;
        }
        return upToDateServers;
    }

    private static Map<Integer, ReplicationServerInfo> filterServersInSameVM(Map<Integer, ReplicationServerInfo> bestServers) {
        HashMap<Integer, ReplicationServerInfo> result = new HashMap<Integer, ReplicationServerInfo>();
        for (Integer rsId : bestServers.keySet()) {
            ReplicationServerInfo replicationServerInfo = bestServers.get(rsId);
            if (!ReplicationServer.isLocalReplicationServer(replicationServerInfo.getServerURL())) continue;
            result.put(rsId, replicationServerInfo);
        }
        return result;
    }

    public static ReplicationServerInfo computeBestServerForWeight(Map<Integer, ReplicationServerInfo> bestServers, int currentRsServerId, int localServerId) {
        int sumOfWeights = 0;
        int sumOfConnectedDSs = 0;
        for (ReplicationServerInfo replicationServerInfo : bestServers.values()) {
            sumOfWeights += replicationServerInfo.getWeight();
            sumOfConnectedDSs += replicationServerInfo.getConnectedDSNumber();
        }
        HashMap<Integer, BigDecimal> loadDistances = new HashMap<Integer, BigDecimal>();
        MathContext mathContext = new MathContext(32);
        for (Integer rsId : bestServers.keySet()) {
            ReplicationServerInfo replicationServerInfo = bestServers.get(rsId);
            int rsWeight = replicationServerInfo.getWeight();
            BigDecimal loadGoalBd = new BigDecimal(rsWeight).divide(new BigDecimal(sumOfWeights), mathContext);
            BigDecimal currentLoadBd = BigDecimal.ZERO;
            if (sumOfConnectedDSs != 0) {
                int connectedDSs = replicationServerInfo.getConnectedDSNumber();
                currentLoadBd = new BigDecimal(connectedDSs).divide(new BigDecimal(sumOfConnectedDSs), mathContext);
            }
            BigDecimal loadDistanceBd = loadGoalBd.subtract(currentLoadBd, mathContext);
            loadDistances.put(rsId, loadDistanceBd);
        }
        if (currentRsServerId == -1) {
            int bestRsId = 0;
            float highestDistance = Float.NEGATIVE_INFINITY;
            boolean allRsWithZeroDistance = true;
            int highestWeightRsId = -1;
            int highestWeight = -1;
            for (Integer rsId : bestServers.keySet()) {
                int weight;
                float loadDistance = ((BigDecimal)loadDistances.get(rsId)).floatValue();
                if (loadDistance > highestDistance) {
                    bestRsId = rsId;
                    highestDistance = loadDistance;
                }
                if (loadDistance != 0.0f) {
                    allRsWithZeroDistance = false;
                }
                if ((weight = bestServers.get(rsId).getWeight()) <= highestWeight) continue;
                highestWeightRsId = rsId;
                highestWeight = weight;
            }
            if (allRsWithZeroDistance) {
                bestRsId = highestWeightRsId;
            }
            return bestServers.get(bestRsId);
        }
        float currentLoadDistance = ((BigDecimal)loadDistances.get(currentRsServerId)).floatValue();
        if (currentLoadDistance < 0.0f) {
            BigDecimal sumOfLoadDistancesOfOtherRSsBd = BigDecimal.ZERO;
            for (Integer rsId : bestServers.keySet()) {
                if (rsId == currentRsServerId) continue;
                sumOfLoadDistancesOfOtherRSsBd = sumOfLoadDistancesOfOtherRSsBd.add((BigDecimal)loadDistances.get(rsId), mathContext);
            }
            if (sumOfLoadDistancesOfOtherRSsBd.floatValue() > 0.0f) {
                float notRoundedOverloadingDSsNumber = sumOfLoadDistancesOfOtherRSsBd.multiply(new BigDecimal(sumOfConnectedDSs), mathContext).floatValue();
                int overloadingDSsNumber = Math.round(notRoundedOverloadingDSsNumber);
                if (overloadingDSsNumber == 1) {
                    ReplicationServerInfo currentReplicationServerInfo = bestServers.get(currentRsServerId);
                    int currentRsWeight = currentReplicationServerInfo.getWeight();
                    BigDecimal currentRsWeightBd = new BigDecimal(currentRsWeight);
                    BigDecimal sumOfWeightsBd = new BigDecimal(sumOfWeights);
                    BigDecimal currentRsLoadGoalBd = currentRsWeightBd.divide(sumOfWeightsBd, mathContext);
                    BigDecimal potentialCurrentRsNewLoadBd = new BigDecimal(0);
                    if (sumOfConnectedDSs != 0) {
                        int connectedDSs = currentReplicationServerInfo.getConnectedDSNumber();
                        BigDecimal potentialNewConnectedDSsBd = new BigDecimal(connectedDSs - 1);
                        BigDecimal sumOfConnectedDSsBd = new BigDecimal(sumOfConnectedDSs);
                        potentialCurrentRsNewLoadBd = potentialNewConnectedDSsBd.divide(sumOfConnectedDSsBd, mathContext);
                    }
                    BigDecimal potentialCurrentRsNewLoadDistanceBd = currentRsLoadGoalBd.subtract(potentialCurrentRsNewLoadBd, mathContext);
                    BigDecimal additionalDsLoadBd = new BigDecimal(1).divide(new BigDecimal(sumOfConnectedDSs), mathContext);
                    BigDecimal potentialNewSumOfLoadDistancesOfOtherRSsBd = sumOfLoadDistancesOfOtherRSsBd.subtract(additionalDsLoadBd, mathContext);
                    MathContext roundMc = new MathContext(6, RoundingMode.DOWN);
                    BigDecimal potentialCurrentRsNewLoadDistanceBdRounded = potentialCurrentRsNewLoadDistanceBd.round(roundMc);
                    BigDecimal potentialNewSumOfLoadDistancesOfOtherRSsBdRounded = potentialNewSumOfLoadDistancesOfOtherRSsBd.round(roundMc);
                    if (potentialCurrentRsNewLoadDistanceBdRounded.compareTo(BigDecimal.ZERO) != 0 && potentialCurrentRsNewLoadDistanceBdRounded.equals(potentialNewSumOfLoadDistancesOfOtherRSsBdRounded.negate())) {
                        return bestServers.get(currentRsServerId);
                    }
                }
                ReplicationServerInfo currentRsInfo = bestServers.get(currentRsServerId);
                List<Integer> serversConnectedToCurrentRS = currentRsInfo.getConnectedDSs();
                ArrayList<Integer> sortedServers = new ArrayList<Integer>(serversConnectedToCurrentRS);
                Collections.sort(sortedServers);
                int index = 0;
                while (overloadingDSsNumber > 0) {
                    int severToDisconnectId = (Integer)sortedServers.get(index);
                    if (severToDisconnectId == localServerId) {
                        return null;
                    }
                    --overloadingDSsNumber;
                    ++index;
                }
                return bestServers.get(currentRsServerId);
            }
            return bestServers.get(currentRsServerId);
        }
        return bestServers.get(currentRsServerId);
    }

    private void startRSHeartBeatMonitoring() {
        if (this.heartbeatInterval > 0L) {
            this.heartbeatMonitor = new HeartbeatMonitor("Replication Heartbeat Monitor on RS " + this.getReplicationServer() + " " + this.rsServerId + " for " + this.baseDn + " in DS " + this.serverId, this.session, this.heartbeatInterval, this.protocolVersion >= 4);
            this.heartbeatMonitor.start();
        }
    }

    synchronized void stopRSHeartBeatMonitoring() {
        if (this.heartbeatMonitor != null) {
            this.heartbeatMonitor.shutdown();
            this.heartbeatMonitor = null;
        }
    }

    public void reStart(boolean infiniteTry) {
        this.reStart(this.session, infiniteTry);
    }

    public void reStart(ProtocolSession failingSession, boolean infiniteTry) {
        if (failingSession != null) {
            if (this.protocolVersion >= 4) {
                try {
                    failingSession.publish(new StopMsg());
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            try {
                failingSession.close();
            }
            catch (IOException e1) {
                // empty catch block
            }
            ++this.numLostConnections;
        }
        if (failingSession == this.session) {
            this.connected = false;
            this.rsGroupId = (byte)-1;
            this.rsServerId = -1;
            this.rsServerUrl = null;
            this.session = null;
        }
        while (!this.connected && !this.shutdown) {
            try {
                this.connect();
            }
            catch (Exception e) {
                MessageBuilder mb = new MessageBuilder();
                mb.append(ReplicationMessages.NOTE_EXCEPTION_RESTARTING_SESSION.get(this.baseDn, e.getLocalizedMessage()));
                mb.append(StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(mb.toMessage());
            }
            if (!this.connected && !infiniteTry) break;
            if (this.connected || this.shutdown) continue;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.debugEnabled()) {
            ReplicationBroker.debugInfo(this + " end restart : connected=" + this.connected + " with RSid=" + this.getRsServerId() + " genid=" + this.generationID);
        }
    }

    public void publish(ReplicationMsg msg) {
        this._publish(msg, false, true);
    }

    public boolean publish(ReplicationMsg msg, boolean retryOnFailure) {
        return this._publish(msg, false, retryOnFailure);
    }

    public void publishRecovery(ReplicationMsg msg) {
        this._publish(msg, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean _publish(ReplicationMsg msg, boolean recoveryMsg, boolean retryOnFailure) {
        boolean done = false;
        while (!done && !this.shutdown) {
            if (this.connectionError) {
                if (this.debugEnabled()) {
                    ReplicationBroker.debugInfo("ReplicationBroker.publish() Publishing a message is not possible due to existing connection error.");
                }
                return false;
            }
            try {
                Semaphore currentWindowSemaphore;
                ProtocolSession current_session;
                Object object = this.connectPhaseLock;
                synchronized (object) {
                    current_session = this.session;
                    currentWindowSemaphore = this.sendWindow;
                }
                if (!recoveryMsg & this.connectRequiresRecovery) {
                    return false;
                }
                boolean credit = msg instanceof UpdateMsg ? currentWindowSemaphore.tryAcquire(500L, TimeUnit.MILLISECONDS) : true;
                if (credit) {
                    object = this.connectPhaseLock;
                    synchronized (object) {
                        if (this.session != null && this.session == current_session) {
                            this.session.publish(msg);
                            done = true;
                        }
                    }
                }
                if (credit || currentWindowSemaphore.availablePermits() != 0) continue;
                this.session.publish(new WindowProbeMsg());
            }
            catch (IOException e) {
                if (!retryOnFailure) {
                    return false;
                }
                Object object = this.connectPhaseLock;
                synchronized (object) {
                    block21: {
                        try {
                            this.connectPhaseLock.wait(100L);
                        }
                        catch (InterruptedException e1) {
                            if (!this.debugEnabled()) break block21;
                            ReplicationBroker.debugInfo("ReplicationBroker.publish() Interrupted exception raised : " + e.getLocalizedMessage());
                        }
                    }
                }
            }
            catch (InterruptedException e) {
                if (!this.debugEnabled()) continue;
                ReplicationBroker.debugInfo("ReplicationBroker.publish() Interrupted exception raised." + e.getLocalizedMessage());
            }
        }
        return true;
    }

    public ReplicationMsg receive() throws SocketTimeoutException {
        return this.receive(false, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReplicationMsg receive(boolean reconnectToTheBestRS, boolean reconnectOnFailure, boolean returnOnTopoChange) throws SocketTimeoutException {
        while (!this.shutdown) {
            Message message;
            if (reconnectOnFailure && !this.connected) {
                this.reStart(null, true);
            }
            ProtocolSession failingSession = this.session;
            try {
                ReplicationMsg msg = this.session.receive();
                if (msg instanceof UpdateMsg) {
                    ReplicationBroker replicationBroker = this;
                    synchronized (replicationBroker) {
                        --this.rcvWindow;
                    }
                }
                if (msg instanceof WindowMsg) {
                    WindowMsg windowMsg = (WindowMsg)msg;
                    this.sendWindow.release(windowMsg.getNumAck());
                    continue;
                }
                if (msg instanceof TopologyMsg) {
                    TopologyMsg topoMsg = (TopologyMsg)msg;
                    this.receiveTopo(topoMsg);
                    if (reconnectToTheBestRS) {
                        this.mustRunBestServerCheckingAlgorithm = 0;
                    }
                    if (!returnOnTopoChange) continue;
                    return msg;
                }
                if (msg instanceof StopMsg) {
                    message = ReplicationMessages.NOTE_REPLICATION_SERVER_PROPERLY_DISCONNECTED.get(this.replicationServer, Integer.toString(this.rsServerId), this.baseDn.toString(), Integer.toString(this.serverId));
                    ErrorLogger.logError(message);
                    this.reStart(failingSession, true);
                    continue;
                }
                if (msg instanceof MonitorMsg) {
                    this.replicaStates = new HashMap();
                    MonitorMsg monitorMsg = (MonitorMsg)msg;
                    Iterator<Integer> it = monitorMsg.ldapIterator();
                    while (it.hasNext()) {
                        int srvId = it.next();
                        this.replicaStates.put(srvId, monitorMsg.getLDAPServerState(srvId));
                    }
                    MutableBoolean srvId = this.monitorResponse;
                    synchronized (srvId) {
                        this.monitorResponse.set(true);
                        this.monitorResponse.notify();
                    }
                    it = monitorMsg.rsIterator();
                    while (it.hasNext()) {
                        int srvId2 = it.next();
                        ReplicationServerInfo rsInfo = this.replicationServerInfos.get(srvId2);
                        if (rsInfo == null) continue;
                        rsInfo.update(monitorMsg.getRSServerState(srvId2));
                    }
                    if (!reconnectToTheBestRS) continue;
                    ++this.mustRunBestServerCheckingAlgorithm;
                    if (this.mustRunBestServerCheckingAlgorithm != 2) continue;
                    ReplicationServerInfo bestServerInfo = ReplicationBroker.computeBestReplicationServer(false, this.rsServerId, this.state, this.replicationServerInfos, this.serverId, this.baseDn, this.groupId, this.generationID);
                    if (this.rsServerId != -1 && (bestServerInfo == null || bestServerInfo.getServerId() != this.rsServerId.intValue())) {
                        Message message2 = ReplicationMessages.NOTE_NEW_BEST_REPLICATION_SERVER.get(this.baseDn.toString(), Integer.toString(this.serverId), Integer.toString(this.rsServerId), this.rsServerUrl, Integer.toString(bestServerInfo.getServerId()));
                        ErrorLogger.logError(message2);
                        this.reStart(true);
                    }
                    this.mustRunBestServerCheckingAlgorithm = 0;
                    continue;
                }
                return msg;
            }
            catch (SocketTimeoutException e) {
                throw e;
            }
            catch (Exception e) {
                if (this.shutdown) continue;
                if (this.session == null || !this.session.closeInitiated()) {
                    message = ReplicationMessages.ERR_REPLICATION_SERVER_BADLY_DISCONNECTED.get(this.replicationServer, Integer.toString(this.rsServerId), this.baseDn.toString(), Integer.toString(this.serverId));
                    ErrorLogger.logError(message);
                }
                if (!reconnectOnFailure) break;
                this.reStart(failingSession, true);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, ServerState> getReplicaStates() {
        this.monitorResponse.set(false);
        this.publish(new MonitorRequestMsg(this.serverId, this.getRsServerId()));
        try {
            MutableBoolean mutableBoolean = this.monitorResponse;
            synchronized (mutableBoolean) {
                if (!this.monitorResponse.get()) {
                    this.monitorResponse.wait(10000L);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.replicaStates;
    }

    public synchronized void updateWindowAfterReplay() {
        try {
            ++this.updateDoneCount;
            if (this.updateDoneCount >= this.halfRcvWindow && this.session != null) {
                this.session.publish(new WindowMsg(this.updateDoneCount));
                this.rcvWindow += this.updateDoneCount;
                this.updateDoneCount = 0;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void stop() {
        if (this.debugEnabled()) {
            ReplicationBroker.debugInfo("ReplicationBroker " + this.serverId + " is stopping and will" + " close the connection to replication server " + this.rsServerId + " for" + " domain " + this.baseDn);
        }
        this.stopRSHeartBeatMonitoring();
        this.stopChangeTimeHeartBeatPublishing();
        this.replicationServer = "stopped";
        this.shutdown = true;
        this.connected = false;
        this.rsGroupId = (byte)-1;
        this.rsServerId = -1;
        this.rsServerUrl = null;
        try {
            if (this.protocolVersion >= 4) {
                this.session.publish(new StopMsg());
            }
            this.session.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setSoTimeout(int timeout) throws SocketException {
        this.timeout = timeout;
        if (this.session != null) {
            this.session.setSoTimeout(timeout);
        }
    }

    public String getReplicationServer() {
        return this.replicationServer;
    }

    public int getMaxRcvWindow() {
        return this.maxRcvWindow;
    }

    public int getCurrentRcvWindow() {
        return this.rcvWindow;
    }

    public int getMaxSendWindow() {
        return this.maxSendWindow;
    }

    public int getCurrentSendWindow() {
        if (this.connected) {
            return this.sendWindow.availablePermits();
        }
        return 0;
    }

    public int getNumLostConnections() {
        return this.numLostConnections;
    }

    public boolean changeConfig(Collection<String> replicationServers, int window, long heartbeatInterval, byte groupId) {
        Boolean needToRestartSession = false;
        if (this.servers == null || replicationServers.size() != this.servers.size() || !replicationServers.containsAll(this.servers) || window != this.maxRcvWindow || heartbeatInterval != this.heartbeatInterval || groupId != this.groupId) {
            needToRestartSession = true;
        }
        this.servers = replicationServers;
        this.rcvWindow = window;
        this.maxRcvWindow = window;
        this.halfRcvWindow = window / 2;
        this.heartbeatInterval = heartbeatInterval;
        this.groupId = groupId;
        return needToRestartSession;
    }

    public short getProtocolVersion() {
        return this.protocolVersion;
    }

    public boolean isConnected() {
        return this.connected;
    }

    private boolean debugEnabled() {
        return false;
    }

    private static final void debugInfo(String s) {
        ErrorLogger.logError(Message.raw(Category.SYNC, Severity.NOTICE, s, new Object[0]));
        TRACER.debugInfo(s);
    }

    public boolean isSessionEncrypted() {
        boolean isEncrypted = false;
        if (this.session != null) {
            return this.session.isEncrypted();
        }
        return isEncrypted;
    }

    public void signalStatusChange(ServerStatus newStatus) {
        try {
            ChangeStatusMsg csMsg = new ChangeStatusMsg(ServerStatus.INVALID_STATUS, newStatus);
            this.session.publish(csMsg);
        }
        catch (IOException ex) {
            Message message = ReplicationMessages.ERR_EXCEPTION_SENDING_CS.get(this.baseDn, Integer.toString(this.serverId), ex.getLocalizedMessage() + StaticUtils.stackTraceToSingleLineString(ex));
            ErrorLogger.logError(message);
        }
    }

    public void setGroupId(byte groupId) {
        this.groupId = groupId;
    }

    public List<DSInfo> getDsList() {
        return this.dsList;
    }

    public List<RSInfo> getRsList() {
        ArrayList<RSInfo> result = new ArrayList<RSInfo>();
        for (ReplicationServerInfo replicationServerInfo : this.replicationServerInfos.values()) {
            result.add(replicationServerInfo.toRSInfo());
        }
        return result;
    }

    private List<Integer> computeConnectedDSs(int rsId, List<DSInfo> dsList) {
        ArrayList<Integer> connectedDSs = new ArrayList<Integer>();
        if (this.rsServerId == rsId) {
            connectedDSs.add(this.serverId);
        }
        for (DSInfo dsInfo : dsList) {
            if (dsInfo.getRsId() != rsId) continue;
            connectedDSs.add(dsInfo.getDsId());
        }
        return connectedDSs;
    }

    public void receiveTopo(TopologyMsg topoMsg) {
        if (this.debugEnabled()) {
            ReplicationBroker.debugInfo(this + " receive TopologyMsg=" + topoMsg);
        }
        this.dsList = topoMsg.getDsList();
        ArrayList<Integer> rsToKeepList = new ArrayList<Integer>();
        for (RSInfo rsInfo : topoMsg.getRsList()) {
            int rsId = rsInfo.getId();
            rsToKeepList.add(rsId);
            List<Integer> connectedDSs = this.computeConnectedDSs(rsId, this.dsList);
            ReplicationServerInfo replicationServerInfo = this.replicationServerInfos.get(rsId);
            if (replicationServerInfo == null) {
                replicationServerInfo = new ReplicationServerInfo(rsInfo, connectedDSs);
                this.updateRSInfoLocallyConfiguredStatus(replicationServerInfo);
                this.replicationServerInfos.put(rsId, replicationServerInfo);
                continue;
            }
            replicationServerInfo.update(rsInfo, connectedDSs);
        }
        Iterator<Map.Entry<Integer, ReplicationServerInfo>> rsInfoIt = this.replicationServerInfos.entrySet().iterator();
        while (rsInfoIt.hasNext()) {
            Map.Entry<Integer, ReplicationServerInfo> rsInfoEntry = rsInfoIt.next();
            if (rsToKeepList.contains(rsInfoEntry.getKey())) continue;
            rsInfoIt.remove();
        }
        if (this.domain != null) {
            for (DSInfo info : this.dsList) {
                this.domain.setEclInclude(info.getDsId(), info.getEclIncludes());
            }
        }
    }

    public boolean hasConnectionError() {
        return this.connectionError;
    }

    public void startChangeTimeHeartBeatPublishing() {
        if (this.changeTimeHeartbeatSendInterval > 0L) {
            this.ctHeartbeatPublisherThread = new CTHeartbeatPublisherThread("Replication CN Heartbeat sender for " + this.baseDn + " with " + this.getReplicationServer(), this.session, this.changeTimeHeartbeatSendInterval, this.serverId);
            this.ctHeartbeatPublisherThread.start();
        } else if (this.debugEnabled()) {
            ReplicationBroker.debugInfo(this + " is not configured to send CN heartbeat interval");
        }
    }

    public synchronized void stopChangeTimeHeartBeatPublishing() {
        if (this.ctHeartbeatPublisherThread != null) {
            this.ctHeartbeatPublisherThread.shutdown();
            this.ctHeartbeatPublisherThread = null;
        }
    }

    public void setChangeTimeHeartbeatInterval(int changeTimeHeartbeatInterval) {
        this.stopChangeTimeHeartBeatPublishing();
        this.changeTimeHeartbeatSendInterval = changeTimeHeartbeatInterval;
        this.startChangeTimeHeartBeatPublishing();
    }

    public void setRecoveryRequired(boolean b) {
        this.connectRequiresRecovery = b;
    }

    public boolean shuttingDown() {
        return this.shutdown;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ReplicationServerInfo {
        private short protocolVersion;
        private long generationId;
        private byte groupId = (byte)-1;
        private int serverId;
        private String serverURL;
        private String baseDn = null;
        private int windowSize;
        private ServerState serverState = null;
        private boolean sslEncryption;
        private int degradedStatusThreshold = -1;
        private int weight = 1;
        private int connectedDSNumber = 0;
        private List<Integer> connectedDSs = null;
        private boolean locallyConfigured = true;

        public static ReplicationServerInfo newInstance(ReplicationMsg msg) throws IllegalArgumentException {
            if (msg instanceof ReplServerStartMsg) {
                ReplServerStartMsg replServerStartMsg = (ReplServerStartMsg)msg;
                return new ReplicationServerInfo(replServerStartMsg);
            }
            if (msg instanceof ReplServerStartDSMsg) {
                ReplServerStartDSMsg replServerStartDSMsg = (ReplServerStartDSMsg)msg;
                return new ReplicationServerInfo(replServerStartDSMsg);
            }
            throw new IllegalArgumentException("Unexpected PDU type: " + msg.getClass().getName() + " :\n" + msg.toString());
        }

        private ReplicationServerInfo(ReplServerStartMsg replServerStartMsg) {
            this.protocolVersion = replServerStartMsg.getVersion();
            this.generationId = replServerStartMsg.getGenerationId();
            this.groupId = replServerStartMsg.getGroupId();
            this.serverId = replServerStartMsg.getServerId();
            this.serverURL = replServerStartMsg.getServerURL();
            this.baseDn = replServerStartMsg.getBaseDn();
            this.windowSize = replServerStartMsg.getWindowSize();
            this.serverState = replServerStartMsg.getServerState();
            this.sslEncryption = replServerStartMsg.getSSLEncryption();
            this.degradedStatusThreshold = replServerStartMsg.getDegradedStatusThreshold();
        }

        private ReplicationServerInfo(ReplServerStartDSMsg replServerStartDSMsg) {
            this.protocolVersion = replServerStartDSMsg.getVersion();
            this.generationId = replServerStartDSMsg.getGenerationId();
            this.groupId = replServerStartDSMsg.getGroupId();
            this.serverId = replServerStartDSMsg.getServerId();
            this.serverURL = replServerStartDSMsg.getServerURL();
            this.baseDn = replServerStartDSMsg.getBaseDn();
            this.windowSize = replServerStartDSMsg.getWindowSize();
            this.serverState = replServerStartDSMsg.getServerState();
            this.sslEncryption = replServerStartDSMsg.getSSLEncryption();
            this.degradedStatusThreshold = replServerStartDSMsg.getDegradedStatusThreshold();
            this.weight = replServerStartDSMsg.getWeight();
            this.connectedDSNumber = replServerStartDSMsg.getConnectedDSNumber();
        }

        public ServerState getServerState() {
            return this.serverState;
        }

        public byte getGroupId() {
            return this.groupId;
        }

        public short getProtocolVersion() {
            return this.protocolVersion;
        }

        public long getGenerationId() {
            return this.generationId;
        }

        public int getServerId() {
            return this.serverId;
        }

        public String getServerURL() {
            return this.serverURL;
        }

        public String getBaseDn() {
            return this.baseDn;
        }

        public int getWindowSize() {
            return this.windowSize;
        }

        public boolean isSslEncryption() {
            return this.sslEncryption;
        }

        public int getDegradedStatusThreshold() {
            return this.degradedStatusThreshold;
        }

        public int getWeight() {
            return this.weight;
        }

        public int getConnectedDSNumber() {
            return this.connectedDSNumber;
        }

        public ReplicationServerInfo(RSInfo rsInfo, List<Integer> connectedDSs) {
            this.serverId = rsInfo.getId();
            this.serverURL = rsInfo.getServerUrl();
            this.generationId = rsInfo.getGenerationId();
            this.groupId = rsInfo.getGroupId();
            this.weight = rsInfo.getWeight();
            this.connectedDSs = connectedDSs;
            this.connectedDSNumber = connectedDSs.size();
        }

        public RSInfo toRSInfo() {
            return new RSInfo(this.serverId, this.serverURL, this.generationId, this.groupId, this.weight);
        }

        public void update(RSInfo rsInfo, List<Integer> connectedDSs) {
            this.generationId = rsInfo.getGenerationId();
            this.groupId = rsInfo.getGroupId();
            this.weight = rsInfo.getWeight();
            this.connectedDSs = connectedDSs;
            this.connectedDSNumber = connectedDSs.size();
        }

        public void update(ServerState serverState) {
            if (this.serverState != null) {
                this.serverState.update(serverState);
            } else {
                this.serverState = serverState;
            }
        }

        public List<Integer> getConnectedDSs() {
            return this.connectedDSs;
        }

        public boolean isLocallyConfigured() {
            return this.locallyConfigured;
        }

        public void setLocallyConfigured(boolean locallyConfigured) {
            this.locallyConfigured = locallyConfigured;
        }

        public String toString() {
            return "Url:" + this.getServerURL() + " ServerId:" + this.serverId;
        }
    }
}

