/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.makeldif;

import java.util.List;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.core.DirectoryServer;
import org.opends.server.tools.makeldif.Branch;
import org.opends.server.tools.makeldif.Tag;
import org.opends.server.tools.makeldif.TagResult;
import org.opends.server.tools.makeldif.Template;
import org.opends.server.tools.makeldif.TemplateEntry;
import org.opends.server.tools.makeldif.TemplateFile;
import org.opends.server.tools.makeldif.TemplateValue;
import org.opends.server.types.AttributeType;
import org.opends.server.types.InitializationException;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IfAbsentTag
extends Tag {
    private AttributeType attributeType = null;
    private String assertionValue = null;

    @Override
    public String getName() {
        return "IfAbsent";
    }

    @Override
    public boolean allowedInBranch() {
        return true;
    }

    @Override
    public void initializeForBranch(TemplateFile templateFile, Branch branch, String[] arguments, int lineNumber, List<Message> warnings) throws InitializationException {
        if (arguments.length < 1 || arguments.length > 2) {
            Message message = ToolMessages.ERR_MAKELDIF_TAG_INVALID_ARGUMENT_RANGE_COUNT.get(this.getName(), lineNumber, 1, 2, arguments.length);
            throw new InitializationException(message);
        }
        String lowerName = StaticUtils.toLowerCase(arguments[0]);
        AttributeType t = DirectoryServer.getAttributeType(lowerName, true);
        if (!branch.hasAttribute(t)) {
            Message message = ToolMessages.ERR_MAKELDIF_TAG_UNDEFINED_ATTRIBUTE.get(arguments[0], lineNumber);
            throw new InitializationException(message);
        }
        this.assertionValue = arguments.length == 2 ? arguments[1] : null;
    }

    @Override
    public void initializeForTemplate(TemplateFile templateFile, Template template, String[] arguments, int lineNumber, List<Message> warnings) throws InitializationException {
        if (arguments.length < 1 || arguments.length > 2) {
            Message message = ToolMessages.ERR_MAKELDIF_TAG_INVALID_ARGUMENT_RANGE_COUNT.get(this.getName(), lineNumber, 1, 2, arguments.length);
            throw new InitializationException(message);
        }
        String lowerName = StaticUtils.toLowerCase(arguments[0]);
        this.attributeType = DirectoryServer.getAttributeType(lowerName, true);
        if (!template.hasAttribute(this.attributeType)) {
            Message message = ToolMessages.ERR_MAKELDIF_TAG_UNDEFINED_ATTRIBUTE.get(arguments[0], lineNumber);
            throw new InitializationException(message);
        }
        this.assertionValue = arguments.length == 2 ? arguments[1] : null;
    }

    @Override
    public TagResult generateValue(TemplateEntry templateEntry, TemplateValue templateValue) {
        List<TemplateValue> values = templateEntry.getValues(this.attributeType);
        if (values == null || values.isEmpty()) {
            return TagResult.SUCCESS_RESULT;
        }
        if (this.assertionValue == null) {
            return TagResult.OMIT_FROM_ENTRY;
        }
        for (TemplateValue v : values) {
            if (!this.assertionValue.equals(v.getValue().toString())) continue;
            return TagResult.OMIT_FROM_ENTRY;
        }
        return TagResult.SUCCESS_RESULT;
    }
}

