/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.workflowelement;

import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.opends.server.admin.std.server.MonitorProviderCfg;
import org.opends.server.admin.std.server.WorkflowElementCfg;
import org.opends.server.api.MonitorProvider;
import org.opends.server.core.DirectoryServer;
import org.opends.server.types.CanceledOperationException;
import org.opends.server.types.Operation;
import org.opends.server.workflowelement.ObservableWorkflowElementState;
import org.opends.server.workflowelement.ObservableWorkflowElementStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WorkflowElement<T extends WorkflowElementCfg>
implements Observer {
    private boolean isPrivate = false;
    private String workflowElementTypeInfo = "not defined";
    private String workflowElementID = null;
    private ObservableWorkflowElementState observableState = new ObservableWorkflowElementState(this);
    private static ConcurrentMap<String, List<Observer>> newWorkflowElementNotificationList = new ConcurrentHashMap<String, List<Observer>>();
    private ObservableWorkflowElementStatus observableStatus = new ObservableWorkflowElementStatus(this);
    private MonitorProvider<MonitorProviderCfg> statistics;

    protected ObservableWorkflowElementState getObservableState() {
        return this.observableState;
    }

    protected ObservableWorkflowElementStatus getObservableStatus() {
        return this.observableStatus;
    }

    public static void registereForStateUpdate(WorkflowElement<?> we, String weid, Observer observer) {
        if (we != null) {
            ObservableWorkflowElementState westate = we.getObservableState();
            westate.addObserver(observer);
        } else {
            if (weid == null) {
                return;
            }
            CopyOnWriteArrayList<Observer> observers = (CopyOnWriteArrayList<Observer>)newWorkflowElementNotificationList.get(weid);
            if (observers == null) {
                observers = new CopyOnWriteArrayList<Observer>();
                observers.add(observer);
                newWorkflowElementNotificationList.put(weid, observers);
            } else {
                observers.add(observer);
            }
        }
    }

    public static void deregistereForStateUpdate(WorkflowElement<?> we, String weid, Observer observer) {
        List observers;
        if (we != null) {
            ObservableWorkflowElementState westate = we.getObservableState();
            westate.deleteObserver(observer);
        }
        if (weid != null && (observers = (List)newWorkflowElementNotificationList.get(weid)) != null) {
            observers.remove(observer);
        }
    }

    public static void notifyStateUpdate(WorkflowElement<?> workflowElement) {
        String weID = workflowElement.getWorkflowElementID();
        List observers = (List)newWorkflowElementNotificationList.get(weID);
        if (observers != null) {
            for (Observer observer : observers) {
                try {
                    observer.update(workflowElement.getObservableState(), null);
                }
                catch (Exception e) {
                    observers.remove(observer);
                }
            }
        }
    }

    public void initialize(String workflowElementID, String workflowElementTypeInfo) {
        this.workflowElementID = workflowElementID;
        this.workflowElementTypeInfo = workflowElementTypeInfo;
        this.statistics = this.createStatistics();
        if (this.statistics != null) {
            DirectoryServer.registerMonitorProvider(this.statistics);
        }
    }

    @Override
    public void update(Observable o, Object arg) {
    }

    public String getWorkflowElementTypeInfo() {
        return this.workflowElementTypeInfo;
    }

    public boolean isConfigurationAcceptable(T configuration, List<String> unacceptableReasons) {
        return true;
    }

    public void finalizeWorkflowElement() {
        if (this.statistics != null) {
            DirectoryServer.deregisterMonitorProvider(this.statistics.getMonitorInstanceName());
        }
    }

    public abstract void execute(Operation var1) throws CanceledOperationException;

    public boolean isPrivate() {
        return this.isPrivate;
    }

    protected void setPrivate(boolean isPrivate) {
        this.isPrivate = isPrivate;
    }

    public String getWorkflowElementID() {
        return this.workflowElementID;
    }

    public void setSaturationIndex(int newValue) {
        this.observableStatus.setSaturationIndex(newValue);
    }

    public int getSaturationIndex() {
        return this.observableStatus.getSaturationIndex();
    }

    public void registerForSaturationIndexUpdate(Observer observer) {
        this.observableStatus.addObserver(observer);
    }

    public void deregisterForSaturationIndexUpdate(Observer observer) {
        this.observableStatus.deleteObserver(observer);
    }

    public abstract List<WorkflowElement<?>> getChildWorkflowElements();

    public boolean hasChildWorkflowElement(WorkflowElement element) {
        if (this.getChildWorkflowElements().size() == 0) {
            return this.equals(element);
        }
        for (WorkflowElement<?> subElement : this.getChildWorkflowElements()) {
            if (!subElement.equals(element) && !subElement.hasChildWorkflowElement(element)) continue;
            return true;
        }
        return false;
    }

    public MonitorProvider<MonitorProviderCfg> createStatistics() {
        return null;
    }
}

