/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel;

import java.util.LinkedHashSet;
import org.opends.admin.ads.util.ConnectionUtils;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.quicksetup.Constants;
import org.opends.quicksetup.UserData;
import org.opends.quicksetup.util.Utils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.FileBasedArgument;
import org.opends.server.util.args.IntegerArgument;
import org.opends.server.util.args.StringArgument;

public class ControlPanelArgumentParser
extends ArgumentParser {
    private StringArgument hostNameArg = null;
    private IntegerArgument portArg = null;
    private StringArgument bindDnArg = null;
    private FileBasedArgument bindPasswordFileArg = null;
    private StringArgument bindPasswordArg = null;
    private BooleanArgument trustAllArg = null;
    private IntegerArgument connectTimeoutArg = null;
    private BooleanArgument showUsageArg;

    public ControlPanelArgumentParser(String mainClassName, Message msg) {
        super(mainClassName, msg, false);
    }

    public static int getDefaultAdministrationPort() {
        return 4444;
    }

    public static String getDefaultBindDN() {
        return "cn=Directory Manager";
    }

    public void initializeArguments() throws ArgumentException {
        this.hostNameArg = new StringArgument("host", Character.valueOf('h'), "hostname", false, false, true, ToolMessages.INFO_HOST_PLACEHOLDER.get(), UserData.getDefaultHostName(), null, ToolMessages.INFO_DESCRIPTION_HOST.get());
        this.hostNameArg.setPropertyName("hostname");
        this.addArgument(this.hostNameArg);
        this.portArg = new IntegerArgument("port", Character.valueOf('p'), "port", false, false, true, ToolMessages.INFO_PORT_PLACEHOLDER.get(), ControlPanelArgumentParser.getDefaultAdministrationPort(), null, true, 1, true, 65535, ToolMessages.INFO_DESCRIPTION_ADMIN_PORT.get());
        this.portArg.setPropertyName("port");
        this.addArgument(this.portArg);
        this.bindDnArg = new StringArgument("bindDN", Character.valueOf('D'), "bindDN", false, false, true, ToolMessages.INFO_BINDDN_PLACEHOLDER.get(), ControlPanelArgumentParser.getDefaultBindDN(), null, ToolMessages.INFO_DESCRIPTION_BINDDN.get());
        this.bindDnArg.setPropertyName("bindDN");
        this.addArgument(this.bindDnArg);
        this.bindPasswordArg = new StringArgument("bindPassword", Character.valueOf('w'), "bindPassword", false, false, true, ToolMessages.INFO_BINDPWD_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_BINDPASSWORD.get());
        this.bindPasswordArg.setPropertyName("bindPassword");
        this.addArgument(this.bindPasswordArg);
        this.bindPasswordFileArg = new FileBasedArgument("bindPasswordFile", Character.valueOf('j'), "bindPasswordFile", false, false, ToolMessages.INFO_BINDPWD_FILE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_BINDPASSWORDFILE.get());
        this.bindPasswordFileArg.setPropertyName("bindPasswordFile");
        this.addArgument(this.bindPasswordFileArg);
        this.trustAllArg = new BooleanArgument("trustAll", Character.valueOf('X'), "trustAll", ToolMessages.INFO_DESCRIPTION_TRUSTALL.get());
        this.trustAllArg.setPropertyName("trustAll");
        this.addArgument(this.trustAllArg);
        int defaultTimeout = ConnectionUtils.getDefaultLDAPTimeout();
        this.connectTimeoutArg = new IntegerArgument("connectTimeout", null, "connectTimeout", false, false, true, ToolMessages.INFO_TIMEOUT_PLACEHOLDER.get(), defaultTimeout, null, true, 0, false, Integer.MAX_VALUE, ToolMessages.INFO_DESCRIPTION_CONNECTION_TIMEOUT.get());
        this.connectTimeoutArg.setPropertyName("connectTimeout");
        this.addArgument(this.connectTimeoutArg);
        this.showUsageArg = new BooleanArgument("help", Character.valueOf('H'), "help", ToolMessages.INFO_DESCRIPTION_USAGE.get());
        this.addArgument(this.showUsageArg);
        this.setUsageArgument(this.showUsageArg);
    }

    public void parseArguments(String[] args) throws ArgumentException {
        Message message;
        LinkedHashSet<Message> errorMessages = new LinkedHashSet<Message>();
        try {
            super.parseArguments(args);
        }
        catch (ArgumentException ae) {
            errorMessages.add(ae.getMessageObject());
        }
        if (this.bindPasswordArg.isPresent() && this.bindPasswordFileArg.isPresent()) {
            message = ToolMessages.ERR_TOOL_CONFLICTING_ARGS.get(this.bindPasswordArg.getLongIdentifier(), this.bindPasswordFileArg.getLongIdentifier());
            errorMessages.add(message);
        }
        if (errorMessages.size() > 0) {
            message = ToolMessages.ERR_CANNOT_INITIALIZE_ARGS.get(Utils.getMessageFromCollection(errorMessages, Constants.LINE_SEPARATOR));
            throw new ArgumentException(message);
        }
    }

    public String getExplicitHostName() {
        String hostName = null;
        if (this.hostNameArg.isPresent()) {
            hostName = this.hostNameArg.getValue();
        }
        return hostName;
    }

    public int getExplicitPort() {
        int port = -1;
        if (this.portArg.isPresent()) {
            try {
                port = this.portArg.getIntValue();
            }
            catch (ArgumentException ae) {
                throw new IllegalStateException("Error parsing data: " + ae, ae);
            }
        }
        return port;
    }

    public String getExplicitBindDn() {
        String dn = null;
        if (this.bindDnArg.isPresent()) {
            dn = this.bindDnArg.getValue();
        }
        return dn;
    }

    public String getBindPassword() {
        return ControlPanelArgumentParser.getBindPassword(this.bindPasswordArg, this.bindPasswordFileArg);
    }

    public boolean isTrustAll() {
        return this.trustAllArg.isPresent();
    }

    public int getConnectTimeout() {
        try {
            return this.connectTimeoutArg.getIntValue();
        }
        catch (ArgumentException ae) {
            throw new IllegalStateException("Argument parser is not parsed: " + ae, ae);
        }
    }
}

